/*
 * Copyright 2014 Diwaker Gupta
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jetcd;

import com.fasterxml.jackson.annotation.JsonProperty;

/** Etcd Admin Response. */
public final class EtcdAdminResponse {
  private final String clientUrl;
  private final String peerUrl;
  private final String name;
  private final String state;

  EtcdAdminResponse(
      @JsonProperty("clientURL") final String clientUrl,
      @JsonProperty("name") final String name,
      @JsonProperty("peerURL") final String peerUrl,
      @JsonProperty("state") final String state) {
    this.clientUrl = clientUrl;
    this.peerUrl = peerUrl;
    this.name = name;
    this.state = state;
  }

  public String getClientUrl() { return clientUrl; }
  public String getPeerUrl() { return peerUrl; }
  public String getName() { return name; }
  public String getState() { return state; }
}
