/*
 * Decompiled with CFR 0.152.
 */
package jetcd;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import jetcd.EtcdApi;
import jetcd.EtcdClient;
import jetcd.EtcdException;
import jetcd.EtcdResponse;
import retrofit.ErrorHandler;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

public class EtcdClientImpl
implements EtcdClient {
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final EtcdApi etcd;

    EtcdClientImpl(String server) {
        RestAdapter restAdapter = new RestAdapter.Builder().setLogLevel(RestAdapter.LogLevel.FULL).setConverter((Converter)new JacksonConverter(objectMapper)).setServer(server).setErrorHandler((ErrorHandler)new EtcdErrorHandler()).build();
        this.etcd = (EtcdApi)restAdapter.create(EtcdApi.class);
    }

    @Override
    public String get(String key) throws EtcdException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        return this.etcd.get(key).getNode().getValue();
    }

    @Override
    public void set(String key, String value) throws EtcdException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0);
        this.etcd.set(key, value, null, null, null);
    }

    @Override
    public void set(String key, String value, int ttl) throws EtcdException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0);
        Preconditions.checkArgument((ttl > 0 ? 1 : 0) != 0);
        this.etcd.set(key, value, ttl, null, null);
    }

    @Override
    public void delete(String key) throws EtcdException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        this.etcd.delete(key);
    }

    @Override
    public Map<String, String> list(String path) throws EtcdException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EtcdResponse.Node node : this.etcd.get(path).getNode().getNodes()) {
            builder.put((Object)node.getKey(), (Object)node.getValue());
        }
        return builder.build();
    }

    @Override
    public void compareAndSwap(String key, String oldValue, String newValue) throws EtcdException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)oldValue) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)newValue) ? 1 : 0) != 0);
        Preconditions.checkArgument((!oldValue.equals(newValue) ? 1 : 0) != 0);
        EtcdResponse response = this.etcd.set(key, newValue, null, null, oldValue);
        response.getNode().getValue();
    }

    private static final class EtcdErrorHandler
    implements ErrorHandler {
        private EtcdErrorHandler() {
        }

        public Throwable handleError(RetrofitError cause) {
            return (EtcdException)cause.getBodyAs(EtcdException.class);
        }
    }
}

