/*
 * Decompiled with CFR 0.152.
 */
package jetcd;

import java.util.HashMap;
import java.util.Map;
import jetcd.EtcdApi;
import jetcd.EtcdClient;
import jetcd.EtcdException;
import jetcd.Response;
import retrofit.RestAdapter;
import retrofit.RetrofitError;

public class EtcdClientImpl
implements EtcdClient {
    private final EtcdApi etcd;

    EtcdClientImpl(String server) {
        RestAdapter restAdapter = new RestAdapter.Builder().setServer(server).build();
        this.etcd = (EtcdApi)restAdapter.create(EtcdApi.class);
    }

    @Override
    public String getKey(String key) throws EtcdException {
        try {
            return this.etcd.getKey((String)key).value;
        }
        catch (RetrofitError e) {
            throw new EtcdException(e);
        }
    }

    @Override
    public void setKey(String key, String value) throws EtcdException {
        try {
            this.etcd.setKey(key, value);
        }
        catch (RetrofitError e) {
            throw new EtcdException(e);
        }
    }

    @Override
    public void deleteKey(String key) throws EtcdException {
        try {
            this.etcd.deleteKey(key);
        }
        catch (RetrofitError e) {
            throw new EtcdException(e);
        }
    }

    @Override
    public Map<String, String> list(String path) throws EtcdException {
        HashMap<String, String> entries = new HashMap<String, String>();
        try {
            for (Response response : this.etcd.list(path)) {
                entries.put(response.key, response.value);
            }
        }
        catch (RetrofitError e) {
            throw new EtcdException(e);
        }
        return entries;
    }

    @Override
    public String testAndSet(String key, String oldValue, String newValue) throws EtcdException {
        try {
            Response response = this.etcd.testAndSet(key, oldValue, newValue);
            return response.prevValue;
        }
        catch (RetrofitError e) {
            throw new EtcdException(e);
        }
    }
}

