/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.client;

import java.io.FileInputStream;
import javax.security.cert.X509Certificate;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.documents.RegisterKeyElement;
import net.exogeni.orca.nodeagent.documents.RegisterKeyResultElement;
import net.exogeni.orca.nodeagent.drivers.DriverBaseTask;
import org.apache.tools.ant.BuildException;

public class RegisterKeyTask
extends DriverBaseTask {
    protected String keyAlias;
    protected String certificateFile;

    @Override
    public void execute() throws BuildException {
        super.execute();
        try {
            if (this.keyAlias == null) {
                throw new Exception("Missing key alias");
            }
            if (this.certificateFile == null) {
                throw new Exception("Missing certificate file");
            }
            X509Certificate certificate = null;
            try (FileInputStream is = null;){
                is = new FileInputStream(this.certificateFile);
                certificate = X509Certificate.getInstance(is);
            }
            byte[] certEncoding = certificate.getEncoded();
            RegisterKeyElement rke = new RegisterKeyElement();
            rke.setAlias(this.keyAlias);
            rke.setPublickey(certEncoding);
            NodeAgentServiceStub stub = this.getStub();
            RegisterKeyResultElement rkre = stub.registerKey(rke);
            int code = rkre.getRegisterKeyResultElement();
            this.setResult(code);
        }
        catch (Exception e) {
            throw new BuildException("An error occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void setCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile;
    }
}

