/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.client;

import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.client.KeyMasterClient;
import net.exogeni.orca.nodeagent.drivers.DriverBaseTask;
import org.apache.tools.ant.BuildException;

public class RegisterAuthorityKeyTask
extends DriverBaseTask {
    String keyStoreLocation;
    String keyStorePassword;
    String authorityIP = "127.0.0.1";
    String keyPassword;
    String keyAlias;
    String serverKey;

    public void setKeystore(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public void setKeystorePassword(String password) {
        this.keyStorePassword = password;
    }

    public void setAuthorityIP(String ip) {
        this.authorityIP = ip;
    }

    public void setKeyPassword(String pass) {
        this.keyPassword = pass;
    }

    public void setKey(String key) {
        this.keyAlias = key;
    }

    public void setServerKey(String key) {
        this.serverKey = key;
    }

    @Override
    public void execute() throws BuildException {
        try {
            super.execute();
            if (this.keyStoreLocation == null) {
                throw new BuildException("keystore location parameter not provided");
            }
            if (this.keyStorePassword == null) {
                throw new BuildException("keystore password parameter not provided");
            }
            if (this.authorityIP == null) {
                throw new BuildException("Authority IP parameter not provided");
            }
            if (this.keyPassword == null) {
                throw new BuildException("key password parameter not provided");
            }
            if (this.keyAlias == null) {
                throw new BuildException("key password parameter not provided");
            }
            if (this.serverKey == null) {
                throw new BuildException("server key alias parameter not provided");
            }
            NodeAgentServiceStub stub = null;
            try {
                stub = this.getStub();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new BuildException("stub could not be initialized");
            }
            KeyMasterClient kmc = new KeyMasterClient(this.location, stub, this.keyStoreLocation, this.keyStorePassword, this.keyAlias, this.keyPassword, this.authorityIP, this.serverKey);
            try {
                int code = kmc.callRegisterAuthorityKey();
                this.setExitCode(code);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new BuildException("Exception while adding the authority key");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }
}

