/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.client;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import net.exogeni.orca.nodeagent.client.AntBaseTask;
import org.apache.axis2.util.Base64;
import org.apache.tools.ant.BuildException;

public class InstallServiceKeyTask
extends AntBaseTask {
    protected String keystore;
    protected String password;
    protected String certificateString;
    protected String certificateFile;
    protected String keyAlias;
    protected KeyStore ks = null;
    protected Certificate certificate = null;

    protected void loadKeyStore() throws Exception {
        try (FileInputStream fis = null;){
            this.ks = KeyStore.getInstance("JKS");
            fis = new FileInputStream(this.keystore);
            this.ks.load(fis, this.password.toCharArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCertificate() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (InputStream is = null;){
            if (this.certificateString != null) {
                byte[] enc = Base64.decode((String)this.certificateString);
                is = new ByteArrayInputStream(enc);
            } else {
                is = new FileInputStream(this.certificateFile);
            }
            this.certificate = cf.generateCertificate(is);
        }
    }

    protected void addCertificate() throws Exception {
        Certificate cert = this.ks.getCertificate(this.keyAlias);
        if (cert == null) {
            this.logger.debug((Object)"adding certificate");
            this.ks.setCertificateEntry(this.keyAlias, this.certificate);
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(this.keystore);
                this.ks.store(fos, this.password.toCharArray());
            }
        } else {
            this.logger.debug((Object)"certificate is already present");
            if (!cert.equals(this.certificate)) {
                throw new Exception("new certificate differs from existing certificate");
            }
        }
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
        try {
            if (this.keystore == null) {
                throw new Exception("must psecify a keystore");
            }
            if (this.password == null) {
                throw new Exception("must specify a password for the keystore");
            }
            if (this.keyAlias == null) {
                throw new Exception("must specify key alias");
            }
            if (this.certificateString == null && this.certificateFile == null) {
                throw new Exception("must specify a source");
            }
            this.logger.debug((Object)("keystore=" + this.keystore));
            this.logger.debug((Object)("alias=" + this.keyAlias));
            this.logger.debug((Object)"loading key store");
            this.loadKeyStore();
            this.logger.debug((Object)"loading certificate");
            this.loadCertificate();
            this.logger.debug((Object)"adding certificate");
            this.addCertificate();
            this.setResult(0);
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BuildException("An error occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setCertificate(String value) {
        this.certificateString = value;
    }

    public void setCertificateFile(String value) {
        this.certificateFile = value;
    }

    public void setKeystore(String value) {
        this.keystore = value;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public void setAlias(String value) {
        this.keyAlias = value;
    }
}

