/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.client;

import java.io.FileOutputStream;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.documents.GetServiceKeyElement;
import net.exogeni.orca.nodeagent.documents.GetServiceKeyResultElement;
import net.exogeni.orca.nodeagent.drivers.DriverBaseTask;
import org.apache.axis2.util.Base64;
import org.apache.tools.ant.BuildException;

public class GetServiceKeyTask
extends DriverBaseTask {
    protected String certificateProperty;
    protected String certificateFile;

    @Override
    public void execute() throws BuildException {
        super.execute();
        try {
            if (this.certificateProperty == null && this.certificateFile == null) {
                throw new Exception("Must speciffy an output");
            }
            GetServiceKeyElement gske = new GetServiceKeyElement();
            NodeAgentServiceStub stub = this.getStub();
            GetServiceKeyResultElement gskre = stub.getServiceKey(gske);
            int retCode = gskre.getCode();
            if (retCode == 0) {
                byte[] encodedCert = gskre.getKey();
                if (this.certificateProperty != null) {
                    String result = Base64.encode((byte[])encodedCert);
                    this.getProject().setProperty(this.certificateProperty, result);
                } else {
                    FileOutputStream fs = new FileOutputStream(this.certificateFile);
                    fs.write(encodedCert);
                    fs.close();
                }
            }
            this.setResult(retCode);
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BuildException("An error occurred: ", (Throwable)e);
        }
    }

    public void setCertificateProperty(String value) {
        this.certificateProperty = value;
    }

    public void setCertificateFile(String value) {
        this.certificateFile = value;
    }
}

