/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.client;

import java.io.File;
import java.util.Properties;
import net.exogeni.orca.util.ChangeClasspath;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class AntBaseTask
extends Task {
    public static final int InternalTaskError = -123456;
    public static final String PropertyRootPath = "root.dir";
    protected String exitCodeProperty;
    protected String exitCodeMessageProperty;
    protected Path classpath;
    protected int timeout;
    protected String loaderref;
    protected Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getCanonicalName());

    public AntBaseTask() {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
    }

    public void execute() throws BuildException {
        super.execute();
        try {
            this.fixClassPath();
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new BuildException("An error occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    protected void fixClassPath() throws Exception {
        Object obj;
        if (this.loaderref != null && (obj = this.getProject().getReference(this.loaderref)) != null) {
            System.out.println(obj.getClass().getCanonicalName());
            if (obj instanceof ClassLoader) {
                Thread.currentThread().setContextClassLoader((ClassLoader)obj);
            }
        }
        if (this.classpath != null) {
            String[] list = this.classpath.list();
            for (int i = 0; i < list.length; ++i) {
                File f = new File(list[i]);
                if (!f.exists()) continue;
                ChangeClasspath.addFile((ClassLoader)this.getProject().getClass().getClassLoader(), (File)f);
            }
        }
    }

    protected void setResult(int code) throws Exception {
        if (this.exitCodeProperty != null) {
            this.getProject().setProperty(this.exitCodeProperty, Integer.toString(code));
            this.getProject().setProperty(this.exitCodeMessageProperty, this.getErrorMessage(code));
        } else if (code != 0) {
            throw new Exception("An error has occurred. Error code: " + code);
        }
    }

    protected String getErrorMessage(int code) {
        return "";
    }

    protected void setExitCode(int code) throws Exception {
        if (this.exitCodeProperty != null) {
            this.getProject().setProperty(this.exitCodeProperty, Integer.toString(code));
        } else if (code != 0) {
            throw new Exception("An error has occurred. Error code: " + code);
        }
    }

    protected Properties getProperties() throws Exception {
        return null;
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setExitCodeProperty(String exitCodeProperty) {
        this.exitCodeProperty = exitCodeProperty;
        this.exitCodeMessageProperty = exitCodeProperty + ".message";
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setLoaderref(String loaderref) {
        this.loaderref = loaderref;
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }
}

