/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent;

import java.util.Properties;
import javax.activation.DataHandler;
import net.exogeni.orca.drivers.DriverId;
import net.exogeni.orca.drivers.util.DriverScriptExecutionResult;
import net.exogeni.orca.nodeagent.NodeAgentConstants;
import net.exogeni.orca.nodeagent.NodeAgentService;
import net.exogeni.orca.nodeagent.RootPathResolver;
import net.exogeni.orca.nodeagent.documents.DriverElement;
import net.exogeni.orca.nodeagent.documents.DriverObjectRequestElement;
import net.exogeni.orca.nodeagent.documents.DriverRequestElement;
import net.exogeni.orca.nodeagent.documents.GetServiceKeyElement;
import net.exogeni.orca.nodeagent.documents.GetServiceKeyResultElement;
import net.exogeni.orca.nodeagent.documents.RegisterAuthorityKeyElement;
import net.exogeni.orca.nodeagent.documents.RegisterAuthorityKeyResultElement;
import net.exogeni.orca.nodeagent.documents.RegisterKeyElement;
import net.exogeni.orca.nodeagent.documents.RegisterKeyResultElement;
import net.exogeni.orca.nodeagent.documents.ResultElement;
import net.exogeni.orca.nodeagent.documents.ScriptElement;
import net.exogeni.orca.nodeagent.documents.ScriptResultElement;
import net.exogeni.orca.nodeagent.documents.TestFuncElement;
import net.exogeni.orca.nodeagent.documents.TestFuncResultElement;
import net.exogeni.orca.nodeagent.documents.UnregisterKeyElement;
import net.exogeni.orca.nodeagent.documents.UnregisterKeyResultElement;
import net.exogeni.orca.nodeagent.util.Serializer;
import org.apache.log4j.Logger;

public class NodeAgentServiceSkeleton {
    protected NodeAgentService service = NodeAgentService.getInstance();
    protected Logger logger = this.service.getLogger();

    public ScriptResultElement executeScript(ScriptElement arg) {
        this.logger.info((Object)"Received an executeScript request");
        String scriptName = arg.getScript();
        String arguments = arg.getArguments();
        if (scriptName == null) {
            this.logger.warn((Object)"No script name specified in request");
            return this.sendExecuteScriptResult(2, "", "");
        }
        DriverScriptExecutionResult r = this.service.executeScript(scriptName, arguments);
        return this.sendExecuteScriptResult(r.code, r.stdout, r.stderr);
    }

    public ResultElement installDriver(DriverElement arg) {
        this.logger.info((Object)"Received an install driver request");
        String className = arg.getClassName();
        String id = arg.getDriverId();
        DataHandler pkg = arg.getPkg();
        if (className == null || id == null) {
            this.logger.warn((Object)"Invalid arguments");
            return this.sendResult(2, null);
        }
        int code = this.service.installDriver(new DriverId(id), className, pkg);
        return this.sendResult(code, null);
    }

    public ResultElement upgradeDriver(DriverElement arg) {
        this.logger.info((Object)"Received an upgrade driver request");
        String className = arg.getClassName();
        String id = arg.getDriverId();
        DataHandler pkg = arg.getPkg();
        if (className == null || id == null) {
            this.logger.warn((Object)"Invalid arguments");
            return this.sendResult(2, null);
        }
        int code = this.service.upgradeDriver(new DriverId(id), className, pkg);
        return this.sendResult(code, null);
    }

    public ResultElement uninstallDriver(DriverElement arg) {
        this.logger.info((Object)"Received an uninstall driver request");
        String id = arg.getDriverId();
        if (id == null) {
            this.logger.warn((Object)"Invalid arguments");
            return this.sendResult(2, null);
        }
        int code = this.service.uninstall(new DriverId(id));
        return this.sendResult(code, null);
    }

    public ResultElement executeDriver(DriverRequestElement arg) {
        this.logger.info((Object)"Received an executeDriver request");
        String strDriverId = arg.getDriverId();
        String actionId = arg.getActionId();
        Properties p = Serializer.serialize(arg.getProperties());
        if (strDriverId == null || actionId == null) {
            this.logger.warn((Object)"Invalid arguments");
            return this.sendResult(2, null);
        }
        DriverId driverId = new DriverId(strDriverId);
        Properties out = new Properties();
        int result = this.service.executeDriver(driverId, actionId, p, out);
        return this.sendResult(result, out);
    }

    public ResultElement executeObjectDriver(DriverObjectRequestElement arg) {
        this.logger.info((Object)"Received an executeDriver request");
        String strDriverId = arg.getDriverId();
        String objectId = arg.getObjectId();
        String actionId = arg.getActionId();
        Properties p = Serializer.serialize(arg.getProperties());
        if (strDriverId == null || actionId == null) {
            this.logger.warn((Object)"Invalid arguments");
            return this.sendResult(2, null);
        }
        DriverId driverId = new DriverId(strDriverId);
        Properties out = new Properties();
        int result = objectId == null ? this.service.executeDriver(driverId, actionId, p, out) : this.service.executeObjectDriver(driverId, objectId, actionId, p, out);
        return this.sendResult(result, out);
    }

    public TestFuncResultElement testFunc(TestFuncElement in) {
        this.logger.debug((Object)("Param1 received in testFunc " + in.getTestFuncElement()));
        int ret = in.getTestFuncElement() + 10;
        TestFuncResultElement trf = new TestFuncResultElement();
        trf.setTestFuncResultElement(ret);
        this.logger.debug((Object)("Value returned " + trf.getTestFuncResultElement()));
        String t = RootPathResolver.getRoot();
        this.logger.debug((Object)("RealBase : " + t));
        return trf;
    }

    public RegisterKeyResultElement registerKey(RegisterKeyElement rk) {
        this.logger.info((Object)"Received registerKey request");
        String alias = rk.getAlias();
        byte[] certificateEncoding = rk.getPublickey();
        int result = this.service.registerKey(alias, certificateEncoding);
        RegisterKeyResultElement rkr = new RegisterKeyResultElement();
        rkr.setRegisterKeyResultElement(result);
        return rkr;
    }

    public UnregisterKeyResultElement unregisterKey(UnregisterKeyElement urk) {
        this.logger.info((Object)"Received an unregisterKey request");
        String alias = urk.getAlias();
        int result = this.service.unregisterKey(alias);
        UnregisterKeyResultElement urkr = new UnregisterKeyResultElement();
        urkr.setUnregisterKeyResultElement(result);
        return urkr;
    }

    public RegisterAuthorityKeyResultElement registerAuthorityKey(RegisterAuthorityKeyElement rak) {
        this.logger.info((Object)"Received registerAuthorityKey request");
        String alias = rak.getAlias();
        byte[] certificateEnconding = rak.getCertificate();
        byte[] message = rak.getRequest();
        byte[] signature = rak.getSignature();
        RegisterAuthorityKeyResultElement gskre = this.service.registerAuthorityKey(alias, certificateEnconding, message, signature);
        return gskre;
    }

    public GetServiceKeyResultElement getServiceKey(GetServiceKeyElement gske) {
        GetServiceKeyResultElement gskre = this.service.getServiceKey();
        return gskre;
    }

    protected ResultElement sendResult(int code, Properties p) {
        ResultElement result = new ResultElement();
        result.setCode(code);
        result.setProperties(Serializer.serialize(p));
        return result;
    }

    protected ScriptResultElement sendExecuteScriptResult(int code, String stdout, String stderr) {
        String message = NodeAgentConstants.getMessage(code);
        ScriptResultElement result = new ScriptResultElement();
        result.setCode(code);
        result.setMessage(message);
        result.setStdOut(stdout);
        result.setStdError(stderr);
        return result;
    }
}

