/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import net.exogeni.orca.drivers.DriverFactory;
import net.exogeni.orca.drivers.DriverId;
import net.exogeni.orca.drivers.IDriver;
import net.exogeni.orca.drivers.util.DriverScriptExecutionResult;
import net.exogeni.orca.drivers.util.DriverScriptExecutor;
import net.exogeni.orca.nodeagent.KeyMasterMessage;
import net.exogeni.orca.nodeagent.MerlinKeyRegister;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.RootPathResolver;
import net.exogeni.orca.nodeagent.documents.GetServiceKeyResultElement;
import net.exogeni.orca.nodeagent.documents.RegisterAuthorityKeyResultElement;
import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axis2.util.Base64;
import org.apache.log4j.Logger;

public class NodeAgentService {
    public static String PropertyExceptionMessage = "driver.exception.message";
    public static String PropertyExceptionStack = "driver.exception.stack";
    public static String AuthHash = "AUTH_HASH";
    public static String NodeToken = "NODE_TOKEN";
    private String cmdlineAuthorityHash = null;
    private String cmdlineNodeToken = null;
    static NodeAgentService instance = new NodeAgentService();
    protected DriverFactory factory;
    protected Logger logger;
    protected boolean debug = true;
    protected String root = RootPathResolver.getRoot();
    protected String dataFolder = this.root + "/data";
    protected String driversFile = this.dataFolder + "/drivers.xml";
    protected String ServerKeyStoreDestination = this.dataFolder + "/server.jks";
    private boolean called = false;
    protected String serverKeyStoreName = "server.jks";
    protected String serverStorePassword = "serverstorepass";
    protected String serverAlias = "serverkey";
    protected String authorityKeyEntry = "firstkey";
    protected String testCmdLineFile = "testcmdline";

    protected NodeAgentService() {
        this.logger = Logger.getLogger((String)this.getClass().getCanonicalName());
        this.factory = new DriverFactory();
        this.factory.setDriversRoot(this.dataFolder + "/drivers/");
        this.loadDrivers();
    }

    protected void loadDrivers() {
        try {
            this.logger.debug((Object)("Root folder: " + this.root));
            this.logger.debug((Object)("Data folder: " + this.dataFolder));
            this.logger.debug((Object)("Drivers file: " + this.driversFile));
            int code = this.factory.load(this.driversFile);
            this.logger.debug((Object)("loadDrivers exit code: " + code));
        }
        catch (Exception e) {
            this.logger.error((Object)"An error in loadDrivers", (Throwable)e);
        }
    }

    public String getRoot() {
        return this.root;
    }

    public String getDataFolder() {
        return this.dataFolder;
    }

    protected synchronized int expandPackage(DriverId id, DataHandler pkg, boolean fresh) {
        this.logger.debug((Object)("Trying to expand package: fresh=" + fresh));
        int code = 0;
        String folder = this.factory.getDriverRoot(id);
        File f = new File(folder);
        if (f.exists() && fresh) {
            this.logger.debug((Object)"driver is already installed");
            return DriverFactory.CodeDriverIsAlreadyInstalled;
        }
        this.logger.debug((Object)"driver folder does not exist");
        if (fresh && !f.mkdir()) {
            this.logger.debug((Object)("cannot create folder: " + f.getAbsolutePath()));
            return DriverFactory.CodeCannotCreateDirectory;
        }
        this.logger.debug((Object)("folder created: " + f.getAbsolutePath()));
        try {
            File inst;
            File temp = new File(f.getAbsolutePath() + "/install.tar.gz");
            InputStream inStream = pkg.getDataSource().getInputStream();
            byte[] bytes = IOUtils.getStreamAsByteArray((InputStream)inStream);
            FileOutputStream fs = new FileOutputStream(temp);
            fs.write(bytes);
            fs.close();
            String fileName = temp.getAbsolutePath();
            String command = "tar xvfz " + fileName + " -C " + folder;
            DriverScriptExecutor exec = new DriverScriptExecutor(command);
            DriverScriptExecutionResult result = exec.execute();
            code = result.code;
            temp.delete();
            if (code == 0 && (inst = new File(f.getAbsolutePath() + "/install.sh")).exists()) {
                command = "chmod u+x " + f.getAbsolutePath() + "/install.sh";
                exec = new DriverScriptExecutor(command);
                result = exec.execute();
                code = result.code;
                if (code == 0) {
                    command = f.getAbsolutePath() + "/install.sh " + f.getAbsolutePath();
                    exec = new DriverScriptExecutor(command);
                    result = exec.execute();
                    code = result.code;
                    if (code != 0) {
                        this.removePackage(id);
                    }
                } else {
                    this.removePackage(id);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"expandPackage", (Throwable)e);
            code = DriverFactory.CodeCannotExpandPackage;
            try {
                this.removePackage(id);
            }
            catch (Exception ee) {
                this.logger.error((Object)"", (Throwable)ee);
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int installDriver(DriverId id, String className, DataHandler pkg) {
        int code;
        block7: {
            code = 0;
            try {
                if (pkg != null && (code = this.expandPackage(id, pkg, true)) != 0) {
                    return code;
                }
                code = this.factory.install(id, className);
                if (code == 0) {
                    String string = this.driversFile;
                    synchronized (string) {
                        code = this.factory.save(this.driversFile);
                        break block7;
                    }
                }
                this.removePackage(id);
            }
            catch (Exception e) {
                code = 1;
            }
        }
        this.logger.debug((Object)"Finished install driver");
        this.logger.debug((Object)("Exit code: " + code));
        return code;
    }

    protected int removePackage(DriverId id) throws Exception {
        String command = "rm -rf " + this.factory.getDriverRoot(id);
        DriverScriptExecutor exec = new DriverScriptExecutor(command);
        DriverScriptExecutionResult result = exec.execute();
        return result.code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int upgradeDriver(DriverId id, String className, DataHandler pkg) {
        int code;
        block6: {
            code = 0;
            try {
                if (pkg != null && (code = this.expandPackage(id, pkg, false)) != 0) {
                    return code;
                }
                code = this.factory.upgrade(id, className);
                if (code != 0) break block6;
                String string = this.driversFile;
                synchronized (string) {
                    code = this.factory.save(this.driversFile);
                }
            }
            catch (Exception e) {
                code = 1;
            }
        }
        this.logger.debug((Object)"Finished upgrade driver");
        this.logger.debug((Object)("Exit code: " + code));
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int uninstall(DriverId id) {
        int code;
        block5: {
            code = 0;
            try {
                this.removePackage(id);
                code = this.factory.uninstall(id);
                if (code != 0) break block5;
                String string = this.driversFile;
                synchronized (string) {
                    code = this.factory.save(this.driversFile);
                }
            }
            catch (Exception e) {
                code = 1;
            }
        }
        this.logger.debug((Object)"Finished uninstall driver");
        this.logger.debug((Object)("Exit code: " + code));
        return code;
    }

    public DriverScriptExecutionResult executeScript(String name, String arguments) {
        DriverScriptExecutionResult r = new DriverScriptExecutionResult();
        try {
            int code;
            String command = name + " " + arguments;
            this.logger.debug((Object)("command: " + command));
            this.logger.debug((Object)"Starting execution");
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(command);
            InputStream in = proc.getInputStream();
            InputStreamReader inr = new InputStreamReader(in);
            BufferedReader inbr = new BufferedReader(inr);
            InputStream err = proc.getErrorStream();
            InputStreamReader errr = new InputStreamReader(err);
            BufferedReader errbr = new BufferedReader(errr);
            boolean moreIn = true;
            boolean moreErr = true;
            StringBuffer inb = new StringBuffer();
            StringBuffer eb = new StringBuffer();
            while (moreIn || moreErr) {
                String line;
                if (moreIn) {
                    line = inbr.readLine();
                    if (line == null) {
                        moreIn = false;
                    } else {
                        if (inb.length() > 0) {
                            inb.append("\n");
                        }
                        inb.append(line);
                    }
                }
                if (!moreErr) continue;
                line = errbr.readLine();
                if (line == null) {
                    moreErr = false;
                    continue;
                }
                if (eb.length() > 0) {
                    eb.append("\n");
                }
                eb.append(line);
            }
            r.code = code = proc.waitFor();
            r.stdout = inb.toString();
            r.stderr = eb.toString();
        }
        catch (Exception e) {
            r.code = 1;
            r.stdout = e.getMessage();
            r.stderr = this.getStackTraceString(e);
        }
        this.logger.debug((Object)"Finished execution");
        this.logger.debug((Object)("Error code: " + r.code));
        this.logger.debug((Object)("Standard out: " + r.stdout));
        this.logger.debug((Object)("Standard error: " + r.stderr));
        return r;
    }

    public int executeDriver(DriverId driverId, String actionId, Properties in, Properties out) {
        this.logger.debug((Object)("DriverId: " + driverId));
        this.logger.debug((Object)("ActionId: " + actionId));
        this.logger.debug((Object)("Properties: " + in.toString()));
        IDriver driver = this.factory.getDriver(driverId);
        if (driver == null) {
            this.logger.warn((Object)"Invalid Driver");
            return 3;
        }
        int code = 0;
        try {
            this.logger.debug((Object)"Starting driver execution");
            code = driver.dispatch(actionId, in, out);
        }
        catch (Exception e) {
            this.logger.error((Object)"executionDriver", (Throwable)e);
            out.setProperty(PropertyExceptionMessage, e.getMessage());
            out.setProperty(PropertyExceptionStack, this.getStackTraceString(e));
            return 4;
        }
        this.logger.debug((Object)"Finished driver execution");
        this.logger.debug((Object)("Exit code: " + code));
        return code;
    }

    public int executeObjectDriver(DriverId driverId, String objectId, String actionId, Properties in, Properties out) {
        this.logger.debug((Object)("DriverId: " + driverId));
        this.logger.debug((Object)("ObjectId: " + objectId));
        this.logger.debug((Object)("ActionId: " + actionId));
        this.logger.debug((Object)("Properties: " + in.toString()));
        IDriver driver = this.factory.getDriver(driverId);
        if (driver == null) {
            this.logger.warn((Object)"Invalid Driver");
            return 3;
        }
        int code = 0;
        try {
            this.logger.debug((Object)"Starting driver execution");
            code = driver.dispatch2(objectId, actionId, in, out);
        }
        catch (Exception e) {
            this.logger.error((Object)"executionDriver", (Throwable)e);
            out.setProperty(PropertyExceptionMessage, e.getMessage());
            out.setProperty(PropertyExceptionStack, this.getStackTraceString(e));
            return 4;
        }
        this.logger.debug((Object)"Finished driver execution");
        this.logger.debug((Object)("Exit code: " + code));
        return code;
    }

    public int registerKey(String alias, byte[] certificateEncoding) {
        this.logger.debug((Object)("registerKey called for alias " + alias));
        ByteArrayInputStream inStream = new ByteArrayInputStream(certificateEncoding);
        Certificate cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = cf.generateCertificate(inStream);
            while (inStream.available() > 0) {
                cert = cf.generateCertificate(inStream);
                this.logger.debug((Object)("Adding certificate to server key store " + cert.toString()));
            }
            this.logger.debug((Object)("Request for registering certificate: " + cert.toString()));
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Exception at registerKey");
            this.logger.debug((Object)ex.getMessage());
            return 1;
        }
        if (cert != null) {
            MerlinKeyRegister mr = MerlinKeyRegister.getInstance();
            if (mr == null) {
                this.logger.debug((Object)"MerlinReloader is NULL !!!");
                return 1;
            }
            this.logger.debug((Object)"MerlinReloader is not NULL !!!");
            try {
                mr.addKeyToKeystore(alias, cert);
            }
            catch (Exception ex) {
                this.logger.debug((Object)("Exception while registering key " + ex.getMessage()));
                return 1;
            }
        } else {
            this.logger.debug((Object)"Certificate is null !!!");
            return 1;
        }
        return 0;
    }

    public int unregisterKey(String alias) {
        MerlinKeyRegister mr = MerlinKeyRegister.getInstance();
        if (mr == null) {
            this.logger.debug((Object)"MerlinReloader is NULL !!!");
            return 1;
        }
        try {
            mr.removeKeyFromKeyStore(alias);
        }
        catch (Exception ex) {
            this.logger.debug((Object)("Exception while unregistering key " + ex.getMessage()));
            return 1;
        }
        return 0;
    }

    public RegisterAuthorityKeyResultElement registerAuthorityKey(String alias, byte[] certificateEncoding, byte[] message, byte[] signature) {
        this.logger.debug((Object)("registerAuthorityKey requested for alias " + alias));
        if (this.getCalled()) {
            RegisterAuthorityKeyResultElement gskre = this.buildServiceKeyResultElement();
            return gskre;
        }
        int val = this.loadCmdLineParameters();
        if (val != 0 && (val = this.loadCmdLineParametersFromFile(this.testCmdLineFile)) != 0) {
            RegisterAuthorityKeyResultElement gskre = this.errorServiceKeyResultElement(val);
            return gskre;
        }
        val = this.verifyCertificateHash(certificateEncoding);
        if (val != 0) {
            RegisterAuthorityKeyResultElement gskre = this.errorServiceKeyResultElement(val);
            return gskre;
        }
        val = this.verifyMessageSignature(certificateEncoding, message, signature);
        if (val != 0) {
            RegisterAuthorityKeyResultElement gskre = this.errorServiceKeyResultElement(val);
            return gskre;
        }
        String messageString = new String(message);
        this.logger.debug((Object)"message received from client");
        this.logger.debug((Object)messageString);
        KeyMasterMessage km = new KeyMasterMessage();
        this.logger.debug((Object)"creating keymastermessage");
        km.buildXMLDocument(messageString);
        this.logger.debug((Object)"extracting msgNodeIP");
        String msgNodeIP = km.getNode("nodeIP");
        this.logger.debug((Object)("msgNodeIP " + msgNodeIP));
        String msgAuthIP = km.getNode("authorityIP");
        this.logger.debug((Object)("msgAuthIP " + msgAuthIP));
        String msgTimestamp = km.getNode("timestamp");
        this.logger.debug((Object)("msgTimestamp " + msgTimestamp));
        this.logger.debug((Object)"check message parameters!!!");
        val = this.checkMessageParameters(msgNodeIP, msgTimestamp, msgAuthIP);
        if (val != 0) {
            RegisterAuthorityKeyResultElement gskre = this.errorServiceKeyResultElement(val);
            return gskre;
        }
        this.logger.debug((Object)"cheking recovery!!!");
        int recoveryVal = MerlinKeyRegister.checkRecovery();
        if (recoveryVal == 7) {
            this.logger.debug((Object)"recovery succeeded");
            this.setCalled(true);
            RegisterAuthorityKeyResultElement gskre = this.buildServiceKeyResultElement();
            return gskre;
        }
        if (recoveryVal == 6) {
            Certificate cert = this.generateCertificate(certificateEncoding);
            if (cert == null) {
                this.logger.debug((Object)"received certificate is null!");
                RegisterAuthorityKeyResultElement gskre = this.errorServiceKeyResultElement(val);
                return gskre;
            }
            val = MerlinKeyRegister.createServiceKeyStore(alias, cert);
            if (val != 0) {
                this.logger.debug((Object)"error while creating service keys");
                RegisterAuthorityKeyResultElement gskre = this.errorServiceKeyResultElement(val);
                return gskre;
            }
            this.setCalled(true);
            RegisterAuthorityKeyResultElement gskre = this.buildServiceKeyResultElement();
            return gskre;
        }
        RegisterAuthorityKeyResultElement gskre = this.errorServiceKeyResultElement(1);
        return gskre;
    }

    public GetServiceKeyResultElement getServiceKey() {
        Certificate cert;
        this.logger.debug((Object)"getServiceKey invoked");
        GetServiceKeyResultElement gskre = new GetServiceKeyResultElement();
        if (!this.getCalled()) {
            int recoveryVal = MerlinKeyRegister.checkRecovery();
            if (recoveryVal != 7) {
                this.logger.debug((Object)"The Service Key has not been generated");
                gskre.setCode(1);
                gskre.setKey(new byte[1]);
                return gskre;
            }
            int val = this.loadCmdLineParameters();
            if (val != 0 && (val = this.loadCmdLineParametersFromFile(this.testCmdLineFile)) != 0) {
                gskre.setCode(1);
                gskre.setKey(new byte[1]);
                return gskre;
            }
            this.setCalled(true);
        }
        if ((cert = MerlinKeyRegister.getServiceKey()) == null) {
            gskre.setCode(1);
            gskre.setKey(new byte[1]);
        } else {
            try {
                byte[] certBytes = cert.getEncoded();
                gskre.setCode(0);
                gskre.setKey(certBytes);
            }
            catch (CertificateEncodingException ex) {
                this.logger.debug((Object)"Service certificate encoding exception");
                gskre.setCode(1);
                gskre.setKey(new byte[1]);
                return gskre;
            }
        }
        return gskre;
    }

    private RegisterAuthorityKeyResultElement buildServiceKeyResultElement() {
        RegisterAuthorityKeyResultElement gskre = new RegisterAuthorityKeyResultElement();
        try {
            Certificate cert = MerlinKeyRegister.getServiceKey();
            PublicKey pk = cert.getPublicKey();
            String pkFormat = pk.getFormat();
            this.logger.debug((Object)("pkFormat for the public key is " + pkFormat));
            KeyGenerator kg = KeyGenerator.getInstance("TripleDES");
            SecretKey secretKey = kg.generateKey();
            byte[] skByteEnc = secretKey.getEncoded();
            String base64Str = Base64.encode((byte[])skByteEnc);
            this.logger.debug((Object)"answer to encrypt with private key");
            this.logger.debug((Object)base64Str);
            byte[] toEncrypt = base64Str.getBytes();
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            Certificate certAuthority = MerlinKeyRegister.getAuthorityKey();
            cipher.init(1, certAuthority.getPublicKey());
            byte[] encryptedBytes = cipher.doFinal(toEncrypt);
            gskre.setKey(encryptedBytes);
            byte[] certBytes = cert.getEncoded();
            KeyMasterMessage km = new KeyMasterMessage();
            String[] nodes1 = new String[]{"nodecertificate", "nodetoken"};
            km.createXMLDocument(nodes1);
            String base64StrCert = Base64.encode((byte[])certBytes);
            km.setNode("nodecertificate", base64StrCert);
            km.setNode("nodetoken", this.cmdlineNodeToken);
            String strDoc = km.getXMLDocumentAsString();
            byte[] toEncryptDoc = strDoc.getBytes();
            Cipher cipherSym = Cipher.getInstance("TripleDES");
            cipherSym.init(1, secretKey);
            byte[] encryptedBytesDoc = cipherSym.doFinal(toEncryptDoc);
            gskre.setResponse(encryptedBytesDoc);
            gskre.setCode(0);
            return gskre;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"the certificate could not be read");
            this.logger.debug((Object)("error message is " + ex.getMessage()));
            gskre.setKey(new byte[1]);
            gskre.setResponse(new byte[1]);
            gskre.setCode(1);
            return gskre;
        }
    }

    private RegisterAuthorityKeyResultElement errorServiceKeyResultElement(int val) {
        RegisterAuthorityKeyResultElement gskre = new RegisterAuthorityKeyResultElement();
        gskre.setCode(val);
        gskre.setKey(new byte[1]);
        gskre.setResponse(new byte[1]);
        return gskre;
    }

    public String getStackTraceString(Exception e) {
        StackTraceElement[] trace = e.getStackTrace();
        StringBuffer sb = new StringBuffer();
        sb.append("Exception stack trace: \n");
        for (int i = 0; i < trace.length; ++i) {
            sb.append(trace[i].toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static NodeAgentService getInstance() {
        return instance;
    }

    private Certificate generateCertificate(byte[] certificateEncoding) {
        ByteArrayInputStream inStream = new ByteArrayInputStream(certificateEncoding);
        Certificate cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = cf.generateCertificate(inStream);
            while (inStream.available() > 0) {
                cert = cf.generateCertificate(inStream);
            }
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Invalid certificate !!!");
            this.logger.debug((Object)ex.getMessage());
        }
        return cert;
    }

    private String toHexString(byte[] digest) {
        char[] hexValues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer stringBuf = new StringBuffer();
        int len = digest.length;
        for (int i = 0; i < len; ++i) {
            int first = (digest[i] & 0xF0) >> 4;
            int second = digest[i] & 0xF;
            stringBuf.append(hexValues[first]);
            stringBuf.append(hexValues[second]);
            if (i == len - 1) continue;
            stringBuf.append(":");
        }
        return stringBuf.toString();
    }

    private int verifyCertificateHash(byte[] certificateEnconding) {
        Certificate cert = this.generateCertificate(certificateEnconding);
        if (cert == null) {
            return 1;
        }
        try {
            cert.verify(cert.getPublicKey());
        }
        catch (Exception ex) {
            this.logger.debug((Object)"exception while verifying the certificate");
            return 2;
        }
        String digestType = null;
        String sigAlg = ((X509Certificate)cert).getSigAlgName();
        if (sigAlg.contains("SHA")) {
            digestType = "SHA";
        } else if (sigAlg.contains("MD5")) {
            digestType = "MD5";
        } else {
            this.logger.debug((Object)("unknown digest type sigAlg is " + sigAlg));
            return 2;
        }
        String computedHash = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(digestType);
            messageDigest.update(certificateEnconding);
            byte[] digestValue = messageDigest.digest();
            computedHash = this.toHexString(digestValue);
            this.logger.debug((Object)(digestType + " for certificate is " + computedHash));
        }
        catch (NoSuchAlgorithmException ex) {
            this.logger.debug((Object)"exception while computing the digest value");
            return 1;
        }
        if (this.cmdlineAuthorityHash.compareTo(computedHash) != 0) {
            this.logger.debug((Object)("hashes do not match: " + this.cmdlineAuthorityHash + " != " + computedHash));
            return 2;
        }
        return 0;
    }

    private int verifyMessageSignature(byte[] certificateEnconding, byte[] message, byte[] signature) {
        Certificate cert = this.generateCertificate(certificateEnconding);
        if (cert == null) {
            return 1;
        }
        try {
            cert.verify(cert.getPublicKey());
        }
        catch (Exception ex) {
            this.logger.debug((Object)"exception while verifying the certificate");
            return 2;
        }
        String digestType = null;
        String sigAlg = ((X509Certificate)cert).getSigAlgName();
        if (sigAlg.contains("SHA")) {
            digestType = "SHA";
        } else if (sigAlg.contains("MD5")) {
            digestType = "MD5";
        } else {
            this.logger.debug((Object)("unknown digest type sigAlg is " + sigAlg));
            return 2;
        }
        try {
            Signature sig = null;
            if (digestType.contains("MD5")) {
                sig = Signature.getInstance("MD5withRSA");
            } else if (digestType.contains("SHA")) {
                sig = Signature.getInstance("SHA1withRSA");
            }
            sig.initVerify(cert);
            sig.update(message);
            if (!sig.verify(signature)) {
                this.logger.debug((Object)"Signature verification failed!");
                return 2;
            }
            this.logger.debug((Object)"Signature verified succesfully!");
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Exception while verifying the signature");
            return 2;
        }
        return 0;
    }

    private int loadCmdLineParameters() {
        try {
            RandomAccessFile rf = new RandomAccessFile("/proc/cmdline", "r");
            String cmdline = rf.readLine();
            int fromIndex = cmdline.indexOf(AuthHash);
            if (fromIndex == -1) {
                this.logger.debug((Object)("could not read " + AuthHash + " from /proc/cmdline"));
                return 1;
            }
            int argLen = AuthHash.length() + 1;
            int toIndex = cmdline.indexOf(" ", fromIndex);
            if (toIndex == -1) {
                toIndex = cmdline.length();
            }
            this.cmdlineAuthorityHash = cmdline.substring(fromIndex + argLen, toIndex);
            if (this.cmdlineAuthorityHash == null) {
                this.logger.debug((Object)"hash not provided in the boot command line");
                return 1;
            }
            fromIndex = cmdline.indexOf(NodeToken);
            if (fromIndex == -1) {
                this.logger.debug((Object)("could not read " + NodeToken + " from /proc/cmdline"));
                return 1;
            }
            argLen = NodeToken.length() + 1;
            toIndex = cmdline.indexOf(" ", fromIndex);
            if (toIndex == -1) {
                toIndex = cmdline.length();
            }
            this.cmdlineNodeToken = cmdline.substring(fromIndex + argLen, toIndex);
            if (this.cmdlineNodeToken == null) {
                this.logger.debug((Object)"Node's token not provided in the boot command line");
                return 1;
            }
            this.logger.debug((Object)("read cmdlineAuthorityHash " + this.cmdlineAuthorityHash));
            this.logger.debug((Object)("read cmdlineNodeToken " + this.cmdlineNodeToken));
            this.logger.debug((Object)("cmdline read is " + cmdline));
        }
        catch (Exception ex) {
            this.logger.debug((Object)"exception while reading /proc/cmdline");
            return 1;
        }
        return 0;
    }

    private int loadCmdLineParametersFromFile(String filename) {
        InputStream in = NodeAgentServiceStub.class.getClassLoader().getResourceAsStream(filename);
        if (in == null) {
            this.logger.debug((Object)("Could not read file " + filename));
        }
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        try {
            String cmdline = br.readLine();
            this.logger.debug((Object)("cmdline read is " + cmdline));
            if (cmdline == null) {
                this.logger.debug((Object)("could not read the cmdline from file " + filename));
                return 1;
            }
            int fromIndex = cmdline.indexOf(AuthHash);
            if (fromIndex == -1) {
                this.logger.debug((Object)("could not read " + AuthHash + " from " + filename));
                return 1;
            }
            int argLen = AuthHash.length() + 1;
            int toIndex = cmdline.indexOf(" ", fromIndex);
            if (toIndex == -1) {
                toIndex = cmdline.length();
            }
            this.cmdlineAuthorityHash = cmdline.substring(fromIndex + argLen, toIndex);
            if (this.cmdlineAuthorityHash == null) {
                this.logger.debug((Object)"hash not provided in the boot command line");
                return 1;
            }
            fromIndex = cmdline.indexOf(NodeToken);
            if (fromIndex == -1) {
                this.logger.debug((Object)("could not read " + NodeToken + " from " + filename));
                return 1;
            }
            argLen = NodeToken.length() + 1;
            toIndex = cmdline.indexOf(" ", fromIndex);
            if (toIndex == -1) {
                toIndex = cmdline.length();
            }
            this.cmdlineNodeToken = cmdline.substring(fromIndex + argLen, toIndex);
            if (this.cmdlineNodeToken == null) {
                this.logger.debug((Object)"Node's token not provided in the boot command line");
                return 1;
            }
            this.logger.debug((Object)("read cmdlineAuthorityHash " + this.cmdlineAuthorityHash));
            this.logger.debug((Object)("read cmdlineNodeToken " + this.cmdlineNodeToken));
        }
        catch (Exception ex) {
            this.logger.debug((Object)("exception while reading file " + filename));
            this.logger.debug((Object)ex.getMessage());
            return 1;
        }
        return 0;
    }

    private int checkMessageParameters(String msgNodeIP, String msgTimestamp, String msgAuthIP) {
        return 0;
    }

    public synchronized void setCalled(boolean flag) {
        this.called = flag;
    }

    public synchronized boolean getCalled() {
        return this.called;
    }
}

