/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Properties;
import net.exogeni.orca.nodeagent.RootPathResolver;
import net.exogeni.orca.util.ID;
import org.apache.log4j.Logger;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Merlin;

public class MerlinKeyRegister
extends Merlin {
    public static final String AuthorityKeyStoreEntry = "firstkey";
    public static final String ServiceKeyStoreEntry = "serverkey";
    public static final String ServerKeyValidity = "3650";
    public static final String ServerKeySize = "2048";
    public static final String ServerKeyStoreName = "server.jks";
    public static final String ServicePropertiesFile = "service.properties";
    public static final int CodeInternalError = 1;
    public static final int CodeRecoverySuccessful = 7;
    public static final int CodeNoRecovery = 6;
    private static final String ServerKeyPassword = "serverkeypass";
    protected static final Logger logger = Logger.getLogger((String)MerlinKeyRegister.class.getCanonicalName());
    protected static final String root = RootPathResolver.getRoot();
    protected static final String dataFolder = root + "/data/";
    protected static final String ServerKeyStoreDestination = dataFolder + "server.jks";
    protected static MerlinKeyRegister mr = null;
    protected static KeyStore keyStore = null;
    protected static String serverPassword;

    public static MerlinKeyRegister getInstance() {
        return mr;
    }

    public MerlinKeyRegister(Properties prop) throws IOException, CredentialException {
        super(prop);
        logger.debug((Object)("Constructor (prop) invoked. mr=" + (Object)((Object)mr)));
        try {
            mr = this;
            this.verify(prop);
        }
        catch (Exception e) {
            logger.error((Object)"Could not create instance", (Throwable)e);
            throw new RuntimeException(e);
        }
        logger.debug((Object)"Constructor (prop) completed");
    }

    public MerlinKeyRegister(Properties prop, ClassLoader cls) throws IOException, CredentialException {
        super(prop, cls);
        logger.debug((Object)("Constructor (prop, cls) invoked. mr=" + (Object)((Object)mr)));
        try {
            mr = this;
            this.verify(prop);
        }
        catch (Exception e) {
            logger.error((Object)"Could not create instance", (Throwable)e);
            throw new RuntimeException(e);
        }
        logger.debug((Object)"Constructor (prop, cls) completed");
    }

    private void verify(Properties prop) throws IOException {
        logger.debug((Object)"verify called");
        logger.debug((Object)("Root directory is: " + root));
        logger.debug((Object)("Server keystore path is: " + ServerKeyStoreDestination));
        if (keyStore != null) {
            logger.debug((Object)"Merlin KeyStore is not null, setting it");
            this.setKeyStore(keyStore);
        } else {
            logger.debug((Object)"Merlin Keystore instance is null.");
            File f = new File(ServerKeyStoreDestination);
            if (f.exists()) {
                logger.debug((Object)"We have a keystore");
                int recVal = MerlinKeyRegister.checkRecovery();
                if (recVal == 7) {
                    logger.debug((Object)"Recovery succeeded");
                    this.setKeyStore(keyStore);
                } else {
                    logger.debug((Object)"Recovery failed");
                }
            } else {
                logger.debug((Object)"No keystore to recover!");
            }
        }
    }

    public void setKeyStore(KeyStore arg0) {
        super.setKeyStore(arg0);
        logger.debug((Object)"keystore set");
    }

    public static synchronized int checkRecovery() {
        logger.debug((Object)"Recovery invoked!");
        logger.debug((Object)("Root directory is: " + root));
        logger.debug((Object)("Server keystore path is: " + ServerKeyStoreDestination));
        InputStream in = MerlinKeyRegister.class.getClassLoader().getResourceAsStream(ServicePropertiesFile);
        if (in == null) {
            logger.debug((Object)"can not get the crypto provider properties");
            return 1;
        }
        Properties prop = new Properties();
        try {
            prop.load(in);
        }
        catch (Exception ex) {
            logger.debug((Object)"can not load the crypto provider as properties");
            return 1;
        }
        serverPassword = prop.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
        File file = new File(ServerKeyStoreDestination);
        if (file.exists()) {
            try {
                FileInputStream fisKeyStore = new FileInputStream(ServerKeyStoreDestination);
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(fisKeyStore, serverPassword.toCharArray());
                logger.debug((Object)"keystore loaded succesfully!");
                Certificate cert = ks.getCertificate(AuthorityKeyStoreEntry);
                if (cert == null) {
                    logger.debug((Object)"could not find the authority certificate");
                    file.delete();
                    return 6;
                }
                PublicKey pk = cert.getPublicKey();
                try {
                    cert.verify(pk);
                }
                catch (Exception ex) {
                    logger.debug((Object)"exception while verifying authority certificate during recovery");
                    file.delete();
                    return 6;
                }
                cert = ks.getCertificate(ServiceKeyStoreEntry);
                if (cert == null) {
                    logger.debug((Object)"could not find a service certificate");
                    file.delete();
                    return 6;
                }
                pk = cert.getPublicKey();
                try {
                    cert.verify(pk);
                }
                catch (Exception ex) {
                    logger.debug((Object)"exception while verifying service certificate during recovery");
                    file.delete();
                    return 6;
                }
                keyStore = ks;
                return 7;
            }
            catch (KeyStoreException ex) {
                logger.debug((Object)"exception at keystore while trying recovery");
                file.delete();
                return 6;
            }
            catch (NoSuchAlgorithmException ex) {
                logger.debug((Object)"exception at keystore while trying recovery");
                file.delete();
                return 6;
            }
            catch (CertificateException ex) {
                logger.debug((Object)"exception at keystore while trying recovery");
                file.delete();
                return 6;
            }
            catch (IOException ex) {
                logger.debug((Object)"exception at keystore while trying recovery");
                file.delete();
                return 6;
            }
        }
        logger.debug((Object)"Could not locate the keystore file!");
        return 6;
    }

    public static synchronized int createServiceKeyStore(String alias, Certificate cert) {
        if (keyStore != null) {
            logger.debug((Object)"keyStore already initialized createServiceKeyStore is invoked multiple times!!!");
            return 1;
        }
        InputStream in = MerlinKeyRegister.class.getClassLoader().getResourceAsStream(ServicePropertiesFile);
        if (in == null) {
            logger.debug((Object)"can not get the crypto provider properties");
            return 1;
        }
        Properties prop = new Properties();
        try {
            prop.load(in);
        }
        catch (IOException ex) {
            logger.debug((Object)"cannot load the crypto provider as properties");
            return 1;
        }
        serverPassword = prop.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
        File file = new File(ServerKeyStoreDestination);
        if (file.exists()) {
            logger.debug((Object)(ServerKeyStoreDestination + " exists, multiple calls to createServiceKeystore !!!"));
            return 1;
        }
        try {
            logger.debug((Object)"creating the keystore");
            FileOutputStream fos = new FileOutputStream(file);
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(null, serverPassword.toCharArray());
            logger.debug((Object)"keystore created");
            ks.setCertificateEntry(AuthorityKeyStoreEntry, cert);
            logger.debug((Object)"authority certificate saved");
            ks.store(fos, serverPassword.toCharArray());
            fos.close();
            logger.debug((Object)"stored the authority certificate");
            int val = MerlinKeyRegister.generateServiceCertificate();
            if (val != 0) {
                logger.debug((Object)"could not generate service certificate");
                return 1;
            }
            logger.debug((Object)"generated the service certificate\n");
            FileInputStream fin = new FileInputStream(file);
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(fin, serverPassword.toCharArray());
        }
        catch (KeyStoreException ex) {
            logger.debug((Object)"Exception while creating service keystore");
            logger.debug((Object)ex.getMessage());
            return 1;
        }
        catch (IOException ex) {
            logger.debug((Object)("Exception could not create/write to " + ServerKeyStoreDestination));
            return 1;
        }
        catch (NoSuchAlgorithmException ex) {
            logger.debug((Object)("Exception could not store the keystore in " + ServerKeyStoreDestination));
            return 1;
        }
        catch (CertificateException ex) {
            logger.debug((Object)("Exception could not store the keystore in " + ServerKeyStoreDestination));
            return 1;
        }
        return 0;
    }

    public static synchronized Certificate getServiceKey() {
        logger.debug((Object)"Merlin request for service key");
        try {
            Certificate cert = keyStore.getCertificate(ServiceKeyStoreEntry);
            return cert;
        }
        catch (KeyStoreException ex) {
            logger.debug((Object)"could not read the certificate serverkey from the keystore");
            return null;
        }
    }

    public static synchronized Certificate getAuthorityKey() {
        logger.debug((Object)"Merlin request for authority key");
        try {
            Certificate cert = keyStore.getCertificate(AuthorityKeyStoreEntry);
            return cert;
        }
        catch (KeyStoreException ex) {
            logger.debug((Object)"could not read the certificate firstkey from the keystore");
            return null;
        }
    }

    public void addKeyToKeystore(String alias, Certificate cert) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore.TrustedCertificateEntry trustedEntry = new KeyStore.TrustedCertificateEntry(cert);
        if (keyStore.containsAlias(alias)) {
            return;
        }
        keyStore.setEntry(alias, trustedEntry, null);
        keyStore.store(new FileOutputStream(ServerKeyStoreDestination), serverPassword.toCharArray());
        this.setKeyStore(keyStore);
    }

    public void removeKeyFromKeyStore(String alias) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!keyStore.containsAlias(alias)) {
            return;
        }
        keyStore.deleteEntry(alias);
        keyStore.store(new FileOutputStream(ServerKeyStoreDestination), serverPassword.toCharArray());
        this.setKeyStore(keyStore);
    }

    private static int generateServiceCertificate() {
        logger.debug((Object)"generate service certificate called");
        try {
            String line1;
            ID id = new ID();
            String[] cmd = new String[]{"keytool", "-genkey", "-alias", ServiceKeyStoreEntry, "-keystore", ServerKeyStoreName, "-keyalg", "rsa", "-storepass", serverPassword, "-keypass", ServerKeyPassword, "-dname", "CN=" + id.toString() + ",OU=orca,O=nicl,L=Durham,S=NC,C=US", "-validity", ServerKeyValidity, "-keysize", ServerKeySize};
            String cmdToExecute = "";
            for (int i = 0; i < 14; ++i) {
                cmdToExecute = cmdToExecute + cmd[i] + " ";
            }
            logger.debug((Object)"executing command");
            logger.debug((Object)cmdToExecute);
            File dir = new File(dataFolder);
            logger.debug((Object)"executing keytool command");
            Process p = Runtime.getRuntime().exec(cmd, null, dir);
            logger.debug((Object)("keytool command executed in " + dir));
            logger.debug((Object)"keytool command called waiting for result");
            p.waitFor();
            String line = "stdout \n";
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line1 = input.readLine()) != null) {
                line = line + line1 + "\n";
            }
            logger.debug((Object)line);
            line = "stderr \n";
            BufferedReader input2 = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line1 = input2.readLine()) != null) {
                line = line + line1 + "\n";
            }
            logger.debug((Object)line);
            int exitValue = p.exitValue();
            logger.debug((Object)("keytool exited with code " + exitValue));
            if (exitValue != 0) {
                logger.debug((Object)("keytool exited with error " + exitValue));
                return 1;
            }
        }
        catch (IOException ex) {
            logger.debug((Object)"could not run the keytool command");
            return 1;
        }
        catch (InterruptedException ex) {
            logger.debug((Object)"interrupted while executing the keytool command");
            return 1;
        }
        logger.debug((Object)"");
        return 0;
    }
}

