/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.tests.security.known;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.documents.RegisterKeyElement;
import net.exogeni.orca.nodeagent.documents.RegisterKeyResultElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;

public class TestRegisterKey {
    String serviceLocation;
    String repositoryPath;
    String configFile;
    String trudyKeyStoreLocation;
    char[] trudyStorePasswordChar;

    public TestRegisterKey() {
        this.serviceLocation = "http://localhost:8080/axis2/services/NodeAgentService";
        this.repositoryPath = "../lib/external";
        this.configFile = "test/orca/nodeagent/tests/security/known/client.axis2.xml";
        this.trudyKeyStoreLocation = "test/orca/nodeagent/tests/security/unknown/trudy.jks";
        this.trudyStorePasswordChar = new String("trudystorepass").toCharArray();
    }

    public TestRegisterKey(String serviceLocation, String repositoryPath, String configFile, String trudyKeyStoreLocation, String trudyStorePass) {
        this.serviceLocation = serviceLocation;
        this.repositoryPath = repositoryPath;
        this.configFile = configFile;
        this.trudyKeyStoreLocation = trudyKeyStoreLocation;
        this.trudyStorePasswordChar = trudyStorePass.toCharArray();
    }

    public int run() throws Exception {
        ConfigurationContext cc = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.repositoryPath, (String)this.configFile);
        NodeAgentServiceStub stub = new NodeAgentServiceStub(cc, this.serviceLocation);
        KeyStore ks = KeyStore.getInstance("JKS");
        FileInputStream fis = new FileInputStream(this.trudyKeyStoreLocation);
        ks.load(fis, this.trudyStorePasswordChar);
        fis.close();
        Certificate cert = ks.getCertificate("trudykey");
        byte[] certEncoding = cert.getEncoded();
        RegisterKeyElement rke = new RegisterKeyElement();
        rke.setAlias("trudykey");
        rke.setPublickey(certEncoding);
        RegisterKeyResultElement rkre = stub.registerKey(rke);
        int res = rkre.getRegisterKeyResultElement();
        return res;
    }

    public static void main(String[] args) throws Exception {
        TestRegisterKey test1 = null;
        test1 = new TestRegisterKey();
        test1.run();
    }
}

