/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.tests.security.known;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.exogeni.orca.nodeagent.tests.security.known.TestAuthorizedClient;
import net.exogeni.orca.nodeagent.tests.security.known.TestRegisterKey;
import net.exogeni.orca.nodeagent.tests.security.known.TestUnregisterKey;
import net.exogeni.orca.nodeagent.tests.security.unknown.TestUnauthorizedClient;

public class SecurityTest
extends TestCase {
    protected String serviceLocation = null;
    protected String repositoryPath = null;
    protected String configFileAuthorized = null;
    protected String configFileUnauthorized = null;
    protected String trudyKeyStoreLocation = null;
    protected String trudyKeyStorePass = null;
    TestAuthorizedClient tac;
    TestUnauthorizedClient tuc;
    TestRegisterKey trk;
    TestUnregisterKey tuk;

    public SecurityTest() {
        this(System.getenv("na.location"), System.getenv("na.repository"), System.getenv("na.config.authorized"), System.getenv("na.config.unauthorized"));
    }

    public SecurityTest(String location, String repository, String configFileAuthorized, String configFileUnauthorized) {
        if (location == null) {
            throw new RuntimeException("Location cannot be null");
        }
        if (repository == null) {
            throw new RuntimeException("Repository cannot be null");
        }
        if (configFileAuthorized == null) {
            throw new RuntimeException("ConfigFileAuthorized cannot be null");
        }
        if (configFileUnauthorized == null) {
            throw new RuntimeException("ConfigFileUnauthorized cannot be null");
        }
        this.serviceLocation = location;
        this.repositoryPath = repository;
        this.configFileAuthorized = configFileAuthorized;
        this.configFileUnauthorized = configFileUnauthorized;
    }

    public void setTrudyParameters() {
        this.trudyKeyStoreLocation = System.getenv("na.trudykeystorelocation");
        if (this.trudyKeyStoreLocation == null) {
            throw new RuntimeException("TrudyKeyStoreLocation cannot be null");
        }
        this.trudyKeyStorePass = System.getenv("na.trudykeystorepass");
        if (this.trudyKeyStorePass == null) {
            throw new RuntimeException("TrudyKeyStorePass cannot be null");
        }
    }

    public void test() throws Exception {
        int retVal;
        System.out.println("Running Authorized Client Security suite ...");
        this.tac = new TestAuthorizedClient(this.serviceLocation, this.repositoryPath, this.configFileAuthorized);
        System.out.println("Testing authorized client ...");
        try {
            retVal = this.tac.run();
            Assert.assertEquals((int)retVal, (int)0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Authorized clien call failed ... OK");
        }
        System.out.println("Authorized client test ... OK");
        this.setTrudyParameters();
        this.trk = new TestRegisterKey(this.serviceLocation, this.repositoryPath, this.configFileAuthorized, this.trudyKeyStoreLocation, this.trudyKeyStorePass);
        System.out.println("Testing Trudy key registration ...");
        retVal = this.trk.run();
        Assert.assertTrue((String)("key registration failed ... code = " + retVal), (retVal == 0 ? 1 : 0) != 0);
        System.out.println("Key registration ... OK");
        this.tuc = new TestUnauthorizedClient(this.serviceLocation, this.repositoryPath, this.configFileUnauthorized);
        System.out.println("Testing authorized Trudy ... ");
        retVal = this.tuc.run();
        Assert.assertTrue((String)("Authorized Trudy call failed ... code = " + retVal), (retVal == 0 ? 1 : 0) != 0);
        System.out.println("Authorized Trudy test ... OK");
        this.tuk = new TestUnregisterKey(this.serviceLocation, this.repositoryPath, this.configFileAuthorized);
        System.out.println("Testing Trudy key removal ... ");
        retVal = this.tuk.run();
        Assert.assertTrue((String)("Key Removal failed ... code = " + retVal), (retVal == 0 ? 1 : 0) != 0);
        System.out.println("Trudy key removal test ... OK");
        System.out.println("Testing unauthorized Trudy ...");
        try {
            retVal = this.tuc.run();
            Assert.fail((String)("Trudy call successful code = " + retVal + " test failed"));
        }
        catch (Exception ex) {
            System.out.println("Unauthorized Trudy test ... OK");
        }
        System.out.println("Authorized Client suite completed");
    }

    public static Test suite() {
        return new TestSuite(SecurityTest.class);
    }
}

