/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.tests.nosecurity;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.tests.nosecurity.TestAddAuthorityKey;
import net.exogeni.orca.nodeagent.tests.nosecurity.TestGetServiceKey;
import net.exogeni.orca.nodeagent.tests.nosecurity.TestSecurityNotEnabled;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;

public class NoSecurityTest
extends TestCase {
    protected String serviceLocation = null;
    protected String repositoryPath = null;
    protected String configFile = null;
    protected String keyStoreLocation = null;
    protected String keyStorePass = null;
    protected String keyPass = null;
    protected String authorityIP = null;
    TestAddAuthorityKey taak;
    TestGetServiceKey tgsk;
    TestSecurityNotEnabled tsne;

    public NoSecurityTest() {
        this(System.getenv("na.location"), System.getenv("na.repository"), System.getenv("na.config"));
    }

    public NoSecurityTest(String location, String repository, String config) {
        if (location == null) {
            throw new RuntimeException("Location cannot be null");
        }
        if (repository == null) {
            throw new RuntimeException("Repository cannot be null");
        }
        if (config == null) {
            throw new RuntimeException("Config cannot be null");
        }
        this.serviceLocation = location;
        this.repositoryPath = repository;
        this.configFile = config;
    }

    public void setSecurityParameters() {
        this.keyStoreLocation = System.getenv("na.keystorelocation");
        if (this.keyStoreLocation == null) {
            throw new RuntimeException("KeyStoreLocation cannot be null");
        }
        this.keyStorePass = System.getenv("na.keystorepass");
        if (this.keyStorePass == null) {
            throw new RuntimeException("KeyStorePass cannot be null");
        }
        this.keyPass = System.getenv("na.keypass");
        if (this.keyPass == null) {
            throw new RuntimeException("KeyPass cannot be null");
        }
        this.authorityIP = System.getenv("na.authorityip");
        if (this.authorityIP == null) {
            throw new RuntimeException("authorityIP cannot be null");
        }
    }

    protected NodeAgentServiceStub getStub() throws Exception {
        ConfigurationContext cc = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.repositoryPath, (String)this.configFile);
        return new NodeAgentServiceStub(cc, this.serviceLocation);
    }

    public void test() throws Exception {
        System.out.println("Running nosecurity suite ...");
        this.tsne = new TestSecurityNotEnabled(this.serviceLocation, this.repositoryPath, this.configFile);
        System.out.println("Testing if service security is enabled ...");
        try {
            this.tsne.run();
            Assert.fail((String)"Service security enabled ... Failed");
        }
        catch (Exception ex) {
            System.out.println("Service security is enabled ... OK");
        }
        NodeAgentServiceStub stub = this.getStub();
        this.setSecurityParameters();
        System.out.println("Testing getServiceKey ... assuming that registerAuthorityKey was NOT invoked.");
        this.tgsk = new TestGetServiceKey(this.serviceLocation, stub, this.keyStoreLocation, this.keyStorePass, this.keyPass, this.authorityIP);
        int retVal = this.tgsk.run();
        Assert.assertTrue((String)("getServiceKey succeeded instead of failing ... code = " + retVal + "\n check if registerAuhorityKey was invoked/server.jks has been created on the service side"), (retVal != 0 ? 1 : 0) != 0);
        System.out.println("Testing getServiceKey failed ... registerAuthorityKey was NOT invoked ... OK");
        System.out.println("Testing registerAuthorityKey ... ");
        this.taak = new TestAddAuthorityKey(this.serviceLocation, stub, this.keyStoreLocation, this.keyStorePass, "clientkey", this.keyPass, this.authorityIP);
        retVal = this.taak.run();
        Assert.assertEquals((String)("registerAuthorityKey invocation failed ... code " + retVal), (int)retVal, (int)0);
        System.out.println("Testing registerAuthorityKey ... OK");
        System.out.println("Testing getServiceKey ... assuming that registerAuthorityKey was invoked.");
        this.tgsk = new TestGetServiceKey(this.serviceLocation, stub, this.keyStoreLocation, this.keyStorePass, this.keyPass, this.authorityIP);
        retVal = this.tgsk.run();
        Assert.assertTrue((String)("getServiceKey failed ... code = " + retVal), (retVal == 0 ? 1 : 0) != 0);
        System.out.println("Testing getServiceKey ... registerAuthorityKey was invoked ... OK");
        System.out.println("Nosecurity suite completed");
    }

    public static Test suite() {
        return new TestSuite(NoSecurityTest.class);
    }
}

