/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.tests.drivers;

import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.exogeni.orca.drivers.DriverFactory;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.documents.DriverRequestElement;
import net.exogeni.orca.nodeagent.documents.PropertiesElement;
import net.exogeni.orca.nodeagent.documents.ResultElement;
import net.exogeni.orca.nodeagent.tests.drivers.TestDriver;
import net.exogeni.orca.nodeagent.tools.DriverTool;
import net.exogeni.orca.nodeagent.util.Serializer;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;

public class DriverTest
extends TestCase {
    protected String location = null;
    protected String repository = null;
    protected String config = null;

    public DriverTest() {
        this(System.getenv("na.location"), System.getenv("na.repository"), System.getenv("na.config"));
    }

    public DriverTest(String location, String repository, String config) {
        if (location == null) {
            throw new RuntimeException("Location cannot be null");
        }
        this.location = location;
        this.repository = repository;
        this.config = config;
    }

    protected NodeAgentServiceStub getStub() throws Exception {
        if (this.repository != null || this.config != null) {
            ConfigurationContext cc = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.repository, (String)this.config);
            return new NodeAgentServiceStub(cc, this.location);
        }
        return new NodeAgentServiceStub(this.location);
    }

    public void test() throws Exception {
        DriverTool tool = new DriverTool(this.location, this.repository, this.config);
        String id = TestDriver.MyDriverId.toString();
        String className = "orca.nodeagent.tests.drivers.TestDriver";
        String pkg = "dist/testdriver.tar.gz";
        tool.uninstallDriver(id);
        System.out.println("\nTesting install of a new driver...");
        int code = tool.installDriver(id, className, pkg);
        Assert.assertEquals((int)code, (int)0);
        System.out.println("Testing install of a new driver...OK");
        System.out.println("Testing install of an already installed driver...");
        code = tool.installDriver(id, className, pkg);
        Assert.assertEquals((int)code, (int)DriverFactory.CodeDriverIsAlreadyInstalled);
        System.out.println("Testing install of an already installed driver...OK");
        System.out.println("Testing upgrade of an already installed driver...");
        code = tool.upgradeDriver(id, className, pkg);
        Assert.assertEquals((int)code, (int)0);
        System.out.println("Testing upgrade of an already installed driver...OK");
        System.out.println("Testing uninstall of an already installed driver...");
        code = tool.uninstallDriver(id);
        Assert.assertEquals((int)code, (int)0);
        System.out.println("Testing uninstall of an already installed driver...OK");
        System.out.println("Testing uninstall of an already uninstalled driver...");
        code = tool.uninstallDriver(id);
        Assert.assertEquals((int)code, (int)DriverFactory.CodeDriverIsNotInstalled);
        System.out.println("Testing uninstall of an already uninstalled driver...OK");
        System.out.println("Testing driver invocation...");
        System.out.println("Installing driver...");
        code = tool.installDriver(id, className, pkg);
        Assert.assertEquals((int)0, (int)code);
        System.out.println("Installing driver...OK");
        DriverRequestElement request = new DriverRequestElement();
        request.setDriverId(id.toString());
        request.setActionId(TestDriver.TestAction);
        Properties p = new Properties();
        p.setProperty("a1", "b1");
        p.setProperty("a2", "b2");
        p.setProperty("a3", "b3");
        request.setProperties(Serializer.serialize((Properties)p));
        NodeAgentServiceStub stub = this.getStub();
        ResultElement result = stub.executeDriver(request);
        Assert.assertEquals((int)result.getCode(), (int)0);
        System.out.println("Testing driver invocation...OK");
        System.out.println("Checking if properties are passed correctly...");
        Properties rp = Serializer.serialize((PropertiesElement)result.getProperties());
        Assert.assertNotNull((Object)rp);
        Assert.assertEquals((String)"b1", (String)rp.getProperty("a1"));
        Assert.assertEquals((String)"b2", (String)rp.getProperty("a2"));
        Assert.assertEquals((String)"b3", (String)rp.getProperty("a3"));
        Assert.assertEquals((String)"test2", (String)rp.getProperty("test1"));
        Assert.assertEquals((String)"test4", (String)rp.getProperty("test3"));
        Assert.assertEquals((String)"test6", (String)rp.getProperty("test5"));
        Assert.assertEquals((String)"test8", (String)rp.getProperty("test7"));
        System.out.println("Checking if properties are passed correctly...OK");
        System.out.println("Driver support unit test successful.");
    }

    public static Test suite() {
        return new TestSuite(DriverTest.class);
    }
}

