/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.tools;

import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.documents.DriverElement;
import net.exogeni.orca.nodeagent.documents.ResultElement;
import net.exogeni.orca.nodeagent.tools.ToolHelper;
import net.exogeni.orca.nodeagent.util.Serializer;
import net.exogeni.orca.tools.axis2.Axis2ClientConfigurationManager;
import org.apache.axis2.context.ConfigurationContext;

public class DriverTool {
    protected String location = "http://localhost:8080/axis2/services/NodeManagerService";
    protected String repository = null;
    protected String config = null;

    public DriverTool() {
    }

    public DriverTool(String location) {
        this.location = location;
    }

    public DriverTool(String location, String repository, String config) {
        if (location != null) {
            this.location = location;
        }
        this.repository = repository;
        this.config = config;
    }

    public NodeAgentServiceStub getStub() throws Exception {
        ConfigurationContext context = Axis2ClientConfigurationManager.getInstance().getContext(this.repository, this.config);
        return new NodeAgentServiceStub(context, this.location);
    }

    public int installDriver(String id, String className, String pkg) {
        int code = 0;
        try {
            DriverElement args = new DriverElement();
            args.setDriverId(id);
            args.setClassName(className);
            if (pkg != null) {
                FileDataSource ds = new FileDataSource(pkg);
                DataHandler d = new DataHandler((DataSource)ds);
                args.setPkg(d);
            }
            NodeAgentServiceStub stub = this.getStub();
            ResultElement result = stub.installDriver(args);
            Properties p = Serializer.serialize(result.getProperties());
            code = result.getCode();
        }
        catch (Exception e) {
            e.printStackTrace();
            code = -1;
        }
        return code;
    }

    public int upgradeDriver(String id, String className, String pkg) {
        int code = 0;
        try {
            DriverElement args = new DriverElement();
            args.setDriverId(id);
            args.setClassName(className);
            if (pkg != null) {
                FileDataSource ds = new FileDataSource(pkg);
                DataHandler d = new DataHandler((DataSource)ds);
                args.setPkg(d);
            }
            NodeAgentServiceStub stub = this.getStub();
            ResultElement result = stub.upgradeDriver(args);
            Properties p = Serializer.serialize(result.getProperties());
            code = result.getCode();
        }
        catch (Exception e) {
            e.printStackTrace();
            code = -1;
        }
        return code;
    }

    public int uninstallDriver(String id) {
        int code = 0;
        try {
            DriverElement args = new DriverElement();
            args.setDriverId(id);
            NodeAgentServiceStub stub = this.getStub();
            ResultElement result = stub.uninstallDriver(args);
            Properties p = Serializer.serialize(result.getProperties());
            code = result.getCode();
        }
        catch (Exception e) {
            e.printStackTrace();
            code = -1;
        }
        return code;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public static DriverTool getDriverTool(String[] args) {
        DriverTool tool = new DriverTool();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-l")) {
                    if (i + 1 < args.length) {
                        tool.setLocation(args[i + 1]);
                        ++i;
                        continue;
                    }
                    return null;
                }
                if (!args[i].equals("-r")) continue;
                if (i + 1 < args.length) {
                    tool.setRepository(args[i + 1]);
                    ++i;
                    continue;
                }
                return null;
            }
            if (!args[i].equals("-c")) continue;
            if (i + 1 < args.length) {
                tool.setConfig(args[i + 1]);
                ++i;
                continue;
            }
            return null;
        }
        return tool;
    }

    public static void printUsage() {
        System.out.println("Usage [modifiers] command parameters:\nModifiers can be:\n-l location -> location of nodemanager service\n-r path -> path to repository\n-c path -> path to axis2.xml\ninstall id class [path] [pkg] --> installs the driver\nupgrade id class [path] [pkg] --> upgrades the driver\nuninstall id --> uninstalls the driver");
    }

    public static int processInstall(DriverTool tool, String[] args, int index) {
        if (index + 1 >= args.length) {
            DriverTool.printUsage();
            return -1;
        }
        String id = args[index];
        String className = args[index + 1];
        String pkg = null;
        if (index + 2 < args.length) {
            pkg = args[index + 2];
        }
        int code = tool.installDriver(id, className, pkg);
        return code;
    }

    public static int processUpgradeDriver(DriverTool tool, String[] args, int index) {
        int i = index;
        if (i + 1 >= args.length) {
            DriverTool.printUsage();
            return -1;
        }
        String id = args[i];
        String className = args[i + 1];
        String pkg = null;
        if (i + 2 < args.length) {
            pkg = args[i + 2];
        }
        int code = tool.upgradeDriver(id, className, pkg);
        return code;
    }

    public static int processUninstallDriver(DriverTool tool, String[] args, int index) {
        int i = index;
        if (i >= args.length) {
            DriverTool.printUsage();
            return -1;
        }
        String id = args[i];
        int code = tool.uninstallDriver(id);
        return code;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            DriverTool.printUsage();
            System.exit(-1);
        }
        ToolHelper helper = new ToolHelper(args);
        DriverTool tool = new DriverTool(helper.getLocation(), helper.getRepository(), helper.getConfig());
        int index = helper.getIndex();
        if (args[index].equals("install")) {
            System.exit(DriverTool.processInstall(tool, args, index + 1));
        } else if (args[index].equals("upgrade")) {
            System.exit(DriverTool.processUpgradeDriver(tool, args, index + 1));
        } else if (args[index].equals("uninstall")) {
            System.exit(DriverTool.processUninstallDriver(tool, args, index + 1));
        } else {
            System.err.println("Unsupported operation");
            System.exit(-1);
        }
    }
}

