/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.drivers;

import net.exogeni.orca.drivers.DriverId;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.tools.axis2.Axis2ClientConfigurationManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.log4j.Logger;

public class DriverClient {
    protected String location = null;
    protected String repository = null;
    protected String config = null;
    protected DriverId id;
    private NodeAgentServiceStub stub;
    protected Logger logger;

    public DriverClient(DriverId id, String location, String repository, String config) {
        if (id == null || location == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.location = location;
        this.repository = repository;
        this.config = config;
        this.logger = Logger.getLogger((String)this.getClass().getCanonicalName());
    }

    public DriverClient(DriverId id, NodeAgentServiceStub stub) {
        if (id == null || stub == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.stub = stub;
        this.logger = Logger.getLogger((String)this.getClass().getCanonicalName());
    }

    protected synchronized NodeAgentServiceStub getStub() throws Exception {
        if (this.stub == null) {
            this.message("Creating axis2 configuration context: repository=" + this.repository + " config=" + this.config);
            ConfigurationContext context = Axis2ClientConfigurationManager.getInstance().getContext(this.repository, this.config);
            this.message("Creating service stub: location=" + this.location);
            this.stub = new NodeAgentServiceStub(context, this.location);
        }
        return this.stub;
    }

    protected void reportError(Exception e) {
        System.err.println("An error occurred: " + e.getMessage());
        e.printStackTrace();
        this.logger.error((Object)e);
    }

    protected void message(String message) {
        this.logger.debug((Object)message);
        System.out.println(message);
    }
}

