/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.drivers;

import java.util.Properties;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.client.AntBaseTask;
import net.exogeni.orca.tools.axis2.Axis2ClientConfigurationManager;
import net.exogeni.orca.tools.axis2.Axis2ClientSecurityConfigurator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.tools.ant.BuildException;

public abstract class DriverBaseTask
extends AntBaseTask {
    public static final String PropertyAxis2Security = "axis2.security";
    public static final String PropertyActorID = "actor.id";
    protected String location;
    protected String repository;
    protected String config;
    protected String driverId;

    public void setDriverId(String driverId) {
        this.driverId = driverId;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
    }

    protected void resolveSecurity() throws Exception {
        String sec;
        String actorID = null;
        String rootDir = null;
        if (this.config == null && (sec = this.getProject().getProperty(PropertyAxis2Security)) != null && sec.equalsIgnoreCase("yes")) {
            System.out.println("fixing security");
            actorID = this.getProject().getProperty(PropertyActorID);
            rootDir = this.getProject().getProperty("root.dir");
            if (actorID != null && rootDir != null) {
                System.out.println("trying to set security");
                Axis2ClientSecurityConfigurator configurator = Axis2ClientSecurityConfigurator.getInstance();
                this.config = configurator.getAxis2ConfigPath(rootDir, actorID);
                System.out.println("config: " + this.config);
            }
        }
    }

    protected NodeAgentServiceStub getStub() throws Exception {
        this.message("Creating axis2 configuration context: repository=" + this.repository + " config=" + this.config);
        ConfigurationContext context = Axis2ClientConfigurationManager.getInstance().getContext(this.repository, this.config);
        this.message("Creating service stub: location=" + this.location);
        return new NodeAgentServiceStub(context, this.location);
    }

    @Override
    public Properties getProperties() throws Exception {
        return new Properties();
    }

    protected void message(String message) {
        this.logger.debug((Object)message);
        System.out.println(message);
    }
}

