/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.client;

import java.util.Hashtable;
import java.util.Map;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.documents.ScriptElement;
import net.exogeni.orca.nodeagent.documents.ScriptResultElement;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class NodeAgentTask
extends Task {
    protected String script;
    protected String arguments = "";
    protected String address;
    protected boolean generate = true;
    protected String stdErrorProperty;
    protected String stdOutProperty;
    protected String exitCodeProperty;

    public void setStdErrorProperty(String p) {
        this.stdErrorProperty = p;
    }

    public void setStdOutProperty(String p) {
        this.stdOutProperty = p;
    }

    public void setExitCodeProperty(String p) {
        this.exitCodeProperty = p;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public void setGenerate(boolean generate) {
        this.generate = generate;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    protected String makePropertiesString() {
        Hashtable p = this.getProject().getProperties();
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry entry : p.entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith("host") && !name.startsWith("unit") && (!name.startsWith("new") || name.equals("unit.all"))) continue;
            String value = (String)entry.getValue();
            buffer.append(name);
            buffer.append("='");
            buffer.append(value);
            buffer.append("' ");
        }
        String result = buffer.toString();
        return result;
    }

    protected void callNodeManager(String args) throws Exception {
        NodeAgentServiceStub stub = new NodeAgentServiceStub(this.address);
        ScriptElement el = new ScriptElement();
        el.setScript(this.script);
        el.setArguments(args);
        ScriptResultElement res = stub.executeScript(el);
        if (res != null) {
            if (this.exitCodeProperty != null) {
                this.getProject().setProperty(this.exitCodeProperty, Integer.toString(res.getCode()));
            }
            if (this.stdOutProperty != null) {
                this.getProject().setProperty(this.stdOutProperty, res.getStdOut());
            }
            if (this.stdErrorProperty != null) {
                this.getProject().setProperty(this.stdErrorProperty, res.getStdError());
            }
        }
    }

    public void execute() throws BuildException {
        try {
            String args = this.arguments;
            if (this.generate) {
                args = this.makePropertiesString();
            }
            this.callNodeManager(args);
        }
        catch (Exception e) {
            throw new BuildException("An error occurred: " + e.getMessage(), (Throwable)e);
        }
    }
}

