/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.nodeagent.client;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.exogeni.orca.nodeagent.KeyMasterMessage;
import net.exogeni.orca.nodeagent.NodeAgentServiceStub;
import net.exogeni.orca.nodeagent.documents.GetServiceKeyElement;
import net.exogeni.orca.nodeagent.documents.GetServiceKeyResultElement;
import net.exogeni.orca.nodeagent.documents.RegisterAuthorityKeyElement;
import net.exogeni.orca.nodeagent.documents.RegisterAuthorityKeyResultElement;
import org.apache.axis2.util.Base64;

public class KeyMasterClient {
    String clientPassword;
    char[] clientPasswordChar;
    String clientStorePassword;
    char[] clientStorePasswordChar;
    NodeAgentServiceStub stub;
    String location;
    String keyStoreLocation;
    String authorityIP;
    String keyAlias;
    String serverKey;

    public KeyMasterClient(String location, NodeAgentServiceStub stub, String keyStoreLocation, String keyStorePass, String keyAlias, String keyPass, String authorityIP, String serverKey) {
        this.location = location;
        this.stub = stub;
        this.keyStoreLocation = keyStoreLocation;
        this.authorityIP = authorityIP;
        this.clientStorePassword = keyStorePass;
        this.keyAlias = keyAlias;
        this.clientPassword = keyPass;
        this.serverKey = serverKey;
        this.clientPasswordChar = this.clientPassword.toCharArray();
        this.clientStorePasswordChar = this.clientStorePassword.toCharArray();
    }

    public int callRegisterAuthorityKey() throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        FileInputStream fis = new FileInputStream(this.keyStoreLocation);
        ks.load(fis, this.clientStorePasswordChar);
        fis.close();
        Certificate cert = ks.getCertificate(this.keyAlias);
        byte[] certEncoding = cert.getEncoded();
        String alias = "authoritykey";
        RegisterAuthorityKeyElement rke = new RegisterAuthorityKeyElement();
        rke.setAlias(alias);
        rke.setCertificate(certEncoding);
        byte[] messageByte = this.createKeyMasterMessage();
        rke.setRequest(messageByte);
        Signature sig = Signature.getInstance("MD5withRSA");
        PrivateKey privateKey = (PrivateKey)ks.getKey(this.keyAlias, this.clientPasswordChar);
        if (privateKey == null) {
            System.out.println("private key is null");
        }
        sig.initSign(privateKey);
        sig.update(messageByte);
        byte[] signature = sig.sign();
        rke.setSignature(signature);
        RegisterAuthorityKeyResultElement rkre = this.stub.registerAuthorityKey(rke);
        int res = rkre.getCode();
        if (res != 0) {
            return res;
        }
        byte[] encodedBytes = rkre.getKey();
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, ks.getKey(this.keyAlias, this.clientPasswordChar));
        byte[] decryptBytes = cipher.doFinal(encodedBytes);
        String sharedKeyBase64 = new String(decryptBytes);
        byte[] sharedKeyBytes = Base64.decode((String)sharedKeyBase64);
        SecretKeySpec sharedKey = new SecretKeySpec(sharedKeyBytes, "TripleDES");
        byte[] encodedBytesDoc = rkre.getResponse();
        Cipher cipherSym = Cipher.getInstance("TripleDES");
        cipherSym.init(2, sharedKey);
        byte[] decryptBytesDoc = cipherSym.doFinal(encodedBytesDoc);
        KeyMasterMessage kmm = this.createKeyMasterReplyMessage(decryptBytesDoc);
        String certBase64 = kmm.getNode("nodecertificate");
        byte[] certBase64Bytes = Base64.decode((String)certBase64);
        Certificate nodeCert = this.generateCertificate(certBase64Bytes);
        ks.setCertificateEntry(this.serverKey, nodeCert);
        FileOutputStream fos = new FileOutputStream(this.keyStoreLocation);
        ks.store(fos, this.clientStorePasswordChar);
        fos.close();
        String nodeToken = kmm.getNode("nodetoken");
        return res;
    }

    public int callGetServiceKey() throws Exception {
        GetServiceKeyElement gske = new GetServiceKeyElement();
        GetServiceKeyResultElement gskre = this.stub.getServiceKey(gske);
        int retCode = gskre.getCode();
        if (retCode != 0) {
            return retCode;
        }
        if (retCode == 0) {
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream(this.keyStoreLocation);
            ks.load(fis, this.clientStorePasswordChar);
            fis.close();
            byte[] encodedCert = gskre.getKey();
            Certificate cert = this.generateCertificate(encodedCert);
            Certificate servCert = ks.getCertificate(this.serverKey);
            if (cert.equals(servCert)) {
                return retCode;
            }
            return 1;
        }
        return retCode;
    }

    private byte[] createKeyMasterMessage() {
        KeyMasterMessage km = new KeyMasterMessage();
        String[] nodes1 = new String[]{"nodeIP", "timestamp", "authorityIP"};
        km.createXMLDocument(nodes1);
        String nodeIP = this.authorityIP;
        if (nodeIP == null || nodeIP.length() == 0) {
            InetAddress addr = null;
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException(ex);
            }
            nodeIP = addr.getHostAddress();
        }
        km.setNode("nodeIP", nodeIP);
        km.setNode("authorityIP", this.authorityIP);
        km.setNode("timestamp", "NA");
        byte[] messageByte = km.getBytes();
        return messageByte;
    }

    private KeyMasterMessage createKeyMasterReplyMessage(byte[] decryptBytesDoc) {
        KeyMasterMessage kmm = new KeyMasterMessage();
        kmm.buildXMLDocument(new String(decryptBytesDoc));
        return kmm;
    }

    private void printKeyMasterMessage(byte[] messageByte) {
        String str = new String(messageByte);
        System.out.println(str);
    }

    public int run() throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        FileInputStream fis = new FileInputStream(this.keyStoreLocation);
        ks.load(fis, this.clientStorePasswordChar);
        fis.close();
        Certificate cert = ks.getCertificate(this.keyAlias);
        PublicKey pkey = cert.getPublicKey();
        cert.verify(pkey);
        byte[] encCertInfo = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(encCertInfo);
        StringBuffer strBufDigest = new StringBuffer();
        int length = digest.length;
        for (int n = 0; n < length; ++n) {
            strBufDigest.append(digest[n]);
        }
        byte[] certEncoding = cert.getEncoded();
        String alias = "authoritykey";
        RegisterAuthorityKeyElement rke = new RegisterAuthorityKeyElement();
        rke.setAlias(alias);
        rke.setCertificate(certEncoding);
        KeyMasterMessage km = new KeyMasterMessage();
        String[] nodes1 = new String[]{"nodeIP", "timestamp", "authorityIP"};
        km.createXMLDocument(nodes1);
        InetAddress addr = InetAddress.getLocalHost();
        String nodeIP = addr.getHostAddress();
        km.setNode("nodeIP", nodeIP);
        km.setNode("authorityIP", this.authorityIP);
        km.setNode("timestamp", "2007:06:16");
        byte[] messageByte = km.getBytes();
        rke.setRequest(messageByte);
        String str = new String(messageByte);
        KeyMasterMessage km1 = new KeyMasterMessage();
        km1.buildXMLDocument(str);
        String msgNodeIP = km1.getNode("nodeIP");
        String msgSSHPublicKey = km1.getNode("sshpublickey");
        String msgAuthIP = km1.getNode("authorityIP");
        String msgTimestamp = km1.getNode("timestamp");
        Signature sig = Signature.getInstance("MD5withRSA");
        PrivateKey privateKey = (PrivateKey)ks.getKey(this.keyAlias, this.clientPasswordChar);
        sig.initSign(privateKey);
        sig.update(messageByte);
        byte[] signature = sig.sign();
        rke.setSignature(signature);
        RegisterAuthorityKeyResultElement rkre = this.stub.registerAuthorityKey(rke);
        int res = rkre.getCode();
        if (res != 0) {
            return res;
        }
        byte[] encodedBytes = rkre.getKey();
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, ks.getKey(this.keyAlias, this.clientPasswordChar));
        byte[] decryptBytes = cipher.doFinal(encodedBytes);
        String sharedKeyBase64 = new String(decryptBytes);
        byte[] sharedKeyBytes = Base64.decode((String)sharedKeyBase64);
        SecretKeySpec sharedKey = new SecretKeySpec(sharedKeyBytes, "TripleDES");
        byte[] encodedBytesDoc = rkre.getResponse();
        Cipher cipherSym = Cipher.getInstance("TripleDES");
        cipherSym.init(2, sharedKey);
        byte[] decryptBytesDoc = cipherSym.doFinal(encodedBytesDoc);
        String strDoc = new String(decryptBytesDoc);
        KeyMasterMessage kmm = new KeyMasterMessage();
        kmm.buildXMLDocument(strDoc);
        String certBase64 = kmm.getNode("nodecertificate");
        byte[] certBase64Bytes = Base64.decode((String)certBase64);
        Certificate nodeCert = this.generateCertificate(certBase64Bytes);
        ks.setCertificateEntry(this.serverKey, nodeCert);
        FileOutputStream fos = new FileOutputStream(this.keyStoreLocation);
        ks.store(fos, this.clientStorePasswordChar);
        fos.close();
        String nodeToken = kmm.getNode("nodetoken");
        return res;
    }

    private String toHexString(byte[] digest) {
        char[] hexValues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer stringBuf = new StringBuffer();
        int len = digest.length;
        for (int i = 0; i < len; ++i) {
            int first = (digest[i] & 0xF0) >> 4;
            int second = digest[i] & 0xF;
            stringBuf.append(hexValues[first]);
            stringBuf.append(hexValues[second]);
            if (i == len - 1) continue;
            stringBuf.append(":");
        }
        return stringBuf.toString();
    }

    private Certificate generateCertificate(byte[] certificateEncoding) {
        ByteArrayInputStream inStream = new ByteArrayInputStream(certificateEncoding);
        Certificate cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = cf.generateCertificate(inStream);
            while (inStream.available() > 0) {
                cert = cf.generateCertificate(inStream);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cert;
    }
}

