/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.util;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.tdb.TDB;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ModelFolders {
    protected Map<OntModel, ModelFolder> modelFolders = new HashMap<OntModel, ModelFolder>();
    protected Set<Dataset> datasets = new HashSet<Dataset>();
    protected boolean noMoreFolders = false;
    private static ModelFolders instance = new ModelFolders();

    private ModelFolders() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Closing datasets");
                ModelFolders.getInstance().closeDatasets();
                System.out.println("Deleting ephemeral TDB folders");
                ModelFolders.getInstance().deleteTDBOnShutDown();
            }
        });
    }

    public static ModelFolders getInstance() {
        return instance;
    }

    public synchronized void deleteTDBOnShutDown() {
        ModelFolders.getInstance().noMoreFolders = true;
        for (Map.Entry<OntModel, ModelFolder> entry : this.modelFolders.entrySet()) {
            if (!entry.getValue().isEphemeral()) continue;
            ModelFolders.deleteFolder(entry.getValue().getFolderPath());
        }
    }

    private File _createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public synchronized File createTempDirectory(String prefix) {
        File tmpDir = null;
        if (this.noMoreFolders) {
            return null;
        }
        String tmpDirName = (prefix == null ? System.getProperty("java.io.tmpdir") : prefix) + System.getProperty("file.separator") + "jenatdb" + UUID.randomUUID();
        tmpDir = new File(tmpDirName);
        if (!tmpDir.mkdir()) {
            return null;
        }
        return tmpDir;
    }

    public synchronized File createNamedDirectory(String p) {
        if (this.noMoreFolders) {
            return null;
        }
        File dir = new File(p);
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        return dir;
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    ModelFolders.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    public static void deleteFolder(String p) {
        ModelFolders.deleteFolder(new File(p));
    }

    public static boolean folderExists(File folder) {
        if (folder == null) {
            return false;
        }
        return folder.exists();
    }

    public static boolean folderExists(String p) {
        if (p == null) {
            return false;
        }
        return new File(p).exists();
    }

    public synchronized void put(OntModel m, Dataset ds, String path, boolean e) throws Exception {
        assert (path != null && m != null && ds != null);
        this.datasets.add(ds);
        if (this.modelFolders.containsKey(m)) {
            throw new Exception("ModelFolders already contain a mapping for model " + m);
        }
        this.modelFolders.put(m, new ModelFolder(path, ds, e));
    }

    public synchronized boolean remove(OntModel m) {
        assert (m != null);
        if (!m.isClosed()) {
            return false;
        }
        if (this.modelFolders.containsKey(m)) {
            ModelFolder mf = this.modelFolders.get(m);
            if (mf.getDataset() != null && this.datasets.contains(mf.getDataset())) {
                mf.getDataset().close();
                this.datasets.remove(mf.getDataset());
            }
            ModelFolders.deleteFolder(mf.getFolderPath());
            this.modelFolders.remove(m);
            return true;
        }
        return false;
    }

    public synchronized String getPath(OntModel m) {
        assert (m != null);
        if (this.modelFolders.containsKey(m)) {
            ModelFolder mf = this.modelFolders.get(m);
            return mf.getFolderPath();
        }
        return null;
    }

    public synchronized boolean isEphemeral(OntModel m) {
        assert (m != null);
        if (this.modelFolders.containsKey(m)) {
            ModelFolder mf = this.modelFolders.get(m);
            return mf.isEphemeral();
        }
        return true;
    }

    public synchronized boolean isInTDB(OntModel m) {
        assert (m != null);
        return this.modelFolders.containsKey(m);
    }

    public void closeDatasets() {
        for (Map.Entry<OntModel, ModelFolder> entry : this.modelFolders.entrySet()) {
            if (entry.getValue().isEphemeral()) continue;
            System.out.println("Syncing dataset " + entry.getValue().getFolderPath());
            try {
                TDB.sync((Dataset)entry.getValue().getDataset());
            }
            catch (Exception e) {
                System.out.println("Failed to sync " + entry.getValue().getFolderPath() + ", trying again in .5s ");
                try {
                    Thread.sleep(500L);
                    TDB.sync((Dataset)entry.getValue().getDataset());
                }
                catch (Exception ee) {
                    System.out.println("Failed again to sync " + entry.getValue().getFolderPath() + ", continuing");
                }
            }
        }
    }

    private static class ModelFolder {
        private boolean ephemeral;
        private String folderPath;
        private Dataset dataset;

        public ModelFolder(String p, Dataset ds, boolean e) {
            this.ephemeral = e;
            this.folderPath = p;
            this.dataset = ds;
        }

        public boolean isEphemeral() {
            return this.ephemeral;
        }

        public String getFolderPath() {
            return this.folderPath;
        }

        public Dataset getDataset() {
            return this.dataset;
        }

        public void closeDataset() {
            this.dataset.end();
        }
    }
}

