/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.ontology.OntModel;
import net.exogeni.orca.ndl.LayerConstant;
import net.exogeni.orca.ndl.elements.Label;
import net.exogeni.orca.ndl.elements.SwitchMatrix;
import net.exogeni.orca.util.persistence.Persistent;
import org.apache.log4j.Logger;

public class SwitchingAction
extends SwitchMatrix {
    @Persistent
    protected String defaultAction;
    @Persistent
    protected String startTime;
    @Persistent
    protected String endTime;
    @Persistent
    private float label_ID;
    @Persistent
    private Label label;
    @Persistent
    private long bw;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("Action: " + this.defaultAction + " from " + this.startTime + " to " + this.endTime + "\n");
        sb.append("Label: " + this.label + "/" + this.label_ID + "/" + this.bw + "\n");
        return sb.toString();
    }

    public long getBw() {
        return this.bw;
    }

    public void setBw(long bw) {
        this.bw = bw;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
        if (label != null) {
            this.label_ID = label.label.floatValue();
        }
    }

    public SwitchingAction() {
        this.defaultAction = LayerConstant.Action.Temporary.toString();
    }

    public SwitchingAction(OntModel m) {
        this.model = m;
        this.defaultAction = LayerConstant.Action.Temporary.toString();
    }

    public SwitchingAction(String layer, String time1, String time2) {
        this.atLayer = layer;
        this.startTime = time1;
        this.endTime = time2;
        this.label_ID = -1.0f;
        this.defaultAction = LayerConstant.Action.Temporary.toString();
        this.bw = 0L;
    }

    @Override
    public void print(Logger logger) {
        super.print(logger);
        logger.info((Object)("Time:" + this.startTime + "-" + this.endTime));
        logger.info((Object)("Action:" + this.defaultAction));
        logger.info((Object)("Label_ID:" + this.label_ID));
        logger.info((Object)("Bandwidth:" + this.bw));
    }

    public String getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(String defaultAction) {
        this.defaultAction = defaultAction;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public float getLabel_ID() {
        return this.label_ID;
    }

    public void setLabel_ID(float label_ID) {
        this.label_ID = label_ID;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }
}

