/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class OrcaReservationTerm {
    protected Date start = new Date();
    protected Date end = null;
    protected int dDays = 0;
    protected int dHours = 24;
    protected int dMins = 0;
    protected int dSecs = 0;

    public OrcaReservationTerm() {
        this._setEnd(this.dDays, this.dHours, this.dMins, this.dSecs);
    }

    private void _setEnd(int d, int h, int m, int s) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.start);
        cal.add(6, d);
        cal.add(10, h);
        cal.add(12, m);
        cal.add(13, s);
        this.end = cal.getTime();
    }

    public int getDurationInMinutes() {
        return this.durationInMinutes(this.dDays, this.dHours, this.dMins);
    }

    public int getDurationInSeconds() {
        return Math.toIntExact(TimeUnit.MINUTES.toSeconds(this.getDurationInMinutes())) + this.dSecs;
    }

    private int durationInMinutes(int d, int h, int m) {
        return Math.toIntExact(TimeUnit.DAYS.toMinutes(d)) + Math.toIntExact(TimeUnit.HOURS.toMinutes(h)) + m;
    }

    public void setStart(Date s) {
        this.start = s;
        this._setEnd(this.dDays, this.dHours, this.dMins, this.dSecs);
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setDuration(int d, int h, int m, int s) {
        if (d < 0 || h < 0 || m < 0 || s < 0) {
            return;
        }
        if (d == 0 && h == 0 && m == 0 && s == 0) {
            return;
        }
        if (this.start == null) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.start);
        cal.add(6, d);
        cal.add(10, h);
        cal.add(12, m);
        cal.add(13, s);
        this.modifyTerm(cal.getTime());
    }

    public void modifyTerm(Date newEnd) {
        if (this.start == null) {
            this.start = new Date();
        }
        long newDuration = newEnd.getTime() - this.start.getTime();
        this.dDays = (int)TimeUnit.MILLISECONDS.toDays(newDuration);
        this.dHours = (int)TimeUnit.MILLISECONDS.toHours(newDuration -= TimeUnit.DAYS.toMillis(this.dDays));
        this.dMins = (int)TimeUnit.MILLISECONDS.toMinutes(newDuration -= TimeUnit.HOURS.toMillis(this.dHours));
        this.dSecs = (int)TimeUnit.MILLISECONDS.toSeconds(newDuration -= TimeUnit.MINUTES.toMillis(this.dMins));
        this.end = newEnd;
    }

    public void normalizeDuration() {
        if (this.durationInMinutes(this.dDays, this.dHours, this.dMins) == 0) {
            this.dHours = 24;
        }
        int tmpMins = this.dMins;
        this.dMins = tmpMins % 60;
        int tmpHours = (int)Math.floor((double)tmpMins / 60.0) + this.dHours;
        this.dHours = tmpHours % 24;
        this.dDays += (int)Math.floor((double)tmpHours / 24.0);
    }

    public int getDurationDays() {
        return this.dDays;
    }

    public int getDurationHours() {
        return this.dHours;
    }

    public int getDurationMins() {
        return this.dMins;
    }

    public int getDurationSecs() {
        return this.dSecs;
    }

    public String toString() {
        return "start: " + this.start + " duration: " + this.dDays + " days " + this.dHours + " hours " + this.dMins + " minutes " + this.dSecs + " seconds end: " + this.end;
    }
}

