/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.exogeni.orca.ndl.DomainResource;
import net.exogeni.orca.ndl.DomainResourceType;
import net.exogeni.orca.ndl.LayerConstant;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.elements.Interface;
import net.exogeni.orca.util.persistence.NotPersistent;
import net.exogeni.orca.util.persistence.Persistable;
import net.exogeni.orca.util.persistence.Persistent;
import org.apache.log4j.Logger;

public class NetworkElement
implements LayerConstant,
Comparable,
Persistable {
    @NotPersistent
    protected OntModel model;
    @NotPersistent
    protected boolean isModify;
    @Persistent
    protected int modifyVersion;
    @Persistent
    protected String uri;
    @Persistent
    protected String name;
    @Persistent
    protected String atLayer;
    @Persistent
    protected DomainResourceType resourceType;
    @Persistent
    protected int numInterface;
    @Persistent
    protected LinkedList<Interface> clientInterface;
    @Persistent
    protected HashMap<String, DomainResource> resourcesMap;
    @Persistent
    protected String castType;
    @Persistent
    protected String GUID;
    @Persistent
    protected Integer sn;
    @Persistent
    protected String hostName;
    @Persistent
    protected String managementIP;
    @NotPersistent
    protected Logger logger = NdlCommons.getNdlLogger();

    public NetworkElement(OntModel m, OntResource rs) {
        this.model = m;
        this.name = this.uri = rs.getURI();
    }

    public NetworkElement(OntModel m, Resource rs) {
        this.model = m;
        this.name = this.uri = m.getOntResource(rs).getURI();
    }

    public NetworkElement(OntModel m, String u, String n) {
        this.model = m;
        this.uri = u;
        this.name = n;
    }

    public NetworkElement() {
    }

    public boolean equals(Object o) {
        if (o instanceof NetworkElement && this.name != null) {
            NetworkElement neNew = (NetworkElement)o;
            return this.name.equals(neNew.name);
        }
        return false;
    }

    public int compareTo(Object o) {
        int compare = 0;
        if (o == null) {
            return 1;
        }
        NetworkElement ne = (NetworkElement)o;
        if (this.getRank() < ne.getRank()) {
            compare = -1;
        } else if (this.getRank() > ne.getRank()) {
            compare = 1;
        } else if (this.getRank() == ne.getRank()) {
            if (ne.getType() != null && ne.getType().equals("Server")) {
                compare = -1;
            }
            if (this.getType() != null && this.getType().equals("Server")) {
                compare = 1;
            }
        }
        return compare;
    }

    public String getCastType() {
        return this.castType;
    }

    public void setCastType(String castType) {
        this.castType = castType;
    }

    public Interface getDefaultClientInterface() {
        if (this.clientInterface == null) {
            return null;
        }
        return this.clientInterface.getFirst();
    }

    public LinkedList<Interface> getClientInterface() {
        return this.clientInterface;
    }

    public Interface getClientInterfaceByURI(String url) {
        if (url == null) {
            return null;
        }
        if (this.clientInterface == null) {
            return null;
        }
        Interface inter = null;
        for (Interface intf : this.clientInterface) {
            if (!url.equalsIgnoreCase(intf.getURI())) continue;
            inter = intf;
            break;
        }
        return inter;
    }

    public void setClientInterface(LinkedList<Interface> clientInterface) {
        this.clientInterface = clientInterface;
    }

    public void addClientInterface(Interface intf) {
        if (intf == null) {
            return;
        }
        if (this.clientInterface == null) {
            this.clientInterface = new LinkedList();
        }
        if (!this.clientInterface.contains(intf)) {
            this.clientInterface.add(intf);
        }
    }

    public DomainResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(DomainResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void print() {
        this.logger.debug((Object)("URL:" + this.uri));
        this.logger.debug((Object)("Name:" + this.getName()));
        this.logger.debug((Object)("At Layer:" + this.atLayer));
        this.logger.debug((Object)("#sn:" + this.sn));
    }

    public void print(Logger logger) {
        logger.info((Object)("URL:" + this.uri));
        logger.info((Object)("Name:" + this.getName()));
        logger.info((Object)("At Layer:" + this.atLayer));
        logger.info((Object)("#sn:" + this.sn));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Type: " + this.getClass().getSimpleName() + "\n");
        sb.append("URL: " + this.uri + " ");
        sb.append("Name: " + this.getName() + " ");
        sb.append("At Layer: " + this.atLayer + " ");
        sb.append("#sn:" + this.sn + " ");
        sb.append("ResourceType: " + this.resourceType + " ");
        sb.append("ClientInterface: [\n");
        if (this.clientInterface != null) {
            for (Interface interface_ : this.clientInterface) {
                sb.append(interface_ + " ");
            }
        }
        sb.append("]\n");
        sb.append("Interface Bandwidth: ");
        if (this.resourcesMap != null) {
            for (Map.Entry entry : this.resourcesMap.entrySet()) {
                sb.append("[ " + (String)entry.getKey() + " <> " + entry.getValue() + " ] ");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public int getNumUnits() {
        return this.resourceType.getCount();
    }

    public void setNumUnits(int numUnits) {
        this.resourceType.setCount(numUnits);
    }

    public String getInDomain() {
        return this.resourceType.getDomainURL();
    }

    public void setInDomain(String inDomain) {
        this.resourceType.setDomainURL(inDomain);
    }

    public int getSn() {
        return this.sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public int getRank() {
        return this.resourceType.getRank();
    }

    public void setRank(int rank) {
        this.resourceType.setRank(rank);
    }

    public OntResource getResource() {
        if (this.uri != null && !this.model.isClosed()) {
            return this.model.getOntResource(this.uri);
        }
        this.logger.error((Object)("resource is null:uri=" + this.uri + ";model.isClosed()=" + this.model.isClosed()));
        return null;
    }

    public void setResource(OntResource r) {
        if (r != null) {
            if (this.model == null) {
                this.model = r.getOntModel();
            }
            this.uri = r.getURI();
        } else {
            this.uri = null;
        }
    }

    public String getURI() {
        return this.uri;
    }

    public OntModel getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setModel(OntModel model) {
        this.model = model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAtLayer() {
        return this.atLayer;
    }

    public void setAtLayer(String atLayer) {
        this.atLayer = atLayer;
    }

    public String getType() {
        if (this.resourceType == null) {
            return null;
        }
        return this.resourceType.getResourceType();
    }

    public void setType(String type) {
        if (this.resourceType == null) {
            this.resourceType = new DomainResourceType();
        }
        this.resourceType.setResourceType(type);
    }

    public void setHostName(String n) {
        this.hostName = n;
    }

    public void setManagementIP(String ip) {
        this.managementIP = ip;
    }

    public List<DomainResource> getResources() {
        if (this.resourcesMap == null) {
            return null;
        }
        ArrayList<DomainResource> l = new ArrayList<DomainResource>(this.resourcesMap.values().size());
        for (DomainResource r : this.resourcesMap.values()) {
            l.add(r);
        }
        return l;
    }

    public HashMap<String, DomainResource> getResourcesMap() {
        return this.resourcesMap;
    }

    public void setResourcesMap(HashMap<String, DomainResource> m) {
        this.resourcesMap = m;
    }

    public DomainResource getResource(String iface) {
        if (this.resourcesMap == null) {
            return null;
        }
        return this.resourcesMap.get(iface);
    }

    public void addResource(DomainResource resource) {
        if (this.resourcesMap == null) {
            this.resourcesMap = new HashMap();
        }
        this.resourcesMap.put(resource.getInterface(), resource);
    }

    public boolean isModify() {
        return this.isModify;
    }

    public void setModify(boolean isModify) {
        this.isModify = isModify;
    }

    public int getModifyVersion() {
        return this.modifyVersion;
    }

    public void setModifyVersion(int modifyVersion) {
        this.modifyVersion = modifyVersion;
    }

    public int getNumInterface() {
        return this.numInterface;
    }

    public void setNumInterface(int numInterface) {
        this.numInterface = numInterface;
    }

    public String getGUID() {
        return this.GUID;
    }

    public void setGUID(String gUID) {
        this.GUID = gUID;
    }

    public static class LayerComparator
    implements Comparator {
        public int compare(Object s, Object o) {
            NetworkElement se = (NetworkElement)s;
            NetworkElement ne = (NetworkElement)o;
            int compare = 0;
            if (se == null) {
                return -1;
            }
            if (ne == null) {
                return 1;
            }
            if (se.getRank() < ne.getRank()) {
                compare = -1;
            } else if (se.getRank() > ne.getRank()) {
                compare = 1;
            } else if (se.getRank() == ne.getRank()) {
                if (ne.getType() != null && ne.getType().equals("Server")) {
                    compare = -1;
                }
                if (se.getType() != null && se.getType().equals("Server")) {
                    compare = 1;
                }
            }
            return compare;
        }
    }
}

