/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import java.util.LinkedList;
import net.exogeni.orca.ndl.DomainResourceType;
import net.exogeni.orca.ndl.elements.NetworkElement;
import net.exogeni.orca.util.persistence.Persistent;
import org.apache.log4j.Logger;

public final class NetworkConnection
extends NetworkElement {
    @Persistent
    private NetworkElement ne1;
    @Persistent
    private NetworkElement ne2;
    @Persistent
    private LinkedList<NetworkElement> connection = new LinkedList();
    @Persistent
    private LinkedList<NetworkConnection> clientConnections = new LinkedList();
    @Persistent
    private String connectionType;
    @Persistent
    private String openflowCapable;
    @Persistent
    protected Long bandwidth = 0L;
    @Persistent
    protected Long latency = 0L;
    @Persistent
    private Float label_ID = Float.valueOf(0.0f);

    public NetworkConnection() {
    }

    public NetworkConnection(OntModel m, OntResource rs) {
        super(m, rs);
    }

    public NetworkConnection(OntModel m, Resource rs) {
        super(m, rs);
    }

    public NetworkConnection(OntModel model, String url, String name) {
        super(model, url, name);
    }

    public NetworkConnection copy(String name) {
        NetworkConnection b_nc = new NetworkConnection();
        b_nc.setName(name);
        b_nc.setBandwidth(this.bandwidth);
        b_nc.setOpenflowCapable(this.openflowCapable);
        b_nc.setAtLayer(this.atLayer);
        b_nc.setLabel_ID(this.label_ID.floatValue());
        if (this.resourceType == null) {
            this.resourceType = new DomainResourceType(DomainResourceType.VLAN_RESOURCE_TYPE, 1);
        }
        b_nc.setResourceType(this.resourceType);
        return b_nc;
    }

    public String getOpenflowCapable() {
        return this.openflowCapable;
    }

    public void setOpenflowCapable(String openflowCapable) {
        this.openflowCapable = openflowCapable;
    }

    public float getLabel_ID() {
        return this.label_ID.floatValue();
    }

    public void setLabel_ID(float label_ID) {
        this.label_ID = Float.valueOf(label_ID);
    }

    public NetworkElement getNe1() {
        return this.ne1;
    }

    public void setNe1(NetworkElement ne1) {
        this.ne1 = ne1;
    }

    public NetworkElement getNe2() {
        return this.ne2;
    }

    public void setNe2(NetworkElement ne2) {
        this.ne2 = ne2;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
    }

    public long getLatency() {
        return this.latency;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    @Override
    public int compareTo(Object o) {
        int compare = 0;
        int rc1 = 0;
        int rc2 = 0;
        if (o == null) {
            return 1;
        }
        NetworkConnection ne = (NetworkConnection)o;
        if (this.bandwidth < ne.getBandwidth()) {
            compare = 1;
        } else if (this.bandwidth > ne.getBandwidth()) {
            compare = -1;
        } else if (this.bandwidth.longValue() == ne.getBandwidth()) {
            rc1 = this.getNe1().getNumUnits() + this.getNe1().getNumUnits();
            compare = rc1 <= (rc2 = this.getNe2().getNumUnits() + this.getNe2().getNumUnits()) ? 1 : -1;
        }
        return compare;
    }

    @Override
    public void print() {
        System.out.println(this.name + ":" + this.uri + ":" + this.uri);
        if (this.ne1 != null) {
            this.ne1.print();
        }
        if (this.ne2 != null) {
            this.ne2.print();
        }
        if (this.connection != null) {
            for (NetworkElement ne : this.connection) {
                ne.print();
            }
        }
    }

    @Override
    public void print(Logger logger) {
        logger.info((Object)(this.connectionType + ":" + this.ne1.getName() + ":" + this.ne1.getNumUnits() + "-" + this.ne2.getName() + ":" + this.ne2.getNumUnits() + ":" + this.bandwidth));
        for (NetworkElement ne : this.connection) {
            ne.print(logger);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("NE1: \n" + this.ne1 + "\n");
        sb.append("NE2: \n" + this.ne2 + "\n");
        sb.append("Attributes: " + this.connectionType + "/" + this.bandwidth + "\n");
        sb.append("NetworkElements:\n");
        if (this.connection != null) {
            int j = 0;
            Iterator it = this.connection.iterator();
            while (it.hasNext()) {
                sb.append("NetworkElement " + j++ + ":\n");
                NetworkElement ne = (NetworkElement)it.next();
                sb.append(ne);
            }
        }
        sb.append("Client connections:\n");
        if (this.clientConnections != null) {
            Iterator cit = this.clientConnections.iterator();
            int i = 0;
            while (cit.hasNext()) {
                NetworkConnection nc = (NetworkConnection)cit.next();
                sb.append("Connection " + i++ + ":\n");
                sb.append(nc);
            }
        }
        return sb.toString();
    }

    public LinkedList<NetworkConnection> getClientConnections() {
        return this.clientConnections;
    }

    public NetworkElement getFirstClientConnectionsElement() {
        return this.clientConnections.getFirst();
    }

    public void setClientConnections(LinkedList<NetworkConnection> clientConnections) {
        this.clientConnections = clientConnections;
    }

    public void setClientConnection(NetworkConnection clientConnection) {
        this.clientConnections.add(clientConnection);
    }

    public LinkedList<? extends NetworkElement> getConnection() {
        return this.connection;
    }

    public void setConnection(LinkedList<NetworkElement> connection) {
        this.connection = connection;
    }

    public NetworkElement getFirstConnectionElement() {
        if (this.connection.isEmpty()) {
            return null;
        }
        return this.connection.getFirst();
    }

    public void addConnection(NetworkElement element) {
        this.connection.add(element);
    }

    public boolean hasConnection(NetworkElement element) {
        for (NetworkElement ne : this.connection) {
            if (ne != element) continue;
            return true;
        }
        return false;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }
}

