/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.NdlException;

public class NdlPath
extends NdlCommons {
    public static final boolean debug = false;
    Set<Resource> unattached = new HashSet<Resource>();
    Set<Resource> ends = new HashSet<Resource>();
    Set<Resource> roots = new HashSet<Resource>();

    public boolean pathComplete() {
        return this.unattached.size() == 0;
    }

    private boolean tryPathRecursive(PathElement end, List<PathElement> path) {
        ArrayList<PathElement> candidates = new ArrayList<PathElement>();
        PathElement last = path.get(path.size() - 1);
        for (Resource endInt : NdlCommons.getResourceInterfaces(end.getResource())) {
            if (!endInt.equals((Object)last.getTail())) continue;
            end.setHead(endInt);
            path.add(end);
            return true;
        }
        for (Resource u : this.unattached) {
            PathElement pe2;
            boolean contFlag = false;
            for (PathElement pe2 : path) {
                if (!u.equals((Object)pe2.getResource())) continue;
                contFlag = true;
                break;
            }
            if (contFlag) continue;
            List<Resource> unInt = NdlCommons.getResourceInterfaces(u);
            if (unInt.get(0).equals((Object)last.getTail())) {
                pe2 = new PathElement(u, unInt.get(0), unInt.get(1));
                candidates.add(pe2);
                continue;
            }
            if (!unInt.get(1).equals((Object)last.getTail())) continue;
            pe2 = new PathElement(u, unInt.get(1), unInt.get(0));
            candidates.add(pe2);
        }
        if (candidates.size() == 0) {
            return false;
        }
        for (PathElement pe : candidates) {
            ArrayList<PathElement> newPath = new ArrayList<PathElement>(path);
            newPath.add(pe);
            if (!this.tryPathRecursive(end, newPath)) continue;
            path.clear();
            for (PathElement ppe : newPath) {
                path.add(ppe);
            }
            return true;
        }
        return false;
    }

    private boolean tryPath(PathElement end, List<PathElement> path) {
        boolean attached = true;
        PathElement current = path.get(0);
        HashSet<Resource> unattachedTmp = new HashSet<Resource>(this.unattached);
        block0: while (attached) {
            attached = false;
            for (Resource u : unattachedTmp) {
                List<Resource> unInt = NdlCommons.getResourceInterfaces(u);
                if (unInt.get(0).equals((Object)current.getTail())) {
                    attached = true;
                    current = new PathElement(u, unInt.get(0), unInt.get(1));
                    path.add(current);
                    unattachedTmp.remove(u);
                } else if (unInt.get(1).equals((Object)current.getTail())) {
                    attached = true;
                    current = new PathElement(u, unInt.get(1), unInt.get(0));
                    path.add(current);
                    unattachedTmp.remove(u);
                }
                if (!attached) continue;
                continue block0;
            }
        }
        boolean finished = false;
        for (Resource endInt : NdlCommons.getResourceInterfaces(end.getResource())) {
            if (!endInt.equals((Object)current.getTail())) continue;
            finished = true;
            end.setHead(endInt);
            path.add(end);
        }
        return finished;
    }

    private List<PathElement> assemblePath(Resource start, Resource end) throws NdlException {
        LinkedList<PathElement> path = new LinkedList<PathElement>();
        if (this.unattached.size() == 0) {
            return null;
        }
        Resource tmp = start;
        start = end;
        end = tmp;
        List<Resource> headInterfaces = NdlCommons.getResourceInterfaces(start);
        PathElement pathHead = new PathElement(start);
        PathElement pathTail = new PathElement(end);
        path.add(pathHead);
        for (Resource i : headInterfaces) {
            pathHead.setTail(i);
            if (this.tryPathRecursive(pathTail, path)) break;
            path.clear();
            path.add(pathHead);
        }
        return path;
    }

    private List<Resource> convertPath(List<PathElement> path) throws NdlException {
        ArrayList<Resource> arrayPath = new ArrayList<Resource>(path.size());
        int index = 0;
        while (index < path.size() - 1) {
            PathElement elem = path.get(index);
            PathElement nextElem = path.get(index + 1);
            arrayPath.add(index++, elem.getResource());
            if (elem.getTail().equals((Object)nextElem.getHead())) continue;
            throw new NdlException("Path not continuous between " + elem + " and " + nextElem);
        }
        arrayPath.add(index, path.get(index).getResource());
        return arrayPath;
    }

    public List<List<Resource>> getPaths() throws NdlException {
        if (this.ends.size() == 0) {
            return null;
        }
        ArrayList<List<Resource>> ret = new ArrayList<List<Resource>>();
        if (this.roots.size() == 0) {
            Resource pathEnd;
            if (this.ends.size() != 2) {
                StringBuilder sb = new StringBuilder();
                for (Resource e : this.ends) {
                    sb.append(e.toString());
                    sb.append(" ");
                }
                sb.append(" : ");
                for (Resource u : this.unattached) {
                    sb.append(u);
                    sb.append(" ");
                }
                throw new NdlException("Path has " + this.ends.size() + " (odd number) of endpoints: [" + sb.toString() + "] - expected 2");
            }
            Iterator<Resource> riter = this.ends.iterator();
            Resource pathStart = riter.next();
            List<PathElement> path = this.assemblePath(pathStart, pathEnd = riter.next());
            if (path == null || path.size() == 0) {
                throw new NdlException("Unable to find path between " + pathStart + " and " + pathEnd);
            }
            ret.add(this.convertPath(path));
        } else {
            for (Resource root : this.roots) {
                HashSet<Resource> endsToRemove = new HashSet<Resource>();
                for (Resource end : this.ends) {
                    List<PathElement> partPath = this.assemblePath(root, end);
                    if (partPath == null || partPath.size() == 0) continue;
                    endsToRemove.add(end);
                    ret.add(this.convertPath(partPath));
                }
                this.ends.removeAll(endsToRemove);
            }
            if (this.roots.size() > 1) {
                HashSet<Resource> tmpRoots = new HashSet<Resource>(this.roots);
                for (Resource root : this.roots) {
                    HashSet<Resource> rootsToRemove = new HashSet<Resource>();
                    for (Resource otherRoot : tmpRoots) {
                        List<PathElement> partPath = this.assemblePath(root, otherRoot);
                        if (partPath == null || partPath.size() == 0) {
                            throw new NdlException("Unable to find path between multicast roots " + root + " and " + otherRoot);
                        }
                        rootsToRemove.add(otherRoot);
                        ret.add(this.convertPath(partPath));
                    }
                    tmpRoots.removeAll(rootsToRemove);
                }
            }
        }
        return ret;
    }

    public void addEndElement(Resource r) throws NdlException {
        this.ends.add(r);
    }

    public void addElement(Resource r) throws NdlException {
        List<Resource> interfaces = NdlPath.getResourceInterfaces(r);
        if (interfaces.size() == 2) {
            this.unattached.add(r);
        } else {
            this.ends.add(r);
        }
    }

    public void addRoot(Resource r) throws NdlException {
        this.roots.add(r);
    }

    public List<Resource> getRoots() throws NdlException {
        if (this.roots.size() == 0) {
            return null;
        }
        return new LinkedList<Resource>(this.roots);
    }

    public static class PathElement {
        final Resource r;
        Resource headInterface = null;
        Resource tailInterface = null;

        PathElement(Resource i) {
            this.r = i;
        }

        PathElement(Resource i, Resource h, Resource t) {
            this.r = i;
            this.headInterface = h;
            this.tailInterface = t;
        }

        void setHead(Resource i) {
            this.headInterface = i;
        }

        void setTail(Resource i) {
            this.tailInterface = i;
        }

        Resource getHead() {
            return this.headInterface;
        }

        Resource getTail() {
            return this.tailInterface;
        }

        Resource getResource() {
            return this.r;
        }

        public String toString() {
            return this.r.toString();
        }
    }
}

