/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.rdf.model.Resource;
import java.util.BitSet;
import java.util.HashSet;
import net.exogeni.orca.ndl.elements.Label;
import net.exogeni.orca.util.persistence.Persistable;
import net.exogeni.orca.util.persistence.Persistent;

public class LabelSet
extends HashSet<Label>
implements Persistable {
    @Persistent
    private Label minLabel;
    @Persistent
    private Label maxLabel;
    @Persistent
    public String LabelType;
    @Persistent
    public Float setID;
    @Persistent
    public String resourceUri;
    @Persistent
    public Integer setSize;
    @Persistent
    private BitSet usedBitSet;
    @Persistent
    private boolean isAllocatable = true;

    public LabelSet() {
        this.minLabel = null;
        this.maxLabel = null;
        this.usedBitSet = new BitSet(4001);
    }

    public LabelSet(Label min, Label max, Resource rs) {
        this.minLabel = min;
        this.maxLabel = max;
        this.setSize = this.getMaxLabe_ID() == 0.0f ? Integer.valueOf(1) : Integer.valueOf((int)(this.getMaxLabe_ID() - this.getMinLabel_ID() + 1.0f));
        this.LabelType = min.type;
        this.resourceUri = rs.getURI();
        this.usedBitSet = new BitSet(4001);
    }

    @Override
    public String toString() {
        return "" + this.resourceUri + " size " + this.setSize + " type " + this.LabelType + " [" + (this.minLabel != null ? this.minLabel : "") + " " + (this.maxLabel != null ? this.maxLabel : "") + "]";
    }

    public boolean contains(Label label) {
        return label.label.floatValue() >= this.minLabel.label.floatValue() & label.label.floatValue() <= this.maxLabel.label.floatValue();
    }

    public float getMinLabel_ID() {
        if (this.minLabel == null) {
            return 0.0f;
        }
        return this.minLabel.label.floatValue();
    }

    public float getMaxLabe_ID() {
        if (this.maxLabel == null) {
            return 0.0f;
        }
        return this.maxLabel.label.floatValue();
    }

    public int getLabelRangeSize() {
        if (this.maxLabel == null || this.minLabel == null) {
            return 1;
        }
        return (int)(this.maxLabel.label.floatValue() - this.minLabel.label.floatValue() + 1.0f);
    }

    public BitSet getUsedBitSet() {
        return this.usedBitSet;
    }

    public void setUsedBitSet(BitSet usedBitSet) {
        this.usedBitSet = usedBitSet;
    }

    public void setUsedBitSet(int usedBit) {
        this.usedBitSet.set(usedBit);
    }

    public String getLabelType() {
        return this.LabelType;
    }

    public void setLabelType(String labelType) {
        this.LabelType = labelType;
    }

    public Label getMaxLabel() {
        return this.maxLabel;
    }

    public void setMaxLabel(Label maxLabel) {
        this.maxLabel = maxLabel;
    }

    public Label getMinLabel() {
        return this.minLabel;
    }

    public void setMinLabel(Label minLabel) {
        this.minLabel = minLabel;
    }

    public float getSetID() {
        return this.setID.floatValue();
    }

    public void setSetID(float setID) {
        this.setID = Float.valueOf(setID);
    }

    public int getSetSize() {
        return this.setSize;
    }

    public void setSetSize(int setSize) {
        this.setSize = setSize;
    }

    public void setNotAllocatable() {
        this.isAllocatable = false;
    }

    public boolean getIsAllocatable() {
        return this.isAllocatable;
    }
}

