/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import java.util.HashMap;
import net.exogeni.orca.util.persistence.Persistable;
import net.exogeni.orca.util.persistence.Persistent;
import org.apache.log4j.Logger;

public class Label
implements Persistable {
    @Persistent
    public String name = "unspecified";
    @Persistent
    public Float label;
    @Persistent
    public String type;
    @Persistent
    protected String label_uri;
    @Persistent
    public HashMap<String, String> metric;
    @Persistent
    public Float swap;

    public Label(String name, float label, String type) {
        this.name = name;
        this.label = Float.valueOf(label);
        this.type = type;
        this.metric = new HashMap();
    }

    public Label(OntResource rs, float label, String type) {
        this.label_uri = rs.getURI();
        this.label = Float.valueOf(label);
        this.type = type;
    }

    public Label(OntResource rs, String name, float label, String type) {
        this.label_uri = rs.getURI();
        this.name = name;
        this.label = Float.valueOf(label);
        this.type = type;
        this.metric = new HashMap();
    }

    public Label() {
    }

    public boolean equals(Object o) {
        if (o instanceof Label && this.type != null) {
            Label newL = (Label)o;
            return this.type.equals(newL.type) && this.label == newL.label;
        }
        return false;
    }

    public void setmetric(String key, String value) {
        if (this.metric == null) {
            this.metric = new HashMap();
        }
        this.metric.put(key, value);
    }

    public String toString() {
        return this.name + ":" + this.label + ":" + this.type + ":" + this.swap + ":" + this.label_uri;
    }

    public void print(Logger logger) {
        logger.info((Object)this.label);
    }

    public void setResource(OntResource r) {
        this.label_uri = r != null ? r.getURI() : null;
    }

    public OntResource getResource(OntModel m) {
        if (m.isClosed()) {
            return null;
        }
        return m.getOntResource(this.label_uri);
    }

    public String getURI() {
        return this.label_uri;
    }
}

