/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.net.UnknownHostException;
import java.util.LinkedList;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.elements.IPAddress;
import net.exogeni.orca.ndl.elements.Label;
import net.exogeni.orca.ndl.elements.NetworkElement;
import net.exogeni.orca.util.persistence.NotPersistent;
import net.exogeni.orca.util.persistence.Persistent;
import net.jwhoisserver.utils.InetNetworkException;

public class Interface
extends NetworkElement {
    @Persistent
    private String upLayer;
    @Persistent
    private String lowLayer;
    @Persistent
    private String usedLabelSetUri = null;
    @Persistent
    private Label label;
    @NotPersistent
    private LinkedList<Interface> serverInterface;
    @Persistent
    private Interface input;
    @Persistent
    private Interface output;
    @Persistent
    private Integer mark;

    public Interface(OntModel m, String u, String n) {
        super(m, u, n);
        Individual new_intf_ont = null;
        if (this.getResource() == null) {
            new_intf_ont = this.model.createIndividual(u, NdlCommons.interfaceOntClass);
        }
    }

    public Interface() {
    }

    public Interface(OntModel m, OntResource rs) {
        super(m, rs);
    }

    public void setLabel(String ip, String mask) throws UnknownHostException, InetNetworkException {
        this.label = new IPAddress(ip, mask);
        this.label.setResource(this.getResource());
        if (((IPAddress)this.label).getCIDR() != null && this.label.getResource(this.model).getProperty(NdlCommons.layerLabelIdProperty) == null) {
            this.label.getResource(this.model).addProperty(NdlCommons.layerLabelIdProperty, ((IPAddress)this.label).getCIDR());
        }
        this.logger.debug((Object)("Interface:" + this.label.getResource(this.model).getProperty(NdlCommons.layerLabelIdProperty) + "-----ip=" + ip));
    }

    public Interface(OntModel m, OntResource rs, boolean client) {
        super(m, rs.getURI(), rs.getLabel(null));
        this.setResource(rs);
        String layer = NdlCommons.findLayer(m, (Resource)rs);
        this.setAtLayer(layer);
        if (client) {
            this.findClientInterface(this);
        }
        this.findUNIInterface((Resource)rs, this);
    }

    public void findClientInterface(Interface parent) {
        ResultSet results = NdlCommons.getLayerAdapatation(this.model, parent.getURI());
        OntResource parent_rs = parent.getResource();
        Interface intf = null;
        Resource rs = null;
        String varName = (String)results.getResultVars().get(0);
        if (results.hasNext()) {
            rs = results.nextSolution().getResource(varName);
            OntResource rs_ont = this.model.getOntResource(rs);
            intf = new Interface(this.model, rs_ont, true);
            parent.addClientInterface(intf);
            intf.addServerInterface(parent);
            rs_ont.addProperty(NdlCommons.adaptationPropertyOf, (RDFNode)parent_rs);
            parent_rs.addProperty(NdlCommons.adaptationProperty, (RDFNode)rs);
        }
    }

    public void findUNIInterface(Resource rs, Interface intf) {
        Statement st = rs.getProperty(NdlCommons.hasInputInterface);
        if (st != null) {
            intf.setInput(new Interface(this.getModel(), this.model.getOntResource(st.getResource()), true));
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        st = rs.getProperty(NdlCommons.hasOutputInterface);
        if (st != null) {
            intf.setOutput(new Interface(this.model, this.model.getOntResource(st.getResource()), true));
        }
    }

    public void addClientInterface(OntModel ontModel, Interface client, String adaptation) {
        this.addClientInterface(client);
        Property adaptationP = ontModel.createProperty("http://geni-orca.renci.org/owl/layer.owl#" + adaptation);
        OntResource rs_client = client.getResource();
        this.getResource().addProperty(NdlCommons.adaptationProperty, (RDFNode)rs_client);
        this.getResource().addProperty(adaptationP, (RDFNode)rs_client);
        rs_client.addProperty(NdlCommons.topologyInterfaceOfProperty, (RDFNode)this.getResource().getProperty(NdlCommons.topologyInterfaceOfProperty).getResource());
        rs_client.addProperty(NdlCommons.adaptationPropertyOf, (RDFNode)this.getResource());
    }

    public void addServerInterface(Interface intf) {
        if (this.serverInterface == null) {
            this.serverInterface = new LinkedList();
        }
        this.serverInterface.add(intf);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("Label:");
        if (this.label != null) {
            sb.append(this.label);
        }
        int size = 0;
        int i = 0;
        Interface intf = null;
        if (this.clientInterface != null) {
            size = this.clientInterface.size();
            sb.append("Client Interface:" + size);
            for (i = 0; i < size; ++i) {
                intf = (Interface)this.clientInterface.get(i);
                sb.append(intf.toString());
            }
        }
        return sb.toString();
    }

    public String getLowLayer() {
        return this.lowLayer;
    }

    public void setLowLayer(String lowLayer) {
        this.lowLayer = lowLayer;
    }

    public String getUpLayer() {
        return this.upLayer;
    }

    public void setUpLayer(String upLayer) {
        this.upLayer = upLayer;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public int getMark() {
        return this.mark;
    }

    public void setMark(int mark) {
        this.mark = mark;
    }

    public LinkedList<Interface> getServerInterface() {
        return this.serverInterface;
    }

    public void setServerInterface(LinkedList<Interface> serverInterface) {
        this.serverInterface = serverInterface;
    }

    public Interface getInput() {
        return this.input;
    }

    public void setInput(Interface input) {
        this.input = input;
    }

    public Interface getOutput() {
        return this.output;
    }

    public void setOutput(Interface output) {
        this.output = output;
    }

    public Resource getUsedLabelSet(Model m) {
        if (m != null) {
            return m.getResource(this.usedLabelSetUri);
        }
        return null;
    }

    public void setUsedLabelSet(Resource usedLabelSet) {
        this.usedLabelSetUri = usedLabelSet.getURI();
    }
}

