/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.ontology.OntResource;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.BitSet;
import net.exogeni.orca.ndl.elements.IPAddress;
import net.jwhoisserver.utils.InetIP2UBI;
import net.jwhoisserver.utils.InetNetwork;
import net.jwhoisserver.utils.InetNetworkException;

public class IPAddressRange {
    public IPAddress base_ip_addr;
    InetNetwork base_IP;
    BigInteger bi_base_IP;
    BitSet bSet;
    String hostInterface;

    public IPAddressRange(BitSet set) {
        this.bSet = set;
    }

    public IPAddressRange(String addr, String netmask, OntResource addr_rs) throws InetNetworkException, UnknownHostException {
        if (addr == null) {
            return;
        }
        if (netmask == null) {
            netmask = "255.255.255.0";
        }
        this.base_ip_addr = new IPAddress(addr, netmask);
        this.base_ip_addr.setResource(addr_rs);
        this.base_IP = new InetNetwork(addr, netmask);
        InetAddress base_IP_InetAddr = InetAddress.getByName(addr);
        this.bi_base_IP = InetIP2UBI.convertIP2UBI((byte[])base_IP_InetAddr.getAddress());
        BigInteger bi_max_IP = InetIP2UBI.convertIP2UBI((byte[])this.base_IP.getMaxHostAddressBytes());
        long range = bi_max_IP.longValue() - this.bi_base_IP.longValue();
        this.bSet = new BitSet((int)range);
        this.bSet.set(0);
    }

    public String toString() {
        return this.base_ip_addr + " " + this.base_IP + " " + this.bi_base_IP + " " + this.hostInterface;
    }

    public void modify(String addr, String netmask, OntResource addr_rs) throws UnknownHostException, InetNetworkException {
        InetAddress ip_InetAddr;
        BigInteger bi_ip_str_IP;
        int position;
        if (addr == null) {
            return;
        }
        if (this.bSet == null) {
            return;
        }
        if (this.base_ip_addr == null) {
            this.base_ip_addr = new IPAddress(addr, netmask);
            this.base_ip_addr.setResource(addr_rs);
            this.base_IP = new InetNetwork(addr, netmask);
            InetAddress base_IP_InetAddr = InetAddress.getByName(addr);
            this.bi_base_IP = InetIP2UBI.convertIP2UBI((byte[])base_IP_InetAddr.getAddress());
        }
        if ((position = (int)((bi_ip_str_IP = InetIP2UBI.convertIP2UBI((byte[])(ip_InetAddr = InetAddress.getByName(addr)).getAddress())).longValue() - this.bi_base_IP.longValue())) >= 0) {
            this.bSet.set(position);
        }
    }

    public IPAddress getBase_ip_addr() {
        return this.base_ip_addr;
    }

    public void setBase_ip_addr(IPAddress base_ip_addr) {
        this.base_ip_addr = base_ip_addr;
    }

    public InetNetwork getBase_IP() {
        return this.base_IP;
    }

    public void setBase_IP(InetNetwork base_IP) {
        this.base_IP = base_IP;
    }

    public BigInteger getBi_base_IP() {
        return this.bi_base_IP;
    }

    public void setBi_base_IP(BigInteger bi_base_IP) {
        this.bi_base_IP = bi_base_IP;
    }

    public BitSet getbSet() {
        return this.bSet;
    }

    public void setbSet(BitSet bSet) {
        if (bSet == null) {
            return;
        }
        this.bSet.or(bSet);
    }

    public String getHostInterface() {
        return this.hostInterface;
    }

    public void setHostInterface(String hostInterface) {
        this.hostInterface = hostInterface;
    }
}

