/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Resource;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.elements.Label;
import net.jwhoisserver.utils.InetIP2UBI;
import net.jwhoisserver.utils.InetNetwork;
import net.jwhoisserver.utils.InetNetworkException;

public class IPAddress
extends Label {
    public String address;
    public String netmask;
    public String cidr;
    public IPAddress base_IP;
    private static final String IP_PATTERN = "^([\\d]+)[.]([\\d]+)[.]([\\d]+)[.]([\\d]+)$";
    private static final Pattern ipPattern = Pattern.compile("^([\\d]+)[.]([\\d]+)[.]([\\d]+)[.]([\\d]+)$");
    private static final String CIDR_PATTERN = "^([\\d]+)[.]([\\d]+)[.]([\\d]+)[.]([\\d]+)/([\\d]+)$";
    private static final Pattern cidrPattern = Pattern.compile("^([\\d]+)[.]([\\d]+)[.]([\\d]+)[.]([\\d]+)/([\\d]+)$");

    public IPAddress(String a, String m) throws UnknownHostException, InetNetworkException {
        this.address = a;
        this.netmask = m;
        this.type = "IPAddress";
        if (this.netmask == null) {
            this.netmask = "255.255.255.0";
        }
        InetAddress addr1_netmask = InetAddress.getByName(this.netmask);
        if (a != null) {
            InetNetwork addr1_network = new InetNetwork(this.address, this.netmask);
            this.cidr = addr1_network.networkIdentifierCIDR();
        }
        this.base_IP = this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(";cidr=" + this.cidr);
        return sb.toString();
    }

    public String getCIDR() {
        return this.cidr;
    }

    public String getCIDRAddress() {
        if (null != this.cidr && this.cidr.indexOf("/") >= 0) {
            return this.cidr.split("/")[0];
        }
        return this.cidr;
    }

    public String getCIDRNetmask() {
        if (this.cidr.indexOf("/") >= 0) {
            return this.cidr.split("/")[1];
        }
        return "24";
    }

    public IPAddress getNewIpAddress(OntModel om, String start_ip, String netmask, String label_uri, int i) throws UnknownHostException, InetNetworkException {
        if (i < 0) {
            return this;
        }
        String new_address = null;
        if (start_ip != null) {
            InetAddress ip = InetAddress.getByName(this.base_IP.address);
            BigInteger biIP = InetIP2UBI.convertIP2UBI((byte[])ip.getAddress());
            BigInteger nbiIP = biIP.add(new BigInteger(new Integer(i).toString()));
            InetAddress nIP = InetIP2UBI.convertUBI2IP((BigInteger)nbiIP, (int)4);
            new_address = nIP.toString().substring(1);
        }
        IPAddress new_ip = new IPAddress(new_address, netmask);
        String old_url = label_uri;
        String url = old_url + "/" + String.valueOf(i);
        Individual new_ip_rs = om.createIndividual(url, NdlCommons.IPAddressOntClass);
        OntResource new_ip_ont = om.getOntResource((Resource)new_ip_rs);
        if (new_address != null) {
            new_ip_ont.addProperty(NdlCommons.layerLabelIdProperty, new_ip.getCIDRAddress());
            new_ip_ont.addProperty(NdlCommons.ip4NetmaskProperty, netmask);
        }
        new_ip.setResource(new_ip_ont);
        return new_ip;
    }

    public IPAddress getNewIpAddress(OntModel om, int i) throws UnknownHostException, InetNetworkException {
        if (i == 0) {
            return this;
        }
        IPAddress new_ip = this.getNewIpAddress(om, this.address, this.netmask, this.label_uri, i);
        new_ip.base_IP = this;
        return new_ip;
    }

    private static boolean checkOctet(String i) {
        try {
            int ii = Integer.parseInt(i);
            return ii >= 0 && ii <= 255;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static boolean checkNetmask(String i) {
        try {
            int ii = Integer.parseInt(i);
            return ii >= 0 && ii <= 32;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean validateIP(String ip) {
        Matcher m = ipPattern.matcher(ip);
        if (m.find()) {
            return IPAddress.checkOctet(m.group(1)) && IPAddress.checkOctet(m.group(2)) && IPAddress.checkOctet(m.group(3)) && IPAddress.checkOctet(m.group(4));
        }
        return false;
    }

    public static boolean validateCIDR(String ip) {
        Matcher m = cidrPattern.matcher(ip);
        if (m.find()) {
            return IPAddress.checkOctet(m.group(1)) && IPAddress.checkOctet(m.group(2)) && IPAddress.checkOctet(m.group(3)) && IPAddress.checkOctet(m.group(4)) && IPAddress.checkNetmask(m.group(5));
        }
        return false;
    }
}

