/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.exogeni.orca.ndl.DomainResourceType;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.NdlException;
import net.exogeni.orca.ndl.NdlModel;
import net.exogeni.orca.ndl.elements.ComputeElement;
import net.exogeni.orca.ndl.elements.Device;
import net.exogeni.orca.ndl.elements.IPAddressRange;
import net.exogeni.orca.ndl.elements.Interface;
import net.exogeni.orca.ndl.elements.LabelSet;
import net.exogeni.orca.ndl.elements.SwitchingAction;

public class DomainElement
extends Device {
    protected ComputeElement ce = null;
    protected HashMap<DomainElement, OntResource> followedBy;
    protected HashMap<DomainElement, OntResource> precededBy;
    protected IPAddressRange ip_range;
    protected boolean needFollowerInterface = false;
    protected OntResource followerInterface = null;

    public DomainElement(OntModel model, OntResource domain) {
        super(model, domain);
    }

    public DomainElement(OntModel idm, String url, String name) {
        super(idm, url, name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("IP Range: " + this.ip_range + "\n");
        sb.append("followedBy: \n");
        if (this.followedBy != null) {
            for (Map.Entry<DomainElement, OntResource> ee : this.followedBy.entrySet()) {
                sb.append(ee.getKey().getURI() + " <> " + ee.getValue());
            }
            sb.append("\n");
        }
        sb.append("precededBy: \n");
        if (this.precededBy != null) {
            for (Map.Entry<DomainElement, OntResource> ee : this.precededBy.entrySet()) {
                sb.append(ee.getKey().getURI() + " <> " + ee.getValue());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getDomainPrefix(Resource domain) {
        String prefix = domain.getURI().split("\\#")[0];
        return prefix;
    }

    @Override
    public void setParameters(OntModel ontModel, OntResource rs) {
        super.setParameters(ontModel, rs);
        OntResource rs_ont = ontModel.getOntResource((Resource)rs);
        if (rs_ont.hasProperty(NdlCommons.domainHasServiceProperty)) {
            Resource networkService = rs_ont.getRequiredProperty(NdlCommons.domainHasServiceProperty).getResource();
            Resource set = null;
            Object label_set = null;
            Object label = null;
            this.labelSets = new HashMap();
            StmtIterator j = networkService.listProperties(NdlCommons.availableLabelSet);
            while (j.hasNext()) {
                LinkedList<LabelSet> lSetList;
                set = ((Statement)j.next()).getResource();
                Statement typeStm = set.getProperty(NdlCommons.domainHasResourceTypeProperty);
                String rType = typeStm.getResource().getLocalName().toLowerCase();
                if (set.hasProperty(NdlCommons.domainIsAllocatable) && !set.getProperty(NdlCommons.domainIsAllocatable).getBoolean() || (lSetList = NdlCommons.getLabelSet(set.getURI(), rType, ontModel)) == null) continue;
                this.labelSets.put(rType, lSetList);
            }
        }
    }

    public OntModel domainRequest() throws NdlException {
        DomainResourceType rType;
        OntModel domainRequestModel = NdlModel.createModel(OntModelSpec.OWL_MEM, true);
        Individual reservation = domainRequestModel.createIndividual(this.getURI(), NdlCommons.reservationOntClass);
        reservation.addProperty(NdlCommons.inDomainProperty, (RDFNode)this.getResource());
        String castType = null;
        LinkedList<SwitchingAction> action_list = this.getActionList();
        int size = action_list.size();
        SwitchingAction action = null;
        for (int i = 0; i < size; ++i) {
            action = action_list.get(i);
            if (action == null) {
                this.logger.info((Object)"No Action");
                continue;
            }
            castType = action.getCastType();
            if (castType != null && castType.equalsIgnoreCase("Multicast")) break;
        }
        Individual connection_rs = null;
        int numPreceded = 0;
        int numFollowed = 0;
        if (castType != null && castType.equalsIgnoreCase("Multicast")) {
            if (this.getPrecededBySet() != null) {
                numPreceded = this.getPrecededBySet().size();
            }
            if (this.getFollowedBy() != null) {
                numFollowed = this.getFollowedBySet().size();
            }
            castType = numPreceded + numFollowed >= 2 ? "Multicast" : "Unicast";
        }
        connection_rs = castType != null && castType.equalsIgnoreCase("Multicast") ? domainRequestModel.createIndividual(reservation.getURI() + "/conn", NdlCommons.topologyBroadcastConnectionClass) : domainRequestModel.createIndividual(reservation.getURI() + "/conn", NdlCommons.topologyNetworkConnectionClass);
        domainRequestModel.add((Resource)reservation, NdlCommons.collectionElementProperty, (RDFNode)connection_rs);
        long bw = 0L;
        LinkedList<SwitchingAction> actionList = this.getActionList();
        if (actionList != null) {
            action = actionList.element();
            bw = action.getBw();
        }
        if ((rType = this.getResourceType()) != null) {
            String rTypeURL = rType.getResourceTypeURL();
            Resource rType_rs = null;
            if (rTypeURL != null && this.model != null) {
                rType_rs = this.model.createResource(rTypeURL);
                connection_rs.addProperty(NdlCommons.domainHasResourceTypeProperty, (RDFNode)rType_rs);
            }
            connection_rs.addProperty(NdlCommons.numResource, String.valueOf(rType.getCount()), (RDFDatatype)XSDDatatype.XSDint);
        }
        connection_rs.addLiteral(NdlCommons.layerBandwidthProperty, (Object)bw);
        OntResource up_device_rs = null;
        OntResource down_device_rs = null;
        DomainElement parent_de = null;
        OntResource intf_ont = null;
        OntResource label_ont = null;
        if (castType != null && castType.equalsIgnoreCase("Multicast")) {
            int label_id;
            Resource intf_link_rs;
            Resource intf_rs;
            if (this.getPrecededBySet() != null) {
                for (Map.Entry<DomainElement, OntResource> entry : this.getPrecededBySet()) {
                    Object var21_32 = null;
                    intf_ont = entry.getValue();
                    if (!intf_ont.hasProperty(NdlCommons.linkTo)) continue;
                    Resource resource = intf_ont.getProperty(NdlCommons.linkTo).getResource();
                    domainRequestModel.removeAll(resource, NdlCommons.topologyInterfaceOfProperty, null);
                    domainRequestModel.removeAll(resource, NdlCommons.connectedTo, null);
                }
            }
            if (this.getPrecededBySet() != null) {
                int i = 0;
                for (Map.Entry<DomainElement, OntResource> entry : this.getPrecededBySet()) {
                    ++i;
                    parent_de = entry.getKey();
                    intf_ont = entry.getValue();
                    intf_rs = null;
                    intf_link_rs = null;
                    if (!intf_ont.hasProperty(NdlCommons.linkTo)) continue;
                    intf_link_rs = intf_ont.getProperty(NdlCommons.linkTo).getResource();
                    up_device_rs = this.setNeighborDevice(domainRequestModel, this.getURI() + "/up/" + i, intf_link_rs, null);
                    if (up_device_rs != null) {
                        intf_rs = up_device_rs.getProperty(NdlCommons.topologyHasInterfaceProperty).getResource();
                        connection_rs.addProperty(NdlCommons.topologyHasInterfaceProperty, (RDFNode)intf_rs);
                        if (intf_rs.hasProperty(NdlCommons.linkTo)) {
                            intf_link_rs = intf_rs.getProperty(NdlCommons.linkTo).getResource();
                            intf_link_rs.addProperty(NdlCommons.linkTo, (RDFNode)intf_rs);
                        }
                    }
                    if (parent_de.getStaticLabel() != 0.0f) {
                        label_id = (int)parent_de.getStaticLabel();
                        label_ont = domainRequestModel.createOntResource(parent_de.getResource().getURI() + String.valueOf(label_id));
                        label_ont.addProperty(NdlCommons.layerLabelIdProperty, String.valueOf(label_id), (RDFDatatype)XSDDatatype.XSDfloat);
                        domainRequestModel.add(intf_rs, NdlCommons.layerLabel, (RDFNode)label_ont);
                    }
                    this.logger.info((Object)("The multicast domain:precedent=" + parent_de.getURI() + ":" + parent_de.getStaticLabel() + ":" + intf_rs.getURI() + ":" + intf_link_rs.getURI()));
                }
            }
            if (this.getFollowedBy() != null) {
                for (Map.Entry<DomainElement, OntResource> entry : this.getFollowedBySet()) {
                    Object var21_37 = null;
                    intf_ont = entry.getValue();
                    if (!intf_ont.hasProperty(NdlCommons.linkTo)) continue;
                    Resource resource = intf_ont.getProperty(NdlCommons.linkTo).getResource();
                    domainRequestModel.removeAll(resource, NdlCommons.topologyInterfaceOfProperty, null);
                    domainRequestModel.removeAll(resource, NdlCommons.connectedTo, null);
                }
            }
            if (this.getFollowedBy() != null) {
                int i = 0;
                for (Map.Entry<DomainElement, OntResource> entry : this.getFollowedBySet()) {
                    ++i;
                    parent_de = entry.getKey();
                    intf_ont = entry.getValue();
                    intf_rs = null;
                    intf_link_rs = null;
                    if (!intf_ont.hasProperty(NdlCommons.linkTo)) continue;
                    intf_link_rs = intf_ont.getProperty(NdlCommons.linkTo).getResource();
                    up_device_rs = this.setNeighborDevice(domainRequestModel, this.getURI() + "/down/" + i, intf_link_rs, null);
                    if (up_device_rs != null) {
                        intf_rs = up_device_rs.getProperty(NdlCommons.topologyHasInterfaceProperty).getResource();
                        connection_rs.addProperty(NdlCommons.topologyHasInterfaceProperty, (RDFNode)intf_rs);
                        if (intf_rs.hasProperty(NdlCommons.linkTo)) {
                            intf_link_rs = intf_rs.getProperty(NdlCommons.linkTo).getResource();
                            intf_link_rs.addProperty(NdlCommons.linkTo, (RDFNode)intf_rs);
                        }
                    }
                    if (parent_de.getStaticLabel() != 0.0f) {
                        label_id = (int)parent_de.getStaticLabel();
                        label_ont = domainRequestModel.createOntResource(parent_de.getResource().getURI() + String.valueOf(label_id));
                        label_ont.addProperty(NdlCommons.layerLabelIdProperty, String.valueOf(label_id), (RDFDatatype)XSDDatatype.XSDfloat);
                        domainRequestModel.add(intf_rs, NdlCommons.layerLabel, (RDFNode)label_ont);
                    }
                    this.logger.info((Object)("The multicast domain:child=" + parent_de.getURI() + ":" + parent_de.getStaticLabel() + ":" + intf_ont.getURI() + ":" + intf_link_rs.getURI()));
                }
            }
        } else {
            OntResource ontResource;
            OntResource upNeighbour = this.getUpNeighbour(this.getModel());
            if (upNeighbour != null) {
                String string = this.getURI() + "/up";
                OntResource ontResource2 = this.getUpLocal(this.getModel());
                domainRequestModel.removeAll((Resource)upNeighbour, NdlCommons.topologyInterfaceOfProperty, null);
                domainRequestModel.removeAll((Resource)upNeighbour, NdlCommons.connectedTo, null);
                up_device_rs = this.setNeighborDevice(domainRequestModel, string, (Resource)upNeighbour, ontResource2);
            }
            if ((ontResource = this.getDownNeighbour(this.getModel())) != null) {
                String string = this.getURI() + "/down";
                OntResource downLocal = this.getDownLocal(this.getModel());
                domainRequestModel.removeAll((Resource)ontResource, NdlCommons.topologyInterfaceOfProperty, null);
                domainRequestModel.removeAll((Resource)ontResource, NdlCommons.connectedTo, null);
                down_device_rs = this.setNeighborDevice(domainRequestModel, string, (Resource)ontResource, downLocal);
            }
            Object var21_44 = null;
            Resource intf_link_rs = null;
            if (up_device_rs != null) {
                Resource resource = up_device_rs.getProperty(NdlCommons.topologyHasInterfaceProperty).getResource();
                connection_rs.addProperty(NdlCommons.topologyHasInterfaceProperty, (RDFNode)resource);
                if (resource.hasProperty(NdlCommons.linkTo)) {
                    intf_link_rs = resource.getProperty(NdlCommons.linkTo).getResource();
                    intf_link_rs.addProperty(NdlCommons.linkTo, (RDFNode)resource);
                }
            }
            if (down_device_rs != null) {
                Resource resource = down_device_rs.getProperty(NdlCommons.topologyHasInterfaceProperty).getResource();
                connection_rs.addProperty(NdlCommons.topologyHasInterfaceProperty, (RDFNode)resource);
                if (resource.hasProperty(NdlCommons.linkTo)) {
                    intf_link_rs = resource.getProperty(NdlCommons.linkTo).getResource();
                    intf_link_rs.addProperty(NdlCommons.linkTo, (RDFNode)resource);
                }
            }
        }
        return domainRequestModel;
    }

    public OntResource setNeighborDevice(OntModel domainRequestModel, String domain_url, Resource neighbor_intf_rs, OntResource local) {
        if (neighbor_intf_rs == null) {
            return null;
        }
        Individual device_rs = domainRequestModel.createIndividual(domain_url, NdlCommons.computeElementClass);
        device_rs.addLiteral(NdlCommons.domainIsAllocatable, false);
        Statement s = this.getResource().getProperty(NdlCommons.hasSwitchMatrix);
        if (s != null) {
            Resource sm_rs = s.getResource();
            domainRequestModel.add((Resource)device_rs, NdlCommons.hasSwitchMatrix, (RDFNode)sm_rs);
            domainRequestModel.add(sm_rs.getProperty(NdlCommons.switchingCapability));
            domainRequestModel.addLiteral(sm_rs, NdlCommons.domainIsAllocatable, false);
        }
        Resource rs = neighbor_intf_rs;
        neighbor_intf_rs = domainRequestModel.createIndividual(neighbor_intf_rs.getURI(), NdlCommons.interfaceOntClass);
        device_rs.addProperty(NdlCommons.topologyHasInterfaceProperty, (RDFNode)neighbor_intf_rs);
        domainRequestModel.add(neighbor_intf_rs, NdlCommons.topologyInterfaceOfProperty, (RDFNode)device_rs);
        while (true) {
            neighbor_intf_rs = domainRequestModel.createIndividual(rs.getURI(), NdlCommons.interfaceOntClass);
            StmtIterator j = rs.listProperties();
            while (j.hasNext()) {
                Statement s_type = (Statement)j.next();
                domainRequestModel.add(neighbor_intf_rs, s_type.getPredicate(), s_type.getObject());
            }
            ResultSet results = NdlCommons.getLayerAdapatation(this.getModel(), rs.getURI());
            String varName = (String)results.getResultVars().get(0);
            if (!results.hasNext()) break;
            rs = results.nextSolution().getResource(varName);
        }
        if (local != null) {
            rs = local;
            Resource neighbour_device_rs = null;
            boolean isStitching = false;
            if (neighbor_intf_rs.hasProperty(NdlCommons.topologyInterfaceOfProperty)) {
                neighbour_device_rs = neighbor_intf_rs.getProperty(NdlCommons.topologyInterfaceOfProperty).getResource();
                isStitching = neighbour_device_rs.getURI().contains("Stitching/Domain") || neighbor_intf_rs.getURI().contains("Stitching/Domain");
                this.logger.debug((Object)("neighbour_device_rs=" + neighbour_device_rs.getURI()));
            }
            this.logger.debug((Object)("neighbor_intf_rs=" + neighbor_intf_rs.getURI() + ";isStitching=" + isStitching));
            if (local.hasProperty(NdlCommons.topologyInterfaceOfProperty)) {
                neighbour_device_rs = local.getProperty(NdlCommons.topologyInterfaceOfProperty).getResource();
                if (!isStitching) {
                    isStitching = neighbour_device_rs.getURI().contains("Stitching/Domain") || local.getURI().contains("Stitching/Domain");
                }
                this.logger.debug((Object)("neighbour_device_rs=" + neighbour_device_rs.getURI()));
            }
            this.logger.debug((Object)("local=" + local.getURI() + ";isStitching=" + isStitching));
            if (isStitching) {
                while (true) {
                    neighbor_intf_rs = domainRequestModel.createIndividual(rs.getURI(), NdlCommons.interfaceOntClass);
                    StmtIterator j = rs.listProperties();
                    while (j.hasNext()) {
                        Statement s_type = (Statement)j.next();
                        domainRequestModel.add(neighbor_intf_rs, s_type.getPredicate(), s_type.getObject());
                    }
                    ResultSet results = NdlCommons.getLayerAdapatation(local.getOntModel(), rs.getURI());
                    String varName = (String)results.getResultVars().get(0);
                    if (!results.hasNext()) break;
                    rs = results.nextSolution().getResource(varName);
                    if (neighbor_intf_rs.getProperty(NdlCommons.RDFS_Label) == null) continue;
                    rs.addProperty(NdlCommons.RDFS_Label, neighbor_intf_rs.getProperty(NdlCommons.RDFS_Label).getString());
                }
            }
        }
        return device_rs;
    }

    public void copyDependency(DomainElement dd) {
        DomainElement parent_de = null;
        DomainElement child_de = null;
        OntResource intf_ont = null;
        OntResource child_intf_ont = null;
        if (dd.getClientInterface() != null) {
            for (Interface interface_ : dd.getClientInterface()) {
                if (this.getClientInterface() != null && this.getClientInterface().contains(interface_)) continue;
                this.addClientInterface(interface_);
            }
        }
        if (dd.getPrecededBySet() != null) {
            for (Map.Entry entry : dd.getPrecededBySet()) {
                parent_de = (DomainElement)entry.getKey();
                intf_ont = (OntResource)entry.getValue();
                if (this.getPrecededBy() != null && this.getPrecededBySetByElement(parent_de.getURI()) != null) continue;
                this.setPrecededBy(parent_de, intf_ont);
                if (parent_de.getFollowedBySet() != null) {
                    for (Map.Entry<DomainElement, OntResource> child : parent_de.getFollowedBySet()) {
                        child_de = child.getKey();
                        child_intf_ont = child.getValue();
                        if (child_de != dd) continue;
                        parent_de.setFollowedBy(this, child_intf_ont);
                        break;
                    }
                    parent_de.removeFollowedByElement(child_de);
                    continue;
                }
                this.logger.error((Object)("Missed follower:" + parent_de.getName()));
            }
        }
        if (dd.getFollowedBySet() != null) {
            for (Map.Entry entry : dd.getFollowedBySet()) {
                parent_de = (DomainElement)entry.getKey();
                intf_ont = (OntResource)entry.getValue();
                if (this.getFollowedBy() != null && this.getFollowedBy().get(parent_de) != null) continue;
                this.setFollowedBy(parent_de, intf_ont);
                if (parent_de.getPrecededBySet() != null) {
                    for (Map.Entry<DomainElement, OntResource> child : parent_de.getPrecededBySet()) {
                        child_de = child.getKey();
                        child_intf_ont = child.getValue();
                        if (child_de != dd) continue;
                        parent_de.setPrecededBy(dd, child_intf_ont);
                        break;
                    }
                    parent_de.removePrecededByElement(child_de);
                    continue;
                }
                this.logger.error((Object)("Missed follower:" + parent_de.getName()));
            }
        }
    }

    public ComputeElement getCe() {
        return this.ce;
    }

    public void setCe(ComputeElement ce) {
        this.ce = ce;
    }

    public void setFollowedBy(HashMap<DomainElement, OntResource> followedBy) {
        this.followedBy = followedBy;
    }

    public void setPrecededBy(HashMap<DomainElement, OntResource> precededBy) {
        this.precededBy = precededBy;
    }

    public HashMap<DomainElement, OntResource> getFollowedBy() {
        return this.followedBy;
    }

    public Set<Map.Entry<DomainElement, OntResource>> getFollowedBySet() {
        if (this.followedBy == null) {
            return null;
        }
        return this.followedBy.entrySet();
    }

    public OntResource getFollowedBySetByElement(String de) {
        if (this.followedBy == null) {
            return null;
        }
        for (Map.Entry<DomainElement, OntResource> entry : this.followedBy.entrySet()) {
            if (!Objects.equals(entry.getKey().getURI(), de) && !Objects.equals(entry.getKey().getName(), de)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void setFollowedBy(DomainElement follower, Resource remote_intf) {
        this.setFollowedBy(follower, this.model.getOntResource(remote_intf));
    }

    public void setFollowedBy(DomainElement follower, OntResource remote_intf) {
        if (this.followedBy == null) {
            this.followedBy = new HashMap();
        }
        this.followedBy.put(follower, remote_intf);
    }

    public void removeFollowedByElement(DomainElement de) {
        if (this.followedBy != null) {
            this.followedBy.remove(de);
        }
    }

    public HashMap<DomainElement, OntResource> getPrecededBy() {
        return this.precededBy;
    }

    public OntResource getPrecededBySetByElement(String de) {
        if (this.precededBy == null) {
            return null;
        }
        for (Map.Entry<DomainElement, OntResource> entry : this.precededBy.entrySet()) {
            if (!Objects.equals(entry.getKey().getURI(), de)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Set<Map.Entry<DomainElement, OntResource>> getPrecededBySet() {
        if (this.precededBy == null) {
            return null;
        }
        return this.precededBy.entrySet();
    }

    public void setPrecededBy(DomainElement precededBy, Resource remote_intf) {
        this.setPrecededBy(precededBy, this.model.getOntResource(remote_intf));
    }

    public void setPrecededBy(DomainElement precededBy, OntResource remote_intf) {
        if (this.precededBy == null) {
            this.precededBy = new HashMap();
        }
        this.precededBy.put(precededBy, remote_intf);
    }

    public void removePrecededByElement(DomainElement de) {
        if (this.precededBy != null) {
            this.precededBy.remove(de);
        }
    }

    public IPAddressRange getIp_range() {
        return this.ip_range;
    }

    public void setIp_range(IPAddressRange ip_range) {
        this.ip_range = ip_range;
    }

    public boolean isNeedFollowerInterface() {
        return this.needFollowerInterface;
    }

    public void setNeedFollowerInterface(boolean needFolloerInterface) {
        this.needFollowerInterface = needFolloerInterface;
    }

    public OntResource getFollowerInterface() {
        return this.followerInterface;
    }

    public void setFollowerInterface(Resource followerInterface) {
        this.followerInterface = this.model.getOntResource(followerInterface);
    }

    public String getDomainName() {
        String UriSeparator = "#";
        String UriSuffix = "/Domain";
        String domain_url = this.getInDomain();
        int index = domain_url.indexOf(UriSeparator);
        if (index >= 0) {
            int index2 = domain_url.indexOf(UriSuffix, index);
            if (index2 >= 0) {
                return domain_url.substring(index + 1, index2);
            }
            return domain_url.substring(index + 1, domain_url.length());
        }
        return null;
    }
}

