/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import net.exogeni.orca.ndl.DomainResourceType;
import net.exogeni.orca.ndl.LayerConstant;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.elements.Interface;
import net.exogeni.orca.ndl.elements.LabelSet;
import net.exogeni.orca.ndl.elements.NetworkElement;
import net.exogeni.orca.ndl.elements.SwitchMatrix;
import net.exogeni.orca.ndl.elements.SwitchingAction;
import net.exogeni.orca.util.persistence.Persistent;
import org.apache.log4j.Logger;

public class Device
extends NetworkElement {
    @Persistent
    protected LinkedList<SwitchMatrix> switchingMatrix;
    @Persistent
    protected LinkedList<SwitchingAction> actionList;
    @Persistent
    protected Integer actionCount = 0;
    @Persistent
    protected String direction;
    @Persistent
    protected Integer degree = 0;
    @Persistent
    protected Boolean isLabelProducer;
    @Persistent
    protected Boolean layerLabelPrimary;
    @Persistent
    protected String swappingCapability;
    @Persistent
    protected String tunnelingCapability;
    @Persistent
    protected Boolean depend;
    @Persistent
    protected HashMap<String, LinkedList<LabelSet>> labelSets;
    @Persistent
    protected Float staticLabel;
    @Persistent
    protected String availableLabelSet;
    @Persistent
    protected Boolean isAllocatable;
    @Persistent
    protected String NetUUID;
    @Persistent
    protected String upNeighbourUri;
    @Persistent
    protected String upLocalUri;
    @Persistent
    protected String downNeighbourUri;
    @Persistent
    protected String downLocalUri;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("Capabilities: " + this.isLabelProducer + "/" + this.swappingCapability + "/" + this.tunnelingCapability + "\n");
        sb.append("SwitchMatrix: \n");
        if (this.switchingMatrix != null) {
            for (SwitchMatrix sm : this.switchingMatrix) {
                sb.append(sm);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Device(OntModel m, String u, String n) {
        super(m, u, n);
        this.init();
    }

    public Device(OntModel m, OntResource rs) {
        super(m, rs);
        this.init();
        this.setParameters(m, rs);
    }

    public Device(OntModel m, Resource rs) {
        super(m, rs);
        this.init();
        this.setParameters(m, this.getResource());
    }

    public Device() {
        this.init();
    }

    private void init() {
        this.degree = 1;
        this.switchingMatrix = null;
        this.actionList = null;
        this.swappingCapability = null;
        this.isLabelProducer = false;
        this.depend = false;
        this.staticLabel = Float.valueOf(0.0f);
        this.isAllocatable = true;
        this.layerLabelPrimary = false;
    }

    public void setParameters(OntModel ontModel, OntResource rs_ont) {
        Resource networkService;
        Statement st = null;
        st = rs_ont.getProperty(NdlCommons.topologyManagementIP);
        if (st != null) {
            this.setManagementIP(st.getString());
        }
        if ((st = rs_ont.getProperty(NdlCommons.hostName_p)) != null) {
            this.setHostName(st.getString());
        }
        if ((st = rs_ont.getProperty(NdlCommons.isLabelProducer)) != null) {
            this.setLabelProducer(st.getBoolean());
        }
        if ((st = rs_ont.getProperty(NdlCommons.layerLabelIsPrimary)) != null) {
            this.setLayerLabelPrimary(st.getBoolean());
        }
        if ((st = rs_ont.getProperty(NdlCommons.domainHasServiceProperty)) != null && (st = (networkService = st.getResource()).getProperty(NdlCommons.hasCastType)) != null) {
            this.castType = st.getResource().getLocalName();
        }
        String atLayer = null;
        SwitchMatrix sm = null;
        String cap = null;
        StmtIterator stit = rs_ont.listProperties(NdlCommons.hasSwitchMatrix);
        while (stit != null && stit.hasNext()) {
            Resource rs0 = stit.nextStatement().getResource();
            sm = new SwitchMatrix(ontModel, rs_ont);
            st = rs0.getProperty(NdlCommons.switchingCapability);
            if (st != null) {
                cap = st.getResource().getLocalName();
                sm.setCapability(cap);
                sm.setAtLayer(cap);
            }
            if ((st = rs0.getProperty(NdlCommons.swappingCapability)) != null) {
                sm.setSwappingcapability(st.getResource().getLocalName());
                this.swappingCapability = st.getResource().getLocalName();
            }
            if ((st = rs0.getProperty(NdlCommons.tunnelingCapability)) != null) {
                sm.setTunnelingcapability(st.getResource().getLocalName());
                this.tunnelingCapability = st.getResource().getLocalName();
            }
            if ((st = rs0.getProperty(NdlCommons.connectionDirection)) != null) {
                sm.setDirection(st.getResource().getLocalName());
            }
            if ((st = rs0.getProperty(NdlCommons.hasCastType)) != null) {
                sm.setCastType(st.getResource().getLocalName());
                this.setCastType(st.getResource().getLocalName());
            }
            if ((st = rs0.getProperty(NdlCommons.domainIsAllocatable)) != null) {
                this.setAllocatable(st.getBoolean());
            }
            this.setSwitchMatrix(sm);
            this.setDirection(sm.getDirection());
            if (atLayer == null) {
                atLayer = cap;
            }
            if (atLayer == null || cap == null || LayerConstant.Layer.valueOf(atLayer).rank() <= LayerConstant.Layer.valueOf(cap).rank()) continue;
            atLayer = cap;
        }
        if (atLayer != null) {
            if (this.resourceType == null) {
                this.resourceType = new DomainResourceType(LayerConstant.Layer.valueOf(atLayer).getLabelP().toString(), 1);
            }
            this.setAtLayer(atLayer);
            this.setRank(LayerConstant.Layer.valueOf(atLayer).rank());
        }
    }

    @Override
    public int compareTo(Object o) {
        int compare = 0;
        if (o == null) {
            return 1;
        }
        Device d = (Device)o;
        DomainResourceType rType = d.getResourceType();
        if (this.resourceType == null || rType == null) {
            compare = 0;
        }
        if (this.resourceType.getCount() < rType.getCount()) {
            compare = 1;
        } else if (this.resourceType.getCount() > rType.getCount()) {
            compare = -1;
        }
        return compare;
    }

    public void processUNIInterface(String layer) {
        int actionCount = this.getActionCount();
        SwitchingAction action = null;
        LinkedList<SwitchingAction> uniList = null;
        for (int j = 0; j < actionCount; ++j) {
            action = this.actionList.get(j);
            if (!action.getAtLayer().equals(layer) || (uniList = this.findUNIInterface(action)) == null) continue;
            this.actionList.add(j, uniList.get(0));
            this.actionList.add(j + 1, uniList.get(1));
            ++j;
        }
    }

    public LinkedList<SwitchingAction> findUNIInterface(SwitchingAction action) {
        LinkedList<Interface> interfaceList = action.getClientInterface();
        Interface intf1 = null;
        Interface intf2 = null;
        String uriBase = action.getURI();
        uriBase.replaceAll("d$", "");
        SwitchingAction action1 = new SwitchingAction(action.getAtLayer(), action.getStartTime(), action.getEndTime());
        action1.setURI(uriBase + "1");
        SwitchingAction action2 = new SwitchingAction(action.getAtLayer(), action.getStartTime(), action.getEndTime());
        action2.setURI(uriBase + "2");
        boolean valid = true;
        int i = 0;
        for (i = 0; i < interfaceList.size(); ++i) {
            Interface intf = interfaceList.get(i);
            intf1 = intf.getInput();
            if (intf1 == null) {
                valid = false;
            }
            intf2 = intf.getOutput();
            if (i == 0) {
                action1.addClientInterface(intf1);
                action2.addClientInterface(intf2);
            } else {
                action2.addClientInterface(intf1);
                action1.addClientInterface(intf2);
            }
            action1.setDefaultAction(action.getDefaultAction());
            action2.setDefaultAction(action.getDefaultAction());
        }
        if (i > 0) {
            action.setDefaultAction(LayerConstant.Action.Temporary.toString());
        }
        LinkedList<SwitchingAction> subList = null;
        if (valid) {
            subList = new LinkedList<SwitchingAction>();
            subList.add(action1);
            subList.add(action2);
        }
        return subList;
    }

    @Override
    public void print(Logger logger) {
        super.print(logger);
        int size = 0;
        int i = 0;
        logger.info((Object)("\n" + this.isLabelProducer + ":" + this.swappingCapability + ":" + this.degree));
        SwitchMatrix matrix = null;
        if (this.switchingMatrix != null) {
            size = this.switchingMatrix.size();
            logger.debug((Object)("Switching Matrix:" + size));
            for (i = 0; i < size; ++i) {
                matrix = this.switchingMatrix.get(i);
                if (matrix == null) {
                    logger.error((Object)"No Switching Matrix");
                    continue;
                }
                matrix.print(logger);
            }
        }
        SwitchingAction action = null;
        if (this.actionList != null) {
            logger.info((Object)"Switching actions:");
            size = this.actionList.size();
            for (i = 0; i < size; ++i) {
                action = this.actionList.get(i);
                if (action == null) {
                    logger.info((Object)"No Action");
                    continue;
                }
                action.print(logger);
            }
        } else {
            logger.error((Object)"actionList is not initialized");
        }
    }

    public SwitchingAction getDefaultSwitchingAction() {
        return this.actionList.getFirst();
    }

    public void addSwitchingAction(SwitchingAction action) {
        if (this.actionList == null) {
            this.actionList = new LinkedList();
        }
        action.setURI(this.getURI() + "/action" + this.actionCount);
        this.actionList.add(action);
        Integer n = this.actionCount;
        Integer n2 = this.actionCount = Integer.valueOf(this.actionCount + 1);
    }

    public void removeSwitchingAction(int key) {
        this.actionList.remove(key);
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree() {
        Device device = this;
        Integer n = device.degree;
        Integer n2 = device.degree = Integer.valueOf(device.degree + 1);
    }

    public boolean isLabelProducer() {
        return this.isLabelProducer;
    }

    public void setLabelProducer(boolean isLabelProducer) {
        this.isLabelProducer = isLabelProducer;
    }

    public Boolean getLayerLabelPrimary() {
        return this.layerLabelPrimary;
    }

    public void setLayerLabelPrimary(Boolean layerLabelPrimary) {
        this.layerLabelPrimary = layerLabelPrimary;
    }

    public String getSwappingCapability() {
        return this.swappingCapability;
    }

    public void setSwappingCapability(String swappingCapability) {
        this.swappingCapability = swappingCapability;
    }

    public String getTunnelingCapability() {
        return this.tunnelingCapability;
    }

    public void setTunnelingCapability(String tunnelingCapability) {
        this.tunnelingCapability = tunnelingCapability;
    }

    public boolean isDepend() {
        return this.depend;
    }

    public void setDepend(boolean depend) {
        this.depend = depend;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public OntResource getDownNeighbour(OntModel m) {
        if (m != null) {
            return m.getOntResource(this.downNeighbourUri);
        }
        return null;
    }

    public void setDownNeighbour(OntResource downNeighbour) {
        this.downNeighbourUri = downNeighbour.getURI();
    }

    public OntResource getUpNeighbour(OntModel m) {
        if (m != null) {
            return m.getOntResource(this.upNeighbourUri);
        }
        return null;
    }

    public void setUpNeighbour(OntResource upNeighbour) {
        this.upNeighbourUri = upNeighbour.getURI();
    }

    public String getUpNeighbourUri() {
        return this.upNeighbourUri;
    }

    public void setUpNeighbourUri(String upNeighbourUri) {
        this.upNeighbourUri = upNeighbourUri;
    }

    public String getUpLocalUri() {
        return this.upLocalUri;
    }

    public void setUpLocalUri(String upLocalUri) {
        this.upLocalUri = upLocalUri;
    }

    public String getDownNeighbourUri() {
        return this.downNeighbourUri;
    }

    public void setDownNeighbourUri(String downNeighbourUri) {
        this.downNeighbourUri = downNeighbourUri;
    }

    public String getDownLocalUri() {
        return this.downLocalUri;
    }

    public void setDownLocalUri(String downLocalUri) {
        this.downLocalUri = downLocalUri;
    }

    public OntResource getUpLocal(OntModel m) {
        if (m != null) {
            return m.getOntResource(this.upLocalUri);
        }
        return null;
    }

    public void setUpLocal(OntResource upLocal) {
        this.upLocalUri = upLocal.getURI();
    }

    public OntResource getDownLocal(OntModel m) {
        if (m != null) {
            return m.getOntResource(this.downLocalUri);
        }
        return null;
    }

    public void setDownLocal(OntResource downLocal) {
        this.downLocalUri = downLocal.getURI();
    }

    public void setSwitchMatrix(SwitchMatrix matrix) {
        if (this.switchingMatrix == null) {
            this.switchingMatrix = new LinkedList();
        }
        this.switchingMatrix.add(matrix);
    }

    public SwitchMatrix getSwitchingMatrix(int i) {
        SwitchMatrix matrix = this.switchingMatrix.get(i);
        return matrix;
    }

    public LinkedList<SwitchMatrix> getSwitchingMatrix() {
        return this.switchingMatrix;
    }

    public LinkedList<SwitchingAction> getActionList() {
        return this.actionList;
    }

    public int getActionCount() {
        return this.actionCount;
    }

    public void setActionCount(int actionCount) {
        this.actionCount = actionCount;
    }

    public void setActionList(LinkedList<SwitchingAction> actionList) {
        this.actionList = actionList;
    }

    public void setSwitchingMatrix(LinkedList<SwitchMatrix> switchingMatrix) {
        this.switchingMatrix = switchingMatrix;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    @Override
    public void setResource(OntResource resource) {
        super.setResource(resource);
        if (resource != null) {
            this.name = resource.getURI();
        }
    }

    public HashMap<String, LinkedList<LabelSet>> getLabelSets() {
        return this.labelSets;
    }

    public void setLabelSets(HashMap<String, LinkedList<LabelSet>> labelSets) {
        this.labelSets = labelSets;
    }

    public LinkedList<LabelSet> getLabelSet(String rType) {
        return this.labelSets.get(rType);
    }

    public float getStaticLabel() {
        return this.staticLabel.floatValue();
    }

    public void setStaticLabel(float staticLabel) {
        this.staticLabel = Float.valueOf(staticLabel);
    }

    public String getAvailableLabelSet() {
        return this.availableLabelSet;
    }

    public void setAvailableLabelSet(BitSet bitSet) {
        if (bitSet != null) {
            this.availableLabelSet = bitSet.toString().replace("{", "").replace("}", "");
        }
    }

    public boolean isAllocatable() {
        return this.isAllocatable;
    }

    public void setAllocatable(boolean isAllocatable) {
        this.isAllocatable = isAllocatable;
    }

    public String getNetUUID() {
        return this.NetUUID;
    }

    public void setNetUUID(String netUUID) {
        this.NetUUID = netUUID;
    }
}

