/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.elements.IPAddress;
import net.exogeni.orca.ndl.elements.Interface;
import net.exogeni.orca.ndl.elements.NetworkConnection;
import net.exogeni.orca.ndl.elements.NetworkElement;
import net.exogeni.orca.util.persistence.NotPersistent;
import net.exogeni.orca.util.persistence.Persistent;

public class ComputeElement
extends NetworkElement {
    @Persistent
    protected String image = null;
    @Persistent
    protected String VMImageURL;
    @Persistent
    protected String VMImageHash;
    @Persistent
    protected String postBootScript;
    @Persistent
    protected String group;
    @Persistent
    protected String nodeGroupName;
    @Persistent
    protected String CHAP_User = null;
    @Persistent
    protected String CHAP_Password = null;
    @Persistent
    protected String FSParam;
    @Persistent
    protected String FSType;
    @Persistent
    protected String MntPoint;
    @Persistent
    protected boolean doFormat;
    @Persistent
    protected String specificCEType;
    @Persistent
    protected String specificCETypeurl;
    @Persistent
    protected boolean isSplittable;
    @NotPersistent
    protected List<NetworkElement> ceGroup;
    @NotPersistent
    protected Set<NetworkElement> dependencies = new HashSet<NetworkElement>();
    @NotPersistent
    protected HashMap<NetworkConnection, Interface> interfaces;

    public ComputeElement(OntModel m, OntResource rs) {
        super(m, rs);
    }

    public ComputeElement(OntModel m, Resource rs) {
        super(m, rs);
    }

    public ComputeElement(OntModel m, String url, String name) {
        super(m, url, name);
    }

    public ComputeElement partialCopy(OntModel m, OntModel req_m, String url, String name) {
        OntResource ng_rs;
        ComputeElement ce = new ComputeElement(m, url, name);
        ce.setImageInfo(this.getImage(), this.getVMImageURL(), this.getVMImageHash());
        ce.setResourceType(this.getResourceType());
        ce.setDependencies(this.getDependencies());
        ce.setGroup(this.group);
        String group_url = this.getNodeGroupName();
        String script = null;
        if (group_url != null && (ng_rs = req_m.getOntResource(group_url)) != null && ng_rs.hasProperty(NdlCommons.requestPostBootScriptProperty)) {
            script = ng_rs.getProperty(NdlCommons.requestPostBootScriptProperty).getString();
        }
        if (script != null) {
            ce.setPostBootScript(script);
        }
        ce.setSpecificCEType(this.getSpecificCEType());
        ce.setSpecificCETypeurl(this.getSpecificCETypeurl());
        ce.setNodeGroupName(this.getNodeGroupName());
        ce.setFSType(this.getFSType());
        ce.setFSParam(this.getFSParam());
        ce.setMntPoint(this.getMntPoint());
        ce.setDoFormat(this.isDoFormat());
        ce.setCHAP_User(this.getCHAP_User());
        ce.setCHAP_Password(this.getCHAP_Password());
        ce.setResourcesMap(this.getResourcesMap());
        return ce;
    }

    public IPAddress getDefaultClientInterfaceIP() {
        IPAddress ip = null;
        if (this.getClientInterface() == null) {
            return null;
        }
        for (Interface intf : this.getClientInterface()) {
            if (intf.getLabel() == null) continue;
            ip = (IPAddress)intf.getLabel();
            break;
        }
        return ip;
    }

    public String getDefaultClientInterfaceIPAddress() {
        String ipaddr = null;
        IPAddress ip = this.getDefaultClientInterfaceIP();
        if (ip != null) {
            ipaddr = ip.address;
        }
        return ipaddr;
    }

    public OntResource getDefaultClientInterfaceIPAddressRS() {
        OntResource ip_ont = null;
        IPAddress ip = this.getDefaultClientInterfaceIP();
        if (ip != null && !this.model.isClosed()) {
            ip_ont = ip.getResource(this.model);
        }
        return ip_ont;
    }

    public HashMap<NetworkConnection, Interface> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(HashMap<NetworkConnection, Interface> interfaces) {
        this.interfaces = interfaces;
    }

    public void setInterfaceName(NetworkConnection l, Interface ifName) {
        if (l == null || ifName == null) {
            return;
        }
        if (this.interfaces == null) {
            this.interfaces = new HashMap();
        }
        this.interfaces.put(l, ifName);
    }

    public NetworkConnection getConnectionByInterfaceName(Interface intf) {
        if (intf != null && this.interfaces != null) {
            for (Map.Entry<NetworkConnection, Interface> entry : this.interfaces.entrySet()) {
                if (entry.getValue() != intf) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void removeConnectionByInterfaceName(Interface intf) {
        NetworkConnection nc = null;
        if (intf != null && this.interfaces != null) {
            for (Map.Entry<NetworkConnection, Interface> entry : this.interfaces.entrySet()) {
                if (entry.getValue() != intf) continue;
                nc = entry.getKey();
                break;
            }
        }
        if (nc != null) {
            this.interfaces.remove(nc);
        }
    }

    public NetworkConnection getConnectionByInterfaceURI(String intf) {
        if (intf != null && this.interfaces != null) {
            for (Map.Entry<NetworkConnection, Interface> entry : this.interfaces.entrySet()) {
                if (!entry.getValue().getURI().equals(intf)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public Interface getInterfaceName(NetworkConnection l) {
        if (l != null && this.interfaces != null) {
            return this.interfaces.get(l);
        }
        return null;
    }

    public Interface getInterfaceByName(String ln) {
        if (ln == null) {
            return null;
        }
        for (Map.Entry<NetworkConnection, Interface> entry : this.interfaces.entrySet()) {
            if (!ln.equals(entry.getKey().getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean existConnectionInterface() {
        if (this.interfaces == null) {
            return false;
        }
        return !this.interfaces.isEmpty();
    }

    public void addDependency(NetworkElement n) {
        if (n != null) {
            this.dependencies.add(n);
        }
    }

    public void addDependency(HashSet<NetworkElement> set) {
        if (set != null) {
            this.dependencies.addAll(set);
        }
    }

    public void removeDependency(NetworkElement n) {
        if (n != null) {
            this.dependencies.remove(n);
        }
    }

    public void clearDependencies() {
        this.dependencies = new HashSet<NetworkElement>();
    }

    public Set<NetworkElement> getDependencies() {
        return this.dependencies;
    }

    public boolean isDependency(NetworkElement n) {
        if (n == null) {
            return false;
        }
        return this.dependencies.contains(n);
    }

    public String getSpecificCEType() {
        return this.specificCEType;
    }

    public void setSpecificCETypeurl(String specificCETypeurl) {
        this.specificCETypeurl = specificCETypeurl;
    }

    public String getSpecificCETypeurl() {
        return this.specificCETypeurl;
    }

    public void setSpecificCEType(String specificCEType) {
        this.specificCEType = specificCEType;
    }

    public void setSpecificCEType(Resource rs) {
        String specificCEType;
        Resource ceType_rs = NdlCommons.getSpecificCE(rs);
        if (ceType_rs != null) {
            this.specificCETypeurl = ceType_rs.getURI();
        }
        this.specificCEType = specificCEType = NdlCommons.getEC2VMSize(rs);
    }

    public boolean isSplittable() {
        return this.isSplittable;
    }

    public void setSplittable(boolean isSplittable) {
        this.isSplittable = isSplittable;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getVMImageURL() {
        return this.VMImageURL;
    }

    public void setVMImageURL(String vMImageURL) {
        this.VMImageURL = vMImageURL;
    }

    public String getVMImageHash() {
        return this.VMImageHash;
    }

    public void setVMImageHash(String aHash) {
        this.VMImageHash = aHash;
    }

    public void setImageInfo(String image, String vMImageURL, String aHash) {
        this.image = image;
        this.VMImageURL = vMImageURL;
        this.VMImageHash = aHash;
    }

    public String getPostBootScript() {
        return this.postBootScript;
    }

    public void setPostBootScript(String postBootScript) {
        this.postBootScript = postBootScript;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public void setNodeGroupName(String nodeGroupName) {
        this.nodeGroupName = nodeGroupName;
    }

    public void setDependencies(Set<NetworkElement> dependencies) {
        this.dependencies = dependencies;
    }

    public String getFSParam() {
        return this.FSParam;
    }

    public void setFSParam(String fSParam) {
        this.FSParam = fSParam;
    }

    public String getFSType() {
        return this.FSType;
    }

    public void setFSType(String fSType) {
        this.FSType = fSType;
    }

    public String getMntPoint() {
        return this.MntPoint;
    }

    public void setMntPoint(String mntPoint) {
        this.MntPoint = mntPoint;
    }

    public boolean isDoFormat() {
        return this.doFormat;
    }

    public void setDoFormat(boolean doFormat) {
        this.doFormat = doFormat;
    }

    public String getCHAP_User() {
        return this.CHAP_User;
    }

    public void setCHAP_User(String cHAP_User) {
        this.CHAP_User = cHAP_User;
    }

    public String getCHAP_Password() {
        return this.CHAP_Password;
    }

    public void setCHAP_Password(String cHAP_Password) {
        this.CHAP_Password = cHAP_Password;
    }

    public List<NetworkElement> getCeGroup() {
        return this.ceGroup;
    }

    public void setCeGroup(List<NetworkElement> cg) {
        this.ceGroup = cg;
    }

    public void setCeGroup(NetworkElement ce) {
        if (this.ceGroup == null) {
            this.ceGroup = new LinkedList<NetworkElement>();
        }
        this.ceGroup.add(ce);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("CE Type: " + this.specificCEType + "/" + this.isSplittable + "\n");
        sb.append("Image: " + this.image + "/" + this.VMImageURL + "/" + this.VMImageHash + "\n");
        sb.append("Group: " + this.group + "\n");
        sb.append("nodeGroupName: " + this.nodeGroupName + "\n");
        sb.append("iSCSI: " + this.CHAP_User + "/" + this.CHAP_Password + "/" + this.FSParam + "/" + this.MntPoint + "/" + this.doFormat + "\n");
        return sb.toString();
    }
}

