/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import net.exogeni.orca.ndl.DomainResourceType;
import net.exogeni.orca.ndl.LayerConstant;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.elements.Device;
import net.exogeni.orca.ndl.elements.DomainElement;
import net.exogeni.orca.ndl.elements.NetworkConnection;
import net.exogeni.orca.ndl.elements.NetworkElement;
import org.apache.log4j.Logger;

public class OntProcessor
extends NdlCommons
implements LayerConstant {
    public String inputFileName;
    public String outputFileName;
    protected OntModel ontModel;
    protected Logger logger = NdlCommons.getNdlLogger();

    public OntProcessor(OntModel model) {
        this.ontModel = model;
    }

    public OntProcessor(String fileName) throws IOException {
        this.setInputFileName(fileName);
        this.ontModel = OntProcessor.ontCreate(fileName);
    }

    public OntProcessor(InputStream stream) throws IOException {
        this.ontModel = OntProcessor.ontCreate(stream);
    }

    public OntProcessor() {
    }

    public static OntModel ontCreate(InputStream stream) throws IOException {
        OntModel model_base = ModelFactory.createOntologyModel();
        model_base.read(stream, "");
        stream.close();
        return model_base;
    }

    public static OntModel ontCreate(String aFile) throws IOException {
        OntModel model_base = ModelFactory.createOntologyModel();
        InputStream in = FileManager.get().openNoMap(aFile);
        if (in == null) {
            throw new IllegalArgumentException("File: " + aFile + " not found");
        }
        OntDocumentManager dm = model_base.getDocumentManager();
        dm.setProcessImports(true);
        model_base.read(in, "");
        model_base.setDynamicImports(true);
        in.close();
        return model_base;
    }

    public void ontWrite(String aFile, OntModel ontModel) throws IOException {
        FileOutputStream out = new FileOutputStream(aFile);
        if (out == null) {
            throw new IllegalArgumentException("File: " + aFile + " not found");
        }
        ontModel.write((OutputStream)out, "RDF/XML");
        out.flush();
        out.close();
    }

    public String deviceType(Resource rs_device) {
        OntResource rs_ont = this.ontModel.getOntResource(rs_device);
        String type = rs_ont.getLabel(null);
        return type;
    }

    public int numResource(OntModel model, String queryPhrase) {
        ResultSet results = OntProcessor.rdfQuery((Model)model, queryPhrase);
        int size = 0;
        Binding binding = results.nextBinding();
        while (results.hasNext()) {
            ++size;
            binding = results.nextBinding();
        }
        return size;
    }

    public boolean existResourceNode(Node nd, OntModel model, String queryPhrase) {
        Resource rs = model.createResource(nd.getURI());
        return this.existResource(rs, model, queryPhrase);
    }

    public boolean existResourceStr(String url, OntModel model, String queryPhrase) {
        Resource rs = model.createResource(url);
        return this.existResource(rs, model, queryPhrase);
    }

    public boolean existResource(Resource rs, OntModel model, String queryPhrase) {
        ResultSet results = OntProcessor.rdfQuery((Model)model, queryPhrase);
        return this.existResource(rs, results);
    }

    public boolean existResource(Resource rs, ResultSet results) {
        boolean exist = false;
        Resource resource = null;
        String varName = (String)results.getResultVars().get(0);
        while (results.hasNext()) {
            QuerySolution solution = results.nextSolution();
            resource = solution.getResource(varName);
            if (!resource.equals((Object)rs)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public boolean removeFromImport(Resource availableSet_rs, Property p, Resource labelRange_rs) {
        boolean removed = false;
        if (labelRange_rs == null) {
            return false;
        }
        this.logger.info((Object)("Num of Sub models:" + this.ontModel.countSubModels() + "\n"));
        ExtendedIterator subList = this.ontModel.listSubModels(true);
        OntModel subModel = null;
        OntResource set_ont = null;
        while (subList.hasNext()) {
            subModel = (OntModel)subList.next();
            if (!subModel.isInBaseModel((RDFNode)availableSet_rs)) continue;
            set_ont = subModel.getOntResource(availableSet_rs);
            labelRange_rs = subModel.getOntResource(labelRange_rs);
            set_ont.removeProperty(p, (RDFNode)labelRange_rs);
            removed = true;
            break;
        }
        set_ont = this.ontModel.getOntResource(availableSet_rs);
        labelRange_rs = this.ontModel.getOntResource(labelRange_rs);
        set_ont.removeProperty(p, (RDFNode)labelRange_rs);
        return removed;
    }

    public Resource ontLabelUpdate(Resource availableSet_rs, Resource labelRange_rs, int low, int upper, Resource lowerLabel, Resource upperLabel, int stackLabel) {
        Resource pick = null;
        if (labelRange_rs == null || availableSet_rs == null) {
            return null;
        }
        this.logger.info((Object)("labelRange_rs:" + labelRange_rs.getURI() + ":" + this.ontModel.isInBaseModel((RDFNode)availableSet_rs)));
        if (availableSet_rs != null) {
            if (low == upper || upperLabel == null) {
                if (labelRange_rs != null) {
                    this.removeFromImport(availableSet_rs, NdlCommons.collectionElementProperty, labelRange_rs);
                }
                pick = lowerLabel;
                this.logger.debug((Object)("Label removed:" + availableSet_rs + ":" + NdlCommons.collectionElementProperty + ":" + labelRange_rs + "\n" + availableSet_rs.hasProperty(NdlCommons.collectionElementProperty, (RDFNode)labelRange_rs)));
            } else if (stackLabel == 0 || low == stackLabel) {
                this.changeAvailableLabelSetLowerBound(labelRange_rs, low);
                pick = lowerLabel;
            } else {
                pick = this.changeAvailabelLabelSet(availableSet_rs, labelRange_rs, lowerLabel, upperLabel, stackLabel);
            }
        }
        return pick;
    }

    public Resource changeAvailabelLabelSet(Resource availableSet_rs, Resource labelRange_rs, Resource lowerLabel, Resource upperLabel, int stackLabel) {
        this.removeFromImport(availableSet_rs, NdlCommons.collectionElementProperty, labelRange_rs);
        String rangeLabel = null;
        String labelStr = null;
        String labelRange_uri = labelRange_rs.getURI();
        if (labelRange_rs.getProperty(NdlCommons.RDFS_Label) != null) {
            rangeLabel = labelRange_rs.getProperty(NdlCommons.RDFS_Label).getString();
        }
        String new_upper = String.valueOf(stackLabel - 1);
        String new_upper_uri = lowerLabel.getURI().replaceAll("\\d+$", new_upper);
        labelStr = rangeLabel != null ? rangeLabel.concat(new_upper) : new_upper;
        OntResource rs_new_upper = this.ontModel.createOntResource(new_upper_uri);
        rs_new_upper.addRDFType(NdlCommons.labelOntClass);
        rs_new_upper.addProperty(NdlCommons.layerLabelIdProperty, new_upper, (RDFDatatype)XSDDatatype.XSDfloat);
        rs_new_upper.addProperty(NdlCommons.RDFS_Label, labelStr);
        String rs_new_range_uri = labelRange_uri.replaceAll("\\d+$", new_upper);
        OntResource rs_new_range = this.newLabelRange(rs_new_range_uri, labelStr, lowerLabel, (Resource)rs_new_upper);
        availableSet_rs.addProperty(NdlCommons.collectionElementProperty, (RDFNode)rs_new_range);
        String new_lower = String.valueOf(stackLabel + 1);
        String new_lower_uri = lowerLabel.getURI().replaceAll("\\d+$", new_lower);
        labelStr = rangeLabel != null ? rangeLabel.concat(new_lower) : new_lower;
        OntResource rs_new_lower = this.ontModel.createOntResource(new_lower_uri);
        rs_new_lower.addRDFType(NdlCommons.labelOntClass);
        rs_new_lower.addProperty(NdlCommons.layerLabelIdProperty, new_lower, (RDFDatatype)XSDDatatype.XSDfloat);
        rs_new_lower.addProperty(NdlCommons.RDFS_Label, labelStr);
        rs_new_range_uri = labelRange_uri.replaceAll("\\d+$", new_lower);
        rs_new_range = this.newLabelRange(rs_new_range_uri, labelStr, (Resource)rs_new_lower, upperLabel);
        availableSet_rs.addProperty(NdlCommons.collectionElementProperty, (RDFNode)rs_new_range);
        String pick_str = String.valueOf(stackLabel);
        String pick_uri = lowerLabel.getURI().replaceAll("\\d+$", pick_str);
        labelStr = rangeLabel != null ? rangeLabel.concat(pick_str) : pick_str;
        OntResource rs_pick = this.ontModel.createOntResource(pick_uri);
        rs_pick.addRDFType(NdlCommons.labelOntClass);
        rs_pick.addProperty(NdlCommons.layerLabelIdProperty, pick_str, (RDFDatatype)XSDDatatype.XSDfloat);
        rs_pick.addProperty(NdlCommons.RDFS_Label, labelStr);
        return rs_pick;
    }

    public OntResource newLabelRange(String rs_new_range_uri, String rangeLabel, Resource lowerLabel, Resource upperLabel) {
        Individual rs_new_range = this.ontModel.createIndividual(rs_new_range_uri, NdlCommons.labelRangeOntClass);
        rs_new_range.addRDFType(NdlCommons.labelRangeOntClass);
        rs_new_range.addProperty(NdlCommons.RDFS_Label, rangeLabel);
        rs_new_range.addProperty(NdlCommons.lowerBound, (RDFNode)lowerLabel);
        rs_new_range.addProperty(NdlCommons.upperBound, (RDFNode)upperLabel);
        return rs_new_range;
    }

    public void changeAvailableLabelSetLowerBound(Resource labelRange_rs, float low) {
        if (labelRange_rs == null) {
            return;
        }
        OntResource labelRange_rs_on = this.ontModel.getOntResource(labelRange_rs);
        String lower = new String();
        lower = String.valueOf((int)low + 1);
        Resource usedLabel_rs = labelRange_rs.getProperty(NdlCommons.lowerBound).getResource();
        String lowerURI = usedLabel_rs.getURI().replaceAll("\\d+$", lower);
        Resource lb = null;
        if (labelRange_rs.getProperty(NdlCommons.lowerBound) != null) {
            lb = labelRange_rs.getProperty(NdlCommons.lowerBound).getResource();
            labelRange_rs_on.removeProperty(NdlCommons.lowerBound, (RDFNode)lb);
            this.removeFromImport(labelRange_rs, NdlCommons.lowerBound, lb);
        }
        this.logger.info((Object)("Lower bound removed:" + labelRange_rs + ":" + NdlCommons.lowerBound + ":" + labelRange_rs.hasProperty(NdlCommons.lowerBound, (RDFNode)lb)));
        String rangeLabel = null;
        String labelStr = null;
        String usedLabelStr = null;
        if (labelRange_rs.getProperty(NdlCommons.RDFS_Label) != null) {
            rangeLabel = labelRange_rs.getProperty(NdlCommons.RDFS_Label).getLiteral().toString();
            labelStr = rangeLabel.concat(String.valueOf(lower));
            usedLabelStr = rangeLabel.concat(String.valueOf((int)low));
        } else {
            labelStr = String.valueOf(lower);
        }
        Individual rs_lower = this.ontModel.createIndividual(lowerURI, NdlCommons.labelOntClass);
        rs_lower.addRDFType(NdlCommons.labelOntClass);
        rs_lower.addProperty(NdlCommons.layerLabelIdProperty, lower, (RDFDatatype)XSDDatatype.XSDfloat);
        rs_lower.addProperty(NdlCommons.RDFS_Label, labelStr);
        if (usedLabelStr != null) {
            usedLabel_rs.addProperty(NdlCommons.RDFS_Label, usedLabelStr);
        }
        labelRange_rs.addProperty(NdlCommons.lowerBound, (RDFNode)rs_lower);
        this.logger.info((Object)("------New LabelSet----" + labelRange_rs + ":" + labelRange_rs.getProperty(NdlCommons.lowerBound).getResource() + ":" + labelStr + ":" + labelRange_rs.getProperty(NdlCommons.upperBound).getResource()));
    }

    public Resource getLabelResource(Resource rs, float label) {
        if (rs == null) {
            return null;
        }
        String labelstr = String.valueOf((int)label);
        String uri = rs.getURI();
        String URI2 = uri.replaceAll("\\d+$", labelstr);
        Individual label_rs = this.ontModel.createIndividual(URI2, NdlCommons.labelOntClass);
        label_rs.addProperty(NdlCommons.layerLabelIdProperty, String.valueOf((int)label), (RDFDatatype)XSDDatatype.XSDfloat);
        return label_rs;
    }

    public ResultSet getAvailableLabelSet(String rsURI, String availableLableSet_str) {
        return OntProcessor.getAvailableLabelSet(this.ontModel, rsURI, availableLableSet_str);
    }

    public void setUsedLabelSet(String rsURI, String usedLabelSet_str, String usedSet_str, Resource usedSet_rs, Resource label) {
        Property usedLabelSet = this.ontModel.createProperty(usedLabelSet_str);
        Resource rs = this.ontModel.getResource(rsURI);
        if (usedSet_rs == null) {
            usedSet_rs = this.ontModel.createResource(usedSet_str, NdlCommons.labelSetOntClass);
            rs.addProperty(usedLabelSet, (RDFNode)usedSet_rs);
        }
        if (label != null) {
            usedSet_rs.addProperty(NdlCommons.collectionElementProperty, (RDFNode)label);
        }
        this.logger.info((Object)("---Used label added:" + rsURI + ":" + usedLabelSet + ":" + usedSet_rs.hasProperty(NdlCommons.collectionElementProperty, (RDFNode)label) + ":" + label));
    }

    public ResultSet getUsedLabelSet(String rsURI, String usedLabelSet) {
        String s = "SELECT ?b ?r ";
        String f = "";
        String w = "WHERE {<" + rsURI + "> " + usedLabelSet + " ?r.?r collections:element ?b. }";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public ResultSet getCRSDevice(String rs) {
        String s = "SELECT ?r ?intf ";
        String f = "";
        String w = "WHERE {<" + rs + "> ndl:hasInterface ?intf.?intf ndl:interfaceOf ?r. ?r rdf:type ndl:Device.      }";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public ResultSet getSwitchedToInterface(String rsURI) {
        String selectStr = "SELECT ?intf ?intf_peer ?c ";
        String fromStr = "";
        String whereStr = "WHERE {<" + rsURI + "> ndl:hasInterface ?intf. {?intf ndl:connectedTo ?intf_peer} UNION {?intf ndl:linkTo ?intf_peer}.?intf_peer ndl:inConnection true.?intf_peer ?l ?r.?r rdf:type layer:Layer.?intf_peer ndl:interfaceOf ?b.?b ndl:hasSwitchMatrix ?sw. ?sw layer:switchingCapability ?c      }";
        String queryPhrase = OntProcessor.createQueryString(selectStr, fromStr, whereStr);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public ResultSet getSwitchedToAdaptation(String rsURI) {
        String selectStr = "SELECT ?intf ?intf_peer ?c ";
        String fromStr = "";
        String whereStr = "WHERE {?p a layer:AdaptationProperty. <" + rsURI + "> ndl:hasInterface ?intf. {?intf ndl:connectedTo ?intf_peer} UNION {?intf ndl:linkTo ?intf_peer}.?intf ?p ?a.?intf_peer ?l ?r.?r rdf:type layer:Layer.?intf_peer ndl:interfaceOf ?b.?b ndl:hasSwitchMatrix ?sw. ?sw layer:switchingCapability ?c      }";
        String queryPhrase = OntProcessor.createQueryString(selectStr, fromStr, whereStr);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public ResultSet getConnectionSubGraphSwitchedTo(String url, String url2) {
        String s = "SELECT ?a ?b ?c ";
        String f = "";
        String w = "WHERE {(<" + url + "> '([ndl:connectedTo]/[ndl:switchedTo]?/[ndl:connectedTo]*)+ ' <" + url2 + ">) gleen:Subgraph (?a ?b ?c).      }  ";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public ResultSet getConnectionSubGraphSwitchedToAdaptation(String url, String url2) {
        String s = "SELECT ?a ?b ?c ";
        String f = "";
        String w = "WHERE {(<" + url + "> '([ndl:connectedTo]/[layer:adaptationProperty]+/[ndl:switchedTo]?/[layer:adaptationPropertyOf]*)+ ' <" + url2 + ">) gleen:Subgraph (?a ?b ?c)      } ";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public ResultSet getSubGraphLinkToOri(String url1, String url2) {
        String s = "SELECT ?a ?b ?c ";
        String f = "";
        String w = "WHERE {(<" + url1 + "> '[ndl:hasInterface]+/([ndl:hasInputInterface]|[ndl:hasOutputInterface])*/([ndl:linkTo]|[ndl:connectedTo])+/[ndl:interfaceOf]+' <" + url2 + ">) gleen:Subgraph (?a ?b ?c). ?a rdf:type ndl:Interface.?c rdf:type ndl:Interface.      }";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public ResultSet getSubGraphLinkTo(String url1, String url2) {
        String s = "SELECT DISTINCT ?a ?c ";
        String f = "";
        String w = "WHERE {(<" + url1 + "> '[ndl:hasInterface]+/([ndl:connectedTo]|[ndl:switchedTo]|[ndl:linkTo])*/[ndl:interfaceOf]+' <" + url2 + ">) gleen:Subgraph (?a ?b ?c). ?a rdf:type ndl:Interface.?c rdf:type ndl:Interface.       }";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public ResultSet getSubGraphConnectedTo(String url1, String url2) {
        String s = "SELECT ?a ?b ?c ";
        String f = "";
        String w = "WHERE {(<" + url1 + "> '[ndl:hasInterface]+/[ndl:connectedTo]+/[ndl:interfaceOf]+' <" + url2 + ">) gleen:Subgraph (?a ?b ?c)      }";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public String createQueryStringInterfaceOfDevice(String rs) {
        String s = "SELECT ?r ";
        String f = "";
        String w = "WHERE {{?r ndl:hasInterface <" + rs + ">. ?r rdf:type ndl:Device.}UNION{ ?r ndl:hasInterface <" + rs + ">. ?r rdf:type compute:ServerCloud.}}";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        return queryPhrase;
    }

    public ResultSet getNetworkConnection(String rs1, String rs2) {
        String s = "SELECT ?r ";
        String f = "";
        String w = "WHERE {?r ndl:hasInterface <" + rs1 + ">.?r ndl:hasInterface <" + rs2 + ">. ?r rdf:type ndl:NetworkConnection      }";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public ResultSet interfaceOfNetworkConnection(String rs) {
        String onPath = "gleen:OnPath";
        String subPath = " ('[layer:adaptationPropertyOf]*'";
        String selectStr = "SELECT ?nc ";
        String fromStr = "";
        String whereStr = "WHERE {<" + rs + "> " + onPath + subPath + " ?object).?nc ndl:hasInterface ?object.?nc rdf:type ndl:NetworkConnection   }";
        String queryPhrase = OntProcessor.createQueryString(selectStr, fromStr, whereStr);
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        return results;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public void setOntModel(OntModel ontModel) {
        this.ontModel = ontModel;
    }

    public OntResource addResource(String URI2) {
        return this.ontModel.createOntResource(URI2);
    }

    public void addProperty(OntResource aResource, Property aProperty, RDFNode aObject) {
        aResource.addProperty(aProperty, aObject);
    }

    public void setInputFileName(String aName) {
        this.inputFileName = aName;
    }

    public OntModel getOntModel() {
        return this.ontModel;
    }

    LinkedList<Resource> listConnectedDeviceSort(OntModel m, Resource rs1, Resource rs2) {
        LinkedList<Resource> resourceList = new LinkedList<Resource>();
        String url1 = rs1.getURI();
        String url2 = rs2.getURI();
        ResultSet results = this.listConnectedDevice(url1, m);
        Resource rs = null;
        String var0 = (String)results.getResultVars().get(0);
        while (results.hasNext()) {
            rs = results.nextSolution().getResource(var0);
            if (!m.getOntResource(rs).hasRDFType(NdlCommons.deviceOntClass) && !Objects.equals(rs.getURI(), rs2.getURI()) || rs.getNameSpace().equals(rs1.getNameSpace())) continue;
            if (rs.getNameSpace().equals(rs2.getNameSpace())) {
                resourceList.add(0, rs);
                continue;
            }
            if (this.isSameLayerDevice(rs, rs1)) {
                resourceList.add(0, rs);
                continue;
            }
            resourceList.add(rs);
        }
        return resourceList;
    }

    public ResultSet listConnectedDevice(String deviceURL, OntModel model, String subPath) {
        String queryPhrase = OntProcessor.createQueryStringOnPath(deviceURL, subPath);
        ResultSet results = OntProcessor.rdfQuery((Model)model, queryPhrase);
        return results;
    }

    public ResultSet listConnectedDevice(String deviceURL, OntModel model) {
        String subPath = " ('[ndl:hasInterface]*/([ndl:connectedTo]|[ndl:switchedTo]|[ndl:linkTo])+/[ndl:interfaceOf]*'";
        return this.listConnectedDevice(deviceURL, model, subPath);
    }

    public boolean isSameLayerDevice(Resource rs1, Resource rs2) {
        boolean same = false;
        StmtIterator stit1 = rs1.listProperties(NdlCommons.hasSwitchMatrix);
        StmtIterator stit2 = rs2.listProperties(NdlCommons.hasSwitchMatrix);
        Statement st1 = null;
        Statement st2 = null;
        String cap1 = null;
        String cap2 = null;
        if (stit1 != null) {
            while (stit1.hasNext()) {
                st1 = stit1.nextStatement();
                Resource r1 = st1.getResource();
                if ((st1 = r1.getProperty(NdlCommons.switchingCapability)) != null) {
                    cap1 = st1.getResource().getLocalName();
                }
                if (cap1 == null) continue;
                while (stit2.hasNext()) {
                    st2 = stit2.nextStatement();
                    Resource r2 = st2.getResource();
                    if ((st2 = r2.getProperty(NdlCommons.switchingCapability)) != null) {
                        cap2 = st2.getResource().getLocalName();
                    }
                    if (!cap1.equals(cap2)) continue;
                    same = true;
                    break;
                }
                if (!same) continue;
                break;
            }
        }
        return same;
    }

    public ArrayList<ArrayList<OntResource>> findShortestPath(OntModel m, Resource start, Resource end, long bw, String rType1_str, String rType2_str, String nc_of_version) {
        LinkedList neighborQueue = new LinkedList();
        ArrayList<ArrayList<OntResource>> solution = null;
        HashSet<String> seen = new HashSet<String>();
        seen.add(start.getURI());
        LinkedList<Resource> resourceList = this.listConnectedDeviceSort(m, start, end);
        ListIterator rlIterator = resourceList.listIterator();
        Resource rs = null;
        OntResource rs_ont = null;
        while (rlIterator.hasNext()) {
            rs = (Resource)rlIterator.next();
            rs_ont = m.getOntResource(rs);
            ArrayList<Resource> path = new ArrayList<Resource>();
            path.add(rs);
            neighborQueue.add(path);
        }
        if (neighborQueue.isEmpty()) {
            this.logger.warn((Object)("Neighbor queue is empty for resource: " + start));
        }
        while (solution == null && !neighborQueue.isEmpty()) {
            ArrayList candidate = (ArrayList)neighborQueue.remove();
            boolean valid = true;
            if (candidate.contains(end)) {
                solution = this.validPath(start, candidate, bw, rType1_str, rType2_str, nc_of_version);
                if (solution != null) {
                    this.logger.info((Object)"Found the path.\n");
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug((Object)("Shortest path solution: " + Arrays.toString(solution.toArray())));
                    break;
                }
                this.logger.info((Object)"The path is not valid.\n");
                continue;
            }
            rs = (Resource)candidate.get(candidate.size() - 1);
            seen.add(rs.getURI());
            resourceList = this.listConnectedDeviceSort(m, rs, end);
            rlIterator = resourceList.listIterator();
            while (rlIterator.hasNext()) {
                rs = (Resource)rlIterator.next();
                if (seen.contains(rs.getURI())) continue;
                ArrayList<Resource> expand = new ArrayList<Resource>(candidate);
                expand.add(rs);
                neighborQueue.add(expand);
            }
        }
        return solution;
    }

    public ArrayList<ArrayList<OntResource>> validPath(Resource start, ArrayList<Resource> candidate, long bw, String rType1_str, String rType2_str, String nc_of_version) {
        boolean valid = true;
        ArrayList<ArrayList<OntResource>> pathHopList = new ArrayList<ArrayList<OntResource>>();
        Resource next = null;
        OntResource rs_ont = null;
        OntResource intf_ont = null;
        ArrayList<OntResource> pair = null;
        int isEndPoint = 0;
        System.out.println("Candidate path length=" + candidate.size());
        for (int i = 0; i < candidate.size(); ++i) {
            ArrayList<ArrayList<OntResource>> intf_List;
            next = candidate.get(i);
            if (!this.ontModel.getOntResource(next).hasRDFType(NdlCommons.deviceOntClass)) {
                next = (Resource)this.ontModel.getOntResource(next).getPropertyValue(NdlCommons.topologyInterfaceOfProperty);
            }
            if (!this.ontModel.getOntResource(start).hasRDFType(NdlCommons.deviceOntClass)) {
                start = (Resource)this.ontModel.getOntResource(start).getPropertyValue(NdlCommons.topologyInterfaceOfProperty);
            }
            if ((intf_List = this.findInterface(start, next, rType1_str, rType2_str, isEndPoint = i == 0 ? -1 : (i == candidate.size() - 1 ? 1 : 0), nc_of_version)).size() < 2) {
                System.out.println("Intf list size<2:start=" + start.getURI() + ";next=" + next.getURI());
                valid = false;
                break;
            }
            for (int j = 0; j < intf_List.size(); ++j) {
                pair = intf_List.get(j);
                rs_ont = pair.get(0);
                intf_ont = pair.get(1);
                long intf_bw = this.checkBW(intf_ont, bw);
                pair.add(this.ontModel.createOntResource(String.valueOf(intf_bw)));
                valid = intf_bw > 0L ? bw - intf_bw <= 0L : true;
                if (bw != 0L && !valid) {
                    this.logger.error((Object)("Not enough bandwidth:" + intf_ont));
                    break;
                }
                pathHopList.add(pair);
            }
            if (!valid) break;
            start = next;
        }
        if (valid) {
            return pathHopList;
        }
        return null;
    }

    public long minBW(ArrayList<ArrayList<OntResource>> path) {
        ArrayList<OntResource> pair = null;
        pair = path.get(0);
        long minBW = -1L;
        for (int i = 0; i < path.size(); ++i) {
            pair = path.get(i);
            long bw = Long.valueOf(pair.get(2).getURI());
            if (bw <= 0L) continue;
            if (minBW < 0L) {
                minBW = bw;
            }
            if (minBW <= bw) continue;
            minBW = bw;
        }
        return minBW;
    }

    public long checkBW(OntResource intf, long bw) {
        HashSet<Resource> sc_List = new HashSet<Resource>();
        boolean valid = true;
        Resource eth = this.ontModel.createResource("http://geni-orca.renci.org/owl/ethernet.owl#EthernetNetworkElement");
        OntResource device_rs = (OntResource)intf.getPropertyValue(NdlCommons.topologyInterfaceOfProperty);
        Resource sm = null;
        Resource sc = null;
        StmtIterator j = device_rs.listProperties(NdlCommons.hasSwitchMatrix);
        while (j.hasNext()) {
            sm = ((Statement)j.next()).getResource();
            sc = sm.getProperty(switchingCapability).getResource();
            sc_List.add(sc);
            if (!sc.equals((Object)eth)) continue;
            valid = false;
            break;
        }
        if (valid) {
            return -1L;
        }
        OntResource rs = null;
        long intf_bw = 0L;
        ResultSet results = null;
        String varName = null;
        while (true) {
            if (intf.hasProperty(RDF_TYPE, (RDFNode)eth)) {
                rs = intf;
                break;
            }
            results = this.getLayerAdapatation(intf.getURI());
            varName = (String)results.getResultVars().get(0);
            if (results.hasNext()) {
                rs = results.nextSolution().getResource(varName);
            }
            if (rs == null) break;
            if (rs.hasProperty(RDF_TYPE, (RDFNode)eth)) {
                intf = this.ontModel.getOntResource((Resource)rs);
                break;
            }
            intf = this.ontModel.getOntResource((Resource)rs);
        }
        if (intf.getProperty(NdlCommons.layerBandwidthProperty) != null) {
            intf_bw = intf.getProperty(NdlCommons.layerBandwidthProperty).getLiteral().getLong();
        }
        valid = bw - intf_bw <= 0L;
        return intf_bw;
    }

    public LinkedList<OntResource> getDeviceListInPath(ArrayList<ArrayList<OntResource>> path) {
        LinkedList<OntResource> deviceList = null;
        if (path != null && !path.isEmpty()) {
            deviceList = new LinkedList<OntResource>();
            for (int i = 0; i < path.size(); ++i) {
                ArrayList<OntResource> intf_List = path.get(i);
                for (int j = 0; j < intf_List.size(); ++j) {
                    OntResource device_ont = intf_List.get(0);
                    OntResource intf_ont = intf_List.get(1);
                    if (deviceList.contains(device_ont)) continue;
                    deviceList.add(device_ont);
                }
            }
        }
        return deviceList;
    }

    public ArrayList<ArrayList<OntResource>> findInterface(Resource rs0, Resource rs1, String rType1_str, String rType2_str, int isEndPoint, String nc_of_version) {
        ArrayList<ArrayList<OntResource>> intf_List = new ArrayList<ArrayList<OntResource>>();
        ResultSet results = this.getSubGraphLinkTo(rs0.getURI(), rs1.getURI());
        int results_size = 0;
        while (results.hasNext()) {
            results.next();
            ++results_size;
        }
        results = this.getSubGraphLinkTo(rs0.getURI(), rs1.getURI());
        OntResource rs0_ont = this.ontModel.getOntResource(rs0);
        OntResource rs1_ont = this.ontModel.getOntResource(rs1);
        String var0 = (String)results.getResultVars().get(0);
        String var2 = (String)results.getResultVars().get(1);
        ArrayList<OntResource> pair = null;
        boolean correctResourceType = true;
        while (results.hasNext()) {
            QuerySolution solution = results.nextSolution();
            Resource in0 = solution.getResource(var0);
            Resource in2 = solution.getResource(var2);
            OntResource in0_ont = this.ontModel.getOntResource(in0);
            OntResource in2_ont = this.ontModel.getOntResource(in2);
            correctResourceType = true;
            if (!in0_ont.hasRDFType(NdlCommons.interfaceOntClass) || results_size > 1 && (in0_ont.getProperty(NdlCommons.portOccupied) != null && in0_ont.getProperty(NdlCommons.portOccupied).getBoolean() || in2_ont.getProperty(NdlCommons.portOccupied) != null && in2_ont.getProperty(NdlCommons.portOccupied).getBoolean())) continue;
            if (in0_ont.hasProperty(NdlCommons.topologyInterfaceOfProperty, (RDFNode)rs0) && in2_ont.hasProperty(NdlCommons.topologyInterfaceOfProperty, (RDFNode)rs1)) {
                intf_List.clear();
                if (isEndPoint == -1) {
                    correctResourceType = this.correctResourceType(in0_ont, rType1_str);
                }
                if (isEndPoint == 1) {
                    correctResourceType = this.correctResourceType(in2_ont, rType2_str);
                }
                if (correctResourceType) {
                    if (isEndPoint != 0 && !this.check_of_version(in0, nc_of_version) && !this.check_of_version(in2, nc_of_version)) continue;
                    pair = new ArrayList();
                    pair.add(rs0_ont);
                    pair.add(in0_ont);
                    intf_List.add(0, pair);
                    pair = new ArrayList();
                    pair.add(rs1_ont);
                    pair.add(in2_ont);
                    intf_List.add(pair);
                    this.logger.debug((Object)("findInterface:" + rs0.getURI() + ":" + in0_ont.getURI() + "---" + rs1.getURI() + ":" + in2_ont.getURI()));
                    break;
                }
            }
            if (in0_ont.hasProperty(NdlCommons.topologyInterfaceOfProperty, (RDFNode)rs0)) {
                if (isEndPoint == -1) {
                    correctResourceType = this.correctResourceType(in0_ont, rType1_str);
                }
                if (correctResourceType) {
                    pair = new ArrayList<OntResource>();
                    pair.add(rs0_ont);
                    pair.add(in0_ont);
                    intf_List.add(0, pair);
                    this.logger.debug((Object)("findInterface:" + rs0.getURI() + ":" + in0_ont.getURI() + "---"));
                }
            }
            if (!in2_ont.hasProperty(NdlCommons.topologyInterfaceOfProperty, (RDFNode)rs1)) continue;
            if (isEndPoint == 1) {
                correctResourceType = this.correctResourceType(in2_ont, rType2_str);
            }
            if (!correctResourceType) continue;
            pair = new ArrayList();
            pair.add(rs1_ont);
            pair.add(in2_ont);
            intf_List.add(pair);
            this.logger.debug((Object)("findInterface:" + rs1.getURI() + ":" + in2_ont.getURI()));
        }
        return intf_List;
    }

    public boolean check_of_version(Resource intf_rs, String nc_of_version) {
        boolean right_version = false;
        if (intf_rs.hasProperty(topologyInterfaceOfProperty)) {
            Resource domain_rs = intf_rs.getProperty(topologyInterfaceOfProperty).getResource();
            right_version = OntProcessor.isStitchingNodeInManifest(domain_rs);
            if (right_version) {
                return right_version;
            }
        }
        String intf_of = NdlCommons.getOpenFlowVersion(intf_rs);
        if (nc_of_version != null) {
            if (intf_of != null && intf_of.equalsIgnoreCase(nc_of_version)) {
                right_version = true;
            }
        } else if (intf_of == null) {
            right_version = true;
        }
        return right_version;
    }

    boolean correctResourceType(OntResource rs, String resourceType) {
        boolean correct = false;
        DomainResourceType rType = this.resourceType(rs);
        if (rType == null) {
            return true;
        }
        if (resourceType.equals(rType.getResourceType())) {
            correct = true;
        }
        return correct;
    }

    public DomainResourceType resourceType(OntResource rs) {
        DomainResourceType type = null;
        if (rs.getProperty(NdlCommons.availableLabelSet) == null) {
            return type;
        }
        Resource labelSet = rs.getProperty(NdlCommons.availableLabelSet).getResource();
        if (labelSet != null && labelSet.getProperty(NdlCommons.domainHasResourceTypeProperty) != null) {
            Resource resourceType = labelSet.getProperty(NdlCommons.domainHasResourceTypeProperty).getResource();
            int rank = 0;
            if (resourceType.getProperty(NdlCommons.resourceTypeRank) != null) {
                rank = resourceType.getProperty(NdlCommons.resourceTypeRank).getInt();
            }
            type = new DomainResourceType();
            type.setResourceType(resourceType.getLocalName().toLowerCase());
            type.setRank(rank);
        }
        if (type != null) {
            this.logger.info((Object)("Intf resource type:" + type.toString()));
        }
        return type;
    }

    public DomainResourceType getResourceType(String type_str) {
        DomainResourceType type = new DomainResourceType();
        OntResource resourceType = this.ontModel.getOntResource(type_str);
        int rank = 0;
        if (resourceType != null && resourceType.getProperty(NdlCommons.resourceTypeRank) != null) {
            rank = resourceType.getProperty(NdlCommons.resourceTypeRank).getInt();
        }
        type.setResourceType(type_str);
        type.setRank(rank);
        return type;
    }

    public Device getDevice(Resource rs, LinkedList<Device> list) {
        if (list == null) {
            return null;
        }
        Iterator it = list.iterator();
        Device device = null;
        while (it.hasNext()) {
            Device itDevice = (Device)it.next();
            if (!rs.getURI().equals(itDevice.getName()) && !rs.getURI().equals(itDevice.getURI())) continue;
            device = itDevice;
            break;
        }
        return device;
    }

    public boolean isCe(DomainElement device) {
        boolean isCe = false;
        String rType = device.getResourceType().getResourceType().toLowerCase();
        if (rType.endsWith(DomainResourceType.VM_RESOURCE_TYPE) || rType.endsWith(DomainResourceType.BM_RESOURCE_TYPE) || rType.endsWith(DomainResourceType.FourtyGBM_RESOURCE_TYPE)) {
            isCe = true;
        }
        return isCe;
    }

    public Device getDevice(Device d, LinkedList<NetworkElement> list) {
        if (list == null) {
            return null;
        }
        Iterator it = list.iterator();
        Device device = null;
        while (it.hasNext()) {
            Device itDevice = (Device)it.next();
            if (!d.getName().equals(itDevice.getName())) continue;
            device = itDevice;
            break;
        }
        return device;
    }

    public void removeInConnectionProperty(String ps, Property p) {
        String queryPhrase = OntProcessor.createQueryStringSubjectData(ps, "true");
        ResultSet results = OntProcessor.rdfQuery((Model)this.ontModel, queryPhrase);
        String var0 = (String)results.getResultVars().get(0);
        QuerySolution solution = null;
        Resource rs = null;
        LinkedList<Resource> tempList = null;
        if (results.hasNext()) {
            tempList = new LinkedList<Resource>();
        }
        while (results.hasNext()) {
            solution = results.nextSolution();
            rs = solution.getResource(var0);
            tempList.add(rs);
        }
        while (tempList != null && !tempList.isEmpty()) {
            rs = (Resource)tempList.removeLast();
            this.logger.debug((Object)("removeInConnectionProperty:" + rs.getURI() + ":" + ps));
            rs.removeAll(p);
        }
    }

    public String findLayer(Resource resource) {
        ResultSet results = OntProcessor.getLayer(this.ontModel, resource.getURI());
        String varName = (String)results.getResultVars().get(0);
        if (results.hasNext()) {
            return results.nextSolution().getResource(varName).getLocalName();
        }
        return null;
    }

    public static ResultSet getLayer(OntModel m, String rsURI) {
        String s = "SELECT ?r ";
        String f = "";
        String w = "WHERE {<" + rsURI + "> ?p ?r. ?r rdf:type layer:Layer      }";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        ResultSet results = OntProcessor.rdfQuery((Model)m, queryPhrase);
        return results;
    }

    public ResultSet getLayerAdapatation(String rsURI) {
        ResultSet results = OntProcessor.getLayerAdapatation(this.ontModel, rsURI);
        return results;
    }

    public static ResultSet getLayerAdapatation(OntModel m, String rsURI) {
        String s = "SELECT ?r ";
        String f = "";
        String w = "WHERE {{<" + rsURI + "> ?p ?r. ?p rdf:type layer:AdaptationProperty} UNION{<" + rsURI + "> layer:AdaptationProperty ?r}      }";
        String queryPhrase = OntProcessor.createQueryString(s, f, w);
        ResultSet results = OntProcessor.rdfQuery((Model)m, queryPhrase);
        return results;
    }

    public static String getLayerAction(String layer) {
        String action = null;
        for (LayerConstant.Layer lay : LayerConstant.Layer.values()) {
            if (!layer.equals(lay.toString())) continue;
            action = lay.getAction().toString();
            break;
        }
        return action;
    }

    public static String substrateDotString(OntModel ontModel) {
        LinkedList<NetworkConnection> edgeList = new LinkedList<NetworkConnection>();
        NetworkConnection edge = null;
        String dotString = "graph RDFS {\n";
        dotString = dotString + "\trankdir=LR;\n";
        dotString = dotString + "\tranksep=\"1.2\";\n";
        dotString = dotString + "\tedge [arrowhead=none];\n";
        dotString = dotString + "\tnode [label=\"\\N\", fontname=Arial, fixedsize=false, color=lightblue,style=filled];\n";
        ResultSet results = OntProcessor.connectedDevicePair(ontModel);
        OntClass serverOntClass = ontModel.createClass("http://geni-orca.renci.org/owl/compute.owl#Server");
        OntClass deviceOntClass = ontModel.createClass("http://geni-orca.renci.org/owl/topology.owl#Device");
        OntClass interfaceOntClass = ontModel.createClass("http://geni-orca.renci.org/owl/topology.owl#Interface");
        OntProperty interfaceOf = ontModel.createOntProperty("http://geni-orca.renci.org/owl/topology.owl#interfaceOf");
        String var0 = (String)results.getResultVars().get(0);
        String var1 = (String)results.getResultVars().get(1);
        QuerySolution solution = null;
        while (results.hasNext()) {
            solution = results.nextSolution();
            Resource rs1 = solution.getResource(var0);
            Resource rs2 = solution.getResource(var1);
            String url1 = rs1.getURI();
            String url2 = rs2.getURI();
            OntResource ont_rs1 = ontModel.createOntResource(url1);
            OntResource ont_rs2 = ontModel.createOntResource(url2);
            if (ont_rs1.hasRDFType((Resource)interfaceOntClass)) {
                ont_rs1 = (OntResource)ont_rs1.getPropertyValue((Property)interfaceOf);
            }
            if (ont_rs2.hasRDFType((Resource)interfaceOntClass)) {
                ont_rs2 = (OntResource)ont_rs2.getPropertyValue((Property)interfaceOf);
            }
            if (!(ont_rs1.hasRDFType((Resource)serverOntClass) | ont_rs1.hasRDFType((Resource)deviceOntClass)) || OntProcessor.existEdge(edgeList, url1, url2)) continue;
            edge = new NetworkConnection();
            edge.setConnectionType(LayerConstant.ConnectionType.link.toString());
            NetworkElement ne1 = new NetworkElement(ontModel, ont_rs1);
            NetworkElement ne2 = new NetworkElement(ontModel, ont_rs2);
            edge.setNe1(ne1);
            edge.setNe2(ne2);
            edgeList.add(edge);
            String rs1_name = ont_rs1.getLabel(null) != null ? ont_rs1.getLabel(null) : ont_rs1.getLocalName();
            String rs2_name = ont_rs2.getLabel(null) != null ? ont_rs2.getLabel(null) : ont_rs2.getLocalName();
            dotString = dotString + "\"" + rs1_name + "\"--\"" + rs2_name + "\"\n";
        }
        dotString = dotString + "\n}";
        return dotString;
    }

    public static boolean existEdge(LinkedList<NetworkConnection> edgeList, String url1, String url2) {
        boolean exist = false;
        int size = edgeList.size();
        for (int i = 0; i < size; ++i) {
            NetworkConnection thisEdge = edgeList.get(i);
            if (url1.equals(thisEdge.getNe1().getURI()) && url2.equals(thisEdge.getNe2().getURI())) {
                exist = true;
                break;
            }
            if (!url1.equals(thisEdge.getNe2().getURI()) || !url2.equals(thisEdge.getNe1().getURI())) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static ResultSet connectedDevicePair(OntModel model) {
        String queryPhrase = OntProcessor.createQueryStringConnect();
        return OntProcessor.rdfQuery((Model)model, queryPhrase);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

