/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.rdf.model.Resource;
import com.sun.org.apache.xml.internal.resolver.helpers.PublicId;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.dom.DOMInputImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class NdlToRSpecHelper {
    private static final String UNKNOWN = "unknown";
    public static String CM_URN_PATTERN = "urn:publicid:IDN+exogeni.net:@+authority+am";
    public static String CONTROLLER_URL_PATTERN = "https://@-hn.exogeni.net:11443/orca/xmlrpc";
    public static String COMPONENT_URN_PATTERN = "urn:publicid:IDN+exogeni.net:@+^+%";
    public static String SLIVER_URN_PATTERN = "urn:publicid:IDN+@+^+%";
    public static String COMPONENT_URN_GLOBAL_PATTERN = "urn:publicid:IDN+exogeni.net+^+%";
    public static String UNKNOWN_COMPONENT_URN = "urn:publicid:IDN+exogeni.net+component+unknown";
    public static String UNKNOWN_CM_URN = "urn:publicid:IDN+exogeni.net:unknown+authority+cm";
    public static String UNKNOWN_SLIVER_URN = "urn:publicid:IDN+exogeni.net+sliver+unknown";
    private static Pattern pattern = Pattern.compile("http://.+/([\\w-]+).rdf#\\1/.+");
    private static Pattern pattern1 = Pattern.compile("http://.+/([\\w-]+).rdf#.+");
    private static Pattern urlPattern = Pattern.compile("https://([\\w]+)-hn.exogeni.net:[\\d]+/orca/xmlrpc");
    private static final Map<String, String> mapUrlToCm;
    private static final String[] exoDomains;

    public static String getControllerForUrl(String url) {
        if (mapUrlToCm.containsKey(url)) {
            return mapUrlToCm.get(url);
        }
        Matcher matcher = urlPattern.matcher(url);
        if (matcher.matches()) {
            return "exogeni.net:" + matcher.group(1) + "vmsite";
        }
        return "exogeni.net:unknownvmsite";
    }

    private static String decodeUrlString(String s) {
        if (s == null) {
            return s;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return s;
        }
    }

    public static String getControllerForSite(String domainUrl) {
        Matcher matcher = pattern.matcher(domainUrl = NdlToRSpecHelper.decodeUrlString(domainUrl));
        if (!matcher.matches() || matcher.groupCount() != 1) {
            return null;
        }
        String shortDomain = matcher.group(1).replaceAll("Net", "").replaceAll("vmsite", "");
        for (String special : exoDomains) {
            if (!special.equalsIgnoreCase(shortDomain)) continue;
            return null;
        }
        return CONTROLLER_URL_PATTERN.replaceFirst("@", shortDomain);
    }

    public static String cmFromDomain(String domainUrl) {
        String ret = UNKNOWN_CM_URN;
        Matcher matcher = pattern.matcher(domainUrl = NdlToRSpecHelper.decodeUrlString(domainUrl));
        if (!matcher.matches() || matcher.groupCount() != 1) {
            return ret;
        }
        return CM_URN_PATTERN.replaceFirst("@", matcher.group(1));
    }

    public static String idFromDomain(String domainUrl) {
        String ret = UNKNOWN;
        Matcher matcher = pattern.matcher(domainUrl = NdlToRSpecHelper.decodeUrlString(domainUrl));
        if (!matcher.matches() || matcher.groupCount() != 1) {
            return ret;
        }
        return "exogeni.net:" + matcher.group(1);
    }

    private static String massageName(String n) {
        String name = n.replaceAll("[#/]", ":");
        String[] names = name.split(":");
        String tName = "";
        for (int i = 1; i < names.length - 1; ++i) {
            tName = tName + names[i] + ":";
        }
        tName = names.length > 1 && tName.length() > 1 ? tName.substring(0, tName.length() - 1) : names[0];
        return name;
    }

    public static String cidUrnFromUrl(String domainUrl, UrnType type, String name) {
        String ret = UNKNOWN_COMPONENT_URN;
        domainUrl = NdlToRSpecHelper.decodeUrlString(domainUrl);
        Matcher matcher = null;
        if (domainUrl != null) {
            matcher = pattern.matcher(domainUrl);
        }
        if (name == null) {
            return ret;
        }
        String sName = name;
        if (UrnType.Interface == type || UrnType.Link == type || UrnType.StitchPort == type) {
            name = NdlToRSpecHelper.massageName(name);
            sName = name.replaceFirst(".+.rdf:", "");
        }
        if (UrnType.Sliver == type) {
            sName = name.replaceAll("[#/]", ":");
        }
        if (domainUrl == null) {
            return COMPONENT_URN_GLOBAL_PATTERN.replaceFirst("\\^", type.toString()).replaceFirst("%", sName);
        }
        if (matcher != null && !matcher.matches()) {
            Matcher matcher1 = pattern1.matcher(domainUrl);
            if (matcher1.matches()) {
                return COMPONENT_URN_PATTERN.replaceFirst("@", matcher1.group(1)).replaceFirst("\\^", type.toString()).replaceFirst("%", sName);
            }
            return COMPONENT_URN_GLOBAL_PATTERN.replaceFirst("\\^", type.toString()).replaceFirst("%", sName);
        }
        return COMPONENT_URN_PATTERN.replaceFirst("@", matcher.group(1)).replaceFirst("\\^", type.toString()).replaceFirst("%", sName);
    }

    public static String cidUrnFromUrl(String domainUrl, UrnType type, String name1, String name2) {
        String ret = UNKNOWN_COMPONENT_URN;
        domainUrl = NdlToRSpecHelper.decodeUrlString(domainUrl);
        Matcher matcher = pattern.matcher(domainUrl);
        if (name1 == null || name2 == null) {
            return ret;
        }
        String sName1 = name1;
        String sName2 = name2;
        if (UrnType.Interface == type || UrnType.Link == type || UrnType.StitchPort == type) {
            name1 = NdlToRSpecHelper.massageName(name1);
            sName1 = name1.replaceFirst(".+.rdf:", "");
            name2 = NdlToRSpecHelper.massageName(name2);
            sName2 = name2.replaceFirst(".+.rdf:", "");
        }
        if (UrnType.Sliver == type) {
            sName1 = name1.replaceAll("[#/]", ":");
            sName2 = name2.replaceAll("[#/]", ":");
        }
        if (!matcher.matches()) {
            Matcher matcher1 = pattern1.matcher(domainUrl);
            if (matcher1.matches()) {
                return COMPONENT_URN_PATTERN.replaceFirst("@", matcher1.group(1)).replaceFirst("\\^", type.toString()).replaceFirst("%", sName1 + "_" + sName2);
            }
            return ret;
        }
        return COMPONENT_URN_PATTERN.replaceFirst("@", matcher.group(1)).replaceFirst("\\^", type.toString()).replaceFirst("%", sName1 + "_" + sName2);
    }

    public static boolean specificDomainCheck(String urn, String against) {
        String pid = PublicId.decodeURN((String)urn);
        String cd = pid.split(" ")[1];
        return cd.equalsIgnoreCase(against);
    }

    public static boolean domainNameSpaceCheck(String urn, Set<String> dom) {
        String pid = PublicId.decodeURN((String)urn);
        String cd = pid.split(" ")[1];
        for (String d : dom) {
            if (cd == null || !cd.startsWith(d)) continue;
            return true;
        }
        return false;
    }

    public static String generateDomainNameSpace(String urn) {
        String pid = PublicId.decodeURN((String)urn);
        String dom = pid.split(" ")[1];
        if (dom.split("//").length == 2) {
            return dom.split("//")[1] + ".rdf";
        }
        return dom + ".rdf";
    }

    public static String generateSiteName(String urn) {
        String pid = PublicId.decodeURN((String)urn);
        String site = pid.split(" ")[1];
        if (site.split("//").length == 2) {
            return site.split("//")[1];
        }
        return site;
    }

    public static String generateDomainName(String urn) {
        return NdlToRSpecHelper.generateDomainNameSpace(urn) + "#" + NdlToRSpecHelper.generateSiteName(urn);
    }

    public static String sliverUrnFromRack(String sid, String rack) {
        String sName = sid.replaceAll("[#/]", ":");
        return SLIVER_URN_PATTERN.replaceFirst("@", rack).replaceFirst("\\^", UrnType.Sliver.toString()).replaceFirst("%", sName);
    }

    public static String sliverUrlFromURN(String urn) {
        String url = "http://geni-orca.renci.org/owl/";
        if (urn == null) {
            return url + UNKNOWN;
        }
        String pid = PublicId.decodeURN((String)urn);
        String uniq = pid.split(" ")[3];
        if (uniq != null) {
            return url + uniq;
        }
        return url + UNKNOWN;
    }

    public static String interfaceUrlFromURN(String urn) {
        String url = "http://geni-orca.renci.org/owl/";
        if (urn == null) {
            return url + UNKNOWN;
        }
        String pid = PublicId.decodeURN((String)urn);
        String domain = NdlToRSpecHelper.generateDomainNameSpace(urn);
        String uniq = pid.split(" ")[3];
        if (uniq != null) {
            return url + domain + "#" + uniq.replace("//", "/");
        }
        return url + domain + "#" + UNKNOWN;
    }

    public static String getTrueName(Resource r) {
        if (r == null) {
            return null;
        }
        String shortName = StringUtils.removeStart((String)r.getURI(), (String)"http://geni-orca.renci.org/owl/");
        return NdlToRSpecHelper.decodeUrlString(shortName);
    }

    public static String getTrueName(String r) {
        if (r == null) {
            return null;
        }
        String shortName = StringUtils.removeStart((String)r, (String)"http://geni-orca.renci.org/owl/");
        return NdlToRSpecHelper.decodeUrlString(shortName);
    }

    public static String getClientId(Resource r) {
        String ret = NdlToRSpecHelper.getTrueName(r);
        return NdlToRSpecHelper.getClientId(ret);
    }

    public static String getClientId(String s) {
        String ret = s;
        String[] sp = ret.split("#");
        if (sp.length == 2) {
            ret = sp[1];
        }
        return ret;
    }

    public static String domToString(Node n, boolean withNS, boolean withHeader) throws Exception {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer writer = impl.createLSSerializer();
        String str = writer.writeToString(n);
        if (!withHeader) {
            str = NdlToRSpecHelper.stripXmlHead(str);
        }
        if (withNS) {
            return str;
        }
        return NdlToRSpecHelper.stripXmlNs(str);
    }

    public static String stripXmlHead(String s) {
        return s.replaceAll("<\\?.*\\?>", "");
    }

    public static String stripXmlNs(String s) {
        return s.replaceAll("xmlns.*?(\"|').*?(\"|')", "");
    }

    public static NodeList parseXmlToDOM(String s) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSParser builder = impl.createLSParser((short)1, null);
            DOMInputImpl lsi = new DOMInputImpl(null, null, null, s, null);
            Document document = builder.parse((LSInput)lsi);
            return document.getChildNodes();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        String dom = "http://geni-orca.renci.org/owl/rcivmsite.rdf#rcivmsite/Domain";
        System.out.println("1. Result for " + dom + ": " + NdlToRSpecHelper.cmFromDomain(dom));
        String url = "http://geni-orca.renci.org/owl/40b1a531-ebda-4bf5-a595-d5873bab78f6#VLAN0-Node1";
        System.out.println("2. Original URL: " + url);
        String link = "http://geni-orca.renci.org/owl/bbnNet.rdf#BbnNet/IBM/G8052/TenGigabitEthernet/1/0/ethernet";
        System.out.println("6. Result for link url " + link + ": " + NdlToRSpecHelper.cidUrnFromUrl(link, UrnType.Link, "some-link"));
        System.out.println("7. " + NdlToRSpecHelper.cidUrnFromUrl("http://geni-orca.renci.org/owl/ben-6509.rdf#Duke/Cisco/6509/TenGigabitEthernet/gB/1/ethernet", UrnType.Interface, "ben-6509.rdf#Duke/Cisco/6509/TenGigabitEthernet/gB/1/ethernet"));
        System.out.println("Sliver ID: " + NdlToRSpecHelper.sliverUrnFromRack("mySliver", "exogeni.net:rcivmsite"));
        String controller = "https://ncsu2-hn.exogeni.net:11443/orca/xmlrpc";
        System.out.println("Site acronym from URL: " + controller + " is " + NdlToRSpecHelper.getControllerForUrl(controller));
        System.out.println("Massaging 54d52439-8040-47d9-823d-1fae50689981#StitchNode0 " + NdlToRSpecHelper.massageName("54d52439-8040-47d9-823d-1fae50689981#StitchNode0"));
    }

    static {
        HashMap<String, String> tmpM = new HashMap<String, String>();
        tmpM.put("https://geni-test.renci.org:11443/orca/xmlrpc", "exogeni.net:testvmsite");
        tmpM.put("https://geni.renci.org:11443/orca/xmlrpc", "exogeni.net");
        tmpM.put("https://uva-nl-hn.exogeni.net:11443/orca/xmlrpc", "exogeni.net:uvanlvmsite");
        mapUrlToCm = Collections.unmodifiableMap(tmpM);
        exoDomains = new String[]{"nlr", "ion", "ben"};
    }

    public static enum UrnType {
        Node("node"),
        Link("link"),
        StitchPort("stitchport"),
        Sliver("sliver"),
        Interface("interface");

        private final String name;

        private UrnType(String n2) {
            this.name = n2;
        }

        public String toString() {
            return this.name;
        }
    }
}

