/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.exogeni.orca.ndl.INdlColorRequestListener;
import net.exogeni.orca.ndl.INdlRequestModelListener;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.NdlException;
import net.exogeni.orca.ndl.NdlModel;
import net.exogeni.orca.ndl.NdlParserHelper;
import net.exogeni.orca.ndl.OntProcessor;

public class NdlRequestParser
extends NdlParserHelper {
    public static final String USER_REQUEST_RULES_FILE_PROPERTY = "NDL_REQUEST_RULE_FILE";
    private static final String RULES_FILE = "net/exogeni/orca/ndl/rules/requestRules.rules";
    INdlRequestModelListener listener;
    INdlColorRequestListener colorListener = null;
    OntModel requestModel;
    Set<Resource> interfaces = new HashSet<Resource>();
    Set<Resource> nodesAndLinks = new HashSet<Resource>();
    protected String[] inferenceModels = new String[]{"topology.owl", "layer.owl", "ethernet.owl", "compute.owl", "exogeni.owl", "storage.owl", "geni.owl", "eucalyptus.owl", "planetlab.owl", "protogeni.owl", "ec2.owl"};

    OntModel getModel() {
        return this.requestModel;
    }

    public NdlRequestParser(OntModel reqModel, INdlRequestModelListener l) throws NdlException {
        this.listener = l;
        this.requestModel = reqModel;
        for (String model : this.inferenceModels) {
            this.requestModel.read("http://geni-orca.renci.org/owl/" + model);
        }
    }

    public NdlRequestParser(OntModel reqModel, INdlRequestModelListener l, NdlModel.ModelType t, String folderName) throws NdlException {
        if (l == null) {
            throw new NdlException("Null parameters to the NdlRequestParser constructor");
        }
        this.listener = l;
        this.requestModel = reqModel;
        for (String model : this.inferenceModels) {
            this.requestModel.read("http://geni-orca.renci.org/owl/" + model);
        }
    }

    public NdlRequestParser(String ndlRequest, INdlRequestModelListener l) throws NdlException {
        if (ndlRequest == null || l == null) {
            throw new NdlException("Null parameters to the NdlRequestParser constructor;ndlRequest=" + ndlRequest + ";l=" + l);
        }
        this.listener = l;
        ByteArrayInputStream modelStream = new ByteArrayInputStream(ndlRequest.getBytes());
        this.requestModel = NdlModel.getRequestModelFromStream(modelStream, OntModelSpec.OWL_MEM_RDFS_INF, true);
        for (String model : this.inferenceModels) {
            this.requestModel.read("http://geni-orca.renci.org/owl/" + model);
        }
    }

    public NdlRequestParser(String ndlRequest, INdlRequestModelListener l, NdlModel.ModelType t, String folderName) throws NdlException {
        if (ndlRequest == null || l == null) {
            throw new NdlException("Null parameters to the NdlRequestParser constructor");
        }
        this.listener = l;
        ByteArrayInputStream modelStream = new ByteArrayInputStream(ndlRequest.getBytes());
        this.requestModel = NdlModel.getRequestModelFromStream(modelStream, OntModelSpec.OWL_MEM_RDFS_INF, true, t, folderName);
        for (String model : this.inferenceModels) {
            this.requestModel.read("http://geni-orca.renci.org/owl/" + model);
        }
    }

    public void addColorListener(INdlColorRequestListener ci) {
        this.colorListener = ci;
    }

    private boolean checkNodeOrLink(Resource r) {
        return this.nodesAndLinks.add(r);
    }

    public synchronized void processRequest() throws NdlException {
        if (this.requestModel == null) {
            return;
        }
        if (!this.lessStrictChecking) {
            this.validateRequest(RULES_FILE, USER_REQUEST_RULES_FILE_PROPERTY, this.requestModel);
        }
        ArrayList<Resource> resources = null;
        String query = OntProcessor.createQueryStringReservationTerm();
        ResultSet rs = OntProcessor.rdfQuery((Model)this.requestModel, query);
        if (rs.hasNext()) {
            Resource tmpR2;
            ResultBinding result = (ResultBinding)rs.next();
            Resource res = (Resource)result.get("reservation");
            StmtIterator sliceEl = res.listProperties(geniSliceProperty);
            while (sliceEl.hasNext()) {
                tmpR2 = ((Statement)sliceEl.next()).getResource();
                this.listener.ndlSlice(tmpR2, this.requestModel);
            }
            this.listener.ndlReservation(res, this.requestModel);
            Literal sd = (Literal)result.get("beginningTime");
            this.listener.ndlReservationStart(sd, this.requestModel, NdlRequestParser.getTermDate(sd));
            Literal ed = (Literal)result.get("endTime");
            this.listener.ndlReservationEnd(ed, this.requestModel, NdlRequestParser.getTermDate(ed));
            Resource term = (Resource)result.get("term");
            Literal yr = (Literal)result.get("years");
            Literal mo = (Literal)result.get("months");
            Literal day = (Literal)result.get("days");
            Literal hr = (Literal)result.get("hours");
            Literal min = (Literal)result.get("minutes");
            Literal sec = (Literal)result.get("seconds");
            this.listener.ndlReservationTermDuration(term, this.requestModel, NdlRequestParser.getLiteralInt(yr), NdlRequestParser.getLiteralInt(mo), NdlRequestParser.getLiteralInt(day), NdlRequestParser.getLiteralInt(hr), NdlRequestParser.getLiteralInt(min), NdlRequestParser.getLiteralInt(sec));
            resources = new ArrayList<Resource>();
            StmtIterator resEl = res.listProperties(collectionElementProperty);
            while (resEl.hasNext()) {
                tmpR2 = ((Statement)resEl.next()).getResource();
                resources.add(tmpR2);
                if (!tmpR2.hasProperty(RDF_TYPE, (RDFNode)computeElementClass) && !tmpR2.hasProperty(RDF_TYPE, (RDFNode)serverCloudClass) && !tmpR2.hasProperty(RDF_TYPE, (RDFNode)deviceOntClass) && !tmpR2.hasProperty(RDF_TYPE, (RDFNode)networkStorageClass)) continue;
                Object ceClass = NdlRequestParser.getResourceType(tmpR2);
                if (ceClass == null) {
                    ceClass = computeElementClass;
                }
                if (!this.checkNodeOrLink(tmpR2)) continue;
                this.listener.ndlNode(tmpR2, this.requestModel, (Resource)ceClass, NdlRequestParser.getResourceInterfaces(tmpR2));
                this.interfaces.addAll(NdlRequestParser.getResourceInterfaces(tmpR2));
            }
            resEl = res.listProperties(collectionElementProperty);
            while (resEl.hasNext()) {
                tmpR2 = ((Statement)resEl.next()).getResource();
                if (!tmpR2.hasProperty(RDF_TYPE, (RDFNode)topologyNetworkConnectionClass) && !tmpR2.hasProperty(RDF_TYPE, (RDFNode)topologyBroadcastConnectionClass)) continue;
                for (Resource intF : NdlRequestParser.getResourceInterfaces(tmpR2)) {
                    for (Resource attached : NdlRequestParser.getWhoHasInterface(intF, (Model)this.requestModel)) {
                        if (attached.equals((Object)tmpR2) || !attached.hasProperty(RDF_TYPE, (RDFNode)computeElementClass) && !attached.hasProperty(RDF_TYPE, (RDFNode)serverCloudClass) && !attached.hasProperty(RDF_TYPE, (RDFNode)deviceOntClass) && !attached.hasProperty(RDF_TYPE, (RDFNode)networkStorageClass)) continue;
                        Resource ceClass = NdlRequestParser.getResourceType(attached);
                        if (ceClass == null) {
                            ceClass = computeElementClass;
                        }
                        if (!this.checkNodeOrLink(attached)) continue;
                        this.listener.ndlNode(attached, this.requestModel, ceClass, NdlRequestParser.getResourceInterfaces(attached));
                        this.interfaces.addAll(NdlRequestParser.getResourceInterfaces(attached));
                    }
                }
            }
            resEl = res.listProperties(collectionElementProperty);
            while (resEl.hasNext()) {
                tmpR2 = ((Statement)resEl.next()).getResource();
                HashSet<Resource> nodeDeps = new HashSet<Resource>();
                StmtIterator depsIt = tmpR2.listProperties(requestDependOnProperty);
                while (depsIt.hasNext()) {
                    Resource depR = ((Statement)depsIt.next()).getResource();
                    if (depR == null) continue;
                    nodeDeps.add(depR);
                }
                this.listener.ndlNodeDependencies(tmpR2, this.requestModel, nodeDeps);
            }
            resEl = res.listProperties(collectionElementProperty);
            while (resEl.hasNext()) {
                tmpR2 = ((Statement)resEl.next()).getResource();
                if (tmpR2.hasProperty(RDF_TYPE, (RDFNode)topologyNetworkConnectionClass)) {
                    if (!this.checkNodeOrLink(tmpR2)) continue;
                    this.listener.ndlNetworkConnection(tmpR2, this.requestModel, NdlRequestParser.getResourceBandwidth(tmpR2), NdlRequestParser.getResourceLatency(tmpR2), NdlRequestParser.getResourceInterfaces(tmpR2));
                    this.interfaces.addAll(NdlRequestParser.getResourceInterfaces(tmpR2));
                    continue;
                }
                if (!tmpR2.hasProperty(RDF_TYPE, (RDFNode)topologyBroadcastConnectionClass) || !this.checkNodeOrLink(tmpR2)) continue;
                this.listener.ndlBroadcastConnection(tmpR2, this.requestModel, NdlRequestParser.getResourceBandwidth(tmpR2), NdlRequestParser.getResourceInterfaces(tmpR2));
                this.interfaces.addAll(NdlRequestParser.getResourceInterfaces(tmpR2));
            }
            for (Resource tmpR2 : this.interfaces) {
                Statement locIPStmt;
                Resource u;
                query = OntProcessor.createQueryStringWhoHasInterface(tmpR2);
                rs = OntProcessor.rdfQuery((Model)this.requestModel, query);
                if (rs == null || !rs.hasNext()) continue;
                result = (ResultBinding)rs.next();
                Resource conn = null;
                Resource node = null;
                if (result != null) {
                    u = (Resource)result.get("item");
                    if (u.hasProperty(RDF_TYPE, (RDFNode)topologyNetworkConnectionClass) || u.hasProperty(RDF_TYPE, (RDFNode)topologyBroadcastConnectionClass)) {
                        conn = u;
                    } else {
                        node = u;
                    }
                }
                if (rs.hasNext() && (result = (ResultBinding)rs.next()) != null) {
                    u = (Resource)result.get("item");
                    if (u.hasProperty(RDF_TYPE, (RDFNode)topologyNetworkConnectionClass) || u.hasProperty(RDF_TYPE, (RDFNode)topologyBroadcastConnectionClass)) {
                        conn = u;
                    } else {
                        node = u;
                    }
                }
                if ((locIPStmt = tmpR2.getProperty(ip4LocalIPAddressProperty)) != null) {
                    this.listener.ndlInterface(tmpR2, this.requestModel, conn, node, NdlRequestParser.getAddressIP(locIPStmt.getResource()), NdlRequestParser.getAddressNetmask(locIPStmt.getResource()));
                    continue;
                }
                this.listener.ndlInterface(tmpR2, this.requestModel, conn, node, null, null);
            }
            this.listener.ndlReservationResources(resources, this.requestModel);
            if (this.colorListener != null) {
                query = NdlCommons.createQueryStringHasColor();
                rs = NdlCommons.rdfQuery((Model)this.requestModel, query);
                while (rs.hasNext()) {
                    result = (ResultBinding)rs.next();
                    Resource ne = (Resource)result.get("netelement");
                    Resource color = (Resource)result.get("color");
                    if (ne == null || color == null) continue;
                    String label = NdlCommons.getLiteralProperty(color, NdlCommons.hasColorLabel);
                    this.colorListener.ndlResourceColor(ne, color, label);
                }
                query = NdlCommons.createQueryStringColorDependency();
                rs = NdlCommons.rdfQuery((Model)this.requestModel, query);
                while (rs.hasNext()) {
                    result = (ResultBinding)rs.next();
                    Resource fromNe = (Resource)result.get("fromNe");
                    Resource toNe = (Resource)result.get("toNe");
                    Resource color = (Resource)result.get("color");
                    if (fromNe == null || toNe == null || color == null) continue;
                    String label = NdlCommons.getLiteralProperty(color, NdlCommons.hasColorLabel);
                    this.colorListener.ndlColorDependency(fromNe, toNe, color, label);
                }
            }
            this.listener.ndlParseComplete();
        }
    }

    public synchronized void freeModel() {
        NdlModel.closeModel(this.requestModel);
        this.requestModel = null;
    }
}

