/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.util.PrintUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.NdlException;

public class NdlParserHelper
extends NdlCommons {
    protected boolean lessStrictChecking = false;

    protected void validateRequest(String staticRuleFile, String ruleFilePropertyName, OntModel modelToCheck) throws NdlException {
        String userRuleFile;
        PrintUtil.registerPrefix((String)"topo", (String)"http://geni-orca.renci.org/owl/topology.owl#");
        PrintUtil.registerPrefix((String)"comp", (String)"http://geni-orca.renci.org/owl/compute.owl#");
        PrintUtil.registerPrefix((String)"xo", (String)"http://geni-orca.renci.org/owl/exogeni.owl#");
        PrintUtil.registerPrefix((String)"exogeni", (String)"http://geni-orca.renci.org/owl/exogeni.owl#");
        PrintUtil.registerPrefix((String)"storage", (String)"http://geni-orca.renci.org/owl/storage.owl#");
        PrintUtil.registerPrefix((String)"geni", (String)"http://geni-orca.renci.org/owl/geni.owl#");
        PrintUtil.registerPrefix((String)"dom", (String)"http://geni-orca.renci.org/owl/domain.owl#");
        PrintUtil.registerPrefix((String)"req", (String)"http://geni-orca.renci.org/owl/request.owl#");
        PrintUtil.registerPrefix((String)"orca", (String)"http://geni-orca.renci.org/owl/orca.rdf#");
        PrintUtil.registerPrefix((String)"euca", (String)"http://geni-orca.renci.org/owl/eucalyptus.owl#");
        PrintUtil.registerPrefix((String)"pl", (String)"http://geni-orca.renci.org/owl/planetlab.owl#");
        PrintUtil.registerPrefix((String)"col", (String)"http://geni-orca.renci.org/owl/collections.owl#");
        PrintUtil.registerPrefix((String)"color", (String)"http://geni-orca.renci.org/owl/app-color.owl#");
        PrintUtil.registerPrefix((String)"ip4", (String)"http://geni-orca.renci.org/owl/ip4.owl#");
        PrintUtil.registerPrefix((String)"modify", (String)"http://geni-orca.renci.org/owl/modify.owl#");
        ClassLoader cl = NdlCommons.class.getProtectionDomain().getClassLoader();
        NdlParserHelper.getNdlLogger().debug((Object)("Reading default rule set " + staticRuleFile));
        String defaultRules = NdlParserHelper.readResourceIntoString(staticRuleFile);
        if (defaultRules == null) {
            throw new NdlException("Default rule set " + staticRuleFile + " is empty, unable to validate");
        }
        String userRules = null;
        StringBuilder combinedRules = new StringBuilder();
        if (ruleFilePropertyName != null && (userRuleFile = System.getProperty(ruleFilePropertyName)) != null) {
            NdlParserHelper.getNdlLogger().debug((Object)("Merging user rule file " + userRuleFile + " with default rule set " + staticRuleFile));
            userRules = NdlParserHelper.readFileIntoString(userRuleFile);
            if (userRules != null) {
                combinedRules.append(userRules);
            } else {
                NdlParserHelper.getNdlLogger().info((Object)("Specified rule file " + userRuleFile + " doesn't exist or is empty, ignoring"));
            }
        }
        combinedRules.append(defaultRules);
        ByteArrayInputStream is = new ByteArrayInputStream(combinedRules.toString().getBytes());
        InputStreamReader isr = new InputStreamReader(is);
        Rule.Parser rp = Rule.rulesParserFromReader((BufferedReader)new BufferedReader(isr));
        List<Rule> rules = this.getRules(combinedRules);
        if (rules == null) {
            NdlParserHelper.getNdlLogger().error((Object)"Unable to parse combined rule set, using default rules only");
            combinedRules = new StringBuilder();
            combinedRules.append(defaultRules);
            rules = this.getRules(combinedRules);
        }
        if (rules == null) {
            throw new NdlException("Unable to parse default rules");
        }
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        reasoner.setOWLTranslation(true);
        reasoner.setTransitiveClosureCaching(true);
        InfModel ruleModel = ModelFactory.createInfModel((Reasoner)reasoner, (Model)modelToCheck);
        ValidityReport rep = ruleModel.validate();
        if (rep.isValid() && rep.isClean()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Request validation failed rule validation due to");
        Iterator i = rep.getReports();
        while (i.hasNext()) {
            sb.append(": " + i.next());
        }
        throw new NdlException(sb.toString());
    }

    public void doLessStrictChecking() {
        this.lessStrictChecking = true;
    }

    private List<Rule> getRules(StringBuilder combinedRules) {
        ByteArrayInputStream is = new ByteArrayInputStream(combinedRules.toString().getBytes());
        InputStreamReader isr = new InputStreamReader(is);
        Rule.Parser rp = Rule.rulesParserFromReader((BufferedReader)new BufferedReader(isr));
        List rules = null;
        try {
            rules = Rule.parseRules((Rule.Parser)rp);
        }
        catch (Rule.ParserException rpe) {
            return null;
        }
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileIntoString(String fName) {
        String ret = null;
        try (Scanner sc = null;){
            sc = new Scanner(new File(fName));
            ret = sc.useDelimiter("\\A").next();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResourceIntoString(String resource) {
        String ret = null;
        try (Scanner sc = null;){
            ClassLoader cl = NdlCommons.class.getProtectionDomain().getClassLoader();
            sc = new Scanner(cl.getResourceAsStream(resource));
            ret = sc.useDelimiter("\\A").next();
        }
        return ret;
    }
}

