/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.util.ResourceUtils;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.exogeni.orca.ndl.INdlModifyModelListener;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.NdlException;
import net.exogeni.orca.ndl.NdlModel;
import net.exogeni.orca.ndl.NdlParserHelper;
import net.exogeni.orca.ndl.OntProcessor;

public class NdlModifyParser
extends NdlParserHelper {
    public static final String USER_MODIFY_RULES_FILE_PROPERTY = "NDL_MODIFY_RULE_FILE";
    private static final String RULES_FILE = "net/exogeni/orca/ndl/rules/modifyRules.rules";
    INdlModifyModelListener listener;
    OntModel modifyModel;
    boolean rewritten = false;
    private boolean lessStrictChecking = false;

    OntModel getModel() {
        return this.modifyModel;
    }

    public NdlModifyParser(String ndlModifyRequest, INdlModifyModelListener l) throws NdlException {
        if (ndlModifyRequest == null || l == null) {
            throw new NdlException("Null parameters to the NdlRequestParser constructor");
        }
        this.listener = l;
        ByteArrayInputStream modelStream = new ByteArrayInputStream(ndlModifyRequest.getBytes());
        this.modifyModel = NdlModel.getModelFromStream(modelStream, null, true);
    }

    public NdlModifyParser(String ndlModifyRequest, INdlModifyModelListener l, NdlModel.ModelType t, String folderName) throws NdlException {
        if (ndlModifyRequest == null || l == null) {
            throw new NdlException("Null parameters to the NdlRequestParser constructor");
        }
        this.listener = l;
        ByteArrayInputStream modelStream = new ByteArrayInputStream(ndlModifyRequest.getBytes());
        this.modifyModel = NdlModel.getModelFromStream(modelStream, null, true, t, folderName);
    }

    public List<Resource> rewriteModifyRequest() throws NdlException {
        return this.rewriteModifyRequest(null);
    }

    public synchronized List<Resource> rewriteModifyRequest(String ns) throws NdlException {
        if (this.rewritten) {
            return null;
        }
        if (this.modifyModel == null) {
            return null;
        }
        this.rewritten = true;
        INdlModifyModelListener save = this.listener;
        this.listener = new RewriteListener(ns);
        this.processModifyRequest();
        List<Resource> ret = ((RewriteListener)this.listener).listRenamed();
        this.listener = save;
        return ret;
    }

    public synchronized void processModifyRequest() throws NdlException {
        String query;
        ResultSet rs;
        if (this.modifyModel == null) {
            return;
        }
        if (!this.lessStrictChecking) {
            this.validateRequest(RULES_FILE, USER_MODIFY_RULES_FILE_PROPERTY, this.modifyModel);
        }
        if ((rs = OntProcessor.rdfQuery((Model)this.modifyModel, query = OntProcessor.createQueryStringModifyReservation())).hasNext()) {
            ResultBinding result = (ResultBinding)rs.next();
            Resource res = (Resource)result.get("modifyReservation");
            Literal nm = (Literal)result.get("modifyName");
            this.listener.ndlModifyReservation(res, nm, this.modifyModel);
            StmtIterator resEl = res.listProperties(collectionElementProperty);
            while (resEl.hasNext()) {
                Resource tmpR = ((Statement)resEl.next()).getResource();
                if (tmpR == null || !tmpR.hasProperty(modifySubjectProperty)) continue;
                Statement stm = tmpR.getProperty(modifySubjectProperty);
                Resource sub = stm.getResource();
                Resource obj = null;
                int n = 0;
                INdlModifyModelListener.ModifyType modType = null;
                if (tmpR.hasProperty(modifyAddElementProperty)) {
                    modType = INdlModifyModelListener.ModifyType.ADD;
                    obj = tmpR.getProperty(modifyAddElementProperty).getResource();
                } else if (tmpR.hasProperty(modifyElementProperty)) {
                    modType = INdlModifyModelListener.ModifyType.MODIFY;
                    obj = tmpR.getProperty(modifyElementProperty).getResource();
                } else if (tmpR.hasProperty(modifyRemoveElementProperty)) {
                    modType = INdlModifyModelListener.ModifyType.REMOVE;
                    obj = tmpR.getProperty(modifyRemoveElementProperty).getResource();
                } else if (tmpR.hasProperty(modifyIncreaseByProperty)) {
                    modType = INdlModifyModelListener.ModifyType.INCREASE;
                    n = tmpR.getProperty(modifyIncreaseByProperty).getInt();
                }
                this.listener.ndlModifyElement(tmpR, sub, modType, obj, n, this.modifyModel);
            }
        }
        this.listener.ndlParseComplete();
    }

    @Override
    public void doLessStrictChecking() {
        this.lessStrictChecking = true;
    }

    public synchronized void freeModel() {
        NdlModel.closeModel(this.modifyModel);
        this.modifyModel = null;
    }

    private static class RewriteListener
    implements INdlModifyModelListener {
        private List<Resource> toRename = new ArrayList<Resource>();
        private String newNs = null;

        public RewriteListener(String ns) {
            this.newNs = ns != null ? ns : "http://geni-orca.renci.org/owl/modify/" + UUID.randomUUID().toString() + "#";
        }

        public RewriteListener() {
            this.newNs = "http://geni-orca.renci.org/owl/modify/" + UUID.randomUUID().toString() + "#";
        }

        @Override
        public void ndlModifyElement(Resource i, Resource subject, INdlModifyModelListener.ModifyType t, Resource object, int modU, OntModel m) {
            Statement s;
            this.toRename.add(i);
            if (t == INdlModifyModelListener.ModifyType.ADD && (s = i.getProperty(NdlCommons.modifyAddElementProperty)) != null) {
                this.toRename.add((Resource)s.getObject());
            }
        }

        @Override
        public void ndlModifyReservation(Resource i, Literal name, OntModel m) {
            this.toRename.add(i);
        }

        @Override
        public void ndlParseComplete() {
            for (Resource i : this.toRename) {
                String tn = NdlCommons.getTrueName(i);
                ResourceUtils.renameResource((Resource)i, (String)(this.newNs + tn));
            }
        }

        public List<Resource> listRenamed() {
            return new ArrayList<Resource>(this.toRename);
        }
    }
}

