/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.LocatorURL;
import com.hp.hpl.jena.util.TypedStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.NdlException;
import net.exogeni.orca.ndl.util.ModelFolders;

public class NdlModel {
    public static final String[] orcaSchemaFiles = new String[]{"collections.owl", "compute.owl", "domain.owl", "dtn.owl", "ec2.owl", "ethernet.owl", "eucalyptus.owl", "exogeni.owl", "geni.owl", "ip4.owl", "itu-grid.owl", "kansei.owl", "layer.owl", "location.owl", "manifest.owl", "modify.owl", "openflow.owl", "planetlab.owl", "protogeni.owl", "request.owl", "storage.owl", "tcp.owl", "topology.owl", "app-color.owl"};
    public static final String[] orcaSubstrateFiles = new String[]{"orca.rdf", "ben.rdf", "ben-dtn.rdf", "ben-6509.rdf"};
    public static final Map<String, String> externalSchemas;
    private static boolean globalTDB;
    private static boolean globalRedirections;

    public static void setJenaRedirections(OntDocumentManager dm) {
        ClassLoader cl = NdlCommons.class.getProtectionDomain().getClassLoader();
        FileManager fm = new FileManager();
        fm.setLocationMapper(new LocationMapper(OntDocumentManager.getInstance().getFileManager().getLocationMapper()));
        fm.addLocator((Locator)new LocatorJarURL());
        fm.setModelCaching(false);
        dm.setFileManager(fm);
        dm.setCacheModels(false);
        for (String s : orcaSchemaFiles) {
            dm.addAltEntry("http://geni-orca.renci.org/owl/" + s, cl.getResource("net/exogeni/orca/ndl/schema/" + s).toString());
        }
        for (String s : orcaSubstrateFiles) {
            dm.addAltEntry("http://geni-orca.renci.org/owl/" + s, cl.getResource("net/exogeni/orca/ndl/substrate/" + s).toString());
        }
        for (String s : externalSchemas.keySet()) {
            dm.addAltEntry(s, cl.getResource("net/exogeni/orca/ndl/schema/" + externalSchemas.get(s)).toString());
        }
    }

    public static void closeModel(OntModel m) {
        if (m == null) {
            return;
        }
        if (m.supportsTransactions()) {
            m.commit();
        }
        m.close();
        ModelFolders.getInstance().remove(m);
    }

    public static OntModelSpec getOntModelSpec(OntModelSpec spec, boolean uniqueDM) {
        if (spec == null) {
            spec = OntModelSpec.OWL_MEM;
        }
        OntModelSpec s = new OntModelSpec(spec);
        if (uniqueDM) {
            OntDocumentManager odm = new OntDocumentManager();
            NdlModel.setJenaRedirections(odm);
            odm.setProcessImports(true);
            s.setDocumentManager(odm);
        } else {
            NdlModel.setJenaRedirections(s.getDocumentManager());
            s.getDocumentManager().setProcessImports(true);
        }
        return s;
    }

    public static OntModel getModelFromStream(InputStream modelStream, OntModelSpec spec, boolean uniqueDM, ModelType t, String folderName) throws NdlException {
        NdlCommons.getNdlLogger().info((Object)("getModelFromStream(): Creating " + (Object)((Object)t) + " model in " + folderName));
        assert (modelStream != null);
        if (spec == null) {
            spec = OntModelSpec.OWL_MEM;
        }
        OntModelSpec s = new OntModelSpec(spec);
        if (uniqueDM) {
            OntDocumentManager odm = new OntDocumentManager();
            NdlModel.setJenaRedirections(odm);
            odm.setProcessImports(true);
            s.setDocumentManager(odm);
        } else {
            NdlModel.setJenaRedirections(s.getDocumentManager());
            s.getDocumentManager().setProcessImports(true);
        }
        OntModel model = null;
        try {
            switch (t) {
                case TdbEphemeral: {
                    File dir;
                    if (globalTDB) {
                        dir = null;
                        dir = ModelFolders.getInstance().createTempDirectory(folderName);
                        if (dir == null) {
                            throw new NdlException("Unable to create temporary model folder in " + folderName);
                        }
                        Dataset ds = TDBFactory.createDataset((String)dir.getAbsolutePath());
                        Model fileModel = ds.getDefaultModel();
                        model = ModelFactory.createOntologyModel((OntModelSpec)s, (Model)fileModel);
                        ModelFolders.getInstance().put(model, ds, dir.getAbsolutePath(), true);
                        break;
                    }
                    model = ModelFactory.createOntologyModel((OntModelSpec)s);
                    break;
                }
                case TdbPersistent: {
                    File dir;
                    if (globalTDB && folderName != null) {
                        dir = null;
                        dir = ModelFolders.getInstance().createNamedDirectory(folderName);
                        if (dir == null) {
                            throw new NdlException("Unable to create persistent model folder in " + folderName);
                        }
                        Dataset ds = TDBFactory.createDataset((String)dir.getAbsolutePath());
                        Model fileModel = ds.getDefaultModel();
                        model = ModelFactory.createOntologyModel((OntModelSpec)s, (Model)fileModel);
                        ModelFolders.getInstance().put(model, ds, dir.getAbsolutePath(), false);
                        break;
                    }
                    model = ModelFactory.createOntologyModel((OntModelSpec)s);
                    break;
                }
                case InMemory: {
                    model = ModelFactory.createOntologyModel((OntModelSpec)s);
                }
            }
            model.read(modelStream, "");
        }
        catch (Exception e) {
            NdlModel.closeModel(model);
            throw new NdlException("NdlException unable to create model: " + e.getMessage());
        }
        try {
            modelStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static OntModel getModelFromStream(InputStream modelStream, OntModelSpec spec, boolean uniqueDM) throws NdlException {
        return NdlModel.getModelFromStream(modelStream, spec, uniqueDM, ModelType.InMemory, null);
    }

    public static OntModel getModelFromFile(String aFile, OntModelSpec spec, boolean uniqueDM) throws NdlException {
        return NdlModel.getModelFromFile(aFile, spec, uniqueDM, ModelType.InMemory, null);
    }

    public static OntModel getModelFromFile(String aFile, OntModelSpec spec, boolean uniqueDM, ModelType t, String folderName) throws NdlException {
        NdlCommons.getNdlLogger().info((Object)("getModelFromFile(): Creating model from " + aFile));
        InputStream in = FileManager.get().openNoMap(aFile);
        if (in == null) {
            throw new IllegalArgumentException("File: " + aFile + " not found");
        }
        OntModel model = NdlModel.getModelFromStream(in, spec, uniqueDM, t, folderName);
        return model;
    }

    public static OntModel getRequestModelFromStream(InputStream modelStream, OntModelSpec spec, boolean uniqueDM, ModelType t, String folderName) throws NdlException {
        NdlCommons.getNdlLogger().info((Object)("getRequestModelFromStream(): creating " + (Object)((Object)t) + " model in " + folderName));
        assert (modelStream != null);
        FileManager fm = new FileManager();
        fm.setLocationMapper(new LocationMapper(OntDocumentManager.getInstance().getFileManager().getLocationMapper()));
        fm.addLocator((Locator)new LocatorJarURL());
        ClassLoader cl = NdlCommons.class.getProtectionDomain().getClassLoader();
        URL reqUrl = cl.getResource("net/exogeni/orca/ndl/schema/request.owl");
        Model schemaModel = null;
        File dir = null;
        Dataset ds = null;
        switch (t) {
            case TdbEphemeral: {
                Model tmpSchemaModel;
                if (globalTDB) {
                    dir = ModelFolders.getInstance().createTempDirectory(folderName);
                    if (dir == null) {
                        throw new NdlException("Unable to create temporary model folder in " + folderName);
                    }
                    tmpSchemaModel = fm.loadModel(reqUrl.toString());
                    ds = TDBFactory.createDataset((String)dir.getAbsolutePath());
                    schemaModel = ds.getDefaultModel();
                    schemaModel.add(tmpSchemaModel);
                    tmpSchemaModel.close();
                    break;
                }
                schemaModel = fm.loadModel(reqUrl.toString());
                break;
            }
            case TdbPersistent: {
                Model tmpSchemaModel;
                if (globalTDB && folderName != null) {
                    dir = ModelFolders.getInstance().createNamedDirectory(folderName);
                    if (dir == null) {
                        throw new NdlException("Unable to create persistent model folder in " + folderName);
                    }
                    tmpSchemaModel = fm.loadModel(reqUrl.toString());
                    ds = TDBFactory.createDataset((String)dir.getAbsolutePath());
                    schemaModel = ds.getDefaultModel();
                    schemaModel.add(tmpSchemaModel);
                    tmpSchemaModel.close();
                    break;
                }
                schemaModel = fm.loadModel(reqUrl.toString());
                break;
            }
            case InMemory: {
                schemaModel = fm.loadModel(reqUrl.toString());
            }
        }
        try {
            schemaModel.read(modelStream, "");
        }
        catch (Exception e) {
            if (schemaModel.supportsTransactions()) {
                schemaModel.commit();
            }
            schemaModel.close();
            if (dir != null) {
                ModelFolders.deleteFolder(dir.getAbsolutePath());
            }
            throw new NdlException("NdlException, unable to create request model: " + e.getMessage());
        }
        if (spec == null) {
            spec = OntModelSpec.OWL_MEM;
        }
        OntModelSpec s = new OntModelSpec(spec);
        if (uniqueDM) {
            OntDocumentManager odm = new OntDocumentManager();
            NdlModel.setJenaRedirections(odm);
            odm.setProcessImports(true);
            s.setDocumentManager(odm);
        } else {
            NdlModel.setJenaRedirections(s.getDocumentManager());
            s.getDocumentManager().setProcessImports(true);
        }
        OntModel requestModel = ModelFactory.createOntologyModel((OntModelSpec)s, (Model)schemaModel);
        try {
            if (dir != null) {
                ModelFolders.getInstance().put(requestModel, ds, dir.getAbsolutePath(), t != ModelType.TdbPersistent);
            }
            modelStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new NdlException("Unable to get request model from stream due to: " + e);
        }
        return requestModel;
    }

    public static OntModel getRequestModelFromStream(InputStream modelStream, OntModelSpec spec, boolean uniqueDM) throws NdlException {
        return NdlModel.getRequestModelFromStream(modelStream, spec, uniqueDM, ModelType.InMemory, null);
    }

    public static OntModel createModel(OntModelSpec spec, boolean uniqueDM, ModelType t, String folderName) throws NdlException {
        NdlCommons.getNdlLogger().info((Object)("createModel(): creating blank " + (Object)((Object)t) + " model in " + folderName));
        if (spec == null) {
            spec = OntModelSpec.OWL_MEM;
        }
        OntModelSpec s = new OntModelSpec(spec);
        if (uniqueDM) {
            OntDocumentManager odm = new OntDocumentManager();
            NdlModel.setJenaRedirections(odm);
            odm.setProcessImports(true);
            s.setDocumentManager(odm);
        } else {
            NdlModel.setJenaRedirections(s.getDocumentManager());
            s.getDocumentManager().setProcessImports(true);
        }
        OntModel model = null;
        try {
            switch (t) {
                case TdbEphemeral: {
                    if (globalTDB) {
                        File dir = null;
                        dir = ModelFolders.getInstance().createTempDirectory(folderName);
                        if (dir == null) {
                            throw new NdlException("Unable to create temporary model folder in " + folderName);
                        }
                        Dataset ds = TDBFactory.createDataset((String)dir.getAbsolutePath());
                        Model fileModel = ds.getDefaultModel();
                        model = ModelFactory.createOntologyModel((OntModelSpec)s, (Model)fileModel);
                        ModelFolders.getInstance().put(model, ds, dir.getAbsolutePath(), true);
                        break;
                    }
                    model = ModelFactory.createOntologyModel((OntModelSpec)s);
                    break;
                }
                case TdbPersistent: {
                    if (globalTDB && folderName != null) {
                        File dir = null;
                        dir = ModelFolders.getInstance().createNamedDirectory(folderName);
                        if (dir == null) {
                            throw new NdlException("Unable to create persistent model folder in " + folderName);
                        }
                        Dataset ds = TDBFactory.createDataset((String)dir.getAbsolutePath());
                        Model fileModel = ds.getDefaultModel();
                        model = ModelFactory.createOntologyModel((OntModelSpec)s, (Model)fileModel);
                        ModelFolders.getInstance().put(model, ds, dir.getAbsolutePath(), false);
                        break;
                    }
                    model = ModelFactory.createOntologyModel((OntModelSpec)s);
                    break;
                }
                case InMemory: {
                    model = ModelFactory.createOntologyModel((OntModelSpec)s);
                }
            }
        }
        catch (Exception e) {
            throw new NdlException("Unable to create blank model due to: " + e);
        }
        return model;
    }

    public static OntModel createModel(OntModelSpec spec, boolean uniqueDM) throws NdlException {
        return NdlModel.createModel(spec, uniqueDM, ModelType.InMemory, null);
    }

    public static OntModel getModelFromString(String s, OntModelSpec spec, boolean uniqueDM) throws NdlException {
        assert (s != null);
        ByteArrayInputStream modelStream = new ByteArrayInputStream(s.getBytes());
        OntModel model = NdlModel.getModelFromStream(modelStream, spec, uniqueDM, ModelType.InMemory, null);
        return model;
    }

    public static OntModel getModelFromString(String s, OntModelSpec spec, boolean uniqueDM, ModelType t, String folderName) throws NdlException {
        assert (s != null);
        ByteArrayInputStream modelStream = new ByteArrayInputStream(s.getBytes());
        OntModel model = NdlModel.getModelFromStream(modelStream, spec, uniqueDM, t, folderName);
        return model;
    }

    public static OntModel getModelFromTDB(String d, OntModelSpec s) throws NdlException {
        assert (d != null);
        try {
            Dataset dataset = TDBFactory.createDataset((String)d);
            Model fileModel = dataset.getDefaultModel();
            OntModel mm = ModelFactory.createOntologyModel((OntModelSpec)s, (Model)fileModel);
            File tf = new File(d);
            ModelFolders.getInstance().put(mm, dataset, tf.getAbsolutePath(), false);
            return mm;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NdlException("Unable to get model from TDB: " + e);
        }
    }

    public static void setGlobalJenaRedirections() {
        if (globalRedirections) {
            return;
        }
        globalRedirections = true;
        ClassLoader cl = NdlCommons.class.getProtectionDomain().getClassLoader();
        OntDocumentManager dm = OntDocumentManager.getInstance();
        dm.getFileManager().addLocator((Locator)new LocatorJarURL());
        for (String s : orcaSchemaFiles) {
            dm.addAltEntry("http://geni-orca.renci.org/owl/" + s, cl.getResource("net/exogeni/orca/ndl/schema/" + s).toString());
        }
        for (String s : orcaSubstrateFiles) {
            dm.addAltEntry("http://geni-orca.renci.org/owl/" + s, cl.getResource("net/exogeni/orca/ndl/substrate/" + s).toString());
        }
        for (String s : externalSchemas.keySet()) {
            dm.addAltEntry(s, cl.getResource("net/exogeni/orca/ndl/schema/" + externalSchemas.get(s)).toString());
        }
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("http://www.w3.org/2006/time", "time.owl");
        externalSchemas = Collections.unmodifiableMap(m);
        globalTDB = true;
        globalRedirections = false;
    }

    public static class LocatorJarURL
    extends LocatorURL {
        public TypedStream open(String filenameOrURI) {
            try {
                URL u = new URL(filenameOrURI);
                if (filenameOrURI.startsWith("jar:")) {
                    JarURLConnection jarConnection = (JarURLConnection)u.openConnection();
                    return new TypedStream(jarConnection.getInputStream());
                }
                return new TypedStream(u.openStream());
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return super.open(filenameOrURI);
        }

        public String getName() {
            return "LocatorJarURL";
        }
    }

    public static enum ModelType {
        InMemory,
        TdbEphemeral,
        TdbPersistent;

    }
}

