/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import java.util.HashSet;
import java.util.Set;
import net.exogeni.orca.ndl.INdlManifestModelListener;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.NdlException;
import net.exogeni.orca.ndl.NdlModel;
import net.exogeni.orca.ndl.OntProcessor;
import net.exogeni.orca.ndl.elements.NdlPath;

public class NdlManifestParser
extends NdlCommons {
    INdlManifestModelListener listener;
    OntModel manifestModel;
    Set<Resource> nodesAndLinks = new HashSet<Resource>();

    OntModel getModel() {
        return this.manifestModel;
    }

    public NdlManifestParser(OntModel ndlManifestModel, INdlManifestModelListener l) throws NdlException {
        if (ndlManifestModel == null || l == null) {
            throw new NdlException("Null parameters to the NdlManifestParser constructor");
        }
        this.listener = l;
        this.manifestModel = ndlManifestModel;
    }

    public NdlManifestParser(String ndlManifest, INdlManifestModelListener l) throws NdlException {
        if (ndlManifest == null || l == null) {
            throw new NdlException("Null parameters to the NdlManifestParser constructor");
        }
        this.listener = l;
        this.manifestModel = NdlModel.getModelFromString(ndlManifest, null, true);
    }

    public NdlManifestParser(String ndlManifest, INdlManifestModelListener l, NdlModel.ModelType t, String folderName) throws NdlException {
        if (ndlManifest == null || l == null) {
            throw new NdlException("Null parameters to the NdlManifestParser constructor");
        }
        this.listener = l;
        this.manifestModel = NdlModel.getModelFromString(ndlManifest, null, true, t, folderName);
    }

    private boolean checkNodeOrLink(Resource r) {
        return this.nodesAndLinks.add(r);
    }

    public synchronized void processManifest() throws NdlException {
        if (this.manifestModel == null) {
            return;
        }
        HashSet<Resource> interfaces = new HashSet<Resource>();
        String query = NdlCommons.createQueryStringManifestDetails();
        ResultSet rs = OntProcessor.rdfQuery((Model)this.manifestModel, query);
        if (rs.hasNext()) {
            Resource resourceElement;
            ResultBinding result = (ResultBinding)rs.next();
            Resource man = (Resource)result.get("manifest");
            this.listener.ndlManifest(man, this.manifestModel);
            StmtIterator resEl = man.listProperties(collectionElementProperty);
            while (resEl.hasNext()) {
                Resource conItem;
                Resource ceClass;
                resourceElement = ((Statement)resEl.next()).getResource();
                if (resourceElement.hasProperty(RDF_TYPE, (RDFNode)computeElementClass) && (resourceElement.hasProperty(domainHasResourceTypeProperty, (RDFNode)vmResourceTypeClass) || resourceElement.hasProperty(domainHasResourceTypeProperty, (RDFNode)bmResourceTypeClass) || resourceElement.hasProperty(domainHasResourceTypeProperty, (RDFNode)fourtygbmResourceTypeClass))) {
                    ceClass = NdlManifestParser.getResourceType(resourceElement);
                    if (ceClass == null) {
                        ceClass = computeElementClass;
                    }
                    if (!this.checkNodeOrLink(resourceElement)) continue;
                    this.listener.ndlNode(resourceElement, this.manifestModel, ceClass, NdlManifestParser.getResourceInterfaces(resourceElement));
                    interfaces.addAll(NdlManifestParser.getResourceInterfaces(resourceElement));
                }
                if (NdlCommons.isNetworkStorage(resourceElement)) {
                    ceClass = null;
                    this.listener.ndlNode(resourceElement, this.manifestModel, ceClass, NdlManifestParser.getResourceInterfaces(resourceElement));
                    interfaces.addAll(NdlManifestParser.getResourceInterfaces(resourceElement));
                }
                if (!resourceElement.hasProperty(RDF_TYPE, (RDFNode)topologyNetworkConnectionClass) || !this.checkNodeOrLink(resourceElement)) continue;
                this.listener.ndlNetworkConnection(resourceElement, this.manifestModel, NdlManifestParser.getResourceBandwidth(resourceElement), NdlManifestParser.getResourceLatency(resourceElement), NdlManifestParser.getResourceInterfaces(resourceElement));
                NdlPath npath = new NdlPath();
                interfaces.addAll(NdlManifestParser.getResourceInterfaces(resourceElement));
                HashSet<Resource> stitchInterfaces = new HashSet<Resource>();
                StmtIterator conItemIter = resourceElement.listProperties(collectionItemProperty);
                while (conItemIter.hasNext()) {
                    conItem = ((Statement)conItemIter.next()).getResource();
                    if (conItem.hasProperty(RDF_TYPE, (RDFNode)topologyCrossConnectClass)) {
                        npath.addElement(conItem);
                    }
                    if (NdlCommons.isMulticastDevice(conItem)) {
                        npath.addRoot(conItem);
                        this.listener.ndlNode(conItem, this.manifestModel, deviceOntClass, NdlCommons.getResourceInterfaces(conItem));
                        continue;
                    }
                    if (NdlCommons.isStitchingNodeInManifest(conItem)) {
                        stitchInterfaces.addAll(NdlCommons.getResourceInterfaces(conItem));
                        this.listener.ndlNode(conItem, this.manifestModel, deviceOntClass, NdlCommons.getResourceInterfaces(conItem));
                        npath.addEndElement(conItem);
                        continue;
                    }
                    if ((!conItem.hasProperty(RDF_TYPE, (RDFNode)computeElementClass) || conItem.hasProperty(RDF_TYPE, (RDFNode)serverCloudClass)) && !conItem.hasProperty(RDF_TYPE, (RDFNode)topologyCrossConnectClass) && (!conItem.hasProperty(RDF_TYPE, (RDFNode)serverCloudClass) || !conItem.hasLiteral(numCEProperty, 1L)) || !this.checkNodeOrLink(conItem)) continue;
                    Resource ceClass2 = NdlManifestParser.getResourceType(conItem);
                    if (ceClass2 == null) {
                        ceClass2 = computeElementClass;
                    }
                    if (conItem.hasProperty(RDF_TYPE, (RDFNode)topologyCrossConnectClass)) {
                        this.listener.ndlCrossConnect(conItem, this.manifestModel, NdlManifestParser.getResourceBandwidth(conItem), NdlManifestParser.getResourceLabel(conItem), NdlManifestParser.getResourceInterfaces(conItem), resourceElement);
                    } else {
                        this.listener.ndlNode(conItem, this.manifestModel, ceClass2, NdlManifestParser.getResourceInterfaces(conItem));
                    }
                    interfaces.addAll(NdlManifestParser.getResourceInterfaces(conItem));
                }
                conItemIter = resourceElement.listProperties(collectionItemProperty);
                while (conItemIter.hasNext()) {
                    conItem = ((Statement)conItemIter.next()).getResource();
                    if (!conItem.hasProperty(RDF_TYPE, (RDFNode)topologyLinkConnectionClass)) continue;
                    npath.addElement(conItem);
                    this.listener.ndlLinkConnection(conItem, this.manifestModel, NdlManifestParser.getResourceInterfaces(conItem), resourceElement);
                    interfaces.addAll(NdlManifestParser.getResourceInterfaces(conItem));
                }
                this.listener.ndlNetworkConnectionPath(resourceElement, this.manifestModel, npath.getPaths(), npath.getRoots());
            }
            resEl = man.listProperties(collectionElementProperty);
            while (resEl.hasNext()) {
                resourceElement = ((Statement)resEl.next()).getResource();
                if (!resourceElement.hasProperty(RDF_TYPE, (RDFNode)topologyLinkConnectionClass)) continue;
                this.listener.ndlLinkConnection(resourceElement, this.manifestModel, NdlManifestParser.getResourceInterfaces(resourceElement), null);
                interfaces.addAll(NdlManifestParser.getResourceInterfaces(resourceElement));
            }
            for (Resource tmpR : interfaces) {
                query = NdlCommons.createQueryStringWhoHasInterface(tmpR);
                rs = OntProcessor.rdfQuery((Model)this.manifestModel, query);
                if (rs == null || !rs.hasNext()) continue;
                Resource conn = null;
                Resource node = null;
                while (rs.hasNext()) {
                    Resource u;
                    result = (ResultBinding)rs.next();
                    if (result == null || (u = (Resource)result.get("item")).hasProperty(RDF_TYPE, (RDFNode)topologyNetworkConnectionClass) && !u.hasProperty(RDF_TYPE, (RDFNode)topologyLinkConnectionClass) && !u.hasProperty(RDF_TYPE, (RDFNode)topologyCrossConnectClass)) continue;
                    if (u.hasProperty(RDF_TYPE, (RDFNode)topologyLinkConnectionClass) || u.hasProperty(RDF_TYPE, (RDFNode)topologyCrossConnectClass)) {
                        if (conn != null) continue;
                        conn = u;
                        continue;
                    }
                    if (node != null) continue;
                    node = u;
                }
                Statement locIPStmt = tmpR.getProperty(ip4LocalIPAddressProperty);
                if (locIPStmt != null) {
                    this.listener.ndlInterface(tmpR, this.manifestModel, conn, node, NdlManifestParser.getAddressIP(locIPStmt.getResource()), NdlManifestParser.getAddressNetmask(locIPStmt.getResource()));
                    continue;
                }
                this.listener.ndlInterface(tmpR, this.manifestModel, conn, node, null, null);
            }
            this.listener.ndlParseComplete();
        }
    }

    public synchronized void freeModel() {
        NdlModel.closeModel(this.manifestModel);
        this.manifestModel = null;
    }
}

