/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.NdlException;
import net.exogeni.orca.ndl.NdlModel;
import net.exogeni.orca.ndl.NdlModifyParser;
import net.exogeni.orca.ndl.NdlRequestParser;
import net.exogeni.orca.ndl.OntProcessor;
import net.exogeni.orca.util.CompressEncode;
import org.apache.log4j.Logger;

public class NdlGenerator {
    private static final String MODIFY_NS = "modify";
    private static final String REQUEST_NS = "request";
    private static final String XML_SCHEMA_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    private static final String STITCHING_DOMAIN_URL = "http://geni-orca.renci.org/owl/orca.rdf#Stitching/Domain";
    private Logger l;
    public static final Set<String> externalSchemas = NdlModel.externalSchemas.keySet();
    protected OntModel blank;
    private ReferenceModel ref = null;
    protected String requestId;

    private void setRequestId(String req) {
        this.requestId = req;
    }

    private static String massageName(String nm) {
        try {
            return URLEncoder.encode(nm, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return nm;
        }
    }

    public NdlGenerator(Logger log) {
        this.l = log;
        this.l.info((Object)"Initializing reference model");
        this.ref = new ReferenceModel();
        this.initializeRequest(null);
    }

    public NdlGenerator(String guid, Logger log) {
        this.l = log;
        this.l.info((Object)"Initializing reference model");
        this.ref = new ReferenceModel();
        this.initializeRequest(guid);
    }

    public NdlGenerator(String guid, Logger log, boolean modify) {
        this.l = log;
        this.l.info((Object)"Initializing reference model");
        this.ref = new ReferenceModel();
        if (!modify) {
            this.initializeRequest(guid);
        } else {
            this.initializeModify(guid);
        }
    }

    public NdlGenerator(NdlRequestParser p, Logger log) throws NdlException {
        this.l = log;
        this.l.info((Object)"Initializing model from parser");
        this.blank = p.getModel();
        this.ref = new ReferenceModel();
        String nsUri = this.blank.getNsPrefixURI(REQUEST_NS);
        if (nsUri == null) {
            throw new NdlException("Model in NdlRequestParser doesn't contain request namespace!");
        }
        this.requestId = nsUri.replace("http://geni-orca.renci.org/owl/", "");
        this.requestId = this.requestId.replace("#", "");
    }

    public NdlGenerator(NdlModifyParser p, Logger log) throws NdlException {
        this.l = log;
        this.l.info((Object)"Initializing model from parser");
        this.blank = p.getModel();
        this.ref = new ReferenceModel();
        String nsUri = this.blank.getNsPrefixURI(MODIFY_NS);
        if (nsUri == null) {
            throw new NdlException("Model in NdlModifyParser doesn't contain modify namespace!");
        }
        this.requestId = nsUri.replace("http://geni-orca.renci.org/owl/", "");
        this.requestId = this.requestId.replace("#", "");
    }

    public void done() {
        this.ref.done();
        if (this.blank != null) {
            this.blank.close();
            this.blank = null;
        }
    }

    protected void finalize() {
        this.done();
    }

    public OntModel getWorkingModel() {
        return this.blank;
    }

    private void initializeModify(String guid) {
        this.blank = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        NdlCommons.setPrefix(this.blank);
        this.blank.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.blank.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.blank.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        this.blank.setNsPrefix("time", "http://www.w3.org/2006/time#");
        this.requestId = guid == null ? UUID.randomUUID().toString() : guid;
        this.blank.setNsPrefix(MODIFY_NS, "http://geni-orca.renci.org/owl/" + this.requestId + "#");
    }

    private void initializeRequest(String guid) {
        this.blank = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        NdlCommons.setPrefix(this.blank);
        this.blank.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.blank.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.blank.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        this.blank.setNsPrefix("time", "http://www.w3.org/2006/time#");
        this.requestId = guid == null ? UUID.randomUUID().toString() : guid;
        this.blank.setNsPrefix(REQUEST_NS, "http://geni-orca.renci.org/owl/" + this.requestId + "#");
    }

    private Individual addIndividual(String indName, String prefix, String clsName) throws NdlException {
        assert (indName != null);
        assert (prefix != null);
        assert (clsName != null);
        OntClass cls = this.ref.getOntClass(this.ref.getNsPrefixUri(prefix) + clsName);
        if (null == cls) {
            throw new NdlException("Unable to find class " + clsName);
        }
        return this.blank.createIndividual("http://geni-orca.renci.org/owl/" + indName, (Resource)cls);
    }

    private Individual addAnonIndividual(String prefix, String clsName) throws NdlException {
        assert (prefix != null);
        assert (clsName != null);
        OntClass cls = this.ref.getOntClass(this.ref.getNsPrefixUri(prefix) + clsName);
        if (null == cls) {
            throw new NdlException("Unable to find class " + clsName);
        }
        return this.blank.createIndividual((Resource)cls);
    }

    private Individual addUniqueIndividual(String indName, String prefix, String clsName) throws NdlException {
        assert (indName != null);
        assert (prefix != null);
        assert (clsName != null);
        OntClass cls = this.ref.getOntClass(this.ref.getNsPrefixUri(prefix) + clsName);
        if (null == cls) {
            throw new NdlException("Unable to find class " + clsName);
        }
        if (this.blank.getIndividual("http://geni-orca.renci.org/owl/" + indName) != null) {
            throw new NdlException("Attempting to create a resource that already exists in the model: " + indName);
        }
        return this.blank.createIndividual("http://geni-orca.renci.org/owl/" + indName, (Resource)cls);
    }

    private Resource addProperty(Individual i, String prefix, String pName, String uri) throws NdlException {
        assert (i != null);
        assert (prefix != null);
        assert (pName != null);
        assert (uri != null);
        Property pr = this.ref.getProperty(this.ref.getNsPrefixUri(prefix) + pName);
        if (null == pr) {
            throw new NdlException("Unable to find property " + pName);
        }
        return i.addProperty(pr, (RDFNode)this.blank.getResource(uri));
    }

    private Resource addProperty(Individual i, String prefix, String pName, RDFNode n) throws NdlException {
        assert (i != null);
        assert (prefix != null);
        assert (pName != null);
        assert (n != null);
        Property pr = this.ref.getProperty(this.ref.getNsPrefixUri(prefix) + pName);
        if (null == pr) {
            throw new NdlException("Unable to find property " + pName);
        }
        return i.addProperty(pr, n);
    }

    private void removeProperty(Individual i, String prefix, String pName, String toRemove) throws NdlException {
        assert (i != null);
        assert (prefix != null);
        assert (pName != null);
        assert (toRemove != null);
        Property pr = this.ref.getProperty(this.ref.getNsPrefixUri(prefix) + pName);
        if (null == pr) {
            throw new NdlException("Unable to find property " + pName);
        }
        i.removeProperty(pr, (RDFNode)this.blank.getResource(toRemove));
    }

    private Resource addProperty(Individual i, Property p, Resource ob) throws NdlException {
        assert (i != null);
        assert (p != null);
        assert (ob != null);
        return i.addProperty(p, (RDFNode)ob);
    }

    public Resource addTypedProperty(Individual i, String prefix, String pName, String val, RDFDatatype type) throws NdlException {
        if (null == i) {
            throw new IllegalArgumentException("Individual `i` cannot be null");
        }
        DatatypeProperty dpr = this.ref.getDataTypeProperty(this.ref.getNsPrefixUri(prefix) + pName);
        if (null == dpr) {
            throw new NdlException("Unable to find datatype property " + pName);
        }
        return i.addProperty((Property)dpr, val, type);
    }

    public Resource addSimpleProperty(Individual i, String prefix, String pName, String val) throws NdlException {
        if (null == i) {
            throw new IllegalArgumentException("Individual `i` cannot be null");
        }
        Property pr = this.ref.getProperty(this.ref.getNsPrefixUri(prefix) + pName);
        return i.addProperty(pr, val);
    }

    private Literal addTypedLiteral(String s, String typeURI) throws NdlException {
        return this.blank.createTypedLiteral(s, typeURI);
    }

    public Individual declareComputeElement(String name) throws NdlException {
        Individual in = this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(name), "compute", "ComputeElement");
        return in;
    }

    public Individual declareModifiedComputeElement(String url, String guid) throws NdlException {
        OntClass cls = this.ref.getOntClass(this.ref.getNsPrefixUri("compute") + "ComputeElement");
        if (null == cls) {
            throw new NdlException("Unable to find class compute:ComputeElement");
        }
        Individual in = this.blank.createIndividual(url, (Resource)cls);
        if (guid != null) {
            this.addGuid(in, guid);
        }
        this.addTypedProperty(in, "modify-schema", "isModify", "true", (RDFDatatype)XSDDatatype.XSDboolean);
        return in;
    }

    public Individual declareStitchingNode(String name) throws NdlException {
        Individual in = this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(name), "topology", "Device");
        this.addProperty(in, "request-schema", "inDomain", STITCHING_DOMAIN_URL);
        return in;
    }

    public Individual declareISCSIStorageNode(String name) throws NdlException {
        Individual in = this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(name), "storage", "ISCSI");
        this.addProperty(in, "domain", "hasResourceType", "http://geni-orca.renci.org/owl/storage.owl#LUN");
        return in;
    }

    public Individual declareISCSIStorageNode(String name, long capacity, String fstype, String fsparam, String fsmntpoint, boolean doFormat) throws NdlException {
        Individual in = this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(name), "storage", "ISCSI");
        this.addProperty(in, "domain", "hasResourceType", "http://geni-orca.renci.org/owl/storage.owl#LUN");
        this.addTypedProperty(in, "storage", "storageCapacity", capacity + "", TypeMapper.getInstance().getTypeByName(XML_SCHEMA_INTEGER));
        if (fstype != null) {
            this.addTypedProperty(in, "storage", "hasFSType", fstype, (RDFDatatype)XSDDatatype.XSDstring);
        }
        if (fsparam != null) {
            this.addTypedProperty(in, "storage", "hasFSParam", fsparam, (RDFDatatype)XSDDatatype.XSDstring);
        }
        if (fsmntpoint != null) {
            this.addTypedProperty(in, "storage", "hasMntPoint", fsmntpoint, (RDFDatatype)XSDDatatype.XSDstring);
        }
        this.addTypedProperty(in, "storage", "doFormat", "" + doFormat, (RDFDatatype)XSDDatatype.XSDboolean);
        return in;
    }

    public Individual declareServerCloud(String name, boolean splittable) throws NdlException {
        Individual ind = this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(name), "compute", "ServerCloud");
        this.addTypedProperty(ind, "topology", "splittable", "" + splittable, (RDFDatatype)XSDDatatype.XSDboolean);
        this.addSimpleProperty(ind, REQUEST_NS, "groupName", NdlGenerator.massageName(name));
        return ind;
    }

    public Individual declareServerCloud(String name) throws NdlException {
        Individual group = this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(name), "compute", "ServerCloud");
        this.addSimpleProperty(group, REQUEST_NS, "groupName", NdlGenerator.massageName(name));
        return group;
    }

    public Individual declareInterface(String name) throws NdlException {
        return this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(name), "topology", "Interface");
    }

    public Individual declareExistingInterface(String url) throws NdlException {
        OntClass cls = this.ref.getOntClass(this.ref.getNsPrefixUri("topology") + "Interface");
        if (null == cls) {
            throw new NdlException("Unable to find class Interface");
        }
        return this.blank.createIndividual(url, (Resource)cls);
    }

    public Individual declareStitchportInterface(String url, String label) throws NdlException {
        Individual retI = this.declareExistingInterface(this.generateStitchPortInterfaceUrl(url, label));
        this.addLabelToIndividual(retI, label);
        Individual intM = this.declareExistingInterface(url);
        this.addEthernetAdaptation(intM, retI);
        return retI;
    }

    private String generateStitchPortInterfaceUrl(String url, String label) throws NdlException {
        if (url == null || label == null) {
            throw new NdlException("Stitchport does not specify URL or label");
        }
        if (url.endsWith("/")) {
            return url + label;
        }
        return url + "/" + label;
    }

    public Individual declareDiskImage(String url, String guid) throws NdlException {
        if (url == null || guid == null) {
            throw new NdlException("Both image url and guid must be specified");
        }
        Individual vmIm = this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(guid), "compute", "DiskImage");
        this.addSimpleProperty(vmIm, "topology", "hasGUID", guid);
        this.addSimpleProperty(vmIm, "topology", "hasURL", url);
        return vmIm;
    }

    public Individual declareDiskImage(String url, String guid, String shortName) throws NdlException {
        if (url == null || guid == null || shortName == null) {
            throw new NdlException("Image url, guid and short name must be specified");
        }
        Individual vmIm = this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(shortName), "compute", "DiskImage");
        this.addSimpleProperty(vmIm, "topology", "hasGUID", guid);
        this.addSimpleProperty(vmIm, "topology", "hasURL", url);
        this.addTypedProperty(vmIm, "topology", "hasName", shortName, (RDFDatatype)XSDDatatype.XSDstring);
        return vmIm;
    }

    public Individual addLayerToConnection(Individual conn, String prefix, String layer) throws NdlException {
        if (null == conn) {
            throw new IllegalArgumentException("Individual `conn` cannot be null");
        }
        this.addProperty(conn, "layer", "atLayer", this.ref.getOntClass(this.ref.getNsPrefixUri(prefix) + layer).getURI());
        return conn;
    }

    public Individual addBandwidthToConnection(Individual conn, Long bandwidth) throws NdlException {
        if (null == conn) {
            throw new IllegalArgumentException("Individual `conn` cannot be null");
        }
        this.addTypedProperty(conn, "layer", "bandwidth", bandwidth.toString(), TypeMapper.getInstance().getTypeByName(XML_SCHEMA_INTEGER));
        return conn;
    }

    public Individual declareNetworkConnection(String name) throws NdlException {
        Individual conn = this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(name), "topology", "NetworkConnection");
        return conn;
    }

    public Individual declareBroadcastConnection(String name) throws NdlException {
        Individual conn = this.addIndividual(this.requestId + "#" + NdlGenerator.massageName(name), "topology", "BroadcastConnection");
        return conn;
    }

    public Individual declareModifiedBroadcastConnection(String url) throws NdlException {
        OntClass cls = this.ref.getOntClass(this.ref.getNsPrefixUri("topology") + "BroadcastConnection");
        if (null == cls) {
            throw new NdlException("Unable to find class topology:BroadcastConnection");
        }
        Individual in = this.blank.createIndividual(url, (Resource)cls);
        this.addTypedProperty(in, "modify-schema", "isModify", "true", (RDFDatatype)XSDDatatype.XSDboolean);
        return in;
    }

    public void addLabelToIndividual(Individual c, String label) throws NdlException {
        if (null == c) {
            throw new IllegalArgumentException("Individual `c` cannot be null");
        }
        Individual lab = this.addIndividual(this.requestId + "#Label-" + NdlGenerator.massageName(label), "layer", "Label");
        this.addTypedProperty(lab, "layer", "label_ID", label, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#Literal"));
        this.addProperty(c, "layer", "label", lab.getURI());
    }

    public void addRDFSLabelToIndividual(Individual c, String label) throws NdlException {
        if (null == c) {
            throw new IllegalArgumentException("Individual `c` cannot be null");
        }
        this.addTypedProperty(c, "rdfs", "label", label, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#Literal"));
    }

    public void addInterfaceToIndividual(Individual iface, Individual ind) throws NdlException {
        if (null == iface) {
            throw new IllegalArgumentException("Individual `iface` cannot be null");
        }
        if (null == ind) {
            throw new IllegalArgumentException("Individual `ind` cannot be null");
        }
        this.addProperty(ind, "topology", "hasInterface", iface.getURI());
    }

    public void removeInterfaceFromIndividual(String iface, Individual ind) throws NdlException {
        if (null == iface) {
            throw new IllegalArgumentException("Individual `iface` cannot be null");
        }
        if (null == ind) {
            throw new IllegalArgumentException("Individual `ind` cannot be null");
        }
        this.removeProperty(ind, "topology", "hasInterface", iface);
    }

    public Individual addIPToIndividual(String ip, Individual ind) throws NdlException {
        ind.removeAll(NdlCommons.ip4LocalIPAddressProperty);
        String indName = this.requestId + "#ip-" + ip.replace('.', '-');
        Individual ipInd = this.addIndividual(indName, "ip4", "IPAddress");
        this.addTypedProperty(ipInd, "layer", "label_ID", ip, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#Literal"));
        this.addProperty(ind, "ip4", "localIPAddress", ipInd.getURI());
        return ipInd;
    }

    public Individual addUniqueIPToIndividual(String ip, String name, Individual ind) throws NdlException {
        if (null == ind) {
            throw new IllegalArgumentException("Individual `ind` cannot be null");
        }
        ind.removeAll(NdlCommons.ip4LocalIPAddressProperty);
        String indName = this.requestId + "#" + NdlGenerator.massageName(name) + "-ip-" + ip.replace('.', '-');
        Individual ipInd = this.addUniqueIndividual(indName, "ip4", "IPAddress");
        this.addTypedProperty(ipInd, "layer", "label_ID", ip, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#Literal"));
        this.addProperty(ind, "ip4", "localIPAddress", ipInd.getURI());
        return ipInd;
    }

    public void addNetmaskToIP(Individual ip, String netmask) throws NdlException {
        if (null == ip) {
            throw new IllegalArgumentException("Individual `ip` cannot be null");
        }
        this.addTypedProperty(ip, "ip4", "netmask", netmask, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#Literal"));
    }

    public void setInterfaceIP(String ip, Individual intf) throws NdlException {
        if (null == intf) {
            throw new IllegalArgumentException("Individual `intf` cannot be null");
        }
        Statement s = intf.getProperty(NdlCommons.ip4LocalIPAddressProperty);
        Individual ipInd = null;
        if (s != null) {
            ipInd = this.blank.getIndividual(s.getResource().getURI());
            ipInd.removeAll(NdlCommons.layerLabelIdProperty);
        } else {
            ipInd = this.addIndividual("ip-" + UUID.randomUUID().toString(), "ip4", "IPAddress");
            this.addProperty(intf, "ip4", "localIPAddress", ipInd.getURI());
        }
        this.addTypedProperty(ipInd, "layer", "label_ID", ip, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#Literal"));
    }

    public void setInterfaceNetmask(String nm, Individual intf) throws NdlException {
        if (null == intf) {
            throw new IllegalArgumentException("Individual `intf` cannot be null");
        }
        Statement s = intf.getProperty(NdlCommons.ip4LocalIPAddressProperty);
        Individual ipInd = null;
        if (s != null) {
            ipInd = this.blank.getIndividual(s.getResource().getURI());
            ipInd.removeAll(NdlCommons.ip4NetmaskProperty);
        } else {
            ipInd = this.addIndividual("ip-" + UUID.randomUUID().toString(), "ip4", "IPAddress");
            this.addProperty(intf, "ip4", "localIPAddress", ipInd.getURI());
        }
        this.addTypedProperty(ipInd, "ip4", "netmask", nm, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#Literal"));
    }

    public void addNameToInterface(String interfaceName, Individual intf) throws NdlException {
        if (interfaceName != null) {
            this.addTypedProperty(intf, "topology", "hostInterfaceName", interfaceName, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#Literal"));
        }
    }

    public void addPropertiesToStorage(long capacity, String fstype, String fsparam, String fsmntpoint, boolean doFormat, Individual in) throws NdlException {
        if (null == in) {
            throw new IllegalArgumentException("Individual `in` cannot be null");
        }
        this.addTypedProperty(in, "storage", "storageCapacity", capacity + "", TypeMapper.getInstance().getTypeByName(XML_SCHEMA_INTEGER));
        if (fstype != null) {
            this.addTypedProperty(in, "storage", "hasFSType", fstype, (RDFDatatype)XSDDatatype.XSDstring);
        }
        if (fsparam != null) {
            this.addTypedProperty(in, "storage", "hasFSParam", fsparam, (RDFDatatype)XSDDatatype.XSDstring);
        }
        if (fsmntpoint != null) {
            this.addTypedProperty(in, "storage", "hasMntPoint", fsmntpoint, (RDFDatatype)XSDDatatype.XSDstring);
        }
        this.addTypedProperty(in, "storage", "doFormat", "" + doFormat, (RDFDatatype)XSDDatatype.XSDboolean);
    }

    public void addURNToIndividual(Individual ind, String urn) throws NdlException {
        if (null == ind) {
            throw new IllegalArgumentException("Individual `ind` cannot be null");
        }
        this.addTypedProperty(ind, "topology", "hasURN", urn, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#anyURI"));
    }

    public Individual declareTermBeginning(Date date) throws NdlException {
        if (null == date) {
            throw new IllegalArgumentException("Date cannot be null");
        }
        Individual res = this.addIndividual(this.requestId + "#TermBeginning", "time", "Instant");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.addTypedProperty(res, "time", "inXSDDateTime", DatatypeConverter.printDateTime((Calendar)cal), TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#dateTime"));
        return res;
    }

    public Individual declareTermEnd(Date date) throws NdlException {
        if (null == date) {
            throw new IllegalArgumentException("Date cannot be null");
        }
        Individual res = this.addIndividual(this.requestId + "#TermEnd", "time", "Instant");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.addTypedProperty(res, "time", "inXSDDateTime", DatatypeConverter.printDateTime((Calendar)cal), TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#dateTime"));
        return res;
    }

    private void addToTerm(Individual term, long dur, int units) throws NdlException {
        if (null == term) {
            throw new IllegalArgumentException("Individual `term` cannot be null");
        }
        switch (units) {
            case 1: {
                this.addTypedProperty(term, "time", "years", "" + dur, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#decimal"));
                break;
            }
            case 2: {
                this.addTypedProperty(term, "time", "months", "" + dur, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#decimal"));
                break;
            }
            case 6: {
                this.addTypedProperty(term, "time", "days", "" + dur, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#decimal"));
                break;
            }
            case 10: {
                this.addTypedProperty(term, "time", "hours", "" + dur, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#decimal"));
                break;
            }
            case 12: {
                this.addTypedProperty(term, "time", "minutes", "" + dur, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#decimal"));
                break;
            }
            case 13: {
                this.addTypedProperty(term, "time", "seconds", "" + dur, TypeMapper.getInstance().getTypeByName("http://www.w3.org/2001/XMLSchema#decimal"));
                break;
            }
            default: {
                throw new NdlException("declareTermDuration: unknown units, only YEAR, MONTH, DAY_OF_YEAR (DAY), HOUR, MINUTE and SECOND are allowed");
            }
        }
    }

    public Individual declareTermDuration(long dur, int units) throws NdlException {
        Individual res = this.addIndividual(this.requestId + "#TermDuration", "time", "DurationDescription");
        this.addToTerm(res, dur, units);
        return res;
    }

    public Individual declareTermDuration(long d, long hr, long min) throws NdlException {
        Individual t = this.addIndividual(this.requestId + "#TermDuration", "time", "DurationDescription");
        if (d > 0L) {
            this.addToTerm(t, d, 6);
        }
        if (hr > 0L) {
            this.addToTerm(t, hr, 10);
        }
        if (min > 0L) {
            this.addToTerm(t, min, 12);
        }
        return t;
    }

    public Individual declareTerm() throws NdlException {
        Individual res = this.addIndividual(this.requestId + "#Term", "time", "Interval");
        return res;
    }

    public void addBeginningToTerm(Individual begI, Individual termI) throws NdlException {
        if (null == begI) {
            throw new IllegalArgumentException("Individual begI cannot be null");
        }
        if (null == termI) {
            throw new IllegalArgumentException("Individual termI cannot be null");
        }
        this.addProperty(termI, "time", "hasBeginning", begI.getURI());
    }

    public void addEndToTerm(Individual endI, Individual termI) throws NdlException {
        if (null == endI) {
            throw new IllegalArgumentException("Individual endI cannot be null");
        }
        if (null == termI) {
            throw new IllegalArgumentException("Individual termI cannot be null");
        }
        this.addProperty(termI, "time", "hasEnd", endI.getURI());
    }

    public void addDurationToTerm(Individual durI, Individual termI) throws NdlException {
        if (null == durI) {
            throw new IllegalArgumentException("Individual durI cannot be null");
        }
        if (null == termI) {
            throw new IllegalArgumentException("Individual termI cannot be null");
        }
        this.addProperty(termI, "time", "hasDurationDescription", durI.getURI());
    }

    public Individual declareReservation(Date start, Date end) throws NdlException {
        Individual res = this.addIndividual(this.requestId + "#", "request-schema", "Reservation");
        Individual term = this.declareTerm();
        this.addBeginningToTerm(this.declareTermBeginning(start), term);
        this.addEndToTerm(this.declareTermEnd(end), term);
        this.addTermToReservation(term, res);
        return res;
    }

    public Individual declareReservation(Date start, long dur, int units) throws NdlException {
        Individual res = this.addIndividual(this.requestId + "#", "request-schema", "Reservation");
        Individual term = this.declareTerm();
        this.addDurationToTerm(this.declareTermDuration(dur, units), term);
        this.addTermToReservation(term, res);
        return res;
    }

    public Individual declareReservation() throws NdlException {
        Individual res = this.addIndividual(this.requestId + "#", "request-schema", "Reservation");
        return res;
    }

    public Individual declareModifyReservation(String name) throws NdlException {
        Individual mres = this.addIndividual(this.requestId + "#" + name, "modify-schema", "ModifyReservation");
        if (name != null) {
            this.addTypedProperty(mres, "topology", "hasName", name, (RDFDatatype)XSDDatatype.XSDstring);
        }
        return mres;
    }

    public Individual declareModifyElementNGIncreaseBy(Individual mresI, String ngUrl, Integer count) throws NdlException {
        if (null == mresI) {
            throw new IllegalArgumentException("Individual mresI cannot be null");
        }
        if (ngUrl == null) {
            throw new NdlException("Group URL cannot be null");
        }
        Individual melI = null;
        melI = this.addIndividual(this.requestId + "#modifyElement/" + UUID.randomUUID().toString(), "modify-schema", "ModifyElement");
        this.addProperty(mresI, "collections", "element", melI.getURI());
        this.addProperty(melI, "modify-schema", "modifySubject", ngUrl);
        this.addTypedProperty(melI, "modify-schema", "increaseBy", count.toString(), (RDFDatatype)XSDDatatype.XSDinteger);
        return melI;
    }

    public Individual declareModifyElementNGDeleteNode(Individual mresI, String ngUrl, String nodeUrl) throws NdlException {
        if (null == mresI) {
            throw new IllegalArgumentException("Individual mresI cannot be null");
        }
        if (ngUrl == null || nodeUrl == null) {
            throw new NdlException("Group URL and node URL must not be null");
        }
        Individual melI = null;
        melI = this.addIndividual(this.requestId + "#modifyElement/" + UUID.randomUUID().toString(), "modify-schema", "ModifyElement");
        this.addProperty(mresI, "collections", "element", melI.getURI());
        this.addProperty(melI, "modify-schema", "modifySubject", ngUrl);
        this.addProperty(melI, "modify-schema", "removeElement", nodeUrl);
        return melI;
    }

    public Individual declareModifyElementRemoveNode(Individual mresI, String elUrl, String guid) throws NdlException {
        if (null == mresI) {
            throw new IllegalArgumentException("Individual mresI cannot be null");
        }
        Individual el = this.blank.getIndividual(elUrl);
        if (el == null) {
            OntClass cls = this.ref.getOntClass(this.ref.getNsPrefixUri("compute") + "ComputeElement");
            el = this.blank.createIndividual(elUrl, (Resource)cls);
        }
        if (guid != null) {
            this.addGuid(el, guid);
        }
        return this.doModifyElement(mresI, el, "removeElement");
    }

    public Individual declareModifyElementRemoveLink(Individual mresI, String elUrl, String guid) throws NdlException {
        if (null == mresI) {
            throw new IllegalArgumentException("Individual mresI cannot be null");
        }
        Individual el = this.blank.getIndividual(elUrl);
        if (el == null) {
            OntClass cls = this.ref.getOntClass(this.ref.getNsPrefixUri("topology") + "NetworkConnection");
            el = this.blank.createIndividual(elUrl, (Resource)cls);
        }
        if (guid != null) {
            this.addGuid(el, guid);
        }
        return this.doModifyElement(mresI, el, "removeElement");
    }

    public Individual declareModifyElementRemoveElement(Individual mresI, Individual el) throws NdlException {
        return this.doModifyElement(mresI, el, "removeElement");
    }

    protected Individual doModifyElement(Individual mresI, Individual el, String modifyAction) throws NdlException {
        if (null == mresI) {
            throw new IllegalArgumentException("Individual mresI cannot be null");
        }
        if (null == el) {
            throw new IllegalArgumentException("Individual el cannot be null");
        }
        Individual melI = this.addIndividual(this.requestId + "#modifyElement/" + UUID.randomUUID().toString(), "modify-schema", "ModifyElement");
        this.addProperty(mresI, "collections", "element", melI.getURI());
        this.addProperty(melI, "modify-schema", "modifySubject", el.getURI());
        this.addProperty(melI, "modify-schema", modifyAction, el.getURI());
        return melI;
    }

    public Individual declareModifyElementAddElement(Individual mresI, Individual el) throws NdlException {
        return this.doModifyElement(mresI, el, "addElement");
    }

    public Individual declareModifyElementModifyNode(Individual mresI, Individual node) throws NdlException {
        return this.doModifyElement(mresI, node, "modifyElement");
    }

    public Individual declareSlice(String sname) throws NdlException {
        Individual s = this.addUniqueIndividual(this.requestId + "#" + NdlGenerator.massageName(sname), "geni", "Slice");
        this.addTypedProperty(s, "topology", "hasName", sname, (RDFDatatype)XSDDatatype.XSDstring);
        return s;
    }

    public Individual declareOfSlice(String sname) throws NdlException {
        Individual s = this.addUniqueIndividual(this.requestId + "#" + NdlGenerator.massageName(sname), "openflow", "OFSlice");
        this.addTypedProperty(s, "topology", "hasName", sname, (RDFDatatype)XSDDatatype.XSDstring);
        return s;
    }

    public Individual declareOfController(String name, String url) throws NdlException {
        Individual c = this.addUniqueIndividual(this.requestId + "#" + NdlGenerator.massageName(name), "openflow", "OFController");
        this.addTypedProperty(c, "topology", "hasURL", url, (RDFDatatype)XSDDatatype.XSDanyURI);
        return c;
    }

    public Individual declareTCPProxy(String suffix) throws NdlException {
        Individual prx = this.addUniqueIndividual(this.requestId + "#" + NdlGenerator.massageName(suffix), "domain", "TCPProxy");
        return prx;
    }

    public void addProxyToIndividual(Individual proxy, Individual resI) throws NdlException {
        if (null == proxy) {
            throw new IllegalArgumentException("Individual proxy cannot be null");
        }
        if (null == resI) {
            throw new IllegalArgumentException("Individual resI cannot be null");
        }
        this.addProperty(resI, "domain", "proxy", proxy.getURI());
    }

    public void addResourceToReservation(Individual resI, Individual toAdd) throws NdlException {
        if (null == resI) {
            throw new IllegalArgumentException("Individual resI cannot be null");
        }
        if (null == toAdd) {
            throw new IllegalArgumentException("Individual toAdd cannot be null");
        }
        this.addProperty(resI, "collections", "element", toAdd.getURI());
    }

    public void addSliceToReservation(Individual resI, Individual sl) throws NdlException {
        if (null == resI) {
            throw new IllegalArgumentException("Individual resI cannot be null");
        }
        if (null == sl) {
            throw new IllegalArgumentException("Individual sl cannot be null");
        }
        this.addProperty(resI, "geni", "slice", sl.getURI());
    }

    public void addDiskImageToIndividual(Individual diskImage, Individual resI) throws NdlException {
        if (null == diskImage) {
            throw new IllegalArgumentException("Individual diskImage cannot be null");
        }
        if (null == resI) {
            throw new IllegalArgumentException("Individual resI cannot be null");
        }
        this.addProperty(resI, "compute", "diskImage", diskImage.getURI());
    }

    public void addDependOnToIndividual(Individual dependency, Individual ind) throws NdlException {
        if (null == dependency) {
            throw new IllegalArgumentException("Individual dependency cannot be null");
        }
        if (null == ind) {
            throw new IllegalArgumentException("Individual ind cannot be null");
        }
        this.addProperty(ind, "request-schema", "dependOn", dependency.getURI());
    }

    public void addTermToReservation(Individual termI, Individual resI) throws NdlException {
        if (null == termI) {
            throw new IllegalArgumentException("Individual termI cannot be null");
        }
        if (null == resI) {
            throw new IllegalArgumentException("Individual resI cannot be null");
        }
        this.addProperty(resI, "request-schema", "hasTerm", termI.getURI());
    }

    public Individual getRequestIndividual(String name) {
        return this.blank.getIndividual("http://geni-orca.renci.org/owl/" + this.requestId + "#" + NdlGenerator.massageName(name));
    }

    public Individual getNonrequestIndividual(String name) {
        return this.blank.getIndividual("http://geni-orca.renci.org/owl/" + name);
    }

    public Individual declareDomain(String name) throws NdlException {
        return this.addIndividual(name + "/Domain", "topology", "NetworkDomain");
    }

    public void addOpenFlowCapable(Individual res, String version) throws NdlException {
        if (null == res) {
            throw new IllegalArgumentException("Individual res cannot be null");
        }
        if ("1.0".equals(version)) {
            this.addProperty(res, NdlCommons.openflowCapableProperty, NdlCommons.openflowV1_0Ind);
        } else if ("1.1".equals(version)) {
            this.addProperty(res, NdlCommons.openflowCapableProperty, NdlCommons.openflowV1_1Ind);
        } else if ("1.2".equals(version)) {
            this.addProperty(res, NdlCommons.openflowCapableProperty, NdlCommons.openflowV1_2Ind);
        }
    }

    public void addNodeToDomain(Individual dom, Individual node) throws NdlException {
        if (null == dom) {
            throw new IllegalArgumentException("Individual dom cannot be null");
        }
        if (null == node) {
            throw new IllegalArgumentException("Individual node cannot be null");
        }
        this.addProperty(node, "request-schema", "inDomain", dom.getURI());
    }

    public void addDomainToIndividual(Individual dom, Individual ind) throws NdlException {
        if (null == dom) {
            throw new IllegalArgumentException("Individual dom cannot be null");
        }
        if (null == ind) {
            throw new IllegalArgumentException("Individual ind cannot be null");
        }
        this.addProperty(ind, "request-schema", "inDomain", dom.getURI());
    }

    public void addNodeTypeToCE(String ns, String tp, Individual node) throws NdlException {
        if (null == node) {
            throw new IllegalArgumentException("Individual node cannot be null");
        }
        this.addProperty(node, "compute", "specificCE", this.ref.getNsPrefixUri(ns) + tp);
    }

    public void removeNodeTypeFromCE(String ns, String tp, Individual node) throws NdlException {
        if (null == node) {
            throw new IllegalArgumentException("Individual node cannot be null");
        }
        Property pr = this.ref.getProperty(this.ref.getNsPrefixUri("compute") + "specificCE");
        if (null == pr) {
            throw new NdlException("Unable to find property specificCE");
        }
        node.removeProperty(pr, (RDFNode)this.blank.getResource(this.ref.getNsPrefixUri(ns) + tp));
    }

    public void removeNodeTypeFromCE(Individual node) throws NdlException {
        if (null == node) {
            throw new IllegalArgumentException("Individual node cannot be null");
        }
        Property pr = this.ref.getProperty(this.ref.getNsPrefixUri("compute") + "specificCE");
        if (null == pr) {
            throw new NdlException("Unable to find property specificCE");
        }
        node.removeAll(pr);
    }

    public void addPostBootScriptToCE(String pbscript, Individual node) throws NdlException {
        if (null == node) {
            throw new IllegalArgumentException("Individual node cannot be null");
        }
        this.addTypedProperty(node, "request-schema", "postBootScript", pbscript, (RDFDatatype)XSDDatatype.XSDstring);
    }

    public void addPortToProxy(String port, Individual prx) throws NdlException {
        if (null == prx) {
            throw new IllegalArgumentException("Individual prx cannot be null");
        }
        this.addTypedProperty(prx, "topology", "proxiedPort", port, (RDFDatatype)XSDDatatype.XSDunsignedShort);
    }

    public void addPortToProxy(String port, String newPort, String newIp, Individual prx) throws NdlException {
        if (null == prx) {
            throw new IllegalArgumentException("Individual prx cannot be null");
        }
        this.addTypedProperty(prx, "topology", "proxiedPort", port, (RDFDatatype)XSDDatatype.XSDunsignedShort);
        this.addTypedProperty(prx, "topology", "managementIP", newIp, (RDFDatatype)XSDDatatype.XSDstring);
        this.addTypedProperty(prx, "topology", "managementPort", newPort, (RDFDatatype)XSDDatatype.XSDstring);
    }

    public void addNumCEsToCluster(Integer ns, Individual cluster) throws NdlException {
        if (null == ns) {
            throw new IllegalArgumentException("Individual ns cannot be null");
        }
        if (null == cluster) {
            throw new IllegalArgumentException("Individual cluster cannot be null");
        }
        this.addTypedProperty(cluster, "layer", "numCE", ns.toString(), (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public void addVMDomainProperty(Individual cluster) throws NdlException {
        if (null == cluster) {
            throw new IllegalArgumentException("Individual cluster cannot be null");
        }
        this.addProperty(cluster, "domain", "hasResourceType", "http://geni-orca.renci.org/owl/compute.owl#VM");
    }

    public void addBareMetalDomainProperty(Individual cluster) throws NdlException {
        if (null == cluster) {
            throw new IllegalArgumentException("Individual cluster cannot be null");
        }
        this.addProperty(cluster, "domain", "hasResourceType", "http://geni-orca.renci.org/owl/compute.owl#BareMetalCE");
    }

    public void addFourtyGBareMetalDomainProperty(Individual cluster) throws NdlException {
        if (null == cluster) {
            throw new IllegalArgumentException("Individual cluster cannot be null");
        }
        this.addProperty(cluster, "domain", "hasResourceType", "http://geni-orca.renci.org/owl/compute.owl#FourtyGBareMetalCE");
    }

    public void addOfPropertiesToSlice(String userEmail, String slicePass, String userCtrl, Individual slice) throws NdlException {
        if (null == slice) {
            throw new IllegalArgumentException("Individual slice cannot be null");
        }
        this.addTypedProperty(slice, "topology", "hasEmail", userEmail, (RDFDatatype)XSDDatatype.XSDstring);
        this.addTypedProperty(slice, "openflow", "hasSlicePassword", slicePass, (RDFDatatype)XSDDatatype.XSDstring);
        Individual ctrl = this.declareOfController(slice.getLocalName() + "-of-ctrl", userCtrl);
        this.addProperty(slice, "openflow", "controller", ctrl.getURI());
    }

    public void addUserDNProperty(String dn, Individual i) throws NdlException {
        if (null == i) {
            throw new IllegalArgumentException("Individual i cannot be null");
        }
        this.addTypedProperty(i, "topology", "userDN", dn, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public Individual declareColor(String label, Map<String, String> keys, String blob, boolean isXML) throws NdlException {
        Individual in = this.addAnonIndividual("app-color", "Color");
        this.addSimpleProperty(in, "app-color", "hasColorLabel", label);
        this.addKeysOnColor(in, keys);
        this.addBlobOnColor__(in, blob, isXML, null);
        return in;
    }

    public void addKeysOnColor(Individual color, Map<String, String> keys) throws NdlException {
        if (keys == null || color == null) {
            return;
        }
        for (Map.Entry<String, String> e : keys.entrySet()) {
            Individual ca = this.addAnonIndividual("app-color", "ColorAttribute");
            this.addSimpleProperty(ca, "app-color", "hasColorKey", e.getKey());
            this.addSimpleProperty(ca, "app-color", "hasColorValue", e.getValue());
            this.addProperty(color, "app-color", "hasColorAttribute", (RDFNode)ca);
        }
    }

    public Individual addBlobOnColor(Individual color, String blob, boolean isXML) throws NdlException {
        if (color == null) {
            return color;
        }
        if (blob == null) {
            return color;
        }
        if (isXML) {
            Literal blobLit = this.addTypedLiteral(blob, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
            assert (blobLit.isWellFormedXML());
            this.addProperty(color, "app-color", "hasColorXMLBlob", (RDFNode)blobLit);
        } else {
            this.addSimpleProperty(color, "app-color", "hasColorBlob", blob);
        }
        return color;
    }

    public Individual addBlobOnColor__(Individual color, String blob, boolean isXML, String xmlns) throws NdlException {
        if (color == null) {
            return color;
        }
        if (blob == null) {
            return color;
        }
        if (isXML) {
            this.addSimpleProperty(color, "app-color", "hasColorXMLCompressedBlob", NdlGenerator.compressEncode(blob));
        } else {
            this.addSimpleProperty(color, "app-color", "hasColorBlob", blob);
        }
        return color;
    }

    public void encodeColorDependency(Individual from, Individual to, Individual color) throws NdlException {
        if (null == from) {
            throw new IllegalArgumentException("Individual from cannot be null");
        }
        if (null == to) {
            throw new IllegalArgumentException("Individual to cannot be null");
        }
        if (null == color) {
            throw new IllegalArgumentException("Individual color cannot be null");
        }
        this.addProperty(from, "app-color", "toColorDependency", (RDFNode)color);
        this.addProperty(to, "app-color", "fromColorDependency", (RDFNode)color);
    }

    public Individual addColorToIndividual(Individual ne, Individual color) throws NdlException {
        if (null == ne) {
            throw new IllegalArgumentException("Individual ne cannot be null");
        }
        if (null == color) {
            throw new IllegalArgumentException("Individual color cannot be null");
        }
        this.addProperty(ne, "app-color", "hasColor", (RDFNode)color);
        return ne;
    }

    public Individual addEthernetAdaptation(Individual intf, Individual adaptTo) throws NdlException {
        if (null == intf) {
            throw new IllegalArgumentException("Individual intf cannot be null");
        }
        if (null == adaptTo) {
            throw new IllegalArgumentException("Individual adaptTo cannot be null");
        }
        this.addProperty(intf, "ethernet", "Tagged-Ethernet", (RDFNode)adaptTo);
        return intf;
    }

    public void addGuid(Individual in, String guid) throws NdlException {
        if (null == in) {
            throw new IllegalArgumentException("Individual in cannot be null");
        }
        this.addSimpleProperty(in, "topology", "hasGUID", guid);
    }

    public String toN3String() {
        StringWriter sw = new StringWriter();
        this.blank.write((Writer)sw, "N3-PP");
        return sw.toString();
    }

    public String toString() {
        return this.toN3String();
    }

    public String toXMLString() {
        StringWriter sw = new StringWriter();
        this.blank.write((Writer)sw);
        return sw.toString();
    }

    public String getGVOutput() {
        return OntProcessor.substrateDotString(this.blank);
    }

    static String compressEncode(String inputString) {
        return CompressEncode.compressEncode((String)inputString);
    }

    static String decodeDecompress(String inputString) {
        try {
            return CompressEncode.decodeDecompress((String)inputString);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] argv) {
        NdlGenerator ngen = new NdlGenerator("some-unique-guid", Logger.getLogger((String)"my logger"));
        String blob = "<gemininode> \n<geminiservices>\n<geminiactive install=\"yes\" enable=\"yes\">blah1</geminiactive>\n<geminipassive>blah2</geminipassive>\n</geminiservices>\n</gemininode>";
        try {
            ngen.declareColor("test color", null, blob, true);
            Individual n = ngen.declareComputeElement("mynode");
            Individual n1 = ngen.declareComputeElement("mynode1");
            ngen.addNodeTypeToCE("exogeni", "XOMedium", n1);
            ngen.addNodeTypeToCE("exogeni", "XOMedium", n);
            ngen.removeNodeTypeFromCE("exogeni", "XOMedium", n);
            Individual intf = ngen.declareInterface("if1");
            ngen.addInterfaceToIndividual(intf, n);
            ngen.setInterfaceIP("5.5.5.5", intf);
            ngen.setInterfaceNetmask("255.0.0.0", intf);
            ngen.setInterfaceIP("6.6.6.6", intf);
            ngen.setInterfaceNetmask("255.255.255.0", intf);
        }
        catch (NdlException ee) {
            System.out.println("Exception: " + ee);
        }
        System.out.println(ngen.toXMLString());
    }

    private static class ReferenceModel {
        String[] owls = new String[]{"topology.owl", "compute.owl", "ethernet.owl", "collections.owl", "layer.owl", "domain.owl", "ip4.owl", "request.owl", "eucalyptus.owl", "ec2.owl", "planetlab.owl", "protogeni.owl", "kansei.owl", "openflow.owl", "geni.owl", "exogeni.owl", "modify.owl", "app-color.owl"};
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);

        public ReferenceModel() {
            NdlModel.setJenaRedirections(this.m.getDocumentManager());
            for (String owl : externalSchemas) {
                this.m.read(owl);
            }
            for (String owl : this.owls) {
                this.m.read("http://geni-orca.renci.org/owl/" + owl);
            }
            NdlCommons.setPrefix(this.m);
            this.m.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            this.m.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.m.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
            this.m.setNsPrefix("time", "http://www.w3.org/2006/time#");
        }

        protected void done() {
            if (this.m != null) {
                this.m.close();
                this.m = null;
            }
        }

        protected void finalize() {
            this.done();
        }

        public OntClass getOntClass(String s) {
            return this.m.getOntClass(s);
        }

        public DatatypeProperty getDataTypeProperty(String s) {
            return this.m.getDatatypeProperty(s);
        }

        public Property getProperty(String s) {
            return this.m.getProperty(s);
        }

        public String getNsPrefixUri(String prefix) {
            return this.m.getNsPrefixURI(prefix);
        }
    }
}

