/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import net.exogeni.orca.ndl.DomainResource;
import net.exogeni.orca.ndl.DomainResourceType;
import net.exogeni.orca.ndl.LayerConstant;
import net.exogeni.orca.ndl.NdlGenerator;
import net.exogeni.orca.ndl.NdlModel;
import net.exogeni.orca.ndl.OntProcessor;
import net.exogeni.orca.ndl.elements.ComputeElement;
import net.exogeni.orca.ndl.elements.Label;
import net.exogeni.orca.ndl.elements.LabelSet;
import net.exogeni.orca.ndl.elements.NetworkElement;
import net.exogeni.orca.ndl.util.ModelFolders;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NdlCommons {
    public static final String ORCA_NDL_SCHEMA = "net/exogeni/orca/ndl/schema/";
    public static final String ORCA_NDL_SUBSTRATE = "net/exogeni/orca/ndl/substrate/";
    private static final String NDL_LOGGER = "ndl.logger";
    public static final String ORCA_NS = "http://geni-orca.renci.org/owl/";
    public static final String W3_NS = "http://www.w3.org/";
    public static final long Default_Bandwidth = 10000000L;
    public static final int max_vlan_tag = 4095;
    public static final String multicast = "Multicast";
    public static final String unicast = "Unicast";
    public static final String stitching_domain_str = "Stitching/Domain";
    public static String ontPrefix = "PREFIX gleen:<java:edu.washington.sig.gleen.>PREFIX owl:<http://www.w3.org/2002/07/owl#>PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>PREFIX geo:<http://www.w3.org/2003/01/geo/wgs84_pos#>PREFIX fn:<http://www.w3.org/2005/xpath-functions#>PREFIX wdm:<http://geni-orca.renci.org/owl/dtn.owl#>PREFIX ethernet:<http://geni-orca.renci.org/owl/ethernet.owl#>PREFIX owl2xml:<http://www.w3.org/2006/12/owl2-xml#>PREFIX xsd:<http://www.w3.org/2001/XMLSchema#>PREFIX time:<http://www.w3.org/2006/time#>PREFIX ndl:<http://geni-orca.renci.org/owl/topology.owl#>PREFIX location:<http://geni-orca.renci.org/owl/location.owl#>PREFIX layer:<http://geni-orca.renci.org/owl/layer.owl#>PREFIX topology:<http://geni-orca.renci.org/owl/topology.owl#>PREFIX collections:<http://geni-orca.renci.org/owl/collections.owl#>PREFIX request:<http://geni-orca.renci.org/owl/request.owl#>PREFIX dtn:<http://geni-orca.renci.org/owl/dtn.owl#>PREFIX ethernet:<http://geni-orca.renci.org/owl/ethernet.owl#>PREFIX compute:<http://geni-orca.renci.org/owl/compute.owl#>PREFIX storage:<http://geni-orca.renci.org/owl/storage.owl#>PREFIX exogeni:<http://geni-orca.renci.org/owl/exogeni.owl#>PREFIX orca:<http://geni-orca.renci.org/owl/orca.rdf#>PREFIX domain:<http://geni-orca.renci.org/owl/domain.owl#>PREFIX ip4:<http://geni-orca.renci.org/owl/ip4.owl#>PREFIX geni:<http://geni-orca.renci.org/owl/geni.owl#>PREFIX modify:<http://geni-orca.renci.org/owl/modify.owl#>PREFIX manifest:<http://geni-orca.renci.org/owl/manifest.owl#>PREFIX app-color:<http://geni-orca.renci.org/owl/app-color.owl#>";
    public static final Property collectionElementProperty;
    public static final Property collectionItemProperty;
    public static final Property collectionSizeProperty;
    public static final Property RDF_TYPE;
    public static final Property RDFS_Label;
    public static final Property RDFS_SeeAlso;
    public static final Property OWL_sameAs;
    public static final Property numCEProperty;
    public static final Property requestGroupNameProperty;
    public static final Property hasEmailProperty;
    public static final Property hasSlicePasswordProperty;
    public static final Property geniSliceProperty;
    public static final Property hasSliceGeniState;
    public static final Property inDomainProperty;
    public static final Property diskImageProperty;
    public static final Property topologySplittableProperty;
    public static final Property domainHasServiceProperty;
    public static final Property domainProxyProperty;
    public static final Property hasURLProperty;
    public static final Property hasGUIDProperty;
    public static final Property hasURNProperty;
    public static final Property specificCEProperty;
    public static final Property virtualizeProperty;
    public static final Property numCPUCore;
    public static final Property domainHasResourceTypeProperty;
    public static final Property topologyHasInterfaceProperty;
    public static final Property topologyInterfaceOfProperty;
    public static final Property layerBandwidthProperty;
    public static final Property layerLatencyProperty;
    public static final Property layerLabelIdProperty;
    public static final Property layerLabelIsPrimary;
    public static final Property layerUsedLabels;
    public static final Property ip4LocalIPAddressProperty;
    public static final Property ip4NetmaskProperty;
    public static final Property ipMacAddressProperty;
    public static final Property requestDependOnProperty;
    public static final Property requestPostBootScriptProperty;
    public static final Property domainHasAccessMethod;
    public static final Property domainHasTopology;
    public static final Property domainIsAllocatable;
    public static final Property domainHasAggregateManager;
    public static final Property domainHasController;
    public static final Property requestHasReservationState;
    public static final Property requestMessage;
    public static final Property hasDNProperty;
    public static final Property hasInstanceIDProperty;
    public static final Property workerNodeIDProperty;
    public static final Property hasBeginningObjectProperty;
    public static final Property hasEndObjectProperty;
    public static final Property hasDurationDescriptionObjectProperty;
    public static final Property inXSDDateTime;
    public static final Property daysProperty;
    public static final Property hoursProperty;
    public static final Property minutesProperty;
    public static final Property secondsProperty;
    public static final Property locationLocatedAtProperty;
    public static final Property locationLatProperty;
    public static final Property locationLongProperty;
    public static final Property hasInputInterface;
    public static final Property connectedTo;
    public static final Property linkTo;
    public static final Property switchedTo;
    public static final Property hasSwitchMatrix;
    public static final Property hasRequestGroupURL;
    public static final Property inRequestNetworkConnection;
    public static final Property hasOutputInterface;
    public static final Property adaptationProperty;
    public static final Property adaptationPropertyOf;
    public static final Property taggedEthernetProperty;
    public static final Property carryReservation;
    public static final Property atLayer;
    public static final Property hasCastType;
    public static final Property switchingCapability;
    public static final Property swappingCapability;
    public static final Property tunnelingCapability;
    public static final Property connectionDirection;
    public static final Property vlan;
    public static final Property ocgLine;
    public static final Property layerSwapLabelProperty;
    public static final Property portOccupied;
    public static final Property inConnection;
    public static final Property visited;
    public static final Property numHop;
    public static final Property openflowCapableProperty;
    public static final Property modifySubjectProperty;
    public static final Property modifyAddElementProperty;
    public static final Property modifyElementProperty;
    public static final Property isModifyProperty;
    public static final Property modifyRemoveElementProperty;
    public static final Property modifyIncreaseByProperty;
    public static final Property manifestHasParent;
    public static final Property manifestHasChild;
    public static final Property topologyHasName;
    public static final Property topologyHasURL;
    public static final Property hostName_p;
    public static final Property topologyManagementIP;
    public static final Property topologyManagementPort;
    public static final Property topologyHasLogin;
    public static final Property isLabelProducer;
    public static final Property availableLabelSet;
    public static final Property lowerBound;
    public static final Property upperBound;
    public static final Property resourceTypeRank;
    public static final Property hasUnitServer;
    public static final Property numResource;
    public static final Property hostInterfaceName;
    public static final Property layerLabel;
    public static final Property memoryCapacity;
    public static final Property cpuCapacity;
    public static final Property topologyProxiedPort;
    public static final Property openflowControllerProperty;
    public static final Property layerHasBitRate;
    public static final Property quantumNetUUIDProperty;
    public static final Property storageCapacity;
    public static final Property hasFSParam;
    public static final Property hasFSType;
    public static final Property hasMntPoint;
    public static final Property doFormat;
    public static final Property hasColorAttribute;
    public static final Property hasColorBlob;
    public static final Property hasColorKey;
    public static final Property hasColorLabel;
    public static final Property hasColorValue;
    public static final Property hasColorXMLBlob;
    public static final Property hasColorXMLCompressedBlob;
    public static final Resource networkStorageClass;
    public static final Resource computeElementClass;
    public static final Resource serverCloudClass;
    public static final Resource topologyNetworkConnectionClass;
    public static final Resource topologyBroadcastConnectionClass;
    public static final Resource vmResourceTypeClass;
    public static final Resource bmResourceTypeClass;
    public static final Resource fourtygbmResourceTypeClass;
    public static final Resource lunResourceTypeClass;
    public static final Resource ethernetNetworkElementClass;
    public static final Resource multicastOntClass;
    public static final Resource topologyCrossConnectClass;
    public static final Resource topologyLinkConnectionClass;
    public static final Resource deviceOntClass;
    public static final Resource switchingMatrixOntClass;
    public static final Resource interfaceOntClass;
    public static final Resource vlanResourceTypeClass;
    public static final Resource networkDomainOntClass;
    public static final Resource networkServiceClass;
    public static final Resource domainSSHServiceClass;
    public static final Resource reservationOntClass;
    public static final Resource manifestOntClass;
    public static final Resource domainAggregateManagerClass;
    public static final Resource domainControllerClass;
    public static final Resource requestReservationStateClass;
    public static final Resource requestActiveState;
    public static final Resource requestActiveTicketedState;
    public static final Resource topologyLinkClass;
    public static final Resource requestCloseWaitState;
    public static final Resource requestClosedState;
    public static final Resource requestFailedState;
    public static final Resource requestNascentState;
    public static final Resource requestNoState;
    public static final Resource requestTicketedState;
    public static final Resource labelRangeOntClass;
    public static final Resource labelOntClass;
    public static final Resource labelSetOntClass;
    public static final Resource IPAddressOntClass;
    public static final Resource proxyClass;
    public static final Resource tcpProxyClass;
    public static final Resource sliceClass;
    public static final Resource ofSliceClass;
    public static final Resource sliceGeniStateClass;
    public static final Resource instantOntClass;
    public static final Resource geniSliceStateConfiguring;
    public static final Resource geniSliceStateFailed;
    public static final Resource geniSliceStateReady;
    public static final Resource geniSliceStateUnknown;
    public static final Resource openflowV1_0Ind;
    public static final Resource openflowV1_1Ind;
    public static final Resource openflowV1_2Ind;
    public static final Resource openflowV1_3Ind;
    public static final Resource bitRate1G;
    public static final Resource bitRate10G;
    public static final Resource stitchingDomain;
    public static final Resource diskImageClass;
    public static final String UriSeparator = "#";
    public static final String UriSuffix = "/Domain";

    public static String createQueryConnectedToNetworkConnection(Resource nc) {
        String selectStr = "SELECT DISTINCT ?interface ";
        String whereStr = "WHERE { <" + nc.getURI() + "> topology:hasInterface ?interface.    }";
        return NdlCommons.createQueryString(selectStr, "", whereStr);
    }

    public static String createQueryPeers(Resource n) {
        String selectStr = "SELECT DISTINCT ?peer ?interface";
        String whereStr = "WHERE {  <" + n + "> topology:hasInterface ?interface. ?peer topology:hasInterface ?interface. FILTER(?peer != <" + n.getURI() + ">)  }";
        return NdlCommons.createQueryString(selectStr, "", whereStr);
    }

    public static String createQueryConnectionPeers(Resource n) {
        String selectStr = "SELECT DISTINCT ?peer ?interface ";
        String whereStr = "WHERE {  <" + n + "> topology:hasInterface ?if. ?conn topology:hasInterface ?if. {{?conn rdf:type topology:LinkConnection.} UNION {?conn rdf:type topology:NetworkConnection}}. ?conn topology:hasInterface ?interface . ?peer topology:hasInterface ?interface . FILTER(?peer != <" + n.getURI() + "> && ?conn != ?peer)  }";
        return NdlCommons.createQueryString(selectStr, "", whereStr);
    }

    public static String createQueryStringHasColor() {
        String selectStr = "SELECT DISTINCT ?netelement ?color ";
        String whereStr = "WHERE {?netelement rdf:type topology:NetworkElement. ?color rdf:type app-color:Color. ?netelement app-color:hasColor ?color.    }";
        return NdlCommons.createQueryString(selectStr, "", whereStr);
    }

    public static String createQueryStringColorDependency() {
        String selectStr = "SELECT DISTINCT ?fromNe ?toNe ?color ";
        String whereStr = "WHERE {?fromNe rdf:type topology:NetworkElement. ?toNe rdf:type topology:NetworkElement. ?color rdf:type app-color:Color. ?fromNe app-color:toColorDependency ?color. ?toNe app-color:fromColorDependency ?color.     }";
        return NdlCommons.createQueryString(selectStr, "", whereStr);
    }

    public static String createQueryISCSIStorageProperties(Resource st) {
        String selectStr = "SELECT DISTINCT ?fsParam ?fsType ?format ?mntPoint ?capacity ";
        String whereStr = "WHERE {<" + st.getURI() + "> rdf:type storage:ISCSI. <" + st.getURI() + "> domain:hasResourceType storage:LUN. <" + st.getURI() + "> storage:storageCapacity ?capacity. <" + st.getURI() + "> storage:hasFSParam ?fsParam. <" + st.getURI() + "> storage:hasFSType ?fsType. <" + st.getURI() + "> storage:doFormat ?format. <" + st.getURI() + "> storage:hasMntPoint ?mntPoint. }  ";
        return NdlCommons.createQueryString(selectStr, "", whereStr);
    }

    public static String createQueryStringReservationTerm() {
        String selectStr = "SELECT DISTINCT ?reservation ?term ?beginning ?beginningTime ?end ?endTime ?duration ?years ?months ?weeks ?days ?hours ?minutes ?seconds ";
        String fromStr = "";
        String whereStr = "WHERE {?reservation rdf:type request:Reservation. OPTIONAL {?reservation request:hasTerm ?term.}. OPTIONAL {?term time:hasBeginning ?beginning. ?beginning time:inXSDDateTime ?beginningTime.}. OPTIONAL {?term time:hasEnd ?end. ?end time:inXSDDateTime ?endTime.}. OPTIONAL {?term time:hasDurationDescription ?duration.}. OPTIONAL {?duration time:years ?years.}. OPTIONAL {?duration time:months ?months.}. OPTIONAL {?duration time:weeks ?weeks.}. OPTIONAL {?duration time:days ?days.}. OPTIONAL {?duration time:hours ?hours.}. OPTIONAL {?duration time:minutes ?minutes.}. OPTIONAL {?duration time:seconds ?seconds.}.       }";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static String createQueryStringModifyReservation() {
        String selectStr = "SELECT DISTINCT ?modifyReservation ?modifyName";
        String fromStr = "";
        String whereStr = "WHERE {?modifyReservation rdf:type modify:ModifyReservation. OPTIONAL {?modifyReservation topology:hasName ?modifyName.}.     }";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static String createQueryStringDomainLocationDetails() {
        String selectStr = "SELECT ?domain ?popUri ?lat ?lon ";
        String fromStr = "";
        String whereStr = "WHERE {?domain <http://geni-orca.renci.org/owl/collections.owl#element> ?popUri . ?popUri <http://geni-orca.renci.org/owl/location.owl#locatedAt> ?loc . ?loc <http://www.w3.org/2003/01/geo/wgs84_pos#lat> ?lat . ?loc <http://www.w3.org/2003/01/geo/wgs84_pos#long> ?lon .   }";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static Resource getDomainHasCastType(String cast, String property, OntModel ontModel) {
        ResultSet results = NdlCommons.getDomainHasCastType(property, ontModel);
        if (!results.hasNext()) {
            return null;
        }
        QuerySolution solution = null;
        String domain = (String)results.getResultVars().get(0);
        String castType = (String)results.getResultVars().get(1);
        Resource domain_rs = null;
        Resource castType_rs = null;
        while (results.hasNext()) {
            solution = results.nextSolution();
            domain_rs = solution.getResource(domain);
            castType_rs = solution.getResource(castType);
            if (!castType_rs.getLocalName().contains(cast)) continue;
            break;
        }
        return domain_rs;
    }

    public static ResultSet getDomainHasCastType(String property, OntModel ontModel) {
        String selectStr = "SELECT ?domain ?castType ";
        String fromStr = "";
        String whereStr = "WHERE {?domain " + property + " ?service. ?service layer:hasCastType ?castType.  }";
        String queryPhrase = NdlCommons.createQueryString(selectStr, fromStr, whereStr);
        ResultSet results = NdlCommons.rdfQuery((Model)ontModel, queryPhrase);
        return results;
    }

    public static String createQueryStringWhoHasInterface(Resource intf) {
        String selectStr = "SELECT DISTINCT ?item ";
        String fromStr = "";
        String whereStr = "WHERE {?item topology:hasInterface <" + intf.getURI() + ">.      }";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static String createQueryStringWhoHaveInterface(Resource intf) {
        String selectStr = "SELECT DISTINCT ?node ?conn ";
        String fromStr = "";
        String whereStr = "WHERE {?node topology:hasInterface <" + intf.getURI() + ">.?conn topology:hasInterface <" + intf.getURI() + ">.?conn rdf:type ndl:NetworkConnection. {{?node rdf:type compute:ServerCloud.} UNION {?node rdf:type compute:ComputeElement.} UNION {?node rdf:type ndl:Device.}}.       }";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static String createQueryStringManifestDetails() {
        String selectStr = "SELECT DISTINCT ?manifest ";
        String fromStr = "";
        String whereStr = "WHERE {?manifest rdf:type request:Manifest.    }";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static String createQueryStringSite() {
        String selectStr = "SELECT DISTINCT  ?connection ?resource ?rType ?numResource ?bw  ?ip1_addr ?ip1_netmask ?vmImageURL ?vmImageGUID ?parent ?postBoot ?inDomain ";
        String fromStr = "";
        String whereStr = "WHERE {{?reservation collections:element ?resource. ?reservation rdf:type request:Reservation. {{?resource rdf:type compute:ServerCloud.} UNION {?resource rdf:type compute:ComputeElement.}}. OPTIONAL {?resource layer:numCE ?numResource.}OPTIONAL {?resource domain:hasResourceType ?rType.}OPTIONAL {?resource compute:diskImage ?vmImage. ?vmImage ndl:hasURL ?vmImageURL. ?vmImage ndl:hasGUID ?vmImageGUID.}OPTIONAL{?resource ndl:hasInterface ?intf1. ?intf1 ip4:localIPAddress ?ip1. ?ip1 layer:label_ID ?ip1_addr. ?ip1 ip4:netmask ?ip1_netmask.}OPTIONAL {?resource request:dependOn ?parent.}OPTIONAL {?resource request:postBootScript ?postBoot.}OPTIONAL {?resource request:inDomain ?inDomain.}} UNION {?connection a ndl:NetworkConnection.?connection ndl:hasInterface ?resource.OPTIONAL {?resource layer:numCE ?numResource.}.OPTIONAL {?connection layer:bandwidth ?bw.} OPTIONAL{?resource ip4:localIPAddress ?ip1. ?ip1 layer:label_ID ?ip1_addr. ?ip1 ip4:netmask ?ip1_netmask.}OPTIONAL {?connection domain:hasResourceType ?rType.}.}      }";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static String createQueryStringConnect() {
        String selectStr = "SELECT DISTINCT ?resource ?object ?connection ?bw ?ip1_addr ?ip1_netmask ?ip2_addr ?ip2_netmask ?intf1_hostInterfaceName ?intf2_hostInterfaceName ?resourceDomain ?objectDomain ";
        String fromStr = "";
        String whereStr = "WHERE {{?resource ndl:connectedTo ?object. ?resource a compute:ServerCloud. ?object a compute:ServerCloud. FILTER(?resource != ?object)OPTIONAL{?resource request:inDomain ?resourceDomain.}OPTIONAL{?object request:inDomain ?objectDomain.}} UNION {?resource ndl:hasInterface ?intf1. ?object ndl:hasInterface ?intf2. ?intf1 ndl:connectedTo ?intf2. FILTER(?resource != ?object)OPTIONAL{?resource request:inDomain ?resourceDomain.}OPTIONAL{?object request:inDomain ?objectDomain.}} UNION {?connection a ndl:NetworkConnection. ?connection ndl:hasInterface ?intf1. ?connection ndl:hasInterface ?intf2. ?resource ndl:hasInterface ?intf1. ?object ndl:hasInterface ?intf2.{{?resource a compute:ComputeElement.} UNION {?resource a ndl:Device.}}.{{?object a compute:ComputeElement.} UNION {?object a ndl:Device.}}. FILTER(?resource != ?object)OPTIONAL{?connection layer:bandwidth ?bw.}OPTIONAL{?resource request:inDomain ?resourceDomain.}OPTIONAL{?object request:inDomain ?objectDomain.}OPTIONAL{?intf1 ndl:hostInterfaceName ?intf1_hostInterfaceName. ?intf2 ndl:hostInterfaceName ?intf2_hostInterfaceName.}OPTIONAL{?intf1 ip4:localIPAddress ?ip1. ?ip1 layer:label_ID ?ip1_addr. ?ip1 ip4:netmask ?ip1_netmask.}OPTIONAL{?intf2 ip4:localIPAddress ?ip2. ?ip2 layer:label_ID ?ip2_addr. ?ip2 ip4:netmask ?ip2_netmask.}}      }ORDER BY DESC(?ip1_addr)";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static ResultSet getAvailableLabelSet(OntModel ontModel, String rsURI, String availableLableSet_str) {
        ResultSet results = null;
        String s = "SELECT ?lv ?uv ?l ?u ?b ?r ";
        String f = "";
        String w = "WHERE {<" + rsURI + "> " + availableLableSet_str + " ?r.?r collections:element ?b. OPTIONAL{?b layer:upperBound ?u. ?u layer:label_ID ?uv. ?b layer:lowerBound ?l. ?l layer:label_ID ?lv.}.}ORDER BY ASC(?lv)";
        String queryPhrase = NdlCommons.createQueryString(s, f, w);
        results = NdlCommons.rdfQuery((Model)ontModel, queryPhrase);
        return results;
    }

    public static String createQueryStringLinkClass(String ob) {
        String selectStr = "SELECT ?resource ?object ";
        String fromStr = "";
        String whereStr = "WHERE {?resource a " + ob + ".?resource ndl:linkTo ?object      }";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static String createQueryStringOnPath(String subject, String sub) {
        String onPath = "gleen:OnPath";
        String selectStr = "SELECT ?object ";
        String fromStr = "";
        String whereStr = "WHERE {<" + subject + "> " + onPath + sub + " ?object). FILTER(?object !=<" + subject + "> )      }";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static String createQueryStringObject(String sb, String p) {
        String selectStr = "SELECT ?object ";
        String fromStr = "";
        sb = sb == null ? "?resource " : "<" + sb + ">";
        String whereStr = "WHERE {" + sb + p + " ?object      }";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static String findLayer(OntModel m, Resource resource) {
        ResultSet results = NdlCommons.getLayer(m, resource.getURI());
        String varName = (String)results.getResultVars().get(0);
        if (results.hasNext()) {
            return results.nextSolution().getResource(varName).getLocalName();
        }
        return null;
    }

    public static ResultSet getLayer(OntModel m, String rsURI) {
        String s = "SELECT ?r ";
        String f = "";
        String w = "WHERE {<" + rsURI + "> ?p ?r. ?r rdf:type layer:Layer      }";
        String queryPhrase = NdlCommons.createQueryString(s, f, w);
        ResultSet results = NdlCommons.rdfQuery((Model)m, queryPhrase);
        return results;
    }

    public static ResultSet getLayerAdapatation(OntModel m, String rsURI) {
        String s = "SELECT ?r ";
        String f = "";
        String w = "WHERE {{<" + rsURI + "> ?p ?r. ?p rdf:type layer:AdaptationProperty} UNION{<" + rsURI + "> layer:AdaptationProperty ?r}      }";
        String queryPhrase = NdlCommons.createQueryString(s, f, w);
        ResultSet results = NdlCommons.rdfQuery((Model)m, queryPhrase);
        return results;
    }

    public static ResultSet getLayerAdapatationOf(OntModel m, String rsURI) {
        String s = "SELECT ?r ";
        String f = "";
        String w = "WHERE {{?r ?p <" + rsURI + ">. ?p rdf:type layer:AdaptationProperty.} UNION{?r layer:AdaptationProperty <" + rsURI + ">}      }";
        String queryPhrase = NdlCommons.createQueryString(s, f, w);
        ResultSet results = NdlCommons.rdfQuery((Model)m, queryPhrase);
        return results;
    }

    public static Resource parentGetInterface(OntModel m, String node, String parent) {
        String s = "SELECT ?intf ";
        String f = "";
        String w = "WHERE {<" + node + "> ndl:hasInterface ?intf.<" + parent + "> ndl:hasInterface ?intf.}";
        String queryPhrase = NdlCommons.createQueryString(s, f, w);
        ResultSet results = NdlCommons.rdfQuery((Model)m, queryPhrase);
        Resource intf_rs = null;
        Resource first_intf_rs = null;
        while (results.hasNext()) {
            ResultBinding result = (ResultBinding)results.next();
            if (result == null || !(first_intf_rs = (Resource)result.get("intf")).hasProperty(ip4LocalIPAddressProperty)) continue;
            intf_rs = first_intf_rs;
            break;
        }
        if (intf_rs == null) {
            intf_rs = first_intf_rs;
        }
        return intf_rs;
    }

    public static ResultSet rdfQuery(Model model, String queryString) {
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)model);
        ResultSet results = qe.execSelect();
        return results;
    }

    public static void outputQueryResult(ResultSet results, Query query) {
        ResultSetFormatter.out((OutputStream)System.out, (ResultSet)results, (Prologue)query);
    }

    public static void outputQueryResult(ResultSet results) {
        ResultSetFormatter.out((OutputStream)System.out, (ResultSet)results);
    }

    public static List<Resource> getResourceInterfaces(Resource r) {
        assert (r != null);
        ArrayList<Resource> ifs = new ArrayList<Resource>();
        StmtIterator resEl = r.listProperties(topologyHasInterfaceProperty);
        while (resEl.hasNext()) {
            Statement s = (Statement)resEl.next();
            ifs.add(s.getResource());
        }
        return ifs;
    }

    public static Resource getLayer(Resource c) {
        assert (c != null);
        Statement conBwStmt = c.getProperty(atLayer);
        if (conBwStmt != null) {
            return conBwStmt.getResource();
        }
        return null;
    }

    public static long getResourceBandwidth(Resource c) {
        assert (c != null);
        Statement conBwStmt = c.getProperty(layerBandwidthProperty);
        if (conBwStmt != null) {
            return conBwStmt.getLong();
        }
        return 0L;
    }

    public static long getResourceStorageCapacity(Resource c) {
        assert (c != null);
        Statement storCap = c.getProperty(storageCapacity);
        if (storCap != null) {
            return storCap.getLong();
        }
        return 0L;
    }

    public static String getResourceStorageFSParam(Resource c) {
        assert (c != null);
        Statement stor = c.getProperty(hasFSParam);
        if (stor != null) {
            return stor.getString();
        }
        return null;
    }

    public static String getResourceStorageFSType(Resource c) {
        assert (c != null);
        Statement stor = c.getProperty(hasFSType);
        if (stor != null) {
            return stor.getString();
        }
        return null;
    }

    public static String getResourceStorageMntPoint(Resource c) {
        assert (c != null);
        Statement stor = c.getProperty(hasMntPoint);
        if (stor != null) {
            return stor.getString();
        }
        return null;
    }

    public static Boolean getResourceStorageDoFormat(Resource c) {
        assert (c != null);
        Statement stor = c.getProperty(doFormat);
        if (stor != null) {
            return stor.getBoolean();
        }
        return false;
    }

    public static long getResourceLatency(Resource c) {
        assert (c != null);
        Statement conLatStmt = c.getProperty(layerLatencyProperty);
        if (conLatStmt != null) {
            return conLatStmt.getLong();
        }
        return 0L;
    }

    public static String getAddressIP(Resource i) {
        return NdlCommons.getStringProperty(i, layerLabelIdProperty);
    }

    public static String getAddressNetmask(Resource i) {
        return NdlCommons.getStringProperty(i, ip4NetmaskProperty);
    }

    public static String getAddressMAC(Resource i) {
        return NdlCommons.getStringProperty(i, ipMacAddressProperty);
    }

    public static String getInterfaceIP(Resource i) {
        assert (i != null);
        if (i.hasProperty(ip4LocalIPAddressProperty)) {
            Statement st = i.getProperty(ip4LocalIPAddressProperty);
            return NdlCommons.getAddressIP(st.getResource());
        }
        return null;
    }

    public static String getInterfaceNetmask(Resource i) {
        assert (i != null);
        if (i.hasProperty(ip4LocalIPAddressProperty)) {
            Statement st = i.getProperty(ip4LocalIPAddressProperty);
            return NdlCommons.getAddressNetmask(st.getResource());
        }
        return null;
    }

    public static Resource getSameAsResource(Resource i) {
        Statement st = i.getProperty(OWL_sameAs);
        if (st != null && !st.getResource().equals((Object)i)) {
            return st.getResource();
        }
        return null;
    }

    public static String getEC2InstanceId(Resource i) {
        return NdlCommons.getStringProperty(i, hasInstanceIDProperty);
    }

    public static String getEC2WorkerNodeId(Resource i) {
        return NdlCommons.getStringProperty(i, workerNodeIDProperty);
    }

    public static List<String> getNodeServices(Resource node) {
        assert (node != null);
        ArrayList<String> services = new ArrayList<String>();
        StmtIterator si = node.listProperties(domainHasServiceProperty);
        while (si.hasNext()) {
            Resource srv = ((Statement)si.next()).getResource();
            Statement accessStmt = srv.getRequiredProperty(domainHasAccessMethod);
            String service = null;
            if (accessStmt.getResource().equals((Object)domainSSHServiceClass)) {
                service = "ssh://";
            }
            ArrayList<String> logins = new ArrayList<String>();
            Statement loginStmt = srv.getProperty(topologyHasLogin);
            if (loginStmt != null) {
                String loginString = loginStmt.getString();
                if (loginString != null && loginString.length() != 0) {
                    String[] tmp = loginString.split(",");
                    logins.addAll(Arrays.asList(tmp));
                }
            } else {
                logins.add("root");
            }
            for (String l : logins) {
                String serviceURI = null;
                if (srv.getProperty(topologyManagementIP) != null) {
                    serviceURI = service + l + "@" + srv.getProperty(topologyManagementIP).getString();
                    if (srv.getProperty(topologyManagementPort) != null) {
                        serviceURI = serviceURI + ":" + srv.getProperty(topologyManagementPort).getString();
                    }
                }
                if (serviceURI == null) continue;
                services.add(serviceURI);
            }
        }
        return services;
    }

    public static List<String> getNodeLogins(Resource node) {
        assert (node != null);
        HashSet<String> logins = new HashSet<String>();
        StmtIterator si = node.listProperties(domainHasServiceProperty);
        while (si.hasNext()) {
            String loginString;
            Statement loginStmt;
            Resource srv = ((Statement)si.next()).getResource();
            Statement accessStmt = srv.getRequiredProperty(domainHasAccessMethod);
            String service = null;
            if (accessStmt.getResource().equals((Object)domainSSHServiceClass)) {
                service = "ssh://";
            }
            if ((loginStmt = srv.getProperty(topologyHasLogin)) == null || (loginString = loginStmt.getString()) == null || loginString.length() == 0) continue;
            String[] tmp = loginString.split(",");
            logins.addAll(Arrays.asList(tmp));
        }
        ArrayList<String> loginsList = new ArrayList<String>();
        loginsList.addAll(logins);
        return loginsList;
    }

    public static List<ProxyFields> getNodeProxiedPorts(Resource node) {
        ArrayList<ProxyFields> ret = new ArrayList<ProxyFields>();
        StmtIterator si = node.listProperties(domainProxyProperty);
        while (si.hasNext()) {
            ProxyFields pf = new ProxyFields();
            Resource prx = ((Statement)si.next()).getResource();
            Statement proxiedStmt = prx.getRequiredProperty(topologyProxiedPort);
            pf.proxiedPort = proxiedStmt.getShort();
            if (prx.getProperty(topologyManagementIP) != null && prx.getProperty(topologyManagementPort) != null) {
                pf.mgtPort = prx.getProperty(topologyManagementPort).getShort();
                pf.mgtIp = prx.getProperty(topologyManagementIP).getString();
            }
            ret.add(pf);
        }
        return ret;
    }

    public static int getLiteralInt(Literal i) {
        if (i != null) {
            return i.getInt();
        }
        return 0;
    }

    public static Date getTermDate(Literal d) {
        if (d == null) {
            return null;
        }
        Calendar cal = DatatypeConverter.parseDateTime((String)d.getString());
        return cal.getTime();
    }

    public static Resource getDiskImage(Resource i) {
        assert (i != null);
        Statement nodeImageStmt = i.getProperty(diskImageProperty);
        if (nodeImageStmt != null) {
            return nodeImageStmt.getResource();
        }
        return null;
    }

    public static Resource getOfCtrl(Resource sl) {
        assert (sl != null);
        Statement ofCtrlStmt = sl.getProperty(openflowControllerProperty);
        if (ofCtrlStmt != null) {
            return ofCtrlStmt.getResource();
        }
        return null;
    }

    public static String getOpenFlowVersion(Resource res) {
        assert (res != null);
        String ret = null;
        Statement ofCapable = res.getProperty(openflowCapableProperty);
        if (ofCapable != null) {
            if (ofCapable.getResource().equals((Object)openflowV1_0Ind)) {
                ret = "1.0";
            } else if (ofCapable.getResource().equals((Object)openflowV1_1Ind)) {
                ret = "1.1";
            } else if (ofCapable.getResource().equals((Object)openflowV1_2Ind)) {
                ret = "1.2";
            } else if (ofCapable.getResource().equals((Object)openflowV1_3Ind)) {
                ret = "1.3";
            }
        }
        return ret;
    }

    public static String getURL(Resource di) {
        return NdlCommons.getStringProperty(di, hasURLProperty);
    }

    public static String getImageURL(Resource di) {
        return NdlCommons.getURL(di);
    }

    public static String getImageHash(Resource di) {
        assert (di != null);
        Statement diGUIDP = di.getProperty(hasGUIDProperty);
        String diGUID = null;
        if (diGUIDP != null) {
            diGUID = diGUIDP.getString();
        }
        return diGUID;
    }

    public static String getIndividualsImageURL(Resource i) {
        assert (i != null);
        Statement nodeImageStmt = i.getProperty(diskImageProperty);
        if (nodeImageStmt != null) {
            Resource di = nodeImageStmt.getResource();
            return NdlCommons.getImageURL(di);
        }
        return null;
    }

    public static String getIndividualsImageHash(Resource i) {
        assert (i != null);
        Statement nodeImageStmt = i.getProperty(diskImageProperty);
        if (nodeImageStmt != null) {
            Resource di = nodeImageStmt.getResource();
            return NdlCommons.getImageHash(di);
        }
        return null;
    }

    public static Resource getResourceType(Resource r) {
        assert (r != null);
        StmtIterator j = r.listProperties(RDF_TYPE);
        while (j.hasNext()) {
            Resource type = ((Statement)j.next()).getResource();
            if (type.getURI().endsWith("NamedIndividual")) continue;
            return type;
        }
        return null;
    }

    public static boolean hasResourceType(Resource r, Resource t) {
        return r.hasProperty(RDF_TYPE, (RDFNode)t);
    }

    public static String getResourceLabel(Resource r) {
        return NdlCommons.getStringProperty(r, RDFS_Label);
    }

    public static String getPostBootScript(Resource i) {
        return NdlCommons.getStringProperty(i, requestPostBootScriptProperty);
    }

    public static String getGroupName(Resource i) {
        assert (i != null);
        Statement gnStmt = i.getProperty(requestGroupNameProperty);
        if (gnStmt != null) {
            String sc = gnStmt.getString();
            return sc.length() > 0 ? sc : null;
        }
        return null;
    }

    public static ResultSet getInterfaceOfSwitching(OntModel ontModel, String rs) {
        String s = "SELECT ?sm ";
        String f = "";
        String w = "WHERE {?r ndl:hasInterface <" + rs + ">. ?r rdf:type ndl:Device.?r ndl:hasSwitchMatrix ?sm}";
        String queryPhrase = NdlCommons.createQueryString(s, f, w);
        ResultSet results = NdlCommons.rdfQuery((Model)ontModel, queryPhrase);
        return results;
    }

    public static String createQueryStringType(String ob) {
        return NdlCommons.createQueryStringSubjectData("rdf:type", ob);
    }

    public static String createQueryStringSubject(String p, String ob) {
        return NdlCommons.createQueryStringSubjectData(p, "<" + ob + ">");
    }

    public static String createQueryStringSubjectData(String p, String ob) {
        String selectStr = "SELECT ?subject";
        String fromStr = "";
        String whereStr = " WHERE {?subject " + p + " " + ob + " .}";
        return NdlCommons.createQueryString(selectStr, fromStr, whereStr);
    }

    public static String createQueryString(String selectStr, String fromStr, String whereStr) {
        String queryString = ontPrefix + selectStr + " " + fromStr + " " + whereStr;
        return queryString;
    }

    public static OntResource getOntOfType(OntModel aM, String type) {
        Resource rs = null;
        String queryPhrase = NdlCommons.createQueryStringType(type);
        ResultSet results = NdlCommons.rdfQuery((Model)aM, queryPhrase);
        String var0 = (String)results.getResultVars().get(0);
        if (results.hasNext()) {
            rs = results.nextSolution().getResource(var0);
            return aM.getOntResource(rs);
        }
        return null;
    }

    public static Resource getDomain(Resource res) {
        assert (res != null);
        Statement domainStmt = res.getProperty(inDomainProperty);
        if (domainStmt != null) {
            return domainStmt.getResource();
        }
        return null;
    }

    public static String getDomainName(Resource dom) {
        if (dom == null) {
            return null;
        }
        String domainName = StringUtils.removeStart((String)dom.getURI(), (String)ORCA_NS);
        domainName = StringUtils.removeEnd((String)domainName, (String)UriSuffix);
        return domainName;
    }

    public static String getOrcaDomainName(String domain_url) {
        if (domain_url == null) {
            return null;
        }
        int index = domain_url.indexOf(UriSeparator);
        if (index >= 0) {
            int index2 = domain_url.indexOf(UriSuffix, index);
            if (index2 >= 0) {
                return domain_url.substring(index + 1, index2);
            }
            return domain_url.substring(index + 1, domain_url.length());
        }
        return null;
    }

    public static String getOrcaDomainName(Resource dom) {
        if (dom == null) {
            return null;
        }
        String domainName = dom.getURI();
        return NdlCommons.getOrcaDomainName(domainName);
    }

    public static List<Resource> getXOVirtualizationType(OntModel abstractModel, String rType) {
        abstractModel.read("http://geni-orca.renci.org/owl/exogeni.owl");
        String type = "ndl:Device";
        ArrayList<Resource> virtList = new ArrayList<Resource>();
        try {
            OntResource domain_rs = NdlCommons.getOntOfType(abstractModel, type);
            boolean isType = false;
            StmtIterator i = domain_rs.listProperties(collectionElementProperty);
            while (i.hasNext()) {
                Resource pop_rs = ((Statement)i.next()).getResource();
                StmtIterator j = pop_rs.listProperties(collectionElementProperty);
                while (j.hasNext()) {
                    isType = false;
                    Resource cluster_rs = ((Statement)j.next()).getResource();
                    StmtIterator k = cluster_rs.listProperties(availableLabelSet);
                    while (k.hasNext()) {
                        Resource type_rs;
                        Resource set_rs = ((Statement)k.next()).getResource();
                        if (!set_rs.hasProperty(domainHasResourceTypeProperty) || !(type_rs = set_rs.getProperty(domainHasResourceTypeProperty).getResource()).getLocalName().equalsIgnoreCase(rType)) continue;
                        isType = true;
                        break;
                    }
                    if (!isType) continue;
                    StmtIterator l = domain_rs.listProperties(RDF_TYPE);
                    while (l.hasNext()) {
                        OntClass class_class;
                        Resource class_rs = ((Statement)l.next()).getResource();
                        try {
                            class_class = (OntClass)class_rs.as(OntClass.class);
                        }
                        catch (Exception ee) {
                            continue;
                        }
                        ExtendedIterator m = class_class.listSuperClasses();
                        while (m.hasNext()) {
                            Restriction r;
                            OntClass c = (OntClass)m.next();
                            if (!c.isRestriction() || !(r = c.asRestriction()).onProperty(virtualizeProperty) || !r.isHasValueRestriction() || !r.asHasValueRestriction().getHasValue().isResource()) continue;
                            Resource virtType = (Resource)r.asHasValueRestriction().getHasValue().as(Resource.class);
                            virtList.add(virtType);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            return virtList;
        }
        return virtList;
    }

    public static boolean isSplittable(Resource res) {
        assert (res != null);
        Statement splittableStmt = res.getProperty(topologySplittableProperty);
        if (splittableStmt != null) {
            return splittableStmt.getBoolean();
        }
        return false;
    }

    public static boolean isModify(Resource res) {
        assert (res != null);
        Statement isModifyStmt = res.getProperty(isModifyProperty);
        if (isModifyStmt != null) {
            return isModifyStmt.getBoolean();
        }
        return false;
    }

    public static int getNumCE(Resource res) {
        assert (res != null);
        Statement numCEStmt = res.getProperty(numCEProperty);
        int numCE = 0;
        if (numCEStmt != null) {
            numCE = numCEStmt.getInt();
        }
        return numCE;
    }

    public static Resource getSpecificCE(Resource res) {
        assert (res != null);
        Statement nodeTypeStmt = res.getProperty(specificCEProperty);
        Resource ceType = null;
        if (nodeTypeStmt != null) {
            ceType = nodeTypeStmt.getResource();
        }
        return ceType;
    }

    public static void getResourceConstraints(Resource ceType, NetworkElement element, int count) {
        assert (ceType != null);
        OntClass instance_class = (OntClass)ceType.as(OntClass.class);
        ExtendedIterator i = instance_class.listSuperClasses();
        while (i.hasNext()) {
            Restriction r;
            OntClass c = (OntClass)i.next();
            if (!c.isRestriction() || !(r = c.asRestriction()).isHasValueRestriction() || !r.asHasValueRestriction().getHasValue().isLiteral()) continue;
            String key = r.asHasValueRestriction().getOnProperty().getLocalName();
            int value = ((Literal)r.asHasValueRestriction().getHasValue().as(Literal.class)).getInt();
            DomainResource constraint = new DomainResource(key);
            constraint.setBandwidth(value);
            element.addResource(constraint);
        }
    }

    public static DomainResourceType getDomainResourceType(Resource r, NetworkElement element) {
        DomainResourceType type = NdlCommons.getDomainResourceType(r);
        int count = type.getCount();
        Resource ceType = NdlCommons.getSpecificCE(r);
        if (ceType != null) {
            NdlCommons.getResourceConstraints(ceType, element, count);
        }
        if (r.hasProperty(storageCapacity)) {
            int value = r.getProperty(storageCapacity).getInt();
            DomainResource constraint = new DomainResource(storageCapacity.getLocalName());
            constraint.setBandwidth(value);
            element.addResource(constraint);
            NdlCommons.setStorageParam(r, element);
        }
        return type;
    }

    public static void setStorageParam(Resource r, NetworkElement element) {
        ComputeElement ce_element = (ComputeElement)element;
        if (r.hasProperty(hasFSParam)) {
            ce_element.setFSParam(r.getProperty(hasFSParam).getString());
        }
        if (r.hasProperty(hasFSType)) {
            ce_element.setFSType(r.getProperty(hasFSType).getString());
        }
        if (r.hasProperty(hasMntPoint)) {
            ce_element.setMntPoint(r.getProperty(hasMntPoint).getString());
        }
        if (r.hasProperty(doFormat)) {
            ce_element.setDoFormat(r.getProperty(doFormat).getBoolean());
        }
    }

    public static DomainResourceType getDomainResourceType(Resource r) {
        assert (r != null);
        int rank = 0;
        String rType_str = null;
        DomainResourceType type = new DomainResourceType();
        Statement rtStmt = r.getProperty(domainHasResourceTypeProperty);
        Resource rType = null;
        if (rtStmt != null) {
            rType = rtStmt.getResource();
            if (rType != null) {
                rType_str = rType.getURI();
                int i = rType_str.indexOf(35);
                if (i > 0) {
                    rType_str = rType_str.substring(i + 1).toLowerCase();
                }
                if (rType.getProperty(resourceTypeRank) != null) {
                    rank = rType.getProperty(resourceTypeRank).getInt();
                }
            }
        } else {
            rtStmt = r.getProperty(atLayer);
            if (rtStmt != null) {
                rType_str = LayerConstant.Layer.valueOf(rtStmt.getResource().getLocalName()).getLabelP().toString();
                rank = LayerConstant.Layer.valueOf(rtStmt.getResource().getLocalName()).rank();
            }
        }
        type.setResourceType(rType_str);
        type.setRank(rank);
        rtStmt = r.getProperty(numCEProperty);
        if (rtStmt != null) {
            int numResource = rtStmt.getInt();
            type.setCount(numResource);
        } else {
            type.setCount(1);
        }
        return type;
    }

    public static List<DomainResourceType> getDomainResourceTypes(Resource r) {
        assert (r != null);
        int rank = 0;
        ArrayList<DomainResourceType> ret = new ArrayList<DomainResourceType>();
        StmtIterator iter = r.listProperties(domainHasResourceTypeProperty);
        while (iter.hasNext()) {
            DomainResourceType type = new DomainResourceType();
            Statement rtStmt = (Statement)iter.next();
            String rType_str = null;
            Resource rType = rtStmt.getResource();
            if (rType != null) {
                rType_str = rType.getURI();
                int i = rType_str.indexOf(35);
                if (i > 0) {
                    rType_str = rType_str.substring(i + 1).toLowerCase();
                }
                if (rType.getProperty(resourceTypeRank) != null) {
                    rank = rType.getProperty(resourceTypeRank).getInt();
                }
            }
            type.setResourceType(rType_str);
            type.setRank(rank);
            rtStmt = r.getProperty(numCEProperty);
            if (rtStmt != null) {
                int numResource = rtStmt.getInt();
                type.setCount(numResource);
            } else {
                type.setCount(1);
            }
            ret.add(type);
        }
        return ret;
    }

    public static String getTrueName(Resource r) {
        if (r == null) {
            return null;
        }
        return StringUtils.removeStart((String)r.getURI(), (String)ORCA_NS);
    }

    public static String getStateAsString(Resource s) {
        assert (s != null);
        if (s.equals((Object)requestActiveState)) {
            return "Active";
        }
        if (s.equals((Object)requestActiveTicketedState)) {
            return "ActiveTicketed";
        }
        if (s.equals((Object)requestCloseWaitState)) {
            return "CloseWait";
        }
        if (s.equals((Object)requestClosedState)) {
            return "Closed";
        }
        if (s.equals((Object)requestFailedState)) {
            return "Failed";
        }
        if (s.equals((Object)requestNascentState)) {
            return "Nascent";
        }
        if (s.equals((Object)requestNoState)) {
            return "No State";
        }
        if (s.equals((Object)requestTicketedState)) {
            return "Ticketed";
        }
        return "Unspecified";
    }

    public static String getResourceStateAsString(Resource s) {
        assert (s != null);
        Statement hasState = s.getProperty(requestHasReservationState);
        if (hasState != null && hasState.getResource() != null) {
            return NdlCommons.getStateAsString(hasState.getResource());
        }
        return null;
    }

    public static String getResourceReservationNotice(Resource s) {
        return NdlCommons.getStringProperty(s, requestMessage);
    }

    public static List<Resource> getWhoHasInterface(Resource i, Model m) {
        String query = NdlCommons.createQueryStringWhoHasInterface(i);
        ResultSet rs = OntProcessor.rdfQuery(m, query);
        ArrayList<Resource> ret = new ArrayList<Resource>();
        while (rs.hasNext()) {
            Resource u;
            ResultBinding result = (ResultBinding)rs.next();
            if (result == null || (u = (Resource)result.get("item")) == null) continue;
            ret.add(u);
        }
        if (ret.size() > 0) {
            return ret;
        }
        return null;
    }

    public static boolean attachedToCompute(Resource intface) {
        List<Resource> attachedList = NdlCommons.getWhoHasInterface(intface, intface.getModel());
        for (Resource r : attachedList) {
            if (!NdlCommons.isComputeElement(r)) continue;
            return true;
        }
        return false;
    }

    public static boolean attachedToStitchPort(Resource intface) {
        List<Resource> attachedList = NdlCommons.getWhoHasInterface(intface, intface.getModel());
        for (Resource r : attachedList) {
            if (!NdlCommons.isStitchingNode(r)) continue;
            return true;
        }
        return false;
    }

    public static List<Resource> getConnectedToInterfaces(Resource i) {
        ArrayList<Resource> ret = new ArrayList<Resource>();
        StmtIterator sti = i.listProperties(connectedTo);
        while (sti.hasNext()) {
            Resource ic = ((Statement)sti.next()).getResource();
            ret.add(ic);
        }
        return ret.size() > 0 ? ret : null;
    }

    public static String getUrn(Resource i) {
        return NdlCommons.getStringProperty(i, hasURNProperty);
    }

    public static String getEmail(Resource i) {
        return NdlCommons.getStringProperty(i, hasEmailProperty);
    }

    public static String getSlicePassword(Resource i) {
        return NdlCommons.getStringProperty(i, hasSlicePasswordProperty);
    }

    public static double getBitRate(Resource i) {
        if (i.hasProperty(layerHasBitRate, (RDFNode)bitRate1G)) {
            return 1.0E9;
        }
        if (i.hasProperty(layerHasBitRate, (RDFNode)bitRate10G)) {
            return 1.0E10;
        }
        return 0.0;
    }

    public static String getBitRateAsString(Resource i) {
        if (i.hasProperty(layerHasBitRate, (RDFNode)bitRate1G)) {
            return "1000000000";
        }
        if (i.hasProperty(layerHasBitRate, (RDFNode)bitRate10G)) {
            return "10000000000";
        }
        return null;
    }

    protected static String getStringProperty(Resource r, Property p) {
        assert (r != null);
        Statement s = r.getProperty(p);
        if (s != null) {
            String sc = s.getString();
            return sc.length() > 0 ? sc : null;
        }
        return null;
    }

    public static int getSizeProperty(Resource i) {
        return NdlCommons.getIntProperty(i, collectionSizeProperty);
    }

    public static String getDNProperty(Resource i) {
        return NdlCommons.getStringProperty(i, hasDNProperty);
    }

    public static String getHasURLProperty(Resource i) {
        return NdlCommons.getStringProperty(i, topologyHasURL);
    }

    public static String getRequestGroupURLProperty(Resource i) {
        return NdlCommons.getStringProperty(i, hasRequestGroupURL);
    }

    public static String getNameProperty(Resource i) {
        return NdlCommons.getStringProperty(i, topologyHasName);
    }

    public static String getGuidProperty(Resource i) {
        return NdlCommons.getStringProperty(i, hasGUIDProperty);
    }

    public static String getGeniSliceStateName(Resource i) {
        Statement st = i.getProperty(hasSliceGeniState);
        if (st == null) {
            return "unknown";
        }
        Resource r = st.getResource();
        if (r.equals((Object)geniSliceStateConfiguring)) {
            return "configuring";
        }
        if (r.equals((Object)geniSliceStateFailed)) {
            return "failed";
        }
        if (r.equals((Object)geniSliceStateReady)) {
            return "ready";
        }
        return "unknown";
    }

    protected static int getIntProperty(Resource r, Property p) {
        assert (r != null);
        Statement s = r.getProperty(p);
        if (s != null) {
            int ret = s.getInt();
            return ret;
        }
        return Integer.MIN_VALUE;
    }

    protected static float getFloatProperty(Resource r, Property p) {
        assert (r != null);
        Statement s = r.getProperty(p);
        if (s != null) {
            float ret = s.getFloat();
            return ret;
        }
        return Float.MIN_VALUE;
    }

    protected static String getLiteralProperty(Resource r, Property p) {
        assert (r != null);
        Statement s = r.getProperty(p);
        if (s != null) {
            return s.getLiteral().toString();
        }
        return null;
    }

    public static List<String> getDomainControllerUrls(Resource d) {
        if (!NdlCommons.hasResourceType(d, networkDomainOntClass)) {
            return null;
        }
        Statement s1 = d.getProperty(domainHasServiceProperty);
        if (s1 == null) {
            return null;
        }
        Resource ns = s1.getResource();
        ArrayList<String> ret = new ArrayList<String>();
        StmtIterator si = ns.listProperties(domainHasAggregateManager);
        while (si.hasNext()) {
            Resource am = ((Statement)si.next()).getResource();
            if (!NdlCommons.hasResourceType(am, domainAggregateManagerClass)) continue;
            ret.add(NdlCommons.getURL(am));
        }
        return ret;
    }

    public static String getManifestControllerUrl(Resource m) {
        if (!NdlCommons.hasResourceType(m, manifestOntClass)) {
            return null;
        }
        Statement s1 = m.getProperty(domainHasController);
        if (s1 == null) {
            return null;
        }
        Resource c = s1.getResource();
        Statement s2 = c.getProperty(hasURLProperty);
        if (s2 == null) {
            return null;
        }
        return s2.getLiteral().toString();
    }

    public static List<Resource> getDomainLocations(Resource d) {
        ArrayList<Resource> ret = new ArrayList<Resource>();
        StmtIterator si = d.listProperties(collectionElementProperty);
        while (si.hasNext()) {
            Resource pop = ((Statement)si.next()).getResource();
            if (pop.getProperty(locationLocatedAtProperty) == null) continue;
            Statement st = pop.getProperty(locationLocatedAtProperty);
            ret.add(st.getResource());
        }
        if (d.getProperty(locationLocatedAtProperty) != null) {
            Statement st = d.getProperty(locationLocatedAtProperty);
            ret.add(st.getResource());
        }
        return ret;
    }

    public static float getLat(Resource loc) {
        return NdlCommons.getFloatProperty(loc, locationLatProperty);
    }

    public static float getLon(Resource loc) {
        return NdlCommons.getFloatProperty(loc, locationLongProperty);
    }

    public static Resource getLinkTo(Resource r) {
        if (r == null) {
            return null;
        }
        Statement s = r.getProperty(linkTo);
        if (s != null) {
            return s.getResource();
        }
        return null;
    }

    public static String readFile(String aFile) {
        BufferedReader bin = null;
        StringBuilder sb = new StringBuilder();
        try {
            FileInputStream is = new FileInputStream(aFile);
            bin = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            String line = null;
            while ((line = bin.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            bin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return sb.toString();
    }

    public static Label getUpperLabel(Resource lsr) {
        Label l = null;
        if (lsr.hasProperty(upperBound)) {
            Resource upperLabel = lsr.getProperty(upperBound).getResource();
            return NdlCommons.parseLayerLabel(upperLabel);
        }
        return l;
    }

    public static Label getLowerLabel(Resource lsr) {
        Label l = null;
        if (lsr.hasProperty(lowerBound)) {
            Resource lowerLabel = lsr.getProperty(lowerBound).getResource();
            return NdlCommons.parseLayerLabel(lowerLabel);
        }
        return l;
    }

    public static String getLabelID(Resource r) {
        String ret = null;
        if (r.hasProperty(layerLabelIdProperty)) {
            ret = r.getProperty(layerLabelIdProperty).getString();
        }
        return ret;
    }

    public static String getLayerLabelLiteral(Resource r) {
        Resource label;
        String ret = null;
        if (r.hasProperty(layerLabel) && (label = r.getProperty(layerLabel).getResource()).hasProperty(layerLabelIdProperty)) {
            ret = label.getProperty(layerLabelIdProperty).getString();
        }
        return ret;
    }

    public static Label parseLayerLabel(Resource r) {
        Label l = null;
        if (NdlCommons.hasResourceType(r, labelOntClass) && r.hasProperty(layerLabelIdProperty)) {
            Float lid = Float.valueOf(r.getProperty(layerLabelIdProperty).getFloat());
            l = new Label(r.getLocalName(), lid.floatValue(), DomainResourceType.VLAN_RESOURCE_TYPE);
        }
        return l;
    }

    public static Label parseLayerLabel_1(Resource r) {
        Label l = null;
        if (r.hasProperty(layerLabelIdProperty)) {
            Float lid = Float.valueOf(r.getProperty(layerLabelIdProperty).getFloat());
            l = new Label(r.getLocalName(), lid.floatValue(), DomainResourceType.VLAN_RESOURCE_TYPE);
        }
        return l;
    }

    public static ResultSet getLabelSet(String set, OntModel ontModel) {
        ResultSet results = null;
        String s = "SELECT ?lv ?uv ?l ?u ?b ";
        String f = "";
        String w = "WHERE {<" + set + ">  collections:element ?b. OPTIONAL{?b layer:upperBound ?u. ?u layer:label_ID ?uv. ?b layer:lowerBound ?l. ?l layer:label_ID ?lv.}.}ORDER BY ASC(?lv)";
        String queryPhrase = NdlCommons.createQueryString(s, f, w);
        results = NdlCommons.rdfQuery((Model)ontModel, queryPhrase);
        return results;
    }

    public static LinkedList<LabelSet> getLabelSet(String set, String rType, OntModel ontModel) {
        ResultSet results = NdlCommons.getLabelSet(set, ontModel);
        int lower = 0;
        int upper = 0;
        String lowerBound = (String)results.getResultVars().get(0);
        String upperBound = (String)results.getResultVars().get(1);
        String l = (String)results.getResultVars().get(2);
        String u = (String)results.getResultVars().get(3);
        String setElement = (String)results.getResultVars().get(4);
        Resource labelRange_rs = null;
        QuerySolution solution = null;
        if (!results.hasNext()) {
            return null;
        }
        LinkedList<LabelSet> lSetList = new LinkedList<LabelSet>();
        Label lowLabel = null;
        Label upLabel = null;
        while (results.hasNext()) {
            solution = results.nextSolution();
            labelRange_rs = solution.getResource(setElement);
            Resource lowerLabel = null;
            Resource upperLabel = null;
            if (solution.getLiteral(lowerBound) != null) {
                lower = solution.getLiteral(lowerBound).getInt();
                upper = solution.getLiteral(upperBound).getInt();
                lowerLabel = solution.getResource(l);
                upperLabel = solution.getResource(u);
            } else {
                lowerLabel = labelRange_rs;
                lower = lowerLabel.getProperty(layerLabelIdProperty).getInt();
            }
            lowLabel = new Label(ontModel.getOntResource(lowerLabel), (float)lower, rType);
            lowLabel.swap = NdlCommons.swapLabel(lowerLabel);
            if (upperLabel != null) {
                upLabel = new Label(ontModel.getOntResource(upperLabel), (float)upper, rType);
                upLabel.swap = NdlCommons.swapLabel(upperLabel);
            }
            LabelSet labelSet = new LabelSet(lowLabel, upLabel, labelRange_rs);
            lSetList.add(labelSet);
        }
        return lSetList;
    }

    public static Float swapLabel(Resource l_rs) {
        int s_id = 0;
        if (l_rs.hasProperty(layerSwapLabelProperty)) {
            Resource s_rs = l_rs.getProperty(layerSwapLabelProperty).getResource();
            s_id = s_rs.getProperty(layerLabelIdProperty).getInt();
        }
        Float ret = Float.valueOf((float)s_id + 0.0f);
        return ret;
    }

    public static Map<String, String> getColorKeys(Resource color) {
        assert (color != null);
        HashMap<String, String> ret = new HashMap<String, String>();
        StmtIterator si = color.listProperties(hasColorAttribute);
        while (si.hasNext()) {
            Resource ca = ((Statement)si.next()).getResource();
            if (ca == null) continue;
            Statement sk = ca.getProperty(hasColorKey);
            Statement sv = ca.getProperty(hasColorValue);
            if (sk == null || sv == null) continue;
            ret.put(sk.getLiteral().getString(), sv.getLiteral().getString());
        }
        return ret;
    }

    public static String getColorBlob(Resource color) {
        assert (color != null);
        Statement bl = color.getProperty(hasColorBlob);
        if (bl != null) {
            return bl.getLiteral().getString();
        }
        return null;
    }

    public static String getColorBlobXML(Resource color, boolean compressed) {
        assert (color != null);
        if (compressed) {
            Statement xbl = color.getProperty(hasColorXMLCompressedBlob);
            if (xbl != null) {
                return NdlGenerator.decodeDecompress(xbl.getLiteral().getString());
            }
        } else {
            Statement xbl = color.getProperty(hasColorXMLBlob);
            if (xbl != null) {
                return xbl.getLiteral().getString();
            }
        }
        return null;
    }

    public static boolean isLinkConnection(Resource r) {
        return r.hasProperty(RDF_TYPE, (RDFNode)topologyLinkConnectionClass);
    }

    public static boolean isBareMetal(Resource r) {
        Statement st;
        return r.hasProperty(domainHasResourceTypeProperty) && ((st = r.getProperty(domainHasResourceTypeProperty)).getResource().equals((Object)bmResourceTypeClass) || st.getResource().equals((Object)fourtygbmResourceTypeClass));
    }

    public static boolean isISCSINetworkStorage(Resource r) {
        Statement st;
        if (!NdlCommons.isNetworkStorage(r)) {
            return false;
        }
        return r.hasProperty(domainHasResourceTypeProperty) && (st = r.getProperty(domainHasResourceTypeProperty)).getResource().equals((Object)lunResourceTypeClass);
    }

    public static boolean isNetworkStorage(Resource r) {
        return r.hasProperty(RDF_TYPE, (RDFNode)networkStorageClass);
    }

    public static boolean isComputeElement(Resource r) {
        return r.hasProperty(RDF_TYPE, (RDFNode)computeElementClass);
    }

    public static Set<Resource> getPeersOrInterfaces(Resource st, boolean peers) {
        String query = NdlCommons.createQueryConnectionPeers(st);
        ResultSet rs = NdlCommons.rdfQuery((Model)((OntModel)st.getModel()), query);
        HashSet<Resource> storagePeers = new HashSet<Resource>();
        while (rs.hasNext()) {
            ResultBinding result = (ResultBinding)rs.next();
            if (peers) {
                storagePeers.add(result.getResource("peer"));
                continue;
            }
            storagePeers.add(result.getResource("interface"));
        }
        return storagePeers;
    }

    public static boolean isMulticastDevice(Resource r) {
        Statement st;
        if (!r.hasProperty(RDF_TYPE, (RDFNode)deviceOntClass)) {
            return false;
        }
        return r.hasProperty(hasCastType) && (st = r.getProperty(hasCastType)).getResource().equals((Object)multicastOntClass);
    }

    public static boolean isStitchingNode(Resource r) {
        if (NdlCommons.hasResourceType(r, deviceOntClass)) {
            Resource dom = NdlCommons.getDomain(r);
            if (dom == null) {
                return false;
            }
            if (dom.getURI().contains(stitching_domain_str)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isStitchingNodeInManifest(Resource r) {
        if (r == null) {
            return false;
        }
        if (NdlCommons.hasResourceType(r, deviceOntClass)) {
            Resource dom = NdlCommons.getDomain(r);
            if (dom == null) {
                return false;
            }
            if (dom.getURI().contains(stitching_domain_str)) {
                return true;
            }
        }
        return false;
    }

    public static String getBareMetalType(Resource r) {
        if (!NdlCommons.isBareMetal(r)) {
            return null;
        }
        Resource spec = NdlCommons.getSpecificCE(r);
        if (spec != null) {
            return spec.getLocalName();
        }
        return null;
    }

    public static String getEC2VMSize(Resource r) {
        Resource spec = NdlCommons.getSpecificCE(r);
        if (spec == null) {
            return null;
        }
        String indName = spec.getLocalName();
        if (indName == null) {
            return null;
        }
        String prefix = null;
        if (indName.startsWith("EC2")) {
            prefix = "EC2";
        } else if (indName.startsWith("Euca")) {
            prefix = "Euca";
        } else if (indName.startsWith("XO")) {
            prefix = "XO";
        }
        if (prefix == null) {
            return null;
        }
        if (!prefix.equals("XO")) {
            indName = indName.replaceFirst(prefix, "").toLowerCase();
            indName = indName.replaceFirst("1", "1.");
        } else {
            indName = indName.replaceFirst(prefix, "xo.").toLowerCase();
        }
        return indName;
    }

    public static Logger getNdlLogger() {
        return Logger.getLogger((String)NDL_LOGGER);
    }

    public static void setPrefix(OntModel model) {
        model.setNsPrefix("dtn", "http://geni-orca.renci.org/owl/dtn.owl#");
        model.setNsPrefix("ethernet", "http://geni-orca.renci.org/owl/ethernet.owl#");
        model.setNsPrefix("topology", "http://geni-orca.renci.org/owl/topology.owl#");
        model.setNsPrefix("collections", "http://geni-orca.renci.org/owl/collections.owl#");
        model.setNsPrefix("layer", "http://geni-orca.renci.org/owl/layer.owl#");
        model.setNsPrefix("ethernet", "http://geni-orca.renci.org/owl/ethernet.owl#");
        model.setNsPrefix("request-schema", "http://geni-orca.renci.org/owl/request.owl#");
        model.setNsPrefix("ip4", "http://geni-orca.renci.org/owl/ip4.owl#");
        model.setNsPrefix("compute", "http://geni-orca.renci.org/owl/compute.owl#");
        model.setNsPrefix("exogeni", "http://geni-orca.renci.org/owl/exogeni.owl#");
        model.setNsPrefix("orca", "http://geni-orca.renci.org/owl/orca.rdf#");
        model.setNsPrefix("domain", "http://geni-orca.renci.org/owl/domain.owl#");
        model.setNsPrefix("eucalyptus", "http://geni-orca.renci.org/owl/eucalyptus.owl#");
        model.setNsPrefix("ec2", "http://geni-orca.renci.org/owl/ec2.owl#");
        model.setNsPrefix("kansei", "http://geni-orca.renci.org/owl/kansei.owl#");
        model.setNsPrefix("planetlab", "http://geni-orca.renci.org/owl/planetlab.owl#");
        model.setNsPrefix("openflow", "http://geni-orca.renci.org/owl/openflow.owl#");
        model.setNsPrefix("geni", "http://geni-orca.renci.org/owl/geni.owl#");
        model.setNsPrefix("modify-schema", "http://geni-orca.renci.org/owl/modify.owl#");
        model.setNsPrefix("app-color", "http://geni-orca.renci.org/owl/app-color.owl#");
    }

    public static String getBigString(int size) {
        SecureRandom random = new SecureRandom();
        return new BigInteger(size, random).toString(32);
    }

    public static void init() {
        NdlModel.setGlobalJenaRedirections();
        ModelFolders.getInstance();
    }

    static {
        hasURLProperty = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasURL");
        hasURNProperty = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasURN");
        hasGUIDProperty = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasGUID");
        topologyHasInterfaceProperty = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasInterface");
        topologyInterfaceOfProperty = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#interfaceOf");
        hasInputInterface = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasInputInterface");
        hasOutputInterface = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasOutputInterface");
        connectedTo = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#connectedTo");
        linkTo = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#linkTo");
        switchedTo = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#switchedTo");
        hasSwitchMatrix = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasSwitchMatrix");
        topologySplittableProperty = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#splittable");
        topologyManagementIP = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#managementIP");
        topologyProxiedPort = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#proxiedPort");
        topologyManagementPort = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#managementPort");
        topologyHasLogin = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasLogin");
        topologyHasName = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasName");
        topologyHasURL = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasURL");
        hostName_p = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hostName");
        hostInterfaceName = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hostInterfaceName");
        layerSwapLabelProperty = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#swapLabel");
        adaptationPropertyOf = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#adaptationPropertyOf");
        adaptationProperty = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#adaptationProperty");
        taggedEthernetProperty = new PropertyImpl("http://geni-orca.renci.org/owl/ethernet.owl#Tagged-Ethernet");
        availableLabelSet = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#availableLabelSet");
        lowerBound = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#lowerBound");
        upperBound = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#upperBound");
        switchingCapability = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#switchingCapability");
        swappingCapability = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#swappingCapability");
        tunnelingCapability = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#tunnelingCapability");
        connectionDirection = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#connectionDirection");
        atLayer = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#atLayer");
        hasCastType = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#hasCastType");
        layerBandwidthProperty = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#bandwidth");
        layerLatencyProperty = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#latency");
        layerLabel = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#label");
        layerLabelIdProperty = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#label_ID");
        layerLabelIsPrimary = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#isPrimary");
        layerUsedLabels = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#usedLabels");
        numCEProperty = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#numCE");
        isLabelProducer = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#isLabelProducer");
        modifySubjectProperty = new PropertyImpl("http://geni-orca.renci.org/owl/modify.owl#modifySubject");
        modifyAddElementProperty = new PropertyImpl("http://geni-orca.renci.org/owl/modify.owl#addElement");
        modifyElementProperty = new PropertyImpl("http://geni-orca.renci.org/owl/modify.owl#modifyElement");
        isModifyProperty = new PropertyImpl("http://geni-orca.renci.org/owl/modify.owl#isModify");
        modifyRemoveElementProperty = new PropertyImpl("http://geni-orca.renci.org/owl/modify.owl#removeElement");
        modifyIncreaseByProperty = new PropertyImpl("http://geni-orca.renci.org/owl/modify.owl#increaseBy");
        manifestHasParent = new PropertyImpl("http://geni-orca.renci.org/owl/manifest.owl#hasParent");
        manifestHasChild = new PropertyImpl("http://geni-orca.renci.org/owl/manifest.owl#hasChild");
        collectionElementProperty = new PropertyImpl("http://geni-orca.renci.org/owl/collections.owl#element");
        collectionItemProperty = new PropertyImpl("http://geni-orca.renci.org/owl/collections.owl#item");
        collectionSizeProperty = new PropertyImpl("http://geni-orca.renci.org/owl/collections.owl#size");
        carryReservation = new PropertyImpl("http://geni-orca.renci.org/owl/request.owl#carryReservation");
        requestHasReservationState = new PropertyImpl("http://geni-orca.renci.org/owl/request.owl#hasReservationState");
        requestMessage = new PropertyImpl("http://geni-orca.renci.org/owl/request.owl#message");
        requestPostBootScriptProperty = new PropertyImpl("http://geni-orca.renci.org/owl/request.owl#postBootScript");
        inDomainProperty = new PropertyImpl("http://geni-orca.renci.org/owl/request.owl#inDomain");
        requestGroupNameProperty = new PropertyImpl("http://geni-orca.renci.org/owl/request.owl#groupName");
        hasRequestGroupURL = new PropertyImpl("http://geni-orca.renci.org/owl/compute.owl#hasRequestGroupURL");
        inRequestNetworkConnection = new PropertyImpl("http://geni-orca.renci.org/owl/compute.owl#inRequestNetworkConnection");
        cpuCapacity = new PropertyImpl("http://geni-orca.renci.org/owl/compute.owl#cpuCapacity");
        memoryCapacity = new PropertyImpl("http://geni-orca.renci.org/owl/compute.owl#memoryCapacity");
        diskImageProperty = new PropertyImpl("http://geni-orca.renci.org/owl/compute.owl#diskImage");
        specificCEProperty = new PropertyImpl("http://geni-orca.renci.org/owl/compute.owl#specificCE");
        hasUnitServer = new PropertyImpl("http://geni-orca.renci.org/owl/compute.owl#hasUnitServer");
        numResource = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#numResource");
        numHop = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#numHop");
        numCPUCore = new PropertyImpl("http://geni-orca.renci.org/owl/compute.owl#numCPUCore");
        virtualizeProperty = new PropertyImpl("http://geni-orca.renci.org/owl/compute.owl#virtualize");
        storageCapacity = new PropertyImpl("http://geni-orca.renci.org/owl/storage.owl#storageCapacity");
        hasFSParam = new PropertyImpl("http://geni-orca.renci.org/owl/storage.owl#hasFSParam");
        hasFSType = new PropertyImpl("http://geni-orca.renci.org/owl/storage.owl#hasFSType");
        doFormat = new PropertyImpl("http://geni-orca.renci.org/owl/storage.owl#doFormat");
        hasMntPoint = new PropertyImpl("http://geni-orca.renci.org/owl/storage.owl#hasMntPoint");
        ipMacAddressProperty = new PropertyImpl("http://geni-orca.renci.org/owl/ip4.owl#macAddress");
        ip4LocalIPAddressProperty = new PropertyImpl("http://geni-orca.renci.org/owl/ip4.owl#localIPAddress");
        ip4NetmaskProperty = new PropertyImpl("http://geni-orca.renci.org/owl/ip4.owl#netmask");
        requestDependOnProperty = new PropertyImpl("http://geni-orca.renci.org/owl/request.owl#dependOn");
        resourceTypeRank = new PropertyImpl("http://geni-orca.renci.org/owl/domain.owl#resourceTypeRank");
        domainHasResourceTypeProperty = new PropertyImpl("http://geni-orca.renci.org/owl/domain.owl#hasResourceType");
        domainHasServiceProperty = new PropertyImpl("http://geni-orca.renci.org/owl/domain.owl#hasService");
        domainProxyProperty = new PropertyImpl("http://geni-orca.renci.org/owl/domain.owl#proxy");
        domainHasAccessMethod = new PropertyImpl("http://geni-orca.renci.org/owl/domain.owl#hasAccessMethod");
        domainHasTopology = new PropertyImpl("http://geni-orca.renci.org/owl/domain.owl#hasTopology");
        domainIsAllocatable = new PropertyImpl("http://geni-orca.renci.org/owl/domain.owl#isAllocatable");
        domainHasAggregateManager = new PropertyImpl("http://geni-orca.renci.org/owl/domain.owl#hasAggregateManager");
        domainHasController = new PropertyImpl("http://geni-orca.renci.org/owl/domain.owl#hasController");
        openflowCapableProperty = new PropertyImpl("http://geni-orca.renci.org/owl/openflow.owl#openflowCapable");
        quantumNetUUIDProperty = new PropertyImpl("http://geni-orca.renci.org/owl/openflow.owl#quantumNetUUID");
        daysProperty = new PropertyImpl("http://www.w3.org/2006/time#days");
        hoursProperty = new PropertyImpl("http://www.w3.org/2006/time#hours");
        minutesProperty = new PropertyImpl("http://www.w3.org/2006/time#minutes");
        secondsProperty = new PropertyImpl("http://www.w3.org/2006/time#seconds");
        inXSDDateTime = new PropertyImpl("http://www.w3.org/2006/time#inXSDDateTime");
        hasBeginningObjectProperty = new PropertyImpl("http://www.w3.org/2006/time#hasBeginning");
        hasEndObjectProperty = new PropertyImpl("http://www.w3.org/2006/time#hasEnd");
        hasDurationDescriptionObjectProperty = new PropertyImpl("http://www.w3.org/2006/time#hasDurationDescription");
        locationLocatedAtProperty = new PropertyImpl("http://geni-orca.renci.org/owl/location.owl#locatedAt");
        locationLatProperty = new PropertyImpl("http://www.w3.org/2003/01/geo/wgs84_pos#lat");
        locationLongProperty = new PropertyImpl("http://www.w3.org/2003/01/geo/wgs84_pos#long");
        RDF_TYPE = new PropertyImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        RDFS_Label = new PropertyImpl("http://www.w3.org/2000/01/rdf-schema#label");
        RDFS_SeeAlso = new PropertyImpl("http://www.w3.org/2000/01/rdf-schema#", "SeeAlso");
        OWL_sameAs = new PropertyImpl("http://www.w3.org/2002/07/owl#sameAs");
        vlan = new PropertyImpl("http://geni-orca.renci.org/owl/ethernet.owl#vlan");
        ocgLine = new PropertyImpl("http://geni-orca.renci.org/owl/dtn.owl#ocgLine");
        portOccupied = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#portOccupied");
        inConnection = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#inConnection");
        visited = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#visited");
        layerHasBitRate = new PropertyImpl("http://geni-orca.renci.org/owl/layer.owl#hasBitRate");
        hasEmailProperty = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasEmail");
        hasDNProperty = new PropertyImpl("http://geni-orca.renci.org/owl/topology.owl#hasDN");
        hasSlicePasswordProperty = new PropertyImpl("http://geni-orca.renci.org/owl/openflow.owl#hasSlicePassword");
        geniSliceProperty = new PropertyImpl("http://geni-orca.renci.org/owl/geni.owl#slice");
        openflowControllerProperty = new PropertyImpl("http://geni-orca.renci.org/owl/openflow.owl#controller");
        hasSliceGeniState = new PropertyImpl("http://geni-orca.renci.org/owl/geni.owl#hasSliceGeniState");
        hasInstanceIDProperty = new PropertyImpl("http://geni-orca.renci.org/owl/ec2.owl#hasInstanceID");
        workerNodeIDProperty = new PropertyImpl("http://geni-orca.renci.org/owl/ec2.owl#workerNodeID");
        networkStorageClass = new ResourceImpl("http://geni-orca.renci.org/owl/storage.owl#NetworkStorage");
        topologyNetworkConnectionClass = new ResourceImpl("http://geni-orca.renci.org/owl/topology.owl#NetworkConnection");
        topologyBroadcastConnectionClass = new ResourceImpl("http://geni-orca.renci.org/owl/topology.owl#BroadcastConnection");
        topologyLinkConnectionClass = new ResourceImpl("http://geni-orca.renci.org/owl/topology.owl#LinkConnection");
        topologyLinkClass = new ResourceImpl("http://geni-orca.renci.org/owl/topology.owl#Link");
        deviceOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/topology.owl#Device");
        switchingMatrixOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/topology.owl#SwitchingMatrix");
        interfaceOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/topology.owl#Interface");
        vlanResourceTypeClass = new ResourceImpl("http://geni-orca.renci.org/owl/domain.owl#VLAN");
        ethernetNetworkElementClass = new ResourceImpl("http://geni-orca.renci.org/owl/ethernet.owl#EthernetNetworkElement");
        computeElementClass = new ResourceImpl("http://geni-orca.renci.org/owl/compute.owl#ComputeElement");
        vmResourceTypeClass = new ResourceImpl("http://geni-orca.renci.org/owl/compute.owl#VM");
        bmResourceTypeClass = new ResourceImpl("http://geni-orca.renci.org/owl/compute.owl#BareMetalCE");
        fourtygbmResourceTypeClass = new ResourceImpl("http://geni-orca.renci.org/owl/compute.owl#FourtyGBareMetalCE");
        lunResourceTypeClass = new ResourceImpl("http://geni-orca.renci.org/owl/storage.owl#LUN");
        serverCloudClass = new ResourceImpl("http://geni-orca.renci.org/owl/compute.owl#ServerCloud");
        topologyCrossConnectClass = new ResourceImpl("http://geni-orca.renci.org/owl/topology.owl#CrossConnect");
        domainAggregateManagerClass = new ResourceImpl("http://geni-orca.renci.org/owl/domain.owl#AggregateManager");
        domainControllerClass = new ResourceImpl("http://geni-orca.renci.org/owl/domain.owl#Controller");
        domainSSHServiceClass = new ResourceImpl("http://geni-orca.renci.org/owl/domain.owl#SSH");
        requestActiveState = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#Active");
        requestActiveTicketedState = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#ActiveTicketed");
        requestCloseWaitState = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#CloseWait");
        requestClosedState = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#Closed");
        requestFailedState = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#Failed");
        requestNascentState = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#Nascent");
        requestNoState = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#No_state");
        requestTicketedState = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#Ticketed");
        requestReservationStateClass = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#ReservationState");
        geniSliceStateConfiguring = new ResourceImpl("http://geni-orca.renci.org/owl/geni.owl#configuring");
        geniSliceStateFailed = new ResourceImpl("http://geni-orca.renci.org/owl/geni.owl#failed");
        geniSliceStateReady = new ResourceImpl("http://geni-orca.renci.org/owl/geni.owl#ready");
        geniSliceStateUnknown = new ResourceImpl("http://geni-orca.renci.org/owl/geni.owl#unknown");
        reservationOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#Reservation");
        manifestOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/request.owl#Manifest");
        instantOntClass = new ResourceImpl("http://www.w3.org/2006/time.owl#Instant");
        networkDomainOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/topology.owl#NetworkDomain");
        networkServiceClass = new ResourceImpl("http://geni-orca.renci.org/owl/domain.owl#NetworkService");
        multicastOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/layer.owl#Multicast");
        labelRangeOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/layer.owl#LabelRange");
        labelOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/layer.owl#Label");
        labelSetOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/layer.owl#LabelSet");
        IPAddressOntClass = new ResourceImpl("http://geni-orca.renci.org/owl/ip4.owl#IPAddress");
        proxyClass = new ResourceImpl("http://geni-orca.renci.org/owl/domain.owl#Proxy");
        tcpProxyClass = new ResourceImpl("http://geni-orca.renci.org/owl/domain.owl#TCPProxy");
        sliceClass = new ResourceImpl("http://geni-orca.renci.org/owl/geni.owl#Slice");
        ofSliceClass = new ResourceImpl("http://geni-orca.renci.org/owl/openflow.owl#OFSlice");
        sliceGeniStateClass = new ResourceImpl("http://geni-orca.renci.org/owl/geni.owl#SliceGeniState");
        openflowV1_0Ind = new ResourceImpl("http://geni-orca.renci.org/owl/openflow.owl#OpenFlow-1.0");
        openflowV1_1Ind = new ResourceImpl("http://geni-orca.renci.org/owl/openflow.owl#OpenFlow-1.1");
        openflowV1_2Ind = new ResourceImpl("http://geni-orca.renci.org/owl/openflow.owl#OpenFlow-1.2");
        openflowV1_3Ind = new ResourceImpl("http://geni-orca.renci.org/owl/openflow.owl#OpenFlow-1.3");
        bitRate1G = new ResourceImpl("http://geni-orca.renci.org/owl/layer.owl#1G");
        bitRate10G = new ResourceImpl("http://geni-orca.renci.org/owl/layer.owl#10G");
        stitchingDomain = new ResourceImpl("http://geni-orca.renci.org/owl/orca.rdf#Stitching/Domain");
        diskImageClass = new ResourceImpl("http://geni-orca.renci.org/owl/exogeni.owl#DiskImage");
        hasColorAttribute = new PropertyImpl("http://geni-orca.renci.org/owl/app-color.owl#hasColorAttribute");
        hasColorBlob = new PropertyImpl("http://geni-orca.renci.org/owl/app-color.owl#hasColorBlob");
        hasColorKey = new PropertyImpl("http://geni-orca.renci.org/owl/app-color.owl#hasColorKey");
        hasColorLabel = new PropertyImpl("http://geni-orca.renci.org/owl/app-color.owl#hasColorLabel");
        hasColorValue = new PropertyImpl("http://geni-orca.renci.org/owl/app-color.owl#hasColorValue");
        hasColorXMLBlob = new PropertyImpl("http://geni-orca.renci.org/owl/app-color.owl#hasColorXMLBlob");
        hasColorXMLCompressedBlob = new PropertyImpl("http://geni-orca.renci.org/owl/app-color.owl#hasColorXMLCompressedBlob");
    }

    public static class ProxyFields {
        public String mgtIp;
        public short mgtPort;
        public short proxiedPort;
    }
}

