/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.exogeni.orca.ndl.DomainResourceType;
import net.exogeni.orca.ndl.INdlAbstractDelegationModelListener;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.NdlException;
import net.exogeni.orca.ndl.NdlModel;
import net.exogeni.orca.ndl.OntProcessor;
import net.exogeni.orca.ndl.elements.Label;
import net.exogeni.orca.ndl.elements.LabelSet;

public class NdlAbstractDelegationParser
extends NdlCommons {
    INdlAbstractDelegationModelListener listener;
    OntModel delegationModel;
    Set<Resource> interfaces = new HashSet<Resource>();

    public NdlAbstractDelegationParser(String delegation, INdlAbstractDelegationModelListener l) throws NdlException {
        if (delegation == null || l == null) {
            throw new NdlException("Null parameters to the NdlAbstractDelegationParser constructor");
        }
        this.listener = l;
        this.delegationModel = NdlModel.getModelFromString(delegation, null, true);
    }

    public NdlAbstractDelegationParser(String delegation, INdlAbstractDelegationModelListener l, NdlModel.ModelType t, String folderName) throws NdlException {
        if (delegation == null || l == null) {
            throw new NdlException("Null parameters to the NdlAbstractDelegationParser constructor");
        }
        this.listener = l;
        this.delegationModel = NdlModel.getModelFromString(delegation, null, true, t, folderName);
    }

    private List<LabelSet> parseLabelSet(Resource lsr) {
        DomainResourceType drt = NdlCommons.getDomainResourceType(lsr);
        ArrayList<LabelSet> lsl = new ArrayList<LabelSet>();
        LabelSet ls = null;
        StmtIterator si = lsr.listProperties(collectionElementProperty);
        if (si.hasNext()) {
            while (si.hasNext()) {
                Resource lsp = ((Statement)si.next()).getResource();
                Label upper = NdlCommons.getUpperLabel(lsp);
                Label lower = NdlCommons.getLowerLabel(lsp);
                if (upper != null && lower != null) {
                    ls = new LabelSet(lower, upper, lsr);
                } else {
                    Label single = NdlCommons.parseLayerLabel_1(lsp);
                    if (single != null) {
                        ls = new LabelSet(single, single, lsr);
                    }
                }
                if (ls == null) continue;
                ls.setSize = NdlAbstractDelegationParser.getSizeProperty(lsr);
                ls.resourceUri = lsr.getURI();
                ls.LabelType = drt.resourceType;
                Statement isAllocSt = lsr.getProperty(domainIsAllocatable);
                if (isAllocSt != null && "false".equalsIgnoreCase(isAllocSt.getString())) {
                    ls.setNotAllocatable();
                }
                lsl.add(ls);
            }
        } else {
            ls = new LabelSet();
            ls.setSize = NdlAbstractDelegationParser.getSizeProperty(lsr);
            ls.resourceUri = lsr.getURI();
            ls.LabelType = drt.resourceType;
            lsl.add(ls);
        }
        return lsl;
    }

    public synchronized void processDelegationModel() throws NdlException {
        if (this.delegationModel == null) {
            return;
        }
        ResIterator resit = this.delegationModel.listResourcesWithProperty(RDF_TYPE, (RDFNode)networkDomainOntClass);
        while (resit.hasNext()) {
            Resource dom = (Resource)resit.next();
            ArrayList<Resource> nsl = new ArrayList<Resource>();
            ArrayList<LabelSet> lsl = new ArrayList<LabelSet>();
            StmtIterator nsIt = dom.listProperties(domainHasServiceProperty);
            while (nsIt.hasNext()) {
                Resource ns = ((Statement)nsIt.next()).getResource();
                nsl.add(ns);
                StmtIterator alsIt = ns.listProperties(availableLabelSet);
                while (alsIt.hasNext()) {
                    Resource lsr = ((Statement)alsIt.next()).getResource();
                    List<LabelSet> lsT = this.parseLabelSet(lsr);
                    if (lsT == null) continue;
                    lsl.addAll(lsT);
                }
            }
            HashMap<Resource, List<LabelSet>> netLabelSets = new HashMap<Resource, List<LabelSet>>();
            for (Resource domInt : NdlAbstractDelegationParser.getResourceInterfaces(dom)) {
                ArrayList<LabelSet> mapLsl = new ArrayList<LabelSet>();
                StmtIterator alsInt = domInt.listProperties(availableLabelSet);
                while (alsInt.hasNext()) {
                    Resource lsr = ((Statement)alsInt.next()).getResource();
                    List<LabelSet> lsT = this.parseLabelSet(lsr);
                    if (lsT == null) continue;
                    mapLsl.addAll(lsT);
                }
                netLabelSets.put(domInt, mapLsl);
            }
            this.listener.ndlNetworkDomain(dom, this.delegationModel, nsl, NdlAbstractDelegationParser.getResourceInterfaces(dom), lsl, netLabelSets);
            this.interfaces.addAll(NdlAbstractDelegationParser.getResourceInterfaces(dom));
        }
        for (Resource tmpR : this.interfaces) {
            Statement locIPStmt;
            Resource u;
            String query = NdlCommons.createQueryStringWhoHasInterface(tmpR);
            ResultSet rs = OntProcessor.rdfQuery((Model)this.delegationModel, query);
            if (rs == null || !rs.hasNext()) continue;
            ResultBinding result = (ResultBinding)rs.next();
            Resource conn = null;
            Resource node = null;
            if (result != null) {
                u = (Resource)result.get("item");
                if (u.hasProperty(RDF_TYPE, (RDFNode)topologyLinkConnectionClass) || u.hasProperty(RDF_TYPE, (RDFNode)topologyNetworkConnectionClass)) {
                    conn = u;
                } else {
                    node = u;
                }
            }
            if (rs.hasNext() && (result = (ResultBinding)rs.next()) != null) {
                u = (Resource)result.get("item");
                if (u.hasProperty(RDF_TYPE, (RDFNode)topologyLinkConnectionClass) || u.hasProperty(RDF_TYPE, (RDFNode)topologyNetworkConnectionClass)) {
                    conn = u;
                } else {
                    node = u;
                }
            }
            if ((locIPStmt = tmpR.getProperty(ip4LocalIPAddressProperty)) != null) {
                this.listener.ndlInterface(tmpR, this.delegationModel, conn, node, NdlAbstractDelegationParser.getAddressIP(locIPStmt.getResource()), NdlAbstractDelegationParser.getAddressNetmask(locIPStmt.getResource()));
                continue;
            }
            this.listener.ndlInterface(tmpR, this.delegationModel, conn, node, null, null);
        }
        this.listener.ndlParseComplete();
    }

    public synchronized void freeModel() {
        NdlModel.closeModel(this.delegationModel);
        this.delegationModel = null;
    }
}

