/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.exogeni.orca.ndl.DomainResource;
import net.exogeni.orca.ndl.DomainResourceType;
import net.exogeni.orca.util.persistence.Persistable;

public class DomainResources {
    protected HashMap<String, DomainResourceType> resType = new HashMap();
    protected HashMap<String, DomainResource> constraintMap = new HashMap();

    public List<DomainResourceType> getResourceType() {
        ArrayList<DomainResourceType> t = new ArrayList<DomainResourceType>(this.resType.values().size());
        for (DomainResourceType r : this.resType.values()) {
            t.add(r);
        }
        return t;
    }

    public DomainResourceType getResourceType(String type) {
        return this.resType.get(type);
    }

    public void addResourceType(DomainResourceType type) {
        this.resType.put(type.getResourceType(), type);
    }

    public void addResourceType(String type, int units) {
        this.resType.get(type).add(units);
    }

    public boolean hasType(String type) {
        return this.resType.get(type) != null;
    }

    public List<DomainResource> getResources() {
        ArrayList<DomainResource> l = new ArrayList<DomainResource>(this.constraintMap.values().size());
        for (DomainResource r : this.constraintMap.values()) {
            l.add(r);
        }
        return l;
    }

    public DomainResource getResource(String iface) {
        return this.constraintMap.get(iface);
    }

    public void addResource(DomainResource resource) {
        this.constraintMap.put(resource.getInterface(), resource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DomainResources resType: \n");
        for (Map.Entry<String, DomainResourceType> entry : this.resType.entrySet()) {
            sb.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        sb.append("DomainResources constriaintMap:\n");
        for (Map.Entry<String, Persistable> entry : this.constraintMap.entrySet()) {
            sb.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        return sb.toString();
    }
}

