/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.rdf.model.Resource;
import java.io.File;
import net.exogeni.orca.ndl.LayerConstant;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.util.persistence.Persistable;
import net.exogeni.orca.util.persistence.Persistent;

public class DomainResourceType
implements LayerConstant,
Comparable<DomainResourceType>,
Persistable {
    public static String BM_RESOURCE_TYPE = "baremetalce";
    public static String FourtyGBM_RESOURCE_TYPE = "fourtygbaremetalce";
    public static String VM_RESOURCE_TYPE = "vm";
    public static String VLAN_RESOURCE_TYPE = "vlan";
    public static String LUN_RESOURCE_TYPE = "lun";
    @Persistent
    protected String domainURL;
    @Persistent
    protected String resourceType;
    @Persistent
    protected Integer count;
    @Persistent
    protected Integer rank;

    public DomainResourceType() {
        this.count = 0;
    }

    public DomainResourceType(String resourceType, int count) {
        this.resourceType = resourceType;
        this.count = count;
    }

    public Resource getTypeResource() {
        Resource type_rs = null;
        if (this.resourceType == null) {
            return null;
        }
        if (this.resourceType.toLowerCase().endsWith(VM_RESOURCE_TYPE)) {
            return NdlCommons.vmResourceTypeClass;
        }
        if (this.resourceType.toLowerCase().endsWith(BM_RESOURCE_TYPE)) {
            return NdlCommons.bmResourceTypeClass;
        }
        if (this.resourceType.toLowerCase().endsWith(FourtyGBM_RESOURCE_TYPE)) {
            return NdlCommons.fourtygbmResourceTypeClass;
        }
        if (this.resourceType.toLowerCase().endsWith(LUN_RESOURCE_TYPE)) {
            return NdlCommons.lunResourceTypeClass;
        }
        if (this.resourceType.toLowerCase().endsWith(VLAN_RESOURCE_TYPE)) {
            return NdlCommons.vlanResourceTypeClass;
        }
        return type_rs;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public static String generateDomainName(String rdf, String typeName) {
        if (rdf == null) {
            return "undefined";
        }
        String fName = new File(rdf).getName();
        String domName = fName.split("[.]")[0];
        if ((domName = domName.split("\\-")[0]).length() == 0) {
            domName = "undefined";
        }
        String[] rType = typeName.split("[.]");
        typeName = rType[rType.length - 1];
        return domName + "/" + typeName;
    }

    public static String generateDomainResourceName(String domainName) {
        if (domainName == null) {
            return "undefined";
        }
        String[] value12 = domainName.split("\\/");
        String value1 = null;
        String value2 = null;
        value1 = value12[0];
        String domainNameURL = "http://geni-orca.renci.org/owl/" + value1 + ".rdf#";
        domainNameURL = domainNameURL + value1 + "/Domain";
        if (value12.length == 2) {
            value2 = value12[1];
            domainNameURL = domainNameURL + "/" + value2;
        }
        return domainNameURL;
    }

    public static String getSiteFromType(String type) {
        int siteEnd = type.lastIndexOf(46);
        String site = -1 != siteEnd ? type.substring(0, siteEnd) : type;
        siteEnd = site.lastIndexOf(47);
        if (-1 != siteEnd) {
            site = site.substring(0, siteEnd);
        }
        return site;
    }

    public String toString() {
        return this.resourceType + ":" + this.count + ":" + this.rank + ":" + this.domainURL;
    }

    @Override
    public int compareTo(DomainResourceType ne) {
        int compare = 0;
        if (ne == null) {
            return 1;
        }
        if (this.getCount() < ne.getCount()) {
            compare = 1;
        } else if (this.getCount() > ne.getCount()) {
            compare = -1;
        }
        return compare;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getDomainURL() {
        return this.domainURL;
    }

    public void setDomainURL(String domainURL) {
        this.domainURL = domainURL;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceTypeURL() {
        if (this.resourceType.endsWith("vm")) {
            return NdlCommons.vmResourceTypeClass.getURI();
        }
        if (this.resourceType.endsWith("vlan")) {
            return NdlCommons.vlanResourceTypeClass.getURI();
        }
        return null;
    }

    public int getCount() {
        return this.count;
    }

    public void add(int units) {
        this.count = this.count + units;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }
}

