/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl.elements;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.exogeni.orca.ndl.elements.OrcaReservationTerm;
import org.junit.Assert;
import org.junit.Test;

public class OrcaReservationTermTest {
    public static final int NUM_DAYS = 1;

    @Test
    public void getDurationInMinutes() throws Exception {
        OrcaReservationTerm term = new OrcaReservationTerm();
        term.setStart(new Date());
        term.setDuration(1, 0, 0, 0);
        int durationInMinutes = term.getDurationInMinutes();
        Assert.assertEquals((String)"Duration in Minutes did not match expected", (long)TimeUnit.DAYS.toMinutes(1L), (long)durationInMinutes);
    }

    @Test
    public void getDurationInSeconds() throws Exception {
        OrcaReservationTerm term = new OrcaReservationTerm();
        term.setStart(new Date());
        term.setDuration(1, 0, 0, 0);
        int durationInSeconds = term.getDurationInSeconds();
        Assert.assertEquals((String)"Duration in Seconds did not match expected", (long)TimeUnit.DAYS.toSeconds(1L), (long)durationInSeconds);
    }

    @Test
    public void setDurationInDays() throws Exception {
        OrcaReservationTerm term = new OrcaReservationTerm();
        term.setStart(new Date());
        term.setDuration(1, 0, 0, 0);
        Date termEnd = term.end;
        Calendar termStart = Calendar.getInstance();
        termStart.setTime(term.start);
        termStart.add(6, 1);
        Assert.assertEquals((String)"Term end did not match expected value.", (Object)termStart.getTime(), (Object)termEnd);
    }

    @Test
    public void setDurationInHours() throws Exception {
        OrcaReservationTerm term = new OrcaReservationTerm();
        term.setStart(new Date());
        term.setDuration(0, Math.toIntExact(TimeUnit.DAYS.toHours(1L)), 0, 0);
        Date termEnd = term.end;
        Calendar termStart = Calendar.getInstance();
        termStart.setTime(term.start);
        termStart.add(6, 1);
        Assert.assertEquals((String)"Term end did not match expected value.", (Object)termStart.getTime(), (Object)termEnd);
    }

    @Test
    public void setDurationInMinutes() throws Exception {
        OrcaReservationTerm term = new OrcaReservationTerm();
        term.setStart(new Date());
        term.setDuration(0, 0, Math.toIntExact(TimeUnit.DAYS.toMinutes(1L)), 0);
        Date termEnd = term.end;
        Calendar termStart = Calendar.getInstance();
        termStart.setTime(term.start);
        termStart.add(6, 1);
        Assert.assertEquals((String)"Term end did not match expected value.", (Object)termStart.getTime(), (Object)termEnd);
    }

    @Test
    public void setDurationInSeconds() throws Exception {
        OrcaReservationTerm term = new OrcaReservationTerm();
        term.setStart(new Date());
        term.setDuration(0, 0, 0, Math.toIntExact(TimeUnit.DAYS.toSeconds(1L)));
        Date termEnd = term.end;
        Calendar termStart = Calendar.getInstance();
        termStart.setTime(term.start);
        termStart.add(6, 1);
        Assert.assertEquals((String)"Term end did not match expected value.", (Object)termStart.getTime(), (Object)termEnd);
    }
}

