/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import net.exogeni.orca.ndl.NdlCommons;
import net.exogeni.orca.ndl.NdlException;
import net.exogeni.orca.ndl.NdlModel;

public class TestValidator {
    OntModel requestModel = null;
    protected String[] inferenceModels = new String[]{"topology.owl", "compute.owl"};

    public TestValidator() {
        NdlCommons.init();
        OntDocumentManager dm = OntDocumentManager.getInstance();
        dm.getFileManager().addLocator((Locator)new NdlModel.LocatorJarURL());
        PrintUtil.registerPrefix((String)"dom", (String)"http://geni-orca.renci.org/owl/domain.owl#");
        PrintUtil.registerPrefix((String)"comp", (String)"http://geni-orca.renci.org/owl/compute.owl#");
        PrintUtil.registerPrefix((String)"req", (String)"http://geni-orca.renci.org/owl/request.owl#");
        PrintUtil.registerPrefix((String)"orca", (String)"http://geni-orca.renci.org/owl/orca.owl#");
        PrintUtil.registerPrefix((String)"storage", (String)"http://geni-orca.renci.org/owl/storage.owl#");
        PrintUtil.registerPrefix((String)"col", (String)"http://geni-orca.renci.org/owl/collections.owl#");
        PrintUtil.registerPrefix((String)"topo", (String)"http://geni-orca.renci.org/owl/topology.owl#");
    }

    public void openModel(String fName) throws NdlException {
        String ndlRequest = TestValidator.loadFile(fName);
        ByteArrayInputStream modelStream = new ByteArrayInputStream(ndlRequest.getBytes());
        this.requestModel = NdlModel.getRequestModelFromStream((InputStream)modelStream, (OntModelSpec)OntModelSpec.OWL_MEM_RDFS_INF, (boolean)true);
        for (String model : this.inferenceModels) {
            this.requestModel.read("http://geni-orca.renci.org/owl/" + model);
        }
        ValidityReport rep = this.requestModel.validate();
        TestValidator.getValidityOutput(rep);
    }

    public void openModel1(String fName) throws NdlException {
        ClassLoader cl = NdlCommons.class.getProtectionDomain().getClassLoader();
        OntModel allSchemas = ModelFactory.createOntologyModel();
        for (String mode : this.inferenceModels) {
            System.out.println("Validating against " + mode);
            URL schemaowl = cl.getResource("net/exogeni/orca/ndl/schema/" + mode);
            System.out.println("Trying to load " + schemaowl.toString());
            Model schema1 = FileManager.get().loadModel(schemaowl.toString());
            Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
            reasoner = reasoner.bindSchema(schema1);
            Model data = FileManager.get().loadModel(fName);
            InfModel model = ModelFactory.createInfModel((Reasoner)reasoner, (Model)data);
            ValidityReport rep = model.validate();
            TestValidator.getValidityOutput(rep);
            allSchemas.add(schema1);
        }
        System.out.println("Validating against all");
        Reasoner reasonerAll = ReasonerRegistry.getOWLReasoner();
        reasonerAll.bindSchema((Model)allSchemas);
        Model data = FileManager.get().loadModel(fName);
        InfModel model = ModelFactory.createInfModel((Reasoner)reasonerAll, (Model)data);
        ValidityReport rep = model.validate();
        TestValidator.getValidityOutput(rep);
    }

    public static void testData(String dataF, String schemaF) {
        Model schema = FileManager.get().loadModel(schemaF);
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        reasoner.bindSchema(schema);
        Model data = FileManager.get().loadModel(dataF);
        InfModel model = ModelFactory.createInfModel((Reasoner)reasoner, (Model)data);
        ValidityReport rep = model.validate();
        TestValidator.getValidityOutput(rep);
        Resource res = model.getResource("http://www.semanticweb.org/ontologies/2013/8/untitled-ontology-45#Image1");
        System.out.println("Image types:");
        TestValidator.printStatements((Model)model, res, RDF.type, null);
    }

    public static void printStatements(Model m, Resource s, Property p, Resource o) {
        StmtIterator i = m.listStatements(s, p, (RDFNode)o);
        while (i.hasNext()) {
            Statement stmt = i.nextStatement();
            System.out.println(" - " + PrintUtil.print((Statement)stmt));
        }
    }

    public static void getValidityOutput(ValidityReport rep) {
        if (rep.isValid()) {
            System.out.println("Model is valid");
        }
        if (rep.isClean()) {
            System.out.println("Model is clean");
        }
        System.out.println("Report: ");
        Iterator i = rep.getReports();
        while (i.hasNext()) {
            System.out.println("   - " + i.next());
        }
    }

    public void validateModelWithRules(String fName) {
        System.out.println("Using rule file " + fName);
        ClassLoader cl = NdlCommons.class.getProtectionDomain().getClassLoader();
        URL url = cl.getResource("net/exogeni/orca/ndl/rules/" + fName);
        List rules = Rule.rulesFromURL((String)url.toString());
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        reasoner.setOWLTranslation(true);
        reasoner.setTransitiveClosureCaching(true);
        InfModel testModel = ModelFactory.createInfModel((Reasoner)reasoner, (Model)this.requestModel);
        TestValidator.getValidityOutput(testModel.validate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFile(String name) {
        StringBuilder sb = null;
        try {
            BufferedReader bin = null;
            File f = new File(name);
            FileInputStream is = new FileInputStream(f);
            bin = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            sb = new StringBuilder();
            String line = null;
            while ((line = bin.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            bin.close();
        }
        catch (Exception e) {
            System.err.println("Error " + e + " encountered while readling file " + name);
            System.exit(1);
        }
        if (sb != null) {
            return sb.toString();
        }
        return null;
    }

    public static void main(String[] argv) {
        System.out.println("Checking validity of request " + argv[0]);
        TestValidator tv = new TestValidator();
        long now = System.currentTimeMillis();
        try {
            tv.openModel(argv[0]);
        }
        catch (Exception e) {
            System.err.println("Exception encountered: " + e.getMessage());
        }
        long then = System.currentTimeMillis();
        System.out.println("Validation took " + (then - now));
        now = System.currentTimeMillis();
        try {
            tv.validateModelWithRules(argv[1]);
        }
        catch (Exception e) {
            System.err.println("Exception with rules: " + e.getMessage());
            e.printStackTrace();
        }
        then = System.currentTimeMillis();
        System.out.println("Validation took " + (then - now));
    }
}

