/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.exogeni.orca.ndl.INdlManifestModelListener;
import net.exogeni.orca.ndl.INdlRequestModelListener;
import net.exogeni.orca.ndl.NdlManifestParser;
import net.exogeni.orca.ndl.NdlModel;
import net.exogeni.orca.ndl.NdlRequestParser;

public class PersistentStorageTest
implements INdlManifestModelListener,
INdlRequestModelListener {
    private boolean requestPhase = false;

    public void loadRequest(String f, NdlModel.ModelType t, String folderName) {
        System.out.println("Loading request " + f);
        BufferedReader bin = null;
        try {
            FileInputStream is = new FileInputStream(f);
            bin = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = bin.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            bin.close();
            NdlRequestParser nrp = new NdlRequestParser(sb.toString(), (INdlRequestModelListener)this, t, folderName);
            nrp.processRequest();
            nrp.freeModel();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
        }
    }

    public void loadManifest(String f, NdlModel.ModelType t, String folderName) {
        System.out.println("Loading manifest " + f);
        BufferedReader bin = null;
        try {
            FileInputStream is = new FileInputStream(f);
            bin = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = bin.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            bin.close();
            NdlRequestParser nrp = new NdlRequestParser(sb.toString(), (INdlRequestModelListener)this, t, folderName);
            nrp.doLessStrictChecking();
            nrp.processRequest();
            this.requestPhase = false;
            NdlManifestParser nmp = new NdlManifestParser(sb.toString(), (INdlManifestModelListener)this, t, folderName);
            nmp.processManifest();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
        }
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.err.println("request or manifest?");
            System.exit(1);
        }
        if (argv.length == 1) {
            System.err.println("file name? ");
            System.exit(1);
        }
        PersistentStorageTest pst = new PersistentStorageTest();
        long startTime = System.currentTimeMillis();
        if ("request".equalsIgnoreCase(argv[0])) {
            pst.loadRequest(argv[1], NdlModel.ModelType.TdbEphemeral, "/tmp");
        } else {
            pst.loadManifest(argv[1], NdlModel.ModelType.TdbEphemeral, "/tmp");
        }
        long stopTime = System.currentTimeMillis();
        long elapsedTime = stopTime - startTime;
        System.out.println("Total time: " + elapsedTime + "ms");
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long memory = runtime.totalMemory() - runtime.freeMemory();
        System.out.println("Used memory is bytes: " + memory);
        System.out.println("Used memory is megabytes: " + (double)memory / 1048576.0);
    }

    public void ndlCrossConnect(Resource c, OntModel m, long bw, String label, List<Resource> interfaces, Resource parent) {
    }

    public void ndlLinkConnection(Resource l, OntModel m, List<Resource> interfaces, Resource parent) {
    }

    public void ndlManifest(Resource i, OntModel m) {
    }

    public void ndlNetworkConnectionPath(Resource c, OntModel m, List<List<Resource>> path, List<Resource> roots) {
    }

    public void ndlInterface(Resource l, OntModel om, Resource conn, Resource node, String ip, String mask) {
    }

    public void ndlNetworkConnection(Resource l, OntModel om, long bandwidth, long latency, List<Resource> interfaces) {
    }

    public void ndlNode(Resource ce, OntModel om, Resource ceClass, List<Resource> interfaces) {
    }

    public void ndlParseComplete() {
    }

    public void ndlBroadcastConnection(Resource bl, OntModel om, long bandwidth, List<Resource> interfaces) {
    }

    public void ndlNodeDependencies(Resource ni, OntModel m, Set<Resource> dependencies) {
    }

    public void ndlReservation(Resource i, OntModel m) {
    }

    public void ndlReservationEnd(Literal e, OntModel m, Date end) {
    }

    public void ndlReservationResources(List<Resource> r, OntModel m) {
    }

    public void ndlReservationStart(Literal s, OntModel m, Date start) {
    }

    public void ndlReservationTermDuration(Resource d, OntModel m, int years, int months, int days, int hours, int minutes, int seconds) {
    }

    public void ndlSlice(Resource sl, OntModel m) {
    }
}

