/*
 * Decompiled with CFR 0.152.
 */
package net.exogeni.orca.ndl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import junit.framework.TestCase;
import net.exogeni.orca.ndl.OntProcessor;

public class OntProcessorTest
extends TestCase {
    String inputFileName;
    OntProcessor ontProcessor;

    public OntProcessorTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.inputFileName = "net/exogeni/orca/ndl/substrate/ben-6509.rdf";
        this.ontProcessor = new OntProcessor(this.inputFileName);
    }

    public void testListProperty() {
        System.out.println("--------ListProperty-------\n");
        String uri = "http://geni-orca.renci.org/owl/ben.rdf#Renci/Cisco/6509";
        Resource rs = this.ontProcessor.getOntModel().getResource(uri);
        StmtIterator stit = rs.listProperties(OntProcessor.hasSwitchMatrix);
        while (stit != null && stit.hasNext()) {
            Statement st = stit.nextStatement();
            System.out.println(st);
        }
    }

    public void testGetLayer() {
        System.out.println("--------GetLayer-------\n");
        String uri = "http://geni-orca.renci.org/owl/ben-dtn.rdf#Duke/Infinera/DTN/fB/1/ocgB/1";
        System.out.println(this.ontProcessor.getOntModel().getResource(uri).getLocalName());
        ResultSet results = OntProcessor.getLayer((OntModel)this.ontProcessor.getOntModel(), (String)uri);
        String layerName = null;
        String varName = (String)results.getResultVars().get(0);
        while (results.hasNext()) {
            layerName = results.nextSolution().getResource(varName).getLocalName();
            System.out.println(layerName);
        }
        OntProcessorTest.assertTrue((layerName != null ? 1 : 0) != 0);
    }

    public void testConnectedTo() {
        System.out.println("--------ConnectedTo-------\n");
        String url1 = "http://geni-orca.renci.org/owl/ben-6509.rdf#Renci/Cisco/6509/TenGigabitEthernet/3/1/fiber";
        String selectStr = "SELECT ?intf ";
        String fromStr = "";
        String whereStr = "WHERE {<" + url1 + "> ndl:linkTo ?intf.       }";
        OntModel ont1 = this.ontProcessor.getOntModel();
        String queryPhrase = OntProcessor.createQueryString((String)selectStr, (String)fromStr, (String)whereStr);
        System.out.println(queryPhrase);
        OntProcessor.outputQueryResult((ResultSet)OntProcessor.rdfQuery((Model)ont1, (String)queryPhrase));
    }

    public void testListResourceInModel() {
        System.out.println("--------ListResourceInModel-------\n");
        String device = "http://geni-orca.renci.org/owl/ben.rdf#Renci/Cisco/6509";
        String selectStr = "SELECT ?resource ";
        String fromStr = "";
        String whereStr = "WHERE {?resource a ndl:Device      }";
        OntModel ont1 = this.ontProcessor.getOntModel();
        String queryPhrase = OntProcessor.createQueryString((String)selectStr, (String)fromStr, (String)whereStr);
        OntProcessor.outputQueryResult((ResultSet)OntProcessor.rdfQuery((Model)ont1, (String)queryPhrase));
        System.out.println(this.ontProcessor.numResource(ont1, queryPhrase));
        OntProcessorTest.assertTrue((boolean)this.ontProcessor.existResourceStr(device, ont1, queryPhrase));
    }

    public void testGetConnectionSubGraphSwitchedTo() {
        System.out.println("--------GetConnectionSubGraphSwitchedTo-------\n");
        String url1 = "http://geni-orca.renci.org/owl/ben-6509.rdf#Duke/Cisco/6509/TenGigabitEthernet/2/1/fiber";
        String selectStr = "SELECT ?intf ?p ?a ?intf_peer ?b ";
        String fromStr = "";
        String whereStr = "WHERE {?p a layer:AdaptationProperty. <" + url1 + "> ndl:linkTo ?intf. ?intf ?p ?a.?inf_peer layer:switchedTo ?b       }";
        OntModel ont1 = this.ontProcessor.getOntModel();
        String queryPhrase = OntProcessor.createQueryString((String)selectStr, (String)fromStr, (String)whereStr);
        OntProcessor.outputQueryResult((ResultSet)OntProcessor.rdfQuery((Model)ont1, (String)queryPhrase));
        url1 = "http://geni-orca.renci.org/owl/ben.rdf#Renci/Polatis";
        String url2 = "http://geni-orca.renci.org/owl/ben.rdf#Duke/Polatis";
        String s = "SELECT ?a ?b ?c ";
        String f = "";
        String w = "WHERE {?p a layer:AdaptationProperty.(<" + url1 + "> '[ndl:hasInterface]+/[ndl:linkTo]+/[?p]*/[layer:switchedTo]*/[ndl:interfaceOf]+)+' <" + url2 + ">) gleen:Subgraph (?a ?b ?c)      }";
        queryPhrase = OntProcessor.createQueryString((String)s, (String)f, (String)w);
        OntProcessor.outputQueryResult((ResultSet)OntProcessor.rdfQuery((Model)ont1, (String)queryPhrase));
    }

    public void testListConnectedDevice() {
        System.out.println("-------Test listConnectedDevice--------");
        OntModel model = this.ontProcessor.getOntModel();
        String url1 = "http://geni-orca.renci.org/owl/ben-6509.rdf#Renci/Cisco/6509/TenGigabitEthernet/3/7/fiber";
        String url2 = "http://geni-orca.renci.org/owl/ben-6509.rdf#UNC/Cisco/6509/TenGigabitEthernet/3/7/fiber";
        String subPath = " ('[ndl:linkTo]+'";
        String queryPhrase = OntProcessor.createQueryStringOnPath((String)url1, (String)subPath);
        System.out.println(queryPhrase);
        ResultSet results = OntProcessor.rdfQuery((Model)model, (String)queryPhrase);
        OntProcessor.outputQueryResult((ResultSet)results);
    }

    public void testGetSwitchedToAdaptation() {
        System.out.println("-------Test getSwitchedToAdaptation--------");
        OntModel model = this.ontProcessor.getOntModel();
        String url1 = "http://geni-orca.renci.org/owl/ben-6509.rdf#Renci/Cisco/6509";
        ResultSet results = this.ontProcessor.getSwitchedToAdaptation(url1);
        OntProcessor.outputQueryResult((ResultSet)results);
    }

    public void testFindShortestPath() {
        System.out.println("-------Test findShortestPath--------");
        OntModel model = this.ontProcessor.getOntModel();
        String url1 = "http://geni-orca.renci.org/owl/ben-6509.rdf#Renci/Cisco/6509/TenGigabitEthernet/3/7/fiber";
        String url2 = "http://geni-orca.renci.org/owl/ben-6509.rdf#UNC/Cisco/6509/TenGigabitEthernet/3/7/fiber";
        ArrayList path = this.ontProcessor.findShortestPath(model, (Resource)model.getOntResource(url1), (Resource)model.getOntResource(url2), 100000L, "VM", "VM", null);
        ArrayList hop = null;
        if (path == null) {
            System.out.println("No Path");
        } else {
            int i;
            LinkedList deviceList = this.ontProcessor.getDeviceListInPath(path);
            for (i = 0; i < deviceList.size(); ++i) {
                System.out.println(deviceList.get(i));
            }
            System.out.println("\n");
            for (i = 0; i < path.size(); ++i) {
                hop = (ArrayList)path.get(i);
                System.out.println(hop.get(0) + ":" + hop.get(1));
                System.out.println("\n");
            }
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

